/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.registration;

import de.openknowledge.authentication.domain.ClientId;
import de.openknowledge.authentication.domain.KeycloakAdapter;
import de.openknowledge.authentication.domain.RealmName;
import de.openknowledge.authentication.domain.group.GroupId;
import de.openknowledge.authentication.domain.group.GroupName;
import de.openknowledge.authentication.domain.login.Login;
import de.openknowledge.authentication.domain.registration.Attribute;
import de.openknowledge.authentication.domain.registration.RegistrationMode;
import de.openknowledge.authentication.domain.registration.Token;
import de.openknowledge.authentication.domain.registration.VerificationLink;
import de.openknowledge.authentication.domain.role.RoleName;
import de.openknowledge.authentication.domain.user.UserIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KeycloakRegistrationService {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakRegistrationService.class);
    private KeycloakAdapter keycloakAdapter;
    private RealmName realmName;
    private ClientId clientId;
    private RegistrationMode registrationMode;

    protected KeycloakRegistrationService() {
    }

    @Inject
    public KeycloakRegistrationService(KeycloakAdapter aKeycloakAdapter, @ConfigProperty(name="keycloak.registration.realm") String aRealm, @ConfigProperty(name="keycloak.registration.clientId") String aClientId, @ConfigProperty(name="keycloak.registration.mode") String aRegistrationMode) {
        this.keycloakAdapter = aKeycloakAdapter;
        this.realmName = RealmName.fromValue(aRealm);
        this.clientId = ClientId.fromValue(aClientId);
        this.registrationMode = RegistrationMode.fromValue(aRegistrationMode);
    }

    public boolean checkAlreadyExist(Login login) {
        UsersResource usersResource = this.keycloakAdapter.findUserResource(this.realmName);
        List existingUsersByUsername = usersResource.search((String)login.getUsername().getValue());
        LOG.info("List size by username is: {}", existingUsersByUsername != null ? Integer.valueOf(existingUsersByUsername.size()) : "null");
        return existingUsersByUsername != null && !existingUsersByUsername.isEmpty();
    }

    public UserIdentifier createUser(Login login, Attribute ... attributes) {
        UserRepresentation newUser = this.extractUser(login);
        newUser.setCredentials(Collections.singletonList(this.extractCredential(login)));
        newUser.setAttributes(this.extractAttributes(attributes));
        Response response = this.keycloakAdapter.findUserResource(this.realmName).create(newUser);
        if (response.getStatus() != 201) {
            LOG.warn("Problem during create user {} on keycloak (response status {})", (Object)newUser.getUsername(), (Object)response.getStatus());
            return null;
        }
        String path = response.getLocation().getPath();
        String userId = path.replaceAll(".*/([^/]+)$", "$1");
        UserIdentifier userIdentifier = UserIdentifier.fromValue(userId);
        this.joinRoles(userIdentifier, RoleName.fromValue((String)this.clientId.getValue()));
        return userIdentifier;
    }

    public void updateMailVerification(UserIdentifier userIdentifier) {
        UserResource userResource = this.keycloakAdapter.findUserResource(this.realmName).get((String)userIdentifier.getValue());
        UserRepresentation user = userResource.toRepresentation();
        user.setEmailVerified(Boolean.valueOf(true));
        userResource.update(user);
    }

    public void joinGroups(UserIdentifier userIdentifier, GroupName ... groupNames) {
        GroupsResource resource = this.keycloakAdapter.findGroupResource(this.realmName);
        ArrayList joiningGroups = new ArrayList();
        for (GroupName groupName : groupNames) {
            List groups = resource.groups((String)groupName.getValue(), Integer.valueOf(0), Integer.valueOf(1));
            if (groups == null || groups.isEmpty()) {
                LOG.warn("Group (name='{}')\u00a0not found", groupName.getValue());
                continue;
            }
            joiningGroups.addAll(groups.stream().map(group -> GroupId.fromValue(group.getId())).collect(Collectors.toList()));
        }
        UserResource userResource = this.keycloakAdapter.findUserResource(this.realmName).get((String)userIdentifier.getValue());
        for (GroupId groupId : joiningGroups) {
            userResource.joinGroup((String)groupId.getValue());
        }
    }

    public void joinRoles(UserIdentifier userIdentifier, RoleName ... roleNames) {
        RolesResource resource = this.keycloakAdapter.findRoleResource(this.realmName);
        ArrayList joiningRoles = new ArrayList();
        for (RoleName roleName : roleNames) {
            List roles = resource.list((String)roleName.getValue(), Integer.valueOf(0), Integer.valueOf(1));
            if (roles == null || roles.isEmpty()) {
                LOG.warn("Role (name='{}') not found", roleName.getValue());
                continue;
            }
            joiningRoles.addAll(roles);
        }
        UserResource userResource = this.keycloakAdapter.findUserResource(this.realmName).get((String)userIdentifier.getValue());
        userResource.roles().realmLevel().add(joiningRoles);
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public List<RealmName> getRealms() {
        List<RealmName> realmNames = new ArrayList<RealmName>();
        List<RealmRepresentation> realms = this.keycloakAdapter.findAll();
        if (!realms.isEmpty()) {
            realmNames = realms.stream().map(RealmRepresentation::getRealm).map(RealmName::fromValue).collect(Collectors.toList());
        }
        return realmNames;
    }

    public VerificationLink encodeToken(Token token) {
        return this.keycloakAdapter.encode(token);
    }

    public Token decodeToken(VerificationLink link) {
        return this.keycloakAdapter.decode(link);
    }

    private UserRepresentation extractUser(Login login) {
        UserRepresentation keycloakUser = new UserRepresentation();
        keycloakUser.setUsername((String)login.getUsername().getValue());
        keycloakUser.setEmail((String)login.getEmailAddress().getValue());
        keycloakUser.setEnabled(Boolean.valueOf(true));
        if (RegistrationMode.DOUBLE_OPT_IN.equals((Object)this.registrationMode)) {
            keycloakUser.setEmailVerified(Boolean.valueOf(false));
        } else if (RegistrationMode.DEFAULT.equals((Object)this.registrationMode)) {
            keycloakUser.setEmailVerified(Boolean.valueOf(true));
        }
        return keycloakUser;
    }

    private CredentialRepresentation extractCredential(Login login) {
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setValue((String)login.getPassword().getValue());
        credential.setType("password");
        credential.setTemporary(Boolean.valueOf(false));
        return credential;
    }

    private Map<String, List<String>> extractAttributes(Attribute[] attributes) {
        HashMap<String, List<String>> userAttributeMap = new HashMap<String, List<String>>();
        for (Attribute attribute : attributes) {
            List<String> userAttributeList;
            if (userAttributeMap.containsKey(attribute.getKey())) {
                userAttributeList = (List)userAttributeMap.get(attribute.getKey());
                userAttributeList.add(attribute.getValue());
                userAttributeMap.put(attribute.getKey(), userAttributeList);
                continue;
            }
            userAttributeList = new ArrayList<String>();
            userAttributeList.add(attribute.getValue());
            userAttributeMap.put(attribute.getKey(), userAttributeList);
        }
        return userAttributeMap;
    }
}

