/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.login;

import de.openknowledge.authentication.domain.ClientId;
import de.openknowledge.authentication.domain.KeycloakAdapter;
import de.openknowledge.authentication.domain.RealmName;
import de.openknowledge.authentication.domain.login.Login;
import de.openknowledge.authentication.domain.login.LoginToken;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Form;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.keycloak.representations.AccessTokenResponse;

@ApplicationScoped
public class KeycloakLoginService {
    private KeycloakAdapter keycloakAdapter;
    private RealmName realmName;
    private ClientId clientId;

    protected KeycloakLoginService() {
    }

    @Inject
    public KeycloakLoginService(KeycloakAdapter aKeycloakAdapter, @ConfigProperty(name="keycloak.login.realm") String aRealmName, @ConfigProperty(name="keycloak.login.clientId") String aClientId) {
        this.keycloakAdapter = aKeycloakAdapter;
        this.realmName = RealmName.fromValue(aRealmName);
        this.clientId = ClientId.fromValue(aClientId);
    }

    public LoginToken login(Login login) {
        AccessTokenResponse response = this.grantToken(login);
        return new LoginToken(response.getToken(), response.getExpiresIn(), response.getRefreshToken(), response.getRefreshExpiresIn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessTokenResponse grantToken(Login login) {
        Form form = new Form().param("grant_type", "password").param("username", (String)login.getUsername().getValue()).param("password", (String)login.getPassword().getValue()).param("client_id", (String)this.clientId.getValue());
        KeycloakLoginService keycloakLoginService = this;
        synchronized (keycloakLoginService) {
            return this.keycloakAdapter.getTokenService().grantToken((String)this.realmName.getValue(), form.asMap());
        }
    }
}

