/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain;

import de.openknowledge.authentication.domain.registration.Token;
import de.openknowledge.authentication.domain.registration.TokenSecret;
import de.openknowledge.authentication.domain.registration.VerificationLink;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.spec.SecretKeySpec;
import javax.json.bind.JsonbBuilder;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.alg.RsaKeyEncryptionJWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.AesCbcHmacShaEncryptionProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakTokenService {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakTokenService.class);

    public static VerificationLink encode(Token token, TokenSecret tokenSecret, PublicKey encryptionKey) {
        try {
            String payload = JsonbBuilder.create().toJson((Object)token);
            LOG.info(payload);
            JWE jwe = KeycloakTokenService.jwtEncode(tokenSecret, encryptionKey);
            jwe.content(payload.getBytes(StandardCharsets.UTF_8));
            String encodedPayload = jwe.encodeJwe(KeycloakTokenService.getAlgorithmProvider(), KeycloakTokenService.getEncryptionProvider());
            LOG.debug(encodedPayload);
            return VerificationLink.fromValue(encodedPayload);
        }
        catch (JWEException e) {
            LOG.error("problem during encode JWT: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException("problem during encode" + e.getMessage(), e);
        }
    }

    public static Token decode(VerificationLink link, TokenSecret tokenSecret, PrivateKey decryptionKey) {
        try {
            JWE jwe = KeycloakTokenService.jwtDecoder(tokenSecret, decryptionKey);
            jwe.verifyAndDecodeJwe((String)link.getValue(), KeycloakTokenService.getAlgorithmProvider(), KeycloakTokenService.getEncryptionProvider());
            String decodedPayload = new String(jwe.getContent(), StandardCharsets.UTF_8);
            LOG.debug(decodedPayload);
            return (Token)JsonbBuilder.create().fromJson(decodedPayload, Token.class);
        }
        catch (JWEException e) {
            LOG.error("problem during decode JWT: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException("problem during decode" + e.getMessage(), e);
        }
    }

    private static JWE jwtEncode(TokenSecret tokenSecret, PublicKey encryptionKey) {
        JWEHeader jweHeader = new JWEHeader("A256CBC-HS512", "A256CBC-HS512", null);
        JWE jwe = new JWE();
        jwe.header(jweHeader);
        jwe.getKeyStorage().setEncryptionKey((Key)encryptionKey);
        KeycloakTokenService.enrichKeyStorage(jwe, tokenSecret);
        return jwe;
    }

    private static JWE jwtDecoder(TokenSecret tokenSecret, PrivateKey decryptionKey) {
        JWE jwe = new JWE();
        jwe.getKeyStorage().setDecryptionKey((Key)decryptionKey);
        KeycloakTokenService.enrichKeyStorage(jwe, tokenSecret);
        return jwe;
    }

    private static void enrichKeyStorage(JWE jwe, TokenSecret tokenSecret) {
        SecretKeySpec aesKey = new SecretKeySpec(tokenSecret.asByteArray(), "AES");
        SecretKeySpec hmacKey = new SecretKeySpec(tokenSecret.asByteArray(), "HMACSHA2");
        jwe.getKeyStorage().setCEKKey((Key)aesKey, JWEKeyStorage.KeyUse.ENCRYPTION);
        jwe.getKeyStorage().setCEKKey((Key)hmacKey, JWEKeyStorage.KeyUse.SIGNATURE);
    }

    private static JWEAlgorithmProvider getAlgorithmProvider() {
        return new RsaKeyEncryptionJWEAlgorithmProvider("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
    }

    private static JWEEncryptionProvider getEncryptionProvider() {
        return new AesCbcHmacShaEncryptionProvider.Aes256CbcHmacSha512Provider();
    }
}

