/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain;

import de.openknowledge.authentication.domain.KeycloakAdapterConfiguration;
import de.openknowledge.authentication.domain.KeycloakKeyConfiguration;
import de.openknowledge.authentication.domain.KeycloakKeyService;
import de.openknowledge.authentication.domain.KeycloakTokenService;
import de.openknowledge.authentication.domain.RealmName;
import de.openknowledge.authentication.domain.registration.Token;
import de.openknowledge.authentication.domain.registration.TokenSecret;
import de.openknowledge.authentication.domain.registration.VerificationLink;
import java.security.KeyPair;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.admin.client.token.TokenService;
import org.keycloak.representations.idm.RealmRepresentation;

@ApplicationScoped
public class KeycloakAdapter {
    private Keycloak keycloak;
    private TokenService tokenService;
    private KeycloakKeyConfiguration keyConfiguration;
    private KeyPair keyPair;
    private TokenSecret tokenSecret;

    protected KeycloakAdapter() {
    }

    @Inject
    public KeycloakAdapter(KeycloakAdapterConfiguration adapterConfig, KeycloakKeyConfiguration keyConfig) {
        ResteasyClient restClient = new ResteasyClientBuilder().connectionPoolSize(adapterConfig.getConnectionPoolSize().intValue()).build();
        this.keycloak = KeycloakBuilder.builder().serverUrl(adapterConfig.getServerUrl()).realm(adapterConfig.getMasterRealm()).grantType(adapterConfig.getGrantType()).username(adapterConfig.getUsername()).password(adapterConfig.getPassword()).clientId(adapterConfig.getClientId()).resteasyClient(restClient).build();
        this.tokenService = (TokenService)restClient.target(adapterConfig.getServerUrl()).proxy(TokenService.class);
        this.keyConfiguration = keyConfig;
    }

    @PostConstruct
    public void init() {
        this.keyPair = KeycloakKeyService.readKeyPair(this.keyConfiguration);
        this.tokenSecret = TokenSecret.fromValue(this.keyConfiguration.getTokenSecret());
    }

    public List<RealmRepresentation> findAll() {
        RealmsResource realmsResource = this.keycloak.realms();
        return realmsResource.findAll();
    }

    public UsersResource findUserResource(RealmName realmName) {
        RealmResource realmResource = this.keycloak.realm((String)realmName.getValue());
        return realmResource.users();
    }

    public GroupsResource findGroupResource(RealmName realmName) {
        RealmResource realmResource = this.keycloak.realm((String)realmName.getValue());
        return realmResource.groups();
    }

    public RolesResource findRoleResource(RealmName realmName) {
        RealmResource realmResource = this.keycloak.realm((String)realmName.getValue());
        return realmResource.roles();
    }

    public VerificationLink encode(Token token) {
        return KeycloakTokenService.encode(token, this.tokenSecret, this.keyPair.getPublic());
    }

    public Token decode(VerificationLink link) {
        return KeycloakTokenService.decode(link, this.tokenSecret, this.keyPair.getPrivate());
    }

    public TokenService getTokenService() {
        return this.tokenService;
    }
}

