/*
 * Decompiled with CFR 0.152.
 */
package okw.gui.adapter.selenium;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import okw.FrameObjectDictionary_Sngltn;
import okw.OKW_Const_Sngltn;
import okw.OKW_Helper;
import okw.core.Core;
import okw.core.OKW_CurrentObject_Sngltn;
import okw.exceptions.OKWNotAllowedValueException;
import okw.exceptions.OKWOnlySingleValueAllowedException;
import okw.gui.OKWLocatorBase;
import okw.gui.adapter.selenium.SeAnyChildWindow;
import okw.gui.adapter.selenium.SeRadio;
import okw.gui.adapter.selenium.webdriver.SeDriver;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.xml.sax.SAXException;

public class SeRadioList
extends SeAnyChildWindow {
    OKW_CurrentObject_Sngltn CO = null;
    FrameObjectDictionary_Sngltn FOD = null;
    ArrayList<String> myRadioButtonFNs = null;

    public SeRadioList(String Locator, OKWLocatorBase ... Locators) {
        super(Locator, Locators);
        try {
            this.CO = OKW_CurrentObject_Sngltn.getInstance();
            this.FOD = FrameObjectDictionary_Sngltn.getInstance();
        }
        catch (Exception e) {
            System.exit(0);
        }
    }

    @Override
    public void SetValue(ArrayList<String> Val) {
        try {
            this.WaitForMe();
            if (Val.size() == 1) {
                String DELETE = OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("DELETE");
                if (Val.get(0).equals(DELETE)) {
                    throw new OKWNotAllowedValueException("SeRadioList: This Value is Not Alowed here: " + Val.get(0));
                }
            } else {
                throw new OKWOnlySingleValueAllowedException("SeRadioList: Only single value is allowed!");
            }
            String myFN = this.getCAT();
            String myChildFN = myFN + "." + Val.get(0);
            Core myCore = new Core();
            myCore.ClickOn(myChildFN);
            this.CO.setChildName(myFN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void Select(ArrayList<String> Val) {
        this.SetValue(Val);
    }

    @Override
    public ArrayList<String> getValue() {
        ArrayList<String> lvLsReturn = new ArrayList<String>();
        ArrayList myRadioButtonKeys = new ArrayList();
        try {
            this.WaitForMe();
            String isChecked = OKW_Const_Sngltn.getInstance().GetConst4Internalname("CHECKED");
            myRadioButtonKeys = OKW_CurrentObject_Sngltn.getInstance().getAllChildFNsOfParent(this.getParentFN() + "." + this.getCAT() + ".");
            for (String lvsRadioButtonFN : myRadioButtonKeys) {
                ArrayList<String> Actuel = ((SeRadio)((Object)this.FOD.getParentObjectByName(lvsRadioButtonFN))).getValue();
                if (!isChecked.equals(Actuel.get(0))) continue;
                String CurrentValue = OKW_Helper.getRightFromDelimiterNumber((String)lvsRadioButtonFN, (String)(this.getCAT() + "."), (Integer)1);
                lvLsReturn.add(CurrentValue);
                break;
            }
            if (0 == lvLsReturn.size()) {
                lvLsReturn.add("");
            }
        }
        catch (IOException | JAXBException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RuntimeException(e);
        }
        return lvLsReturn;
    }

    @Override
    public ArrayList<String> getLabel() {
        ArrayList<String> lvLsReturn = new ArrayList<String>();
        this.WaitForMe();
        WebElement label = SeDriver.getInstance().getDriver().findElement(By.xpath((String)(this.getLocator() + "//legend")));
        String myAttribute = this.WaitForInteractionReturnString(() -> label.getAttribute("textContent"));
        myAttribute = StringUtils.normalizeSpace((String)myAttribute);
        lvLsReturn.add(myAttribute);
        return lvLsReturn;
    }
}

