/*
 * Decompiled with CFR 0.152.
 */
package okw.gui.adapter.selenium;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import okw.FrameObjectDictionary_Sngltn;
import okw.LogMessenger;
import okw.OKW;
import okw.OKW_Const_Sngltn;
import okw.OKW_TimeOut;
import okw.exceptions.OKWGUIObjectNotFoundException;
import okw.exceptions.OKWGUIObjectNotUniqueException;
import okw.gui.AnyWindow;
import okw.gui.OKWLocatorBase;
import okw.gui.OKWLocatorXPath;
import okw.gui.adapter.selenium.webdriver.SeDriver;
import okw.log.Logger_Sngltn;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.xml.sax.SAXException;

public class SeAnyWindow
extends AnyWindow {
    protected SeDriver mySeDriver = SeDriver.getInstance();
    protected LogMessenger LM = new LogMessenger("GUI");

    public SeAnyWindow() {
        this._locator = new OKWLocatorXPath();
    }

    public void setLocator(String Locator, OKWLocatorBase ... Locators) {
        this._locator.setLocator(Locator, Locators);
    }

    public void ClickOn() {
        if (!this.getExists().booleanValue()) {
            String lvsLM = this.LM.GetMessage("Common", "OKWGUIObjectNotFoundException", (Object)"SeAnyWin.ClickOn()");
            throw new OKWGUIObjectNotFoundException(lvsLM);
        }
        this.Me().click();
    }

    public ArrayList<String> getCaption() {
        ArrayList<String> lvLsReturn = new ArrayList<String>();
        if (!this.getExists().booleanValue()) {
            String lvsLM = this.LM.GetMessage("Common", "OKWGUIObjectNotFoundException", (Object)"GetCaption()");
            throw new OKWGUIObjectNotFoundException(lvsLM);
        }
        lvLsReturn.add(this.Me().getAttribute("textContent"));
        return lvLsReturn;
    }

    public Boolean getExists() {
        Boolean lvbReturn = false;
        String myLocator = null;
        try {
            myLocator = this.getLocator();
            SeDriver.getInstance().getWebElement(myLocator);
            lvbReturn = true;
        }
        catch (OKWGUIObjectNotUniqueException e) {
            this.LogPrintDebug("OKWGUIObjectNotUniqueException - GUI-Objekt existiert nicht mehr...");
            lvbReturn = false;
        }
        catch (OKWGUIObjectNotFoundException e) {
            this.LogPrintDebug("OKWGUIObjectNotFoundException - GUI-Objekt existiert nicht mehr...");
            lvbReturn = false;
        }
        catch (StaleElementReferenceException e) {
            this.LogPrint("StaleElementReferenceException - GUI-Objekt existiert nicht mehr...");
            lvbReturn = false;
        }
        return lvbReturn;
    }

    public ArrayList<String> LogCaption() throws Exception {
        ArrayList<String> lvLsReturn = new ArrayList();
        lvLsReturn = this.getCaption();
        return lvLsReturn;
    }

    public Boolean LogExists() {
        Boolean lvbReturn = false;
        lvbReturn = this.getExists();
        return lvbReturn;
    }

    public Boolean LogIsActive() throws Exception {
        return this.getIsActive();
    }

    public WebElement Me() {
        return this.mySeDriver.getWebElement(this.getLocator());
    }

    public Boolean MemorizeExists() {
        return this.getExists();
    }

    public Boolean MemorizeIsActive() throws Exception {
        return this.getIsActive();
    }

    public Boolean NotExists() throws Exception {
        Boolean lvb_Return = false;
        try {
            this.Me();
            lvb_Return = true;
        }
        catch (NoSuchElementException e) {
            this.LogPrint("NoSuchElementException");
            lvb_Return = true;
        }
        return lvb_Return;
    }

    public void SelectWindow() {
        if (!this.WaitForMe().booleanValue()) {
            this.ResOpenList("GUI-Object not found...");
            this.LogPrint("Locator: '" + this.getLocator() + "'");
            this.ResCloseList();
            throw new OKWGUIObjectNotFoundException("Window (" + ((Object)((Object)this)).getClass().getName() + ") not found!");
        }
    }

    public void SetFocus() throws Exception {
        if (!this.getExists().booleanValue()) {
            String lvsLM = this.LM.GetMessage("Common", "OKWGUIObjectNotFoundException", (Object)"SetFocus()");
            throw new OKWGUIObjectNotFoundException(lvsLM);
        }
        this.Me().sendKeys(new CharSequence[]{""});
    }

    public ArrayList<String> MemorizeCaption() throws Exception {
        return this.getCaption();
    }

    public void TypeKey(ArrayList<String> fps_Values) throws Exception {
        if (!this.getExists().booleanValue()) {
            String lvsLM = this.LM.GetMessage("Common", "OKWGUIObjectNotFoundException", (Object)"SeAnyWin.TypeKey()");
            throw new OKWGUIObjectNotFoundException(lvsLM);
        }
        WebElement lv_WebElement = this.Me();
        for (String Value : fps_Values) {
            Logger_Sngltn.getInstance().LogPrintDebug(">>" + Value + "<<");
            if (Value.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("DELETE"))) {
                lv_WebElement.clear();
                continue;
            }
            lv_WebElement.sendKeys(new CharSequence[]{Value});
        }
    }

    public ArrayList<String> VerifyCaption() throws Exception {
        return this.getCaption();
    }

    public Boolean VerifyExists() throws InterruptedException {
        return this.getExists();
    }

    public Boolean VerifyIsActive() throws Exception {
        return this.getIsActive();
    }

    public Boolean scrollIntoView() {
        Boolean lvbReturn = false;
        this.LogPrint("Scrolling the object into the visible area...");
        ((JavascriptExecutor)SeDriver.getInstance().getDriver()).executeScript("arguments[0].scrollIntoView({block:'nearest'})", new Object[]{this.Me()});
        try {
            this.LogPrint("... und warte 1s.");
            Thread.sleep(1000L);
            lvbReturn = true;
        }
        catch (InterruptedException e) {
            this.LogWarning("Unexpected exception InterruptedException during ScrollWait, we ignore that...");
            e.printStackTrace();
        }
        return lvbReturn;
    }

    public void WaitForInteraction(Runnable Method2Call) {
        RuntimeException TimeOutException = null;
        boolean isExecuted = false;
        try {
            OKW myOKW = FrameObjectDictionary_Sngltn.getInstance().getOKW(this.getKN());
            OKW_TimeOut timeout = new OKW_TimeOut(Integer.valueOf(myOKW.WaitForMe_TO()), Integer.valueOf(myOKW.WaitForMe_PT()));
            Integer Count = 0;
            Integer MaxCount = timeout.getMaxCount();
            Integer PollTime = timeout.getPT();
            while (Count <= MaxCount) {
                try {
                    Method2Call.run();
                    isExecuted = true;
                    break;
                }
                catch (OKWGUIObjectNotFoundException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("OKWGUIObjectNotFoundException: WebElement currently does not not exist. - wait and retry...");
                }
                catch (InvalidElementStateException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("InvalidElementStateException: WebElement is currently not ready for interaction. - scroll, wait and retry...");
                    this.scrollIntoView();
                }
                catch (StaleElementReferenceException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("StaleElementReferenceException: Update WebElement reference to the DOM. -  wait and try ...");
                }
                try {
                    Thread.sleep(PollTime.intValue());
                }
                catch (InterruptedException e) {
                    TimeOutException = new RuntimeException("Unexpected InterruptedException in Threadsleep!", e);
                    e.printStackTrace();
                }
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
            if (!isExecuted) {
                throw TimeOutException;
            }
            this.LogPrint("Interaction succesfull executed");
        }
        catch (IOException | JAXBException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public String WaitForInteractionReturnString(Supplier<String> Method2Call) {
        String lvsReturn = null;
        Throwable TimeOutException = null;
        boolean isExecuted = false;
        try {
            OKW myOKW = FrameObjectDictionary_Sngltn.getInstance().getOKW(this.getKN());
            OKW_TimeOut timeout = new OKW_TimeOut(Integer.valueOf(myOKW.WaitForMe_TO()), Integer.valueOf(myOKW.WaitForMe_PT()));
            Integer Count = 0;
            Integer MaxCount = timeout.getMaxCount();
            Integer PollTime = timeout.getPT();
            while (Count <= MaxCount) {
                try {
                    lvsReturn = Method2Call.get();
                    isExecuted = true;
                    break;
                }
                catch (OKWGUIObjectNotFoundException e) {
                    TimeOutException = e;
                    this.LogPrint("OKWGUIObjectNotFoundException: WebElement currently does not not exist. - wait and retry...");
                }
                catch (InvalidElementStateException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("InvalidElementStateException: WebElement is currently not ready for interaction. - scroll, wait and retry...");
                    this.scrollIntoView();
                }
                catch (StaleElementReferenceException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("StaleElementReferenceException: Update WebElement reference to the DOM. -  wait and retry ...");
                }
                try {
                    Thread.sleep(PollTime.intValue());
                }
                catch (InterruptedException e) {
                    TimeOutException = new RuntimeException("Unexpected InterruptedException in Threadsleep!", e);
                    e.printStackTrace();
                }
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
            if (!isExecuted) {
                throw TimeOutException;
            }
            this.LogPrint("Interaction succesfull executed");
        }
        catch (IOException | JAXBException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RuntimeException(e);
        }
        return lvsReturn;
    }

    public Boolean WaitForInteractionReturnBoolean(Supplier<Boolean> Method2Call) {
        Boolean lvbReturn = null;
        Throwable TimeOutException = null;
        boolean isExecuted = false;
        try {
            OKW myOKW = FrameObjectDictionary_Sngltn.getInstance().getOKW(this.getKN());
            OKW_TimeOut timeout = new OKW_TimeOut(Integer.valueOf(myOKW.WaitForMe_TO()), Integer.valueOf(myOKW.WaitForMe_PT()));
            Integer Count = 0;
            Integer MaxCount = timeout.getMaxCount();
            Integer PollTime = timeout.getPT();
            while (Count <= MaxCount) {
                try {
                    lvbReturn = Method2Call.get();
                    isExecuted = true;
                    break;
                }
                catch (OKWGUIObjectNotFoundException e) {
                    TimeOutException = e;
                    this.LogPrint("OKWGUIObjectNotFoundException: WebElement currently does not not exist. - wait and retry...");
                }
                catch (InvalidElementStateException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("InvalidElementStateException: WebElement is currently not ready for interaction. - scroll, wait and retry...");
                    this.scrollIntoView();
                }
                catch (StaleElementReferenceException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("StaleElementReferenceException: Update WebElement reference to the DOM. -  wait and retry ...");
                }
                try {
                    Thread.sleep(PollTime.intValue());
                }
                catch (InterruptedException e) {
                    TimeOutException = new RuntimeException("Unexpected InterruptedException in Threadsleep!", e);
                    e.printStackTrace();
                }
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
            if (!isExecuted) {
                throw TimeOutException;
            }
            this.LogPrint("Interaction succesfull executed");
        }
        catch (IOException | JAXBException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RuntimeException(e);
        }
        return lvbReturn;
    }

    public Boolean WaitForMe() {
        Boolean lvbReturn = super.WaitForMe();
        if (!lvbReturn.booleanValue()) {
            this.ResOpenList("GUI-Object not found...");
            this.LogPrint("Locator: '" + this.getLocator() + "'");
            this.ResCloseList();
            String lvsLM = this.LM.GetMessage("Common", "OKWGUIObjectNotFoundException", (Object)"WaitForMe()");
            throw new OKWGUIObjectNotFoundException(lvsLM);
        }
        return lvbReturn;
    }
}

