/*
 * Decompiled with CFR 0.152.
 */
package okw.gui.adapter.selenium;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import okw.FrameObjectDictionary_Sngltn;
import okw.LogMessenger;
import okw.OKW;
import okw.OKW_Const_Sngltn;
import okw.OKW_TimeOut;
import okw.exceptions.OKWFrameObjectMethodNotImplemented;
import okw.exceptions.OKWGUIObjectNotFoundException;
import okw.gui.AnyChildwindow;
import okw.gui.OKWLocatorBase;
import okw.gui.OKWLocatorXPath;
import okw.gui.adapter.selenium.webdriver.SeDriver;
import okw.log.Logger_Sngltn;
import okw.parser.SeKeyParser;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.xml.sax.SAXException;

public class SeAnyChildWindow
extends AnyChildwindow {
    protected LogMessenger LM = new LogMessenger("GUI");

    public SeAnyChildWindow() {
        this._locator = new OKWLocatorXPath();
    }

    public SeAnyChildWindow(String fpsLocator, OKWLocatorBase ... locators) {
        this._locator = new OKWLocatorXPath(fpsLocator, locators);
    }

    public void ClickOn() {
        this.WaitForInteraction(() -> this.Me().click());
    }

    public ArrayList<String> getCaption() {
        ArrayList<String> lvLsReturn = new ArrayList<String>();
        String myAttribute = this.WaitForInteractionReturnString(() -> this.Me().getAttribute("textContent"));
        lvLsReturn.add(StringUtils.normalizeSpace((String)myAttribute));
        return lvLsReturn;
    }

    public ArrayList<String> getAttribute(String Attribute) {
        ArrayList<String> lvLsReturn = new ArrayList<String>();
        String myAttribute = this.WaitForInteractionReturnString(() -> this.Me().getAttribute(Attribute));
        lvLsReturn.add(StringUtils.normalizeSpace((String)myAttribute));
        return lvLsReturn;
    }

    public Boolean getExists() {
        Boolean lvbReturn = false;
        String myLocator = null;
        try {
            myLocator = this.getLocator();
            SeDriver.getInstance().getWebElement(myLocator);
            lvbReturn = true;
        }
        catch (OKWGUIObjectNotFoundException e) {
            this.LogPrint("OKWGUIObjectNotFoundException - GUI-Object was not found...");
            lvbReturn = false;
        }
        catch (StaleElementReferenceException e) {
            this.LogPrint("StaleElementReferenceException - GUI-Objekt existiert nicht mehr...");
            lvbReturn = false;
        }
        return lvbReturn;
    }

    public Boolean getHasFocus() {
        Boolean lvbReturn = false;
        this.WaitForMe();
        WebElement currentElement = SeDriver.getInstance().getDriver().switchTo().activeElement();
        lvbReturn = currentElement.equals(this.Me());
        return lvbReturn;
    }

    public Boolean getIsActive() {
        Boolean lvbReturn = false;
        String lvsDisabled = null;
        lvsDisabled = this.WaitForInteractionReturnString(() -> this.Me().getAttribute("disabled"));
        if (lvsDisabled != null) {
            if (lvsDisabled.equals("true")) {
                lvbReturn = false;
            }
        } else {
            lvbReturn = true;
        }
        return lvbReturn;
    }

    public ArrayList<String> getLabel() {
        ArrayList<String> lvLsReturn = new ArrayList<String>();
        String lvsID = this.WaitForInteractionReturnString(() -> this.Me().getAttribute("id"));
        WebElement label = SeDriver.getInstance().getDriver().findElement(By.xpath((String)("//label[@for='" + lvsID + "']")));
        String myAttribute = label.getAttribute("textContent");
        myAttribute = StringUtils.normalizeSpace((String)myAttribute);
        lvLsReturn.add(myAttribute);
        return lvLsReturn;
    }

    public ArrayList<String> getTooltip() {
        ArrayList<String> lvLsReturn = new ArrayList<String>();
        String myAttribute = this.WaitForInteractionReturnString(() -> this.Me().getAttribute("title"));
        myAttribute = StringUtils.normalizeSpace((String)myAttribute);
        lvLsReturn.add(myAttribute);
        return lvLsReturn;
    }

    public ArrayList<String> getValue() {
        ArrayList<String> lvLsReturn = new ArrayList<String>();
        String myAttribute = null;
        String myValue = this.WaitForInteractionReturnString(() -> this.Me().getAttribute("data-harmony-value"));
        myAttribute = null == myValue ? this.WaitForInteractionReturnString(() -> this.Me().getAttribute("textContent")) : myValue;
        lvLsReturn.add(StringUtils.normalizeSpace((String)myAttribute));
        return lvLsReturn;
    }

    public ArrayList<String> LogCaption() {
        ArrayList<String> lvLsReturn = null;
        lvLsReturn = this.getCaption();
        return lvLsReturn;
    }

    public boolean LogExists() {
        Boolean lvbReturn = null;
        lvbReturn = this.getExists();
        return lvbReturn;
    }

    public boolean LogHasFocus() {
        Boolean lvbReturn = null;
        lvbReturn = this.getHasFocus();
        return lvbReturn;
    }

    public boolean LogIsActive() {
        Boolean lvbReturn = null;
        lvbReturn = this.getIsActive();
        return lvbReturn;
    }

    public ArrayList<String> LogLabel() {
        ArrayList<String> lvLsReturn = null;
        lvLsReturn = this.getLabel();
        return lvLsReturn;
    }

    public ArrayList<String> LogPlaceholder() {
        ArrayList<String> lvLsReturn = null;
        lvLsReturn = this.getLabel();
        return lvLsReturn;
    }

    public ArrayList<String> LogTooltip() {
        ArrayList<String> lvLsReturn = null;
        lvLsReturn = this.getTooltip();
        return lvLsReturn;
    }

    public ArrayList<String> LogValue() {
        ArrayList<String> lvLsReturn = new ArrayList();
        lvLsReturn = this.getValue();
        return lvLsReturn;
    }

    public WebElement Me() {
        WebElement me = null;
        me = SeDriver.getInstance().getWebElement(this.getLocator());
        return me;
    }

    public ArrayList<String> MemorizeCaption() {
        ArrayList<String> lvLsReturn = null;
        lvLsReturn = this.getCaption();
        return lvLsReturn;
    }

    public boolean MemorizeExists() {
        Boolean lvbReturn = false;
        lvbReturn = this.getExists();
        return lvbReturn;
    }

    public boolean MemorizeHasFocus() {
        Boolean lvbReturn = null;
        lvbReturn = this.getHasFocus();
        return lvbReturn;
    }

    public boolean MemorizeIsActive() {
        Boolean lvbReturn = false;
        lvbReturn = this.getIsActive();
        return lvbReturn;
    }

    public ArrayList<String> MemorizeLabel() {
        ArrayList<String> lvLsReturn = null;
        lvLsReturn = this.getLabel();
        return lvLsReturn;
    }

    public ArrayList<String> MemorizePlaceholder() {
        ArrayList lvLsReturn = null;
        lvLsReturn = this.getPlaceholder();
        return lvLsReturn;
    }

    public ArrayList<String> MemorizeTooltip() {
        ArrayList<String> lvLsReturn = null;
        lvLsReturn = this.getTooltip();
        return lvLsReturn;
    }

    public ArrayList<String> MemorizeValue() {
        ArrayList<String> lvLsReturn = new ArrayList();
        lvLsReturn = this.getValue();
        return lvLsReturn;
    }

    public Boolean _NotExists() throws Exception {
        Boolean lvb_Return = null;
        try {
            this.Me();
            lvb_Return = false;
        }
        catch (NoSuchElementException e) {
            this.LogPrint("NoSuchElementException");
            lvb_Return = true;
        }
        return lvb_Return;
    }

    public void Select(ArrayList<String> Values) {
        String lvsLM = this.LM.GetMessage("Common", "OKWFrameObjectMethodNotImplemented", (Object)"Select( ArrayList<String> )");
        throw new OKWFrameObjectMethodNotImplemented(lvsLM);
    }

    public void SelectMenu() {
        String lvsLM = this.LM.GetMessage("Common", "OKWFrameObjectMethodNotImplemented", (Object)"SelectMenu()");
        throw new OKWFrameObjectMethodNotImplemented(lvsLM);
    }

    public void SelectMenu(ArrayList<String> Values) {
        String lvsLM = this.LM.GetMessage("Common", "OKWFrameObjectMethodNotImplemented", (Object)"SelectMenu_Value()");
        throw new OKWFrameObjectMethodNotImplemented(lvsLM);
    }

    public void SetFocus() {
        this.WaitForInteraction(() -> this.Me().sendKeys(new CharSequence[]{""}));
    }

    public void SetValue(ArrayList<String> Values) {
        String lvsLM = this.LM.GetMessage("Common", "OKWGUIObjectNotFoundException", (Object)"SetValue()");
        throw new OKWFrameObjectMethodNotImplemented(lvsLM);
    }

    public void TypeKey(ArrayList<String> fps_Values) {
        this.SetFocus();
        for (String Value : fps_Values) {
            Logger_Sngltn.getInstance().LogPrintDebug(">>" + Value + "<<");
            if (Value.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("DELETE"))) {
                this.WaitForInteraction(() -> this.Me().clear());
                continue;
            }
            String resolvedValue = SeKeyParser.ParseMe(Value);
            this.WaitForInteraction(() -> this.Me().sendKeys(new CharSequence[]{resolvedValue}));
        }
    }

    public ArrayList<String> VerifyCaption() {
        ArrayList<String> lvLsReturn = new ArrayList();
        lvLsReturn = this.getCaption();
        return lvLsReturn;
    }

    public Boolean VerifyExists() {
        Boolean lvbReturn = false;
        lvbReturn = this.WaitForInteractionReturnBoolean(() -> this.getExists());
        return lvbReturn;
    }

    public Boolean VerifyIsActive() {
        Boolean lvbReturn = false;
        lvbReturn = this.getIsActive();
        return lvbReturn;
    }

    public Boolean VerifyHasFocus() {
        Boolean lvbReturn = false;
        lvbReturn = this.getHasFocus();
        return lvbReturn;
    }

    public ArrayList<String> VerifyLabel() {
        ArrayList<String> lvLsReturn = new ArrayList();
        lvLsReturn = this.getLabel();
        return lvLsReturn;
    }

    public Integer VerifyMaxLength() {
        Integer lvLsReturn = null;
        lvLsReturn = this.getMaxLength();
        return lvLsReturn;
    }

    public Integer VerifyMinLength() {
        Integer lvLsReturn = null;
        lvLsReturn = this.getMinLength();
        return lvLsReturn;
    }

    public ArrayList<String> VerifyPlaceholder() {
        ArrayList lvLsReturn = new ArrayList();
        lvLsReturn = this.getPlaceholder();
        return lvLsReturn;
    }

    public ArrayList<String> VerifyTooltip() {
        ArrayList<String> lvLsReturn = new ArrayList();
        lvLsReturn = this.getTooltip();
        return lvLsReturn;
    }

    public ArrayList<String> VerifyValue() {
        ArrayList<String> lvLsReturn = null;
        lvLsReturn = this.getValue();
        return lvLsReturn;
    }

    public Boolean WaitForMe() {
        Boolean lvbReturn = super.WaitForMe();
        if (!lvbReturn.booleanValue()) {
            this.ResOpenList("GUI-Object not found...");
            this.LogPrint("Locator: '" + this.getLocator() + "'");
            this.ResCloseList();
            String lvsLM = this.LM.GetMessage("Common", "OKWGUIObjectNotFoundException", (Object)"WaitForMe()");
            throw new OKWGUIObjectNotFoundException(lvsLM);
        }
        return lvbReturn;
    }

    public Boolean scrollIntoView() {
        Boolean lvbReturn = false;
        this.LogPrint("Scrolling the object into the visible area...");
        ((JavascriptExecutor)SeDriver.getInstance().getDriver()).executeScript("arguments[0].scrollIntoView({block:'nearest'})", new Object[]{this.Me()});
        try {
            this.LogPrint("... und warte 1s.");
            Thread.sleep(1000L);
            lvbReturn = true;
        }
        catch (InterruptedException e) {
            this.LogWarning("Unexpected exception InterruptedException during ScrollWait, we ignore that...");
            e.printStackTrace();
        }
        return lvbReturn;
    }

    public void WaitForInteraction(Runnable Method2Call) {
        Throwable TimeOutException = null;
        boolean isExecuted = false;
        try {
            OKW myOKW = FrameObjectDictionary_Sngltn.getInstance().getOKW(this.getKN());
            OKW_TimeOut timeout = new OKW_TimeOut(Integer.valueOf(myOKW.WaitForMe_TO()), Integer.valueOf(myOKW.WaitForMe_PT()));
            Integer Count = 0;
            Integer MaxCount = timeout.getMaxCount();
            Integer PollTime = timeout.getPT();
            while (Count <= MaxCount) {
                try {
                    Method2Call.run();
                    isExecuted = true;
                    break;
                }
                catch (OKWGUIObjectNotFoundException e) {
                    TimeOutException = e;
                    this.LogPrint("OKWGUIObjectNotFoundException: WebElement currently does not not exist. - wait and retry...");
                }
                catch (InvalidElementStateException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("InvalidElementStateException: WebElement is currently not ready for interaction. - scroll, wait and retry...");
                    this.scrollIntoView();
                }
                catch (StaleElementReferenceException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("StaleElementReferenceException: Update WebElement reference to the DOM. -  wait and try ...");
                }
                try {
                    Thread.sleep(PollTime.intValue());
                }
                catch (InterruptedException e) {
                    TimeOutException = new RuntimeException("Unexpected InterruptedException in Threadsleep!", e);
                    e.printStackTrace();
                }
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
            if (!isExecuted) {
                throw TimeOutException;
            }
        }
        catch (IOException | JAXBException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public String WaitForInteractionReturnString(Supplier<String> Method2Call) {
        String lvsReturn = null;
        Throwable TimeOutException = null;
        boolean isExecuted = false;
        try {
            OKW myOKW = FrameObjectDictionary_Sngltn.getInstance().getOKW(this.getKN());
            OKW_TimeOut timeout = new OKW_TimeOut(Integer.valueOf(myOKW.WaitForMe_TO()), Integer.valueOf(myOKW.WaitForMe_PT()));
            Integer Count = 0;
            Integer MaxCount = timeout.getMaxCount();
            Integer PollTime = timeout.getPT();
            while (Count <= MaxCount) {
                try {
                    lvsReturn = Method2Call.get();
                    isExecuted = true;
                    break;
                }
                catch (OKWGUIObjectNotFoundException e) {
                    TimeOutException = e;
                    this.LogPrint("OKWGUIObjectNotFoundException: WebElement currently does not not exist. - wait and retry...");
                }
                catch (InvalidElementStateException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("InvalidElementStateException: WebElement is currently not ready for interaction. - scroll, wait and retry...");
                    this.scrollIntoView();
                }
                catch (StaleElementReferenceException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("StaleElementReferenceException: Update WebElement reference to the DOM. -  wait and retry ...");
                }
                try {
                    Thread.sleep(PollTime.intValue());
                }
                catch (InterruptedException e) {
                    TimeOutException = new RuntimeException("Unexpected InterruptedException in Threadsleep!", e);
                    e.printStackTrace();
                }
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
            if (!isExecuted) {
                throw TimeOutException;
            }
        }
        catch (IOException | JAXBException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RuntimeException(e);
        }
        return lvsReturn;
    }

    public Boolean WaitForInteractionReturnBoolean(Supplier<Boolean> Method2Call) {
        Boolean lvbReturn = null;
        Throwable TimeOutException = null;
        boolean isExecuted = false;
        try {
            OKW myOKW = FrameObjectDictionary_Sngltn.getInstance().getOKW(this.getKN());
            OKW_TimeOut timeout = new OKW_TimeOut(Integer.valueOf(myOKW.WaitForMe_TO()), Integer.valueOf(myOKW.WaitForMe_PT()));
            Integer Count = 0;
            Integer MaxCount = timeout.getMaxCount();
            Integer PollTime = timeout.getPT();
            while (Count <= MaxCount) {
                try {
                    lvbReturn = Method2Call.get();
                    isExecuted = true;
                    break;
                }
                catch (OKWGUIObjectNotFoundException e) {
                    TimeOutException = e;
                    this.LogPrint("OKWGUIObjectNotFoundException: WebElement currently does not not exist. - wait and retry...");
                }
                catch (InvalidElementStateException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("InvalidElementStateException: WebElement is currently not ready for interaction. - scroll, wait and retry...");
                    this.scrollIntoView();
                }
                catch (StaleElementReferenceException e) {
                    TimeOutException = new RuntimeException(e);
                    this.LogPrint("StaleElementReferenceException: Update WebElement reference to the DOM. -  wait and retry ...");
                }
                try {
                    Thread.sleep(PollTime.intValue());
                }
                catch (InterruptedException e) {
                    TimeOutException = new RuntimeException("Unexpected InterruptedException in Threadsleep!", e);
                    e.printStackTrace();
                }
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
            if (!isExecuted) {
                throw TimeOutException;
            }
            this.LogPrint("Interaction succesfull executed");
        }
        catch (IOException | JAXBException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RuntimeException(e);
        }
        return lvbReturn;
    }
}

