/*
 * Decompiled with CFR 0.152.
 */
package okw.gui.adapter.selenium.webdriver;

import java.util.ArrayList;
import java.util.List;
import okw.OKW_Helper;
import okw.exceptions.OKWGUIObjectNotFoundException;
import okw.exceptions.OKWGUIObjectNotUniqueException;
import okw.log.Logger_Sngltn;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class SeDriver {
    protected Logger_Sngltn MyLogger = Logger_Sngltn.getInstance();
    public WebDriver driver = null;
    private String currentiframeID = "";
    private static SeDriver instance = new SeDriver();

    public String getCurrentiframeID() {
        return this.currentiframeID;
    }

    private SeDriver() {
    }

    public static SeDriver getInstance() {
        return instance;
    }

    public void DriveChrome() {
        this.driver = new ChromeDriver();
    }

    public void DriveFireFox() {
        this.driver = new FirefoxDriver();
    }

    public void DriveUnitDriver() {
        try {
            this.driver = new HtmlUnitDriver(true);
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
        }
    }

    public void swichToFrame(String iframeID) {
        if (!this.currentiframeID.equalsIgnoreCase(iframeID)) {
            this.driver.switchTo().defaultContent();
            if (!OKW_Helper.isStringNullOrEmpty((String)iframeID).booleanValue()) {
                try {
                    this.driver.switchTo().frame(iframeID);
                    this.currentiframeID = iframeID;
                }
                catch (NoSuchFrameException e) {
                    System.out.println("Unable to locate frame with id " + iframeID + e.getStackTrace());
                }
                catch (Exception e) {
                    System.out.println("Unable to navigate to frame with id " + iframeID + e.getStackTrace());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFrameID4Locator(String fpsLocator) {
        String return_iFrame = null;
        WebElement myWebElement = null;
        this.MyLogger.LogFunctionStartDebug("SeDriver.getFrameID4Locator", new String[]{"fpsLocator", fpsLocator});
        ArrayList<String> iframeIDs = new ArrayList<String>();
        iframeIDs.add(this.currentiframeID);
        iframeIDs.addAll(this.getIframesID());
        for (String iframeID : iframeIDs) {
            try {
                myWebElement = this.getElement(iframeID, fpsLocator);
                if (myWebElement == null) continue;
                return_iFrame = this.currentiframeID;
                break;
            }
            catch (OKWGUIObjectNotFoundException e) {}
            continue;
            finally {
                this.MyLogger.LogFunctionEndDebug();
            }
        }
        this.MyLogger.LogFunctionEndDebug("iFrame: '" + return_iFrame + "'");
        return return_iFrame;
    }

    public ArrayList<String> getIframesID() {
        this.MyLogger.LogFunctionStartDebug("SeDriver.getIframesID", new String[0]);
        ArrayList<String> lvReturn = new ArrayList<String>();
        List iframes = this.driver.findElements(By.tagName((String)"iframe"));
        this.MyLogger.ResOpenListDebug("iFrames...");
        for (WebElement iframe : iframes) {
            String myID = iframe.getAttribute("id");
            if (!OKW_Helper.isStringNullOrEmpty((String)myID).booleanValue()) {
                lvReturn.add(myID);
                this.MyLogger.LogPrintDebug("ID='" + myID + "'");
                continue;
            }
            myID = iframe.getAttribute("name");
            if (!OKW_Helper.isStringNullOrEmpty((String)myID).booleanValue()) {
                lvReturn.add(myID);
                this.MyLogger.LogPrintDebug("name='" + myID + "'");
                continue;
            }
            this.MyLogger.LogWarning("iFrame has neither ID nor Name:" + iframe.toString());
        }
        this.MyLogger.ResCloseListDebug();
        this.MyLogger.LogFunctionEndDebug(lvReturn);
        return lvReturn;
    }

    public WebElement getElement(String fpsFrameID, String fpsLocator) {
        WebElement me = null;
        List meme = null;
        this.MyLogger.LogFunctionStartDebug("SeDriver.getElement", new String[]{"fpsFrameID", fpsFrameID, "fpsLocator", fpsLocator});
        this.swichToFrame(fpsFrameID);
        meme = this.driver.findElements(By.xpath((String)fpsLocator));
        if (meme.size() == 0) {
            String lvsPrintMe = "GUI-Objekt nicht gefunden! IFrame: '" + fpsFrameID + "' Locator: '" + fpsLocator + "'";
            this.MyLogger.LogPrint(lvsPrintMe);
            throw new OKWGUIObjectNotFoundException(lvsPrintMe);
        }
        if (meme.size() > 1) {
            String lvsPrintMe = "Locator ist nicht eindeutig! IFrame: '" + fpsFrameID + "' Locator: '" + fpsLocator + "'";
            this.MyLogger.LogWarning(lvsPrintMe);
            throw new OKWGUIObjectNotUniqueException(lvsPrintMe);
        }
        String lvsPrintMe = "GUI-Objekt gefunden IFrame: '" + fpsFrameID + "' Locator: '" + fpsLocator + "'";
        this.MyLogger.LogPrintDebug(lvsPrintMe);
        me = (WebElement)meme.get(0);
        this.MyLogger.LogFunctionEndDebug(me.toString());
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> getElements(String fpsFrameID, String fpsLocator) {
        List meme = null;
        this.MyLogger.LogFunctionStartDebug("SeDriver.getElement", new String[]{"fpsFrameID", fpsFrameID, "fpsLocator", fpsLocator});
        try {
            this.swichToFrame(fpsFrameID);
            meme = this.driver.findElements(By.xpath((String)fpsLocator));
        }
        finally {
            this.MyLogger.LogFunctionEndDebug();
        }
        return meme;
    }
}

