/*
 * Decompiled with CFR 0.152.
 */
package okw.log.log2html;

import java.util.ArrayList;
import java.util.List;
import okw.log.log2html.LogTimer;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public abstract class LogBase {
    protected static Integer AllCount = 0;
    protected Integer myID = 0;
    protected String Info = "";
    protected LogTimer myDuration = new LogTimer();
    protected LogBase myParent = null;
    protected List<LogBase> myLogs = new ArrayList<LogBase>();
    protected int Level = -1;
    protected String myIndentionBase = "    ";
    protected Boolean bWarning = false;
    protected Boolean bException = false;
    protected Boolean bError = false;

    public void setParent(LogBase fpParent) {
        this.myParent = fpParent;
    }

    protected void abort() {
        this.setError();
    }

    public LogBase getParent() {
        return this.myParent;
    }

    protected int getLevel() {
        int myReturn = this.Level >= 0 ? this.Level : (this.getParent() != null ? (this.Level = this.getParent().getLevel() + 1) : 0);
        return myReturn;
    }

    protected String getLevelIndention() {
        StringBuilder myIndention = new StringBuilder();
        int n = this.getLevel();
        for (int i = 1; i <= n; ++i) {
            myIndention.append(this.myIndentionBase);
        }
        return myIndention.toString();
    }

    protected String getLevelIndention(int shift) {
        StringBuilder myIndention = new StringBuilder();
        int n = this.getLevel() + shift;
        for (int i = 1; i <= n; ++i) {
            myIndention.append(this.myIndentionBase);
        }
        return myIndention.toString();
    }

    protected void setWarning() {
        if (!this.bWarning.booleanValue()) {
            this.bWarning = true;
            if (this.myParent != null) {
                this.myParent.setWarning();
            }
        }
    }

    protected Boolean getWarning() {
        return this.bWarning;
    }

    protected void setException() {
        if (!this.bException.booleanValue()) {
            this.bException = true;
            if (this.myParent != null) {
                this.myParent.setException();
            }
        }
    }

    protected void setError() {
        if (!this.bError.booleanValue()) {
            this.bError = true;
            if (this.myParent != null) {
                this.myParent.setError();
            }
        }
    }

    protected Boolean getError() {
        return this.bError;
    }

    protected String getInfoAsHTML() {
        String lvsReturn = LogBase.Markdown2HTML(this.getInfo());
        return lvsReturn;
    }

    protected String getInfo() {
        return LogBase.escapeHTML(this.Info);
    }

    static String Markdown2HTML(String fpsMarkdown) {
        String lvsReturn;
        if (fpsMarkdown != null) {
            Parser parser = Parser.builder().build();
            Node document = parser.parse(fpsMarkdown);
            HtmlRenderer renderer = HtmlRenderer.builder().build();
            lvsReturn = renderer.render(document);
            lvsReturn = lvsReturn.replaceAll("^<p>", "").replaceAll("</p>$", "").trim();
        } else {
            lvsReturn = "";
        }
        return lvsReturn;
    }

    protected abstract void ErrorCount();

    protected abstract void ExceptionCount();

    protected abstract void WarningCount();

    protected abstract void PassedCount();

    protected abstract void PrintCount();

    protected abstract void TestcaseCount();

    protected abstract void TestcaseFail();

    protected abstract void TestcasePass();

    protected abstract void FunctionCount();

    protected abstract void FunctionFail();

    protected abstract void FunctionPass();

    protected abstract void KeyWordCount();

    protected abstract void KeyWordFail();

    protected abstract void KeyWordPass();

    protected abstract void SequenceCount();

    protected abstract void SequenceFail();

    protected abstract void SequencePass();

    protected abstract void StepCount();

    protected abstract void StepFail();

    protected abstract void StepPass();

    protected abstract void LocalACCallCount();

    protected abstract void LocalACCallFail();

    protected abstract void LocalACCallPass();

    protected abstract void RemoteACCallCount();

    protected abstract void RemoteACCallFail();

    protected abstract void RemoteACCallPass();

    protected String getHTMLResult() {
        StringBuilder sbResult = new StringBuilder();
        String lvsIndention = this.getLevelIndention();
        sbResult.append(lvsIndention + "<div class='" + this.getClass().getSimpleName() + "'>\n");
        sbResult.append(lvsIndention + this.myIndentionBase + "<div class='Header'>\n");
        if (!this.myLogs.isEmpty()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='FoldMe' onClick='div_change(" + this.myID.toString() + ")'></div>\n");
        }
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Duration'>" + this.myDuration.getSeconds("#0.000") + " s</div>");
        if (this.bException.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='ExceptionSign' title='Exception...'></div>\n");
        }
        if (this.bError.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='ErrorSign' title='Error...'></div>\n");
        }
        if (this.bWarning.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='WarningSign' title='Warning...'></div>\n");
        }
        if (this.bException.booleanValue() || this.bError.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Info_Fail'>" + this.getInfoAsHTML() + "</div>\n");
        } else {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='SuccessSign' title='Success...'></div>\n");
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Info_Pass'>" + this.getInfoAsHTML() + "</div>\n");
        }
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "</div>\n");
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Body' id='" + this.myID.toString() + "' style='display: none;'>\n");
        for (LogBase myLog : this.myLogs) {
            sbResult.append(myLog.getHTMLResult());
        }
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "</div>\n");
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "</div>\n");
        return sbResult.toString();
    }

    public static final String escapeHTML(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        block45: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block45;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block45;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block45;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block45;
                }
                case '\u00e0': {
                    sb.append("&agrave;");
                    continue block45;
                }
                case '\u00c0': {
                    sb.append("&Agrave;");
                    continue block45;
                }
                case '\u00e2': {
                    sb.append("&acirc;");
                    continue block45;
                }
                case '\u00c2': {
                    sb.append("&Acirc;");
                    continue block45;
                }
                case '\u00e4': {
                    sb.append("&auml;");
                    continue block45;
                }
                case '\u00c4': {
                    sb.append("&Auml;");
                    continue block45;
                }
                case '\u00e5': {
                    sb.append("&aring;");
                    continue block45;
                }
                case '\u00c5': {
                    sb.append("&Aring;");
                    continue block45;
                }
                case '\u00e6': {
                    sb.append("&aelig;");
                    continue block45;
                }
                case '\u00c6': {
                    sb.append("&AElig;");
                    continue block45;
                }
                case '\u00e7': {
                    sb.append("&ccedil;");
                    continue block45;
                }
                case '\u00c7': {
                    sb.append("&Ccedil;");
                    continue block45;
                }
                case '\u00e9': {
                    sb.append("&eacute;");
                    continue block45;
                }
                case '\u00c9': {
                    sb.append("&Eacute;");
                    continue block45;
                }
                case '\u00e8': {
                    sb.append("&egrave;");
                    continue block45;
                }
                case '\u00c8': {
                    sb.append("&Egrave;");
                    continue block45;
                }
                case '\u00ea': {
                    sb.append("&ecirc;");
                    continue block45;
                }
                case '\u00ca': {
                    sb.append("&Ecirc;");
                    continue block45;
                }
                case '\u00eb': {
                    sb.append("&euml;");
                    continue block45;
                }
                case '\u00cb': {
                    sb.append("&Euml;");
                    continue block45;
                }
                case '\u00ef': {
                    sb.append("&iuml;");
                    continue block45;
                }
                case '\u00cf': {
                    sb.append("&Iuml;");
                    continue block45;
                }
                case '\u00f4': {
                    sb.append("&ocirc;");
                    continue block45;
                }
                case '\u00d4': {
                    sb.append("&Ocirc;");
                    continue block45;
                }
                case '\u00f6': {
                    sb.append("&ouml;");
                    continue block45;
                }
                case '\u00d6': {
                    sb.append("&Ouml;");
                    continue block45;
                }
                case '\u00f8': {
                    sb.append("&oslash;");
                    continue block45;
                }
                case '\u00d8': {
                    sb.append("&Oslash;");
                    continue block45;
                }
                case '\u00df': {
                    sb.append("&szlig;");
                    continue block45;
                }
                case '\u00f9': {
                    sb.append("&ugrave;");
                    continue block45;
                }
                case '\u00d9': {
                    sb.append("&Ugrave;");
                    continue block45;
                }
                case '\u00fb': {
                    sb.append("&ucirc;");
                    continue block45;
                }
                case '\u00db': {
                    sb.append("&Ucirc;");
                    continue block45;
                }
                case '\u00fc': {
                    sb.append("&uuml;");
                    continue block45;
                }
                case '\u00dc': {
                    sb.append("&Uuml;");
                    continue block45;
                }
                case '\u00ae': {
                    sb.append("&reg;");
                    continue block45;
                }
                case '\u00a9': {
                    sb.append("&copy;");
                    continue block45;
                }
                case '\u20ac': {
                    sb.append("&euro;");
                    continue block45;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    continue block45;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

