/*
 * Decompiled with CFR 0.152.
 */
package okw.log.log2html;

import java.text.DecimalFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class LogTimer {
    private long TimerBegin;
    private long TimerEnd;
    private Instant lvStartTime;
    private Instant lvEndTime;
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MMM-dd HH:mm:ss.SSS").withLocale(Locale.GERMANY).withZone(ZoneId.systemDefault());

    public void startTimer() {
        this.TimerBegin = System.nanoTime();
        this.lvStartTime = Instant.now();
    }

    public void stopTimer() {
        this.TimerEnd = System.nanoTime();
        this.lvEndTime = Instant.now();
    }

    public long getNanos() {
        long lvlReturn = this.TimerEnd - this.TimerBegin;
        return lvlReturn;
    }

    public long getMillis() {
        long lvlReturn = this.TimerEnd - this.TimerBegin;
        lvlReturn = TimeUnit.MILLISECONDS.convert(lvlReturn, TimeUnit.NANOSECONDS);
        return lvlReturn;
    }

    public String getSeconds(String fpsFormat) {
        double seconds = (double)this.getNanos() / 1.0E9;
        DecimalFormat myFormatter = new DecimalFormat(fpsFormat);
        String output = myFormatter.format(seconds);
        return output;
    }

    public String getMilliSeconds(String fpsFormat) {
        double seconds = (double)this.getNanos() / 1000000.0;
        DecimalFormat myFormatter = new DecimalFormat(fpsFormat);
        String output = myFormatter.format(seconds);
        return output;
    }

    public String getStartTime() {
        String lvsReturn = this.formatter.format(this.lvStartTime);
        return lvsReturn;
    }

    public Long getStartTimeMillis() {
        long lvlReturn = this.TimerBegin;
        lvlReturn = TimeUnit.MILLISECONDS.convert(lvlReturn, TimeUnit.NANOSECONDS);
        return lvlReturn;
    }

    public String getEndTime() {
        String lvsReturn = this.formatter.format(this.lvEndTime);
        return lvsReturn;
    }

    public Long getEndTimeMillis() {
        long lvlReturn = this.TimerEnd;
        lvlReturn = TimeUnit.MILLISECONDS.convert(lvlReturn, TimeUnit.NANOSECONDS);
        return lvlReturn;
    }
}

