/*
 * Decompiled with CFR 0.152.
 */
package okw.log.log2html;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import okw.log.ILogger;
import okw.log.log2html.LogBase;
import okw.log.log2html.LogBaseNode;
import okw.log.log2html.LogError;
import okw.log.log2html.LogException;
import okw.log.log2html.LogFunction;
import okw.log.log2html.LogFunctionDebug;
import okw.log.log2html.LogKeyword;
import okw.log.log2html.LogLocalACCall;
import okw.log.log2html.LogPass;
import okw.log.log2html.LogPrint;
import okw.log.log2html.LogPrintDebug;
import okw.log.log2html.LogRemoteACCall;
import okw.log.log2html.LogSequence;
import okw.log.log2html.LogSourceLocation;
import okw.log.log2html.LogStep;
import okw.log.log2html.LogTestcase;
import okw.log.log2html.LogWarning;
import okw.log.log2html.ResultList;
import okw.log.log2html.ResultListDebug;

public class Log2HTML
extends LogBaseNode
implements ILogger {
    private Stack<LogBase> Pointer2LogBaseStack = new Stack();
    private String name = "";
    private String result = "";

    public Log2HTML() {
        this.myDuration.startTimer();
        this.Pointer2LogBaseStack.push(this);
    }

    public Log2HTML(String featereName) {
        this.myDuration.startTimer();
        this.name = featereName;
        this.Pointer2LogBaseStack.push(this);
    }

    public void LogPass(String fpsMessage) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        this.Pointer2LogBaseStack.peek().myLogs.add(new LogPass(this.Pointer2LogBaseStack.peek(), fpsMessage));
    }

    public void LogPrint(String fpsMessage) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        this.Pointer2LogBaseStack.peek().myLogs.add(new LogPrint(this.Pointer2LogBaseStack.peek(), fpsMessage));
    }

    public void LogPrintDebug(String fpsMessage) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        this.Pointer2LogBaseStack.peek().myLogs.add(new LogPrintDebug(this.Pointer2LogBaseStack.peek(), fpsMessage));
    }

    public void LogWarning(String fpsMessage) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        this.Pointer2LogBaseStack.peek().myLogs.add(new LogWarning(this.Pointer2LogBaseStack.peek(), fpsMessage));
    }

    public void LogError(String fpsMessage) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        this.Pointer2LogBaseStack.peek().myLogs.add(new LogError(this.Pointer2LogBaseStack.peek(), fpsMessage));
    }

    public void LogException(String fpsMessage) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        this.Pointer2LogBaseStack.peek().myLogs.add(new LogException(this.Pointer2LogBaseStack.peek(), fpsMessage));
    }

    public void LogSourceLocation(String Start, String End, String featureName, String sourceType) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        this.Pointer2LogBaseStack.peek().myLogs.add(new LogSourceLocation(this.Pointer2LogBaseStack.peek(), Start, End, featureName, sourceType));
    }

    public void LogFunctionStart(String fps_FunctionName, String ... fpsParameter) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        LogFunction myLog = new LogFunction(this.Pointer2LogBaseStack.peek(), fps_FunctionName, fpsParameter);
        myLog.myDuration.startTimer();
        this.Pointer2LogBaseStack.peek().myLogs.add(myLog);
        this.Pointer2LogBaseStack.push(myLog);
    }

    public void LogFunctionStartDebug(String fps_FunctionName, String ... fpsParameter) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        LogFunctionDebug myLog = new LogFunctionDebug(this.Pointer2LogBaseStack.peek(), fps_FunctionName, fpsParameter);
        myLog.myDuration.startTimer();
        this.Pointer2LogBaseStack.peek().myLogs.add(myLog);
        this.Pointer2LogBaseStack.push(myLog);
    }

    public void LogFunctionEnd() {
        LogBase myLog = this.Pointer2LogBaseStack.pop();
        myLog.myDuration.stopTimer();
        LogFunction myLogFunction = (LogFunction)myLog;
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.FunctionPass;
            Integer n2 = this.FunctionPass = Integer.valueOf(this.FunctionPass + 1);
        }
    }

    public void LogFunctionEndDebug() {
        LogBase myLog = this.Pointer2LogBaseStack.pop();
        myLog.myDuration.stopTimer();
        LogFunctionDebug myLogFunction = (LogFunctionDebug)myLog;
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.FunctionPass;
            Integer n2 = this.FunctionPass = Integer.valueOf(this.FunctionPass + 1);
        }
    }

    public void LogFunctionEndDebug(Boolean fpb_Return) {
        LogBase myLog = this.Pointer2LogBaseStack.pop();
        myLog.myDuration.stopTimer();
        LogFunctionDebug myLogFunction = (LogFunctionDebug)myLog;
        myLogFunction.setReturn(fpb_Return.toString());
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.FunctionPass;
            Integer n2 = this.FunctionPass = Integer.valueOf(this.FunctionPass + 1);
        }
    }

    public void LogFunctionEnd(Boolean Return) {
        LogBase myLog = this.Pointer2LogBaseStack.pop();
        myLog.myDuration.stopTimer();
        LogFunction myLogFunction = (LogFunction)myLog;
        myLogFunction.setReturn(Return.toString());
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.FunctionPass;
            Integer n2 = this.FunctionPass = Integer.valueOf(this.FunctionPass + 1);
        }
    }

    public void LogFunctionEnd(String fps_Return) {
        LogBase myLog = this.Pointer2LogBaseStack.pop();
        myLog.myDuration.stopTimer();
        LogFunction myLogFunction = (LogFunction)myLog;
        myLogFunction.setReturn(fps_Return);
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.FunctionPass;
            Integer n2 = this.FunctionPass = Integer.valueOf(this.FunctionPass + 1);
        }
    }

    public void LogFunctionEndDebug(String fps_Return) {
        LogBase myLog = this.Pointer2LogBaseStack.pop();
        myLog.myDuration.stopTimer();
        LogFunctionDebug myLogFunction = (LogFunctionDebug)myLog;
        myLogFunction.setReturn(fps_Return);
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.FunctionPass;
            Integer n2 = this.FunctionPass = Integer.valueOf(this.FunctionPass + 1);
        }
    }

    public void LogFunctionEnd(List<String> fps_Return) {
        LogBase myLog = this.Pointer2LogBaseStack.pop();
        myLog.myDuration.stopTimer();
        LogFunction myLogFunction = (LogFunction)myLog;
        myLogFunction.setReturn(fps_Return.toString());
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.FunctionPass;
            Integer n2 = this.FunctionPass = Integer.valueOf(this.FunctionPass + 1);
        }
    }

    public void LogFunctionEndDebug(List<String> fps_Return) {
        LogBase myLog = this.Pointer2LogBaseStack.pop();
        myLog.myDuration.stopTimer();
        LogFunctionDebug myLogFunction = (LogFunctionDebug)myLog;
        myLogFunction.setReturn(fps_Return.toString());
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.FunctionPass;
            Integer n2 = this.FunctionPass = Integer.valueOf(this.FunctionPass + 1);
        }
    }

    public void LogTestcaseStart(String fps_FunctionName) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        this.StopAllTimerAndEmptyStack();
        this.Pointer2LogBaseStack.push(this);
        LogTestcase myLog = new LogTestcase(this.Pointer2LogBaseStack.peek(), fps_FunctionName);
        myLog.myDuration.startTimer();
        this.Pointer2LogBaseStack.peek().myLogs.add(myLog);
        this.Pointer2LogBaseStack.push(myLog);
    }

    public void LogTestcaseEnd() {
        LogBase myLog = this.Pointer2LogBaseStack.pop();
        myLog.myDuration.stopTimer();
        LogTestcase myCheck = (LogTestcase)myLog;
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.TestcasePass;
            Integer n2 = this.TestcasePass = Integer.valueOf(this.TestcasePass + 1);
        }
        this.StopAllTimerAndEmptyStack();
    }

    public void LogKeyWordStart(String fps_FunctionName, String ... fpsParameter) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        LogKeyword myLog = new LogKeyword(this.Pointer2LogBaseStack.peek(), fps_FunctionName, fpsParameter);
        myLog.myDuration.startTimer();
        this.Pointer2LogBaseStack.peek().myLogs.add(myLog);
        this.Pointer2LogBaseStack.push(myLog);
    }

    public void LogKeyWordEnd() {
        LogBase myLog = this.Pointer2LogBaseStack.peek();
        myLog.myDuration.stopTimer();
        LogKeyword myCheck = (LogKeyword)myLog;
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            myLog.KeyWordPass();
        }
        this.Pointer2LogBaseStack.pop();
    }

    public void LogLocalACCallStart(String sourceExcerpt, String Type2) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        LogLocalACCall myLog = new LogLocalACCall(this.Pointer2LogBaseStack.peek(), sourceExcerpt, Type2);
        myLog.myDuration.startTimer();
        this.Pointer2LogBaseStack.peek().myLogs.add(myLog);
        this.Pointer2LogBaseStack.push(myLog);
    }

    public void LogLocalACCallEnd() {
        LogBase myLog = this.Pointer2LogBaseStack.peek();
        myLog.myDuration.stopTimer();
        LogLocalACCall myCheck = (LogLocalACCall)myLog;
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            myLog.LocalACCallPass();
        }
        this.Pointer2LogBaseStack.pop();
    }

    public void LogStepStart(String categoryName, String categoryType, String choiceValue, String featureName, String localCategoryName, String sourceExcerpt, String type) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        LogStep myLog = new LogStep(this.Pointer2LogBaseStack.peek(), categoryName, categoryType, choiceValue, featureName, localCategoryName, sourceExcerpt, type);
        myLog.myDuration.startTimer();
        this.Pointer2LogBaseStack.peek().myLogs.add(myLog);
        this.Pointer2LogBaseStack.push(myLog);
    }

    public void LogStepEnd() {
        LogBase myLog = this.Pointer2LogBaseStack.peek();
        myLog.myDuration.stopTimer();
        LogStep myCheck = (LogStep)myLog;
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.StepPass;
            Integer n2 = this.StepPass = Integer.valueOf(this.StepPass + 1);
        }
        this.Pointer2LogBaseStack.pop();
    }

    public void LogRemoteACCallStart(String sourceExcerpt, String Type2) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        LogRemoteACCall myLog = new LogRemoteACCall(this.Pointer2LogBaseStack.peek(), sourceExcerpt, Type2);
        myLog.myDuration.startTimer();
        this.Pointer2LogBaseStack.peek().myLogs.add(myLog);
        this.Pointer2LogBaseStack.push(myLog);
    }

    public void LogRemoteACCallEnd() {
        LogBase myLog = this.Pointer2LogBaseStack.peek();
        myLog.myDuration.stopTimer();
        LogRemoteACCall myCheck = (LogRemoteACCall)myLog;
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            Integer n = this.StepPass;
            Integer n2 = this.StepPass = Integer.valueOf(this.StepPass + 1);
        }
        this.Pointer2LogBaseStack.pop();
    }

    public void LogSequenceStart(String fpsKeywordName, String fpsWindowFN, String fpsSequenceName, String ... fpsParameter) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        LogSequence myLog = new LogSequence(this.Pointer2LogBaseStack.peek(), fpsWindowFN, fpsSequenceName, fpsParameter);
        myLog.myDuration.startTimer();
        this.Pointer2LogBaseStack.peek().myLogs.add(myLog);
        this.Pointer2LogBaseStack.push(myLog);
    }

    public void LogSequenceEnd() {
        LogBase myLog = this.Pointer2LogBaseStack.peek();
        myLog.myDuration.stopTimer();
        LogSequence myCheck = (LogSequence)myLog;
        if (!myLog.bError.booleanValue() && !myLog.bException.booleanValue()) {
            myLog.SequencePass();
        }
        this.Pointer2LogBaseStack.pop();
    }

    private String getHTMLFooter() {
        StringBuilder myResult = new StringBuilder();
        myResult.append("</body>\n");
        myResult.append("</html>\n");
        return myResult.toString();
    }

    private String getHTMLHeader() throws IOException {
        StringBuilder myResult = new StringBuilder();
        myResult.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
        myResult.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
        myResult.append("<head>\n");
        myResult.append("\t<title>TestPage Titel</title>\n");
        myResult.append("\t<meta charset=\"utf-8\"/>\n");
        myResult.append("\t<style>\n");
        myResult.append(this.getStyleSheet());
        myResult.append(this.getFoldScript());
        myResult.append("\t</style>\n");
        myResult.append("\t<script language='JavaScript'>\n");
        myResult.append("\tfunction div_change() {\n");
        myResult.append("\t\tfor (i = 0; i < div_change.arguments.length; i++) {\n");
        myResult.append("\t\tvar _id = div_change.arguments[i];\n");
        myResult.append("\t\tdocument.getElementById(_id).style.display = (document.getElementById(_id).style.display == 'none' ) ? 'block' : 'none';\n");
        myResult.append("\t\t}\n");
        myResult.append("\t}\n");
        myResult.append("\t</script>\n");
        myResult.append("</head>\n");
        myResult.append("<body>\n");
        myResult.append("<div class=OKW_Logo title='www.openkeyword.de'></div>\n");
        myResult.append("<h1>OpenKeyWord Testlog</h1>\n");
        return myResult.toString();
    }

    private String getStyleSheet() throws IOException {
        int length;
        StringBuilder myResult = new StringBuilder();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream("Log2HTML.css");
        byte[] buffer = new byte[2048];
        while ((length = is.read(buffer)) != -1) {
            myResult.append(new String(buffer, 0, length));
        }
        is.close();
        return myResult.toString();
    }

    private String getFoldScript() throws IOException {
        int length;
        StringBuilder myResult = new StringBuilder();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream("folder.script");
        byte[] buffer = new byte[2048];
        while ((length = is.read(buffer)) != -1) {
            myResult.append(new String(buffer, 0, length));
        }
        is.close();
        return myResult.toString();
    }

    private String getHTMLStatistics() {
        StringBuilder myResult = new StringBuilder();
        myResult.append("<h2>Test Statistics</h2>\n");
        myResult.append("<p><table class='statistics'>\n");
        myResult.append("\t<thead  class='statistics'>\n");
        myResult.append("\t\t<tr class='statistics'>\n");
        myResult.append("\t\t\t<th></th>\n");
        myResult.append("\t\t\t<th>Count</th>\n");
        myResult.append("\t\t\t<th colspan='3'></th>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t</thead>\n");
        myResult.append("\t<tbody>\n");
        myResult.append("\t\t<tr>\n");
        myResult.append("\t\t\t<td align='right'>Errors:</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.ErrorCount.toString() + "</td>\n");
        myResult.append("\t\t\t<td colspan='3'></td>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t\t<tr>\n");
        myResult.append("\t\t\t<td align='right'>Exceptions:</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.ExceptionCount.toString() + "</td>\n");
        myResult.append("\t\t\t<td colspan='3'></td>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t\t<tr>\n");
        myResult.append("\t\t\t<td align='right'>Warnings:</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.WarningCount.toString() + "</td>\n");
        myResult.append("\t\t\t<td colspan='3'></td>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t\t<tr>\n");
        myResult.append("\t\t\t<td align='right'>Passed:</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.PassedCount.toString() + "</td>\n");
        myResult.append("\t\t\t<td colspan='3'></td>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t<thead  class='statistics'>\n");
        myResult.append("\t\t<tr class='statistics'>\n");
        myResult.append("\t\t\t<th></th>\n");
        myResult.append("\t\t\t<th width='60px'>Count</th>\n");
        myResult.append("\t\t\t<th width='60px'>Pass</th>\n");
        myResult.append("\t\t\t<th width='60px'>Fail</th>\n");
        myResult.append("\t\t\t<th>Pass-Fail-Rate</th>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t</thead>\n");
        myResult.append("\t\t<tr>\n");
        myResult.append("\t\t\t<td align='right'>Test cases:</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.TestcaseCount.toString() + "</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.TestcasePass.toString() + "</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.TestcaseFail.toString() + "</td>\n");
        myResult.append("\t\t\t<td>" + this.getFailPassBar(this.TestcaseFail, this.TestcaseCount - this.TestcaseFail) + "</td>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t\t<tr>\n");
        myResult.append("\t\t\t<td align='right'>Sequences:</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.SequenceCount.toString() + "</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.SequencePass.toString() + "</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.SequenceFail.toString() + "</td>\n");
        myResult.append("\t\t\t<td >" + this.getFailPassBar(this.SequenceFail, this.SequenceCount - this.SequenceFail) + "</td>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t\t<tr>\n");
        myResult.append("\t\t\t<td align='right'>Keywords:</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.KeyWordCount.toString() + "</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.KeyWordPass.toString() + "</td>\n");
        myResult.append("\t\t\t<td align='center'>" + this.KeyWordFail.toString() + "</td>\n");
        myResult.append("\t\t\t<td>" + this.getFailPassBar(this.KeyWordFail, this.KeyWordCount - this.KeyWordFail) + "</td>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t\t<tr class='statistics'>\n");
        myResult.append("\t\t\t<th  colspan='5'>Timer</th>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t\t<tr>\n");
        myResult.append("\t\t\t<td align='right'>Start time:</td>\n");
        myResult.append("\t\t\t<td align='center' colspan='4'>" + this.myDuration.getStartTime() + "</td>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("\t\t<tr>\n");
        myResult.append("\t\t\t<td align='right'>End time:</td>\n");
        myResult.append("\t\t\t<td align='center' colspan='4'>" + this.myDuration.getEndTime() + "</td>\n");
        myResult.append("\t\t</tr>\n");
        myResult.append("</table></p>\n");
        return myResult.toString();
    }

    private String getFailPassBar(int FailCount, int PassCount) {
        StringBuilder myResult = new StringBuilder();
        if (FailCount + PassCount > 0) {
            float lfFailRate = (float)FailCount * 100.0f / (float)(FailCount + PassCount);
            float lfPassRate = 100.0f - lfFailRate;
            myResult.append("<div class='pass-fail-graph'>\n");
            myResult.append("\t<div class='pass-bar' style='width: " + String.format(Locale.ENGLISH, "%.2f", Float.valueOf(lfPassRate)) + "%'></div>\n");
            myResult.append("\t<div class='fail-bar' style='width: " + String.format(Locale.ENGLISH, "%.2f", Float.valueOf(lfFailRate)) + "%'></div>\n");
            myResult.append("</div>\n");
        }
        return myResult.toString();
    }

    public void Result2HTML(String fpsFilename) {
        StringBuilder myResult = new StringBuilder();
        try {
            this.StopAllTimerAndEmptyStack();
            myResult.append(this.getHTMLHeader());
            myResult.append(this.getHTMLStatistics());
            myResult.append("<h2>Result Log</h2>\n");
            myResult.append(this.getHTMLResult());
            myResult.append(this.getHTMLFooter());
            FileWriter fw = new FileWriter(fpsFilename);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(myResult.toString());
            bw.close();
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
        }
    }

    @Override
    protected String getHTMLResult() {
        StringBuilder sbResult = new StringBuilder();
        for (LogBase myLog : this.myLogs) {
            sbResult.append(myLog.getHTMLResult());
        }
        return sbResult.toString();
    }

    public String Result2JSON(String fpsFileName) {
        StringBuilder myJSON = new StringBuilder();
        String myJSONReturn = "";
        try {
            this.StopAllTimerAndEmptyStack();
            myJSON.append(this.getJSONHeader());
            myJSON.append(this.jsonStructureComma("statistics", this.getJSONStatistics()));
            myJSON.append(this.jsonArray("features", this.jsonArrayElement(this.getJSONResult())));
            myJSON.append(this.getJSONFooter());
            myJSONReturn = this.beautify(myJSON.toString());
            System.out.print(myJSON.toString());
            FileWriter fw = new FileWriter(fpsFileName);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(myJSONReturn);
            bw.close();
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
        }
        return myJSONReturn;
    }

    private String getJSONHeader() {
        StringBuilder myResult = new StringBuilder();
        myResult.append("{");
        return myResult.toString();
    }

    @Override
    protected String getJSONResult() {
        StringBuilder myJSON = new StringBuilder();
        StringBuilder myJSONForLoop = new StringBuilder();
        myJSON.append(this.jsonElementComma("name", this.name));
        myJSON.append(this.jsonElement("result", this.result));
        Boolean GreaterOne = false;
        for (LogBase myLog : this.myLogs) {
            if (GreaterOne.booleanValue()) {
                myJSONForLoop.append(", ");
            } else {
                GreaterOne = true;
            }
            myJSONForLoop.append(this.jsonArrayElement(myLog.getJSONResult()));
        }
        if (GreaterOne.booleanValue()) {
            myJSON.append(", " + this.jsonArray("tests", myJSONForLoop.toString()));
        }
        return myJSON.toString();
    }

    private String getJSONFooter() {
        StringBuilder myResult = new StringBuilder();
        myResult.append("}");
        return myResult.toString();
    }

    String beautify(String json) {
        String myReturn = "";
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        try {
            Object obj = mapper.readValue(json, Object.class);
            myReturn = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myReturn;
    }

    @Override
    protected void abort() {
    }

    public void ResOpenList(String fps_ListHeader) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        ResultList myLog = new ResultList(this.Pointer2LogBaseStack.peek(), fps_ListHeader);
        myLog.myDuration.startTimer();
        this.Pointer2LogBaseStack.peek().myLogs.add(myLog);
        this.Pointer2LogBaseStack.push(myLog);
    }

    public void ResOpenListDebug(String fps_ListHeader) {
        Integer n = AllCount;
        Integer n2 = AllCount = Integer.valueOf(AllCount + 1);
        ResultListDebug myLog = new ResultListDebug(this.Pointer2LogBaseStack.peek(), fps_ListHeader);
        myLog.myDuration.startTimer();
        this.Pointer2LogBaseStack.peek().myLogs.add(myLog);
        this.Pointer2LogBaseStack.push(myLog);
    }

    private void StopAllTimerAndEmptyStack() {
        if (this.Pointer2LogBaseStack.size() > 1) {
            this.Pointer2LogBaseStack.peek().abort();
        }
        while (!this.Pointer2LogBaseStack.isEmpty()) {
            this.Pointer2LogBaseStack.pop().myDuration.stopTimer();
        }
    }

    public void ResCloseList() {
        LogBase myLog = this.Pointer2LogBaseStack.pop();
        myLog.myDuration.stopTimer();
        ResultList myResultList = (ResultList)myLog;
        if (!myLog.bError.booleanValue() || !myLog.bException.booleanValue()) {
            Integer n = this.FunctionPass;
            Integer n2 = this.FunctionPass = Integer.valueOf(this.FunctionPass + 1);
        }
    }

    public void ResCloseListDebug() {
        LogBase myLog = this.Pointer2LogBaseStack.peek();
        myLog.myDuration.stopTimer();
        ResultListDebug myResultList = (ResultListDebug)myLog;
        if (!myLog.bError.booleanValue() || !myLog.bException.booleanValue()) {
            Integer n = this.FunctionPass;
            Integer n2 = this.FunctionPass = Integer.valueOf(this.FunctionPass + 1);
        }
        this.Pointer2LogBaseStack.pop();
    }

    public void setDebugMode(Boolean fpbDebugMode) {
    }

    @Override
    protected void TestcaseCount() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.TestcaseCount;
        Integer n2 = log2HTML.TestcaseCount = Integer.valueOf(log2HTML.TestcaseCount + 1);
    }

    @Override
    protected void TestcaseFail() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.TestcaseFail;
        Integer n2 = log2HTML.TestcaseFail = Integer.valueOf(log2HTML.TestcaseFail + 1);
    }

    @Override
    protected void TestcasePass() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.TestcasePass;
        Integer n2 = log2HTML.TestcasePass = Integer.valueOf(log2HTML.TestcasePass + 1);
    }

    @Override
    protected void FunctionCount() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.FunctionCount;
        Integer n2 = log2HTML.FunctionCount = Integer.valueOf(log2HTML.FunctionCount + 1);
    }

    @Override
    protected void FunctionFail() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.FunctionFail;
        Integer n2 = log2HTML.FunctionFail = Integer.valueOf(log2HTML.FunctionFail + 1);
    }

    @Override
    protected void FunctionPass() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.FunctionPass;
        Integer n2 = log2HTML.FunctionPass = Integer.valueOf(log2HTML.FunctionPass + 1);
    }

    @Override
    protected void KeyWordCount() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.KeyWordCount;
        Integer n2 = log2HTML.KeyWordCount = Integer.valueOf(log2HTML.KeyWordCount + 1);
    }

    @Override
    protected void KeyWordFail() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.KeyWordFail;
        Integer n2 = log2HTML.KeyWordFail = Integer.valueOf(log2HTML.KeyWordFail + 1);
    }

    @Override
    protected void KeyWordPass() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.KeyWordPass;
        Integer n2 = log2HTML.KeyWordPass = Integer.valueOf(log2HTML.KeyWordPass + 1);
    }

    @Override
    protected void SequenceCount() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.SequenceCount;
        Integer n2 = log2HTML.SequenceCount = Integer.valueOf(log2HTML.SequenceCount + 1);
    }

    @Override
    protected void SequenceFail() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.SequenceFail;
        Integer n2 = log2HTML.SequenceFail = Integer.valueOf(log2HTML.SequenceFail + 1);
    }

    @Override
    protected void SequencePass() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.SequencePass;
        Integer n2 = log2HTML.SequencePass = Integer.valueOf(log2HTML.SequencePass + 1);
    }

    @Override
    protected void StepCount() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.StepCount;
        Integer n2 = log2HTML.StepCount = Integer.valueOf(log2HTML.StepCount + 1);
    }

    @Override
    protected void StepFail() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.StepFail;
        Integer n2 = log2HTML.StepFail = Integer.valueOf(log2HTML.StepFail + 1);
    }

    @Override
    protected void StepPass() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.StepPass;
        Integer n2 = log2HTML.StepPass = Integer.valueOf(log2HTML.StepPass + 1);
    }

    @Override
    protected void LocalACCallCount() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.LocalACCallCount;
        Integer n2 = log2HTML.LocalACCallCount = Integer.valueOf(log2HTML.LocalACCallCount + 1);
    }

    @Override
    protected void LocalACCallFail() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.LocalACCallFail;
        Integer n2 = log2HTML.LocalACCallFail = Integer.valueOf(log2HTML.LocalACCallFail + 1);
    }

    @Override
    protected void LocalACCallPass() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.LocalACCallPass;
        Integer n2 = log2HTML.LocalACCallPass = Integer.valueOf(log2HTML.LocalACCallPass + 1);
    }

    @Override
    protected void RemoteACCallCount() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.RemoteACCallCount;
        Integer n2 = log2HTML.RemoteACCallCount = Integer.valueOf(log2HTML.RemoteACCallCount + 1);
    }

    @Override
    protected void RemoteACCallFail() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.RemoteACCallFail;
        Integer n2 = log2HTML.RemoteACCallFail = Integer.valueOf(log2HTML.RemoteACCallFail + 1);
    }

    @Override
    protected void RemoteACCallPass() {
        Log2HTML log2HTML = this;
        Integer n = log2HTML.RemoteACCallPass;
        Integer n2 = log2HTML.RemoteACCallPass = Integer.valueOf(log2HTML.RemoteACCallPass + 1);
    }
}

