/*
 * Decompiled with CFR 0.152.
 */
package okw.log.log2html;

import java.util.ArrayList;
import java.util.List;
import okw.OKW_Properties;
import okw.log.log2html.LogTimer;

public abstract class LogBase {
    protected static Integer AllCount = 0;
    protected Integer myID = 0;
    protected String Info = "";
    protected LogTimer myDuration = new LogTimer();
    protected LogBase myParent = null;
    protected List<LogBase> myLogs = new ArrayList<LogBase>();
    protected int Level = -1;
    protected String myIndentionBase = "    ";
    protected Boolean bWarning = false;
    protected Boolean bException = false;
    protected Boolean bError = false;

    public void setParent(LogBase fpParent) {
        this.myParent = fpParent;
    }

    protected void abort() {
        this.setError();
    }

    public LogBase getParent() {
        return this.myParent;
    }

    protected int getLevel() {
        int myReturn = this.Level >= 0 ? this.Level : (this.getParent() != null ? (this.Level = this.getParent().getLevel() + 1) : 0);
        return myReturn;
    }

    protected String getLevelIndention() {
        StringBuilder myIndention = new StringBuilder();
        int n = this.getLevel();
        for (int i = 1; i <= n; ++i) {
            myIndention.append(this.myIndentionBase);
        }
        return myIndention.toString();
    }

    protected String getLevelIndention(int shift) {
        StringBuilder myIndention = new StringBuilder();
        int n = this.getLevel() + shift;
        for (int i = 1; i <= n; ++i) {
            myIndention.append(this.myIndentionBase);
        }
        return myIndention.toString();
    }

    protected String jsonElement(String Key, String Value) {
        return "\"" + Key + "\": \"" + Value + "\"";
    }

    protected String jsonElementComma(String Key, String Value) {
        return "\"" + Key + "\": \"" + Value + "\",";
    }

    protected String jsonElementComma(String Key, Integer Value) {
        return "\"" + Key + "\": \"" + Value.toString() + "\",";
    }

    protected String jsonElement(String Key, Integer Value) {
        return "\"" + Key + "\": \"\"";
    }

    protected String jsonStructure(String Key, String Value) {
        return "\"" + Key + "\": {" + Value + " }";
    }

    protected String jsonStructureComma(String Key, String Value) {
        return "\"" + Key + "\": {" + Value + " },";
    }

    protected String jsonArray(String Key, String Value) {
        StringBuilder myIndention = new StringBuilder();
        myIndention.append("\"" + Key + "\": [");
        myIndention.append(Value);
        myIndention.append("]");
        return myIndention.toString();
    }

    protected String jsonArrayElement(String Value) {
        StringBuilder myIndention = new StringBuilder();
        myIndention.append("{");
        myIndention.append(Value);
        myIndention.append("}");
        return myIndention.toString();
    }

    protected String jsonArrayElementComma(String Value) {
        StringBuilder myIndention = new StringBuilder();
        myIndention.append("{");
        myIndention.append(Value);
        myIndention.append("},");
        return myIndention.toString();
    }

    protected void setWarning() {
        if (!this.bWarning.booleanValue()) {
            this.bWarning = true;
            if (this.myParent != null) {
                this.myParent.setWarning();
            }
        }
    }

    protected Boolean getWarning() {
        return this.bWarning;
    }

    protected void setException() {
        if (!this.bException.booleanValue()) {
            this.bException = true;
            if (this.myParent != null) {
                this.myParent.setException();
            }
        }
    }

    protected void setError() {
        if (!this.bError.booleanValue()) {
            this.bError = true;
            if (this.myParent != null) {
                this.myParent.setError();
            }
        }
    }

    protected Boolean getError() {
        return this.bError;
    }

    protected abstract void ErrorCount();

    protected abstract void ExceptionCount();

    protected abstract void WarningCount();

    protected abstract void PassedCount();

    protected abstract void PrintCount();

    protected abstract void TestcaseCount();

    protected abstract void TestcaseFail();

    protected abstract void TestcasePass();

    protected abstract void FunctionCount();

    protected abstract void FunctionFail();

    protected abstract void FunctionPass();

    protected abstract void KeyWordCount();

    protected abstract void KeyWordFail();

    protected abstract void KeyWordPass();

    protected abstract void SequenceCount();

    protected abstract void SequenceFail();

    protected abstract void SequencePass();

    protected abstract void StepCount();

    protected abstract void StepFail();

    protected abstract void StepPass();

    protected abstract void LocalACCallCount();

    protected abstract void LocalACCallFail();

    protected abstract void LocalACCallPass();

    protected abstract void RemoteACCallCount();

    protected abstract void RemoteACCallFail();

    protected abstract void RemoteACCallPass();

    protected String getHTMLResult() {
        StringBuilder sbResult = new StringBuilder();
        String lvsIndention = this.getLevelIndention();
        sbResult.append(lvsIndention + "<div class='" + this.getClass().getSimpleName() + "'>\n");
        sbResult.append(lvsIndention + this.myIndentionBase + "<div class='Header'>\n");
        if (!this.myLogs.isEmpty()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='FoldMe' href='javascript:/' onClick='div_change(" + this.myID.toString() + ")'></div>\n");
        }
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Duration'>" + this.myDuration.getSeconds("#0.000") + " s</div>");
        if (this.bException.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='ExceptionSign' title='Exception...'></div>\n");
        }
        if (this.bError.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='ErrorSign' title='Error...'></div>\n");
        }
        if (this.bWarning.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='WarningSign' title='Warning...'></div>\n");
        }
        if (this.bException.booleanValue() || this.bError.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Info_Fail'>" + this.Info + "</div>\n");
        } else {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='SuccessSign' title='Success...'></div>\n");
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Info_Pass'>" + this.Info + "</div>\n");
        }
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "</div>\n");
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Body' id='" + this.myID.toString() + "' style='display: none;'>\n");
        for (LogBase myLog : this.myLogs) {
            sbResult.append(myLog.getHTMLResult());
        }
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "</div>\n");
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "</div>\n");
        return sbResult.toString();
    }

    protected String getJSONResult() {
        StringBuilder myJSON = new StringBuilder();
        if ("false".equals(OKW_Properties.getInstance().getProperty("Log2HTML.Test", "false"))) {
            myJSON.append(this.jsonElement("duration", this.myDuration.getSeconds("#0.000")));
        } else {
            myJSON.append(this.jsonElement("duration", "Duration TestMode"));
        }
        Integer EC = 0;
        for (LogBase myLog : this.myLogs) {
            Integer n = EC;
            Integer n2 = EC = Integer.valueOf(EC + 1);
            String Element = myLog.getClass().getSimpleName();
            myJSON.append(this.jsonStructure(Element + EC.toString(), myLog.getJSONResult()));
        }
        return myJSON.toString();
    }
}

