/*
 * Decompiled with CFR 0.152.
 */
package okw.log.log2html;

import java.util.ArrayList;
import java.util.List;
import okw.log.log2html.LogTimer;

public abstract class LogBase {
    static Integer AllCount = 0;
    Integer myID = 0;
    static Integer ErrorCount = 0;
    static Integer ErrorFail = 0;
    static Integer ErrorPass = 0;
    static Integer ExceptionCount = 0;
    static Integer ExceptionFail = 0;
    static Integer ExceptionPass = 0;
    static Integer WarningCount = 0;
    static Integer WarningFail = 0;
    static Integer WarningPass = 0;
    static Integer TestcaseCount = 0;
    static Integer TestcaseFail = 0;
    static Integer TestcasePass = 0;
    static Integer FunctionCount = 0;
    static Integer FunctionFail = 0;
    static Integer FunctionPass = 0;
    static Integer KeyWordCount = 0;
    static Integer KeyWordFail = 0;
    static Integer KeyWordPass = 0;
    static Integer SequensCount = 0;
    static Integer SequensFail = 0;
    static Integer SequensPass = 0;
    static Integer PrintCount = 0;
    String Info = "";
    LogTimer myDuration = new LogTimer();
    LogBase myParent = null;
    List<LogBase> myLogs = new ArrayList<LogBase>();
    int Level = -1;
    String myIndentionBase = "  ";
    Boolean bWarning = false;
    Boolean bException = false;
    Boolean bError = false;

    protected abstract void SetFail();

    protected abstract void SetPass();

    public void setParent(LogBase fpParent) {
        this.myParent = fpParent;
    }

    public LogBase getParent() {
        return this.myParent;
    }

    protected int getLevel() {
        int myReturn = this.Level >= 0 ? this.Level : (this.getParent() != null ? (this.Level = this.getParent().getLevel() + 1) : 0);
        return myReturn;
    }

    protected String getLevelIndention() {
        StringBuilder myIndention = new StringBuilder();
        int n = this.getLevel();
        for (int i = 1; i <= n; ++i) {
            myIndention.append(this.myIndentionBase);
        }
        return myIndention.toString();
    }

    protected void setWarning() {
        this.bWarning = true;
        if (this.myParent != null) {
            this.myParent.setWarning();
        }
    }

    protected Boolean getWarning() {
        return this.bWarning;
    }

    protected void setException() {
        this.bException = true;
        this.SetFail();
        if (this.myParent != null) {
            this.myParent.setException();
        }
    }

    protected Boolean getException() {
        return this.bException;
    }

    protected void setError() {
        this.bError = true;
        this.SetFail();
        if (this.myParent != null) {
            this.myParent.setError();
        }
    }

    protected Boolean getError() {
        return this.bError;
    }

    protected String getResult() {
        StringBuilder sbResult = new StringBuilder();
        String lvsIndention = this.getLevelIndention();
        sbResult.append(lvsIndention + "<div class='" + this.getClass().getSimpleName() + "'>\n");
        sbResult.append(lvsIndention + this.myIndentionBase + "<div class='Header'>\n");
        if (!this.myLogs.isEmpty()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='FoldMe' href='javascript:/' onClick='div_change(" + this.myID.toString() + ")'></div>\n");
        }
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Duration'>" + this.myDuration.getSeconds("#0.000") + " s</div>");
        if (this.bException.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='ExceptionSign' title='Exception...'></div>\n");
        }
        if (this.bError.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='ErrorSign' title='Error...'></div>\n");
        }
        if (this.bWarning.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='WarningSign' title='Warning...'></div>\n");
        }
        if (this.bException.booleanValue() || this.bError.booleanValue()) {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Info_Fail'>" + this.Info + "</div>\n");
        } else {
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='SuccessSign' title='Success...'></div>\n");
            sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Info_Pass'>" + this.Info + "</div>\n");
        }
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "</div>\n");
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "<div class='Body' id='" + this.myID.toString() + "' style='display: none;'>\n");
        for (LogBase myLog : this.myLogs) {
            sbResult.append(myLog.getResult());
        }
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "</div>\n");
        sbResult.append(lvsIndention + this.myIndentionBase + this.myIndentionBase + "</div>\n");
        return sbResult.toString();
    }
}

