/*
 * Decompiled with CFR 0.152.
 */
package okw.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import okw.OKW_Const_Sngltn;
import okw.log.ILogger;
import okw.log.Log2Console;

public class Logger_Sngltn
implements ILogger {
    private static Boolean cvbDebugMode = false;
    private static ArrayList<ILogger> LoggerList;
    private static Logger_Sngltn Instance;

    public Boolean getDebugMode() {
        return cvbDebugMode;
    }

    @Override
    public void setDebugMode(Boolean fpbDebugMode) {
        cvbDebugMode = fpbDebugMode;
        for (ILogger myLogger : LoggerList) {
            myLogger.setDebugMode(cvbDebugMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Logger_Sngltn getInstance() {
        if (Instance != null) return Instance;
        Class<OKW_Const_Sngltn> clazz = OKW_Const_Sngltn.class;
        synchronized (OKW_Const_Sngltn.class) {
            if (Instance != null) return Instance;
            Instance = new Logger_Sngltn();
            Logger_Sngltn.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return Instance;
        }
    }

    public static void init() {
        LoggerList.clear();
        LoggerList.add(new Log2Console());
        Instance.setDebugMode(false);
    }

    private Logger_Sngltn() {
        LoggerList = new ArrayList();
    }

    public void LogVersionTxt() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("okw/version.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.LogPrint("-" + line);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addLogger(ILogger fpLogger) {
        LoggerList.add(fpLogger);
    }

    @Override
    public void reset() {
        for (ILogger myLogger : LoggerList) {
            myLogger.reset();
        }
    }

    @Override
    public void LogError(String fps_Message) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogError(fps_Message);
        }
    }

    @Override
    public void LogException(String fps_Message) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogException(fps_Message);
        }
    }

    @Override
    public void LogKeyWordEnd() {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogKeyWordEnd();
        }
    }

    @Override
    public void LogStepStart(String categoryName, String categoryType, String choiceValue, String featureName, String localCategoryName, String sourceExcerpt, String type) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogStepStart(categoryName, categoryType, choiceValue, featureName, localCategoryName, sourceExcerpt, type);
        }
    }

    @Override
    public void LogStepEnd() {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogStepEnd();
        }
    }

    @Override
    public void LogLocalACCallStart(String Gherkin, String Type2) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogLocalACCallStart(Gherkin, Type2);
        }
    }

    @Override
    public void LogLocalACCallEnd() {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogLocalACCallEnd();
        }
    }

    @Override
    public void LogRemoteACCallStart(String Gherkin, String Type2) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogRemoteACCallStart(Gherkin, Type2);
        }
    }

    @Override
    public void LogRemoteACCallEnd() {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogRemoteACCallEnd();
        }
    }

    @Override
    public void LogSequenceEnd() {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogSequenceEnd();
        }
    }

    @Override
    public void LogTestcaseEnd() {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogTestcaseEnd();
        }
    }

    @Override
    public void LogKeyWordStart(String fpsKeyWordName, String ... fpsParameter) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogKeyWordStart(fpsKeyWordName, fpsParameter);
        }
    }

    @Override
    public void LogSequenceStart(String fpsKeyWordName, String fpsWinowFN, String fpsSequenceName, String ... fpsParameter) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogSequenceStart(fpsKeyWordName, fpsWinowFN, fpsSequenceName, fpsParameter);
        }
    }

    @Override
    public void LogTestcaseStart(String fps_TestcaseName) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogTestcaseStart(fps_TestcaseName);
        }
    }

    @Override
    public void LogPass(String fps_Message) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogPass(fps_Message);
        }
    }

    @Override
    public void LogPrint(String fps_Message) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogPrint(fps_Message);
        }
    }

    @Override
    public void LogPrintDebug(String fpsMessage) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogPrintDebug(fpsMessage);
        }
    }

    @Override
    public void LogWarning(String fps_Message) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogWarning(fps_Message);
        }
    }

    @Override
    public void LogSourceLocation(String Start2, String End2, String featureName, String sourceType) {
        for (ILogger myLogger : LoggerList) {
            myLogger.LogSourceLocation(Start2, End2, featureName, sourceType);
        }
    }

    @Override
    public void ResCloseList() {
        for (ILogger myLogger : LoggerList) {
            myLogger.ResCloseList();
        }
    }

    @Override
    public void ResCloseListDebug() {
        for (ILogger myLogger : LoggerList) {
            myLogger.ResCloseListDebug();
        }
    }

    @Override
    public void ResOpenList(String fps_Name) {
        for (ILogger myLogger : LoggerList) {
            myLogger.ResOpenList(fps_Name);
        }
    }

    @Override
    public void ResOpenListDebug(String fpsListCaption) {
        for (ILogger myLogger : LoggerList) {
            myLogger.ResOpenListDebug(fpsListCaption);
        }
    }
}

