/*
 * Decompiled with CFR 0.152.
 */
package okw.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import okw.FrameObjectDictionary_Sngltn;
import okw.OKW;
import okw.OKWLanguage;
import okw.OKW_Const_Sngltn;
import okw.OKW_FileHelper;
import okw.OKW_Memorize_Sngltn;
import okw.OKW_Properties;
import okw.OKW_TimeOut;
import okw.core.Core;
import okw.core.IOKW_State;
import okw.core.Matcher;
import okw.core.OKW_CurrentObject_Sngltn;
import okw.exceptions.OKWNotAllowedValueException;
import okw.exceptions.OKWVerifyingFailsException;
import okw.gui.IGUIChildwindow;
import okw.gui.IGUIWindow;
import okw.log.Logger_Sngltn;
import okw.parser.Parser;

public class OK
implements IOKW_State {
    private static OKWLanguage CL;
    private static Logger_Sngltn Log;
    private static OKW_Properties PROP;
    private static OKW_CurrentObject_Sngltn CO;
    private static OKW_Memorize_Sngltn MEM;
    private Core _Kernel;
    protected Boolean VerifyFail = false;

    public OK(Core fp_OKW) {
        try {
            CL = OKWLanguage.getInstance();
            Log = Logger_Sngltn.getInstance();
            PROP = OKW_Properties.getInstance();
            CO = OKW_CurrentObject_Sngltn.getInstance();
            MEM = OKW_Memorize_Sngltn.getInstance();
            this._Kernel = fp_OKW;
        }
        catch (Exception e) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(stream));
            System.out.println("=================================================================================");
            System.out.println("= Exception during initialization of Class >>OK<<! Stop running!");
            System.out.println("=================================================================================");
            System.out.println(stream);
            System.exit(1);
        }
    }

    protected void handleException(Exception e) throws Exception {
        Exception e_Wrapped = null;
        if (e instanceof OKWVerifyingFailsException) {
            Boolean lvbAbort = PROP.getProperty2Boolean("core.AbortOnVerifyFail", "false");
            this._Kernel.setNOK_Reason(e);
            if (lvbAbort.booleanValue()) {
                this.logException(e, e_Wrapped);
                this._Kernel.SetCoreStateNOK();
            } else {
                this.logException(e, e_Wrapped);
                this.VerifyFail = true;
            }
        } else if (e instanceof InvocationTargetException) {
            e = (Exception)e.getCause();
            this.logException(e, e_Wrapped);
            this._Kernel.SetCoreStateNOK();
            this._Kernel.setNOK_Reason(e);
        } else if (e instanceof RuntimeException) {
            e_Wrapped = (Exception)e.getCause();
            this.logException(e, e_Wrapped);
            this._Kernel.SetCoreStateNOK();
            this._Kernel.setNOK_Reason(e);
        }
    }

    protected void logException(Exception e, Exception e_Wrapped) {
        Log.LogPrint("==========================================================================");
        Log.LogException(e.getMessage());
        if (e_Wrapped != null) {
            Log.ResOpenList("Trigger of the exception...");
            Log.LogPrint("--------------------------------------------------------------------------");
            Log.LogPrint("Exception: " + e_Wrapped.toString());
            Log.LogPrint("--------------------------------------------------------------------------");
            Log.ResCloseList();
        }
        Log.LogPrint("==========================================================================");
        CO.LogObjectData();
        Log.LogPrint("==========================================================================");
    }

    @Override
    public void BeginTest(String fpsTestname) throws Exception {
        try {
            OKW_Memorize_Sngltn.getInstance().set("TCN", fpsTestname);
            this._Kernel.SetCoreStateOK();
            Log.ResOpenList("Version...");
            Log.LogVersionTxt();
            Log.ResCloseList();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void EndTest() throws Exception {
        String msg = "";
        if (this.VerifyFail.booleanValue()) {
            msg = PROP.getProperty("ok.endtest.verifyfail.msg.${LANGUAGE}");
            Log.LogPrint(msg);
            throw this._Kernel.getNOK_Reason();
        }
        msg = PROP.getProperty("ok.endtest.verifypass.msg.${LANGUAGE}");
        Log.LogPrint(msg);
    }

    @Override
    public void ClickOn(String FN) throws Exception {
        try {
            ((IGUIChildwindow)CO.setChildName(FN)).ClickOn();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void DoubleClickOn(String FN) throws Exception {
        try {
            ((IGUIChildwindow)CO.setChildName(FN)).DoubleClickOn();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void LogCaption(String FN) throws Exception {
        try {
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).LogCaption();
            Log.ResOpenListDebug("Log... ");
            for (String Value : ActualValues) {
                Log.LogPrint("'" + Value + "'");
            }
            Log.ResCloseListDebug();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void LogExists(String FN) throws Exception {
        try {
            Boolean lvbActual = ((IGUIChildwindow)CO.setChildName(FN)).LogExists();
            String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
            String lvsLM = PROP.getProperty("ok.Log.ValueFound.${LANGUAGE}", lvsActual);
            Log.LogPrint(lvsLM);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void LogHasFocus(String FN) throws Exception {
        try {
            Boolean lvbActual = ((IGUIChildwindow)CO.setChildName(FN)).LogHasFocus();
            String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
            String lvsLM = PROP.getProperty("ok.Log.ValueFound.${LANGUAGE}", lvsActual);
            Log.LogPrint(lvsLM);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void LogIsActive(String FN) throws Exception {
        try {
            Boolean lvbActual = ((IGUIChildwindow)CO.setChildName(FN)).LogIsActive();
            String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
            String lvsLM = PROP.getProperty("ok.Log.ValueFound.${LANGUAGE}", lvsActual);
            Log.LogPrint(lvsLM);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void LogLabel(String FN) throws Exception {
        try {
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).LogLabel();
            Log.ResOpenList("Log... ");
            for (String Value : ActualValues) {
                Log.LogPrint("'" + Value + "'");
            }
            Log.ResCloseList();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void LogPlaceholder(String FN) throws Exception {
        try {
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).LogPlaceholder();
            Log.ResOpenList("Log... ");
            for (String Value : ActualValues) {
                Log.LogPrint("'" + Value + "'");
            }
            Log.ResCloseList();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void LogSelected(String FN) throws Exception {
        try {
            ArrayList<String> actualValues = ((IGUIChildwindow)CO.setChildName(FN)).LogSelected();
            String lvsLM = PROP.getProperty("ok.Log.ListValuesFound.${LANGUAGE}");
            Log.ResOpenList(lvsLM);
            for (String Value : actualValues) {
                Log.LogPrint("'" + Value + "'");
            }
            Log.ResCloseList();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void LogTablecellValue(String FN, String COL, String ROW) throws Exception {
        try {
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).LogTablecellValue(COL, ROW);
            String lvsLM = PROP.getProperty("ok.Log.ListValuesFound.${LANGUAGE}");
            Log.ResOpenList(lvsLM);
            for (String Value : ActualValues) {
                Log.LogPrint(">>" + Value + "<<");
            }
            Log.ResCloseList();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void LogTooltip(String FN) throws Exception {
        try {
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).LogTooltip();
            String lvsLM = PROP.getProperty("ok.Log.ListValuesFound.${LANGUAGE}");
            Log.ResOpenList(lvsLM);
            for (String Value : ActualValues) {
                Log.LogPrint("'" + Value + "'");
            }
            Log.ResCloseList();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void LogValue(String FN) throws Exception {
        try {
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).LogValue();
            String lvsLM = PROP.getProperty("ok.Log.ListValuesFound.${LANGUAGE}");
            Log.ResOpenList(lvsLM);
            for (String Value : ActualValues) {
                Log.LogPrint("'" + Value + "'");
            }
            Log.ResCloseList();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void MemorizeCaption(String FN, String MemKey) throws Exception {
        try {
            if (MemKey.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || "".equals(MemKey)) {
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.${LANGUAGE}", MemKey);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            this.isValueAllowed(MemKey, "IGNORE", "DELETE");
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).MemorizeCaption();
            String lvsToMemorize = OKW_Const_Sngltn.getInstance().ConcatSEP(ActualValues);
            MEM.set(MemKey, lvsToMemorize);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void MemorizeExists(String FN, String MemKey) throws Exception {
        try {
            if (MemKey.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || MemKey.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(MemKey, "IGNORE", "EMPTY", "DELETE");
                Boolean lvbActual = ((IGUIChildwindow)CO.setChildName(FN)).MemorizeExists();
                String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
                MEM.set(MemKey, lvsActual);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void MemorizeHasFocus(String FN, String MemKey) throws Exception {
        try {
            if (MemKey.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || MemKey.equals("")) {
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.${LANGUAGE}", MemKey);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            this.isValueAllowed(MemKey, "IGNORE", "DELETE");
            Boolean lvbActual = ((IGUIChildwindow)CO.setChildName(FN)).MemorizeHasFocus();
            String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
            MEM.set(MemKey, lvsActual);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void MemorizeIsActive(String FN, String MemKey) throws Exception {
        try {
            if (MemKey.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || MemKey.equals("")) {
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.${LANGUAGE}", MemKey);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            this.isValueAllowed(MemKey, "IGNORE", "DELETE");
            Boolean lvbActual = ((IGUIChildwindow)CO.setChildName(FN)).MemorizeIsActive();
            String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
            MEM.set(MemKey, lvsActual);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void MemorizeLabel(String FN, String MemKey) throws Exception {
        try {
            if (MemKey.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || MemKey.equals("")) {
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.${LANGUAGE}", MemKey);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            this.isValueAllowed(MemKey, "IGNORE", "DELETE");
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).MemorizeLabel();
            String lvsToMemorize = OKW_Const_Sngltn.getInstance().ConcatSEP(ActualValues);
            MEM.set(MemKey, lvsToMemorize);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void MemorizePlaceholder(String FN, String MemKey) throws Exception {
        try {
            if (MemKey.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || MemKey.equals("")) {
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.${LANGUAGE}", MemKey);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            this.isValueAllowed(MemKey, "IGNORE", "DELETE");
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).MemorizePlaceholder();
            String lvsToMemorize = OKW_Const_Sngltn.getInstance().ConcatSEP(ActualValues);
            MEM.set(MemKey, lvsToMemorize);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void MemorizeSelectedValue(String FN, String MemKey) throws Exception {
        try {
            if (MemKey.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || MemKey.equals("")) {
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.${LANGUAGE}", MemKey);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            this.isValueAllowed(MemKey, "IGNORE", "DELETE");
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).MemorizeSelectedValue();
            String lvsToMemorize = OKW_Const_Sngltn.getInstance().ConcatSEP(ActualValues);
            MEM.set(MemKey, lvsToMemorize);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void MemorizeTablecellValue(String FN, String COL, String ROW, String MemKey) throws Exception {
        try {
            if (MemKey.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || MemKey.equals("")) {
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.${LANGUAGE}", MemKey);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            this.isValueAllowed(MemKey, "IGNORE", "DELETE");
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).MemorizeTablecellValue(COL, ROW);
            String lvsToMemorize = OKW_Const_Sngltn.getInstance().ConcatSEP(ActualValues);
            MEM.set(MemKey, lvsToMemorize);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void MemorizeTooltip(String FN, String MemKey) throws Exception {
        try {
            if (MemKey.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || MemKey.equals("")) {
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.${LANGUAGE}", MemKey);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            this.isValueAllowed(MemKey, "IGNORE", "DELETE");
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).MemorizeTooltip();
            String lvsToMemorize = OKW_Const_Sngltn.getInstance().ConcatSEP(ActualValues);
            MEM.set(MemKey, lvsToMemorize);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void MemorizeValue(String FN, String MemKey) throws Exception {
        try {
            if (MemKey.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || MemKey.equals("")) {
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.${LANGUAGE}", MemKey);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            this.isValueAllowed(MemKey, "IGNORE", "DELETE");
            ArrayList<String> ActualValues = ((IGUIChildwindow)CO.setChildName(FN)).MemorizeValue();
            String lvsToMemorize = OKW_Const_Sngltn.getInstance().ConcatSEP(ActualValues);
            MEM.set(MemKey, lvsToMemorize);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void Select(String FN, String Val) throws Exception {
        try {
            if (Val.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || "".equals(Val)) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(Val, "IGNORE");
                ArrayList<String> lvlsValue = OKW_Const_Sngltn.getInstance().SplitSEP(Val);
                lvlsValue = Parser.ParseMe(lvlsValue);
                ((IGUIChildwindow)CO.setChildName(FN)).Select(lvlsValue);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void SelectMenu(String FN) throws Exception {
        try {
            ((IGUIChildwindow)CO.setChildName(FN)).SelectMenu();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void SelectMenu(String FN, String Val) throws Exception {
        try {
            if (Val.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || Val.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(Val, "IGNORE");
                ArrayList<String> lvlsValue = OKW_Const_Sngltn.getInstance().SplitSEP(Val);
                ((IGUIChildwindow)CO.setChildName(FN)).SelectMenu(lvlsValue);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void SelectTablecell(String FN, String COL, String ROW) throws Exception {
        try {
            ((IGUIChildwindow)CO.setChildName(FN)).SelectTablecell(COL, ROW);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void SelectWindow(String FN) throws Exception {
        try {
            ((IGUIWindow)CO.setWindowName(FN)).SelectWindow();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void SelectChild(String FN) throws Exception {
        try {
            CO.setChildName(FN);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void SelectContext(String FN) throws Exception {
        try {
            CO.setWindowName(FN);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void Sequence(String FN, String SEQ_Name, String SEQ_ID) throws Exception {
        try {
            if (SEQ_ID.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || "".equals(SEQ_ID)) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(SEQ_ID, "IGNORE", "DELETE");
                CO.Sequence(FN, SEQ_Name, SEQ_ID);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void SetFocus(String FN) throws Exception {
        try {
            ((IGUIChildwindow)CO.setChildName(FN)).SetFocus();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setLanguage(String Language) {
        CL.setLanguage(Language);
    }

    @Override
    public void SetValue(String FN, String Val) throws Exception {
        try {
            if (Val.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || Val.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(Val, "IGNORE", "EMPTY");
                ArrayList<String> lvlsValue = OKW_Const_Sngltn.getInstance().SplitSEP(Val);
                lvlsValue = Parser.ParseMe(lvlsValue);
                ((IGUIChildwindow)CO.setChildName(FN)).SetValue(lvlsValue);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void SetVar(String VN, String Val) throws Exception {
        String lvsValue = "";
        try {
            lvsValue = Parser.ParseMe(Val);
            Log.LogPrint(VN + "= \"" + lvsValue + "\"");
            OKW_Memorize_Sngltn.getInstance().set(VN, lvsValue);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void StartApp(String AppName) throws Exception {
        try {
            ((IGUIWindow)CO.setWindowName(AppName)).StartApp();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void StopApp(String AppName) throws Exception {
        try {
            ((IGUIWindow)CO.setWindowName(AppName)).StopApp();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void TypeKey(String FN, String Val) throws Exception {
        try {
            if (Val.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || Val.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(Val, "IGNORE", "EMPTY");
                ArrayList<String> lvlsValue = OKW_Const_Sngltn.getInstance().SplitSEP(Val);
                lvlsValue = Parser.ParseMe(lvlsValue);
                ((IGUIChildwindow)CO.setChildName(FN)).TypeKey(lvlsValue);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void TypeKeyTablecell(String FN, String COL, String ROW, String Val) throws Exception {
        try {
            if (Val.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || Val.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(Val, "IGNORE");
                ArrayList<String> lvlsValue = OKW_Const_Sngltn.getInstance().SplitSEP(Val);
                lvlsValue = Parser.ParseMe(lvlsValue);
                ((IGUIChildwindow)CO.setChildName(FN)).TypeKeyTablecell(COL, ROW, lvlsValue);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void TypeKeyWindow(String FN, String Val) throws Exception {
        try {
            if (Val.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || Val.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(Val, "IGNORE");
                ArrayList<String> lvlsValue = OKW_Const_Sngltn.getInstance().SplitSEP(Val);
                lvlsValue = Parser.ParseMe(lvlsValue);
                ((IGUIWindow)CO.setWindowName(FN)).TypeKeyWindow(lvlsValue);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyBadge(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyBadge_TO(), myOKW.VerifyBadge_PT());
                Actual = this.verify(TimeOut, lvlsExpected, () -> MyObject.VerifyBadge());
                this.verification(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyBadgeWCM(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyBadge_TO(), myOKW.VerifyBadge_PT());
                Actual = this.verifyWCM(TimeOut, lvlsExpected, () -> MyObject.VerifyBadge());
                this.verificationWCM(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyBadgeREGX(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyBadge_TO(), myOKW.VerifyBadge_PT());
                Actual = this.verifyREGX(TimeOut, lvlsExpected, () -> MyObject.VerifyBadge());
                this.verificationREGX(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyCaption(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || "".equals(ExpVal)) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyCaption_TO(), myOKW.VerifyCaption_PT());
                Actual = this.verify(TimeOut, lvlsExpected, () -> MyObject.VerifyCaption());
                this.verification(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyCaptionWCM(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyCaption_TO(), myOKW.VerifyCaption_PT());
                Actual = this.verifyWCM(TimeOut, lvlsExpected, () -> MyObject.VerifyCaption());
                this.verificationWCM(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyCaptionREGX(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyCaption_TO(), myOKW.VerifyCaption_PT());
                Actual = this.verifyREGX(TimeOut, lvlsExpected, () -> MyObject.VerifyCaption());
                this.verificationREGX(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyExists(String FN, String ExpVal) throws Exception {
        block4: {
            try {
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                    String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                    Log.LogPrint(lvsLM);
                    break block4;
                }
                String lvsExpected = Parser.ParseMe(ExpVal);
                if (lvsExpected.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("YES")) || lvsExpected.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("NO"))) {
                    Boolean lvbExpectedValue = OKW_Const_Sngltn.getInstance().YesNo2Boolean(lvsExpected);
                    IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                    OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                    OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyExists_TO(), myOKW.VerifyExists_PT());
                    Boolean lvbActual = this.verify(TimeOut, lvbExpectedValue, () -> MyObject.VerifyExists());
                    String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
                    this.verification(lvsActual, lvsExpected);
                    break block4;
                }
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.YesNoIgnore.${LANGUAGE}", ExpVal);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void VerifyHasFocus(String FN, String ExpVal) throws Exception {
        block4: {
            try {
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                    String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                    Log.LogPrint(lvsLM);
                    break block4;
                }
                String lvsExpected = Parser.ParseMe(ExpVal);
                if (lvsExpected.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("YES")) || lvsExpected.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("NO"))) {
                    Boolean lvbExpectedValue = OKW_Const_Sngltn.getInstance().YesNo2Boolean(lvsExpected);
                    IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                    OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                    OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyHasFocus_TO(), myOKW.VerifyHasFocus_PT());
                    Boolean lvbActual = this.verify(TimeOut, lvbExpectedValue, () -> MyObject.VerifyHasFocus());
                    String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
                    this.verification(lvsActual, lvsExpected);
                    break block4;
                }
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.YesNoIgnore.${LANGUAGE}", ExpVal);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void VerifyIsActive(String FN, String ExpVal) throws Exception {
        block4: {
            try {
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                    String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                    Log.LogPrint(lvsLM);
                    break block4;
                }
                String lvsExpected = Parser.ParseMe(ExpVal);
                if (lvsExpected.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("YES")) || lvsExpected.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("NO"))) {
                    Boolean lvbExpectedValue = OKW_Const_Sngltn.getInstance().YesNo2Boolean(lvsExpected);
                    IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                    OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                    OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyIsActive_TO(), myOKW.VerifyIsActive_PT());
                    Boolean lvbActual = this.verify(TimeOut, lvbExpectedValue, () -> MyObject.VerifyIsActive());
                    String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
                    this.verification(lvsActual, lvsExpected);
                    break block4;
                }
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.YesNoIgnore.${LANGUAGE}", ExpVal);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            catch (Exception e) {
                Log.LogPrint(e.getMessage());
                this.handleException(e);
            }
        }
    }

    private void verification(String fpsActual, String fpsExpected) {
        if (!fpsActual.equals(fpsExpected)) {
            this.LogVerifyError(fpsExpected, fpsActual);
            String lvsLM = PROP.getProperty("OKWVerifyingFailsException.${LANGUAGE}", fpsExpected, fpsActual);
            throw new OKWVerifyingFailsException(lvsLM);
        }
        Log.LogPass(fpsActual + " = " + fpsExpected);
    }

    private void verification(Integer fpiActual, Integer fpiExpected) {
        String fpsExpected;
        String fpsActual = fpiActual.toString();
        if (!fpsActual.equals(fpsExpected = fpiExpected.toString())) {
            this.LogVerifyError(fpsExpected, fpsActual);
            String lvsLM = PROP.getProperty("OKWVerifyingFailsException.${LANGUAGE}", fpsExpected, fpsActual);
            throw new OKWVerifyingFailsException(lvsLM);
        }
        Log.LogPass(fpsActual + " = " + fpsExpected);
    }

    private void verification(ArrayList<String> Actual, ArrayList<String> Expected) {
        Integer ExpectedSize;
        String msg = "";
        Boolean bFail = false;
        Integer ActualSize = new Integer(Actual.size());
        if (ActualSize.equals(ExpectedSize = new Integer(Expected.size()))) {
            Log.LogPass(PROP.getProperty("ok.SizeIsOK.${LANGUAGE}"));
            for (int i = 0; i < Actual.size(); ++i) {
                if (Actual.get(i).equals(Expected.get(i))) {
                    Log.LogPass(Actual.get(i) + " = " + Expected.get(i));
                    continue;
                }
                this.LogVerifyError(Expected.get(i), Actual.get(i));
                msg = PROP.getProperty("ok.verification.exception.unexpectedvalue.${LANGUAGE}");
                bFail = true;
            }
        } else {
            this.LogVerifyError(Integer.valueOf(Expected.size()).toString(), Integer.valueOf(Actual.size()).toString());
            msg = PROP.getProperty("ok.verification.exception.unexpectedsize.${LANGUAGE}");
            bFail = true;
        }
        if (bFail.booleanValue()) {
            throw new OKWVerifyingFailsException(msg);
        }
    }

    private void verificationWCM(ArrayList<String> Actual, ArrayList<String> Expected) {
        Integer ExpectedSize;
        Boolean bFail = false;
        String msg = "";
        Integer ActualSize = new Integer(Actual.size());
        if (ActualSize.equals(ExpectedSize = new Integer(Expected.size()))) {
            Log.LogPass(PROP.getProperty("ok.SizeIsOK.${LANGUAGE}"));
            for (int i = 0; i < Actual.size(); ++i) {
                if (Matcher.WildcardMatch(Actual.get(i), Expected.get(i))) {
                    Log.LogPass(Actual.get(i) + " = " + Expected.get(i));
                    continue;
                }
                this.LogVerifyError(Expected.get(i), Actual.get(i));
                msg = PROP.getProperty("ok.verification.exception.unexpectedvalue.${LANGUAGE}");
                bFail = true;
            }
        } else {
            this.LogVerifyError(Integer.valueOf(Expected.size()).toString(), Integer.valueOf(Actual.size()).toString());
            msg = PROP.getProperty("ok.verification.exception.unexpectedsize.${LANGUAGE}");
            bFail = true;
        }
        if (bFail.booleanValue()) {
            throw new OKWVerifyingFailsException(msg);
        }
    }

    private void verificationREGX(ArrayList<String> Actual, ArrayList<String> Expected) {
        Integer ExpectedSize;
        Boolean bFail = false;
        String msg = "";
        Integer ActualSize = new Integer(Actual.size());
        if (ActualSize.equals(ExpectedSize = new Integer(Expected.size()))) {
            Log.LogPass(PROP.getProperty("ok.SizeIsOK.${LANGUAGE}"));
            for (int i = 0; i < Actual.size(); ++i) {
                if (Matcher.RegexMatch(Actual.get(i), Expected.get(i))) {
                    Log.LogPass(Actual.get(i) + " = " + Expected.get(i));
                    continue;
                }
                this.LogVerifyError(Expected.get(i), Actual.get(i));
                msg = PROP.getProperty("ok.verification.exception.unexpectedvalue.${LANGUAGE}");
                bFail = true;
            }
        } else {
            this.LogVerifyError(Integer.valueOf(Expected.size()).toString(), Integer.valueOf(Actual.size()).toString());
            msg = PROP.getProperty("ok.verification.exception.unexpectedsize.${LANGUAGE}");
            bFail = true;
        }
        if (bFail.booleanValue()) {
            throw new OKWVerifyingFailsException(msg);
        }
    }

    private Boolean verify(OKW_TimeOut timeout, Boolean fpbExpected, Supplier<Boolean> Method2Call) {
        Integer Count = 0;
        Boolean lvbReturn = false;
        try {
            Count = 0;
            while (Count < timeout.getMaxCount() && !fpbExpected.equals(lvbReturn = Method2Call.get())) {
                Thread.sleep(timeout.getPT().intValue());
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
        }
        catch (IllegalArgumentException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return lvbReturn;
    }

    private Integer verify(OKW_TimeOut timeout, Integer fpiExpected, Supplier<Integer> Method2Call) {
        Integer Count = 0;
        Integer lviReturn = 0;
        try {
            Count = 0;
            while (Count < timeout.getMaxCount() && fpiExpected != (lviReturn = Method2Call.get())) {
                Thread.sleep(timeout.getPT().intValue());
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
        }
        catch (IllegalArgumentException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return lviReturn;
    }

    private ArrayList<String> verify(OKW_TimeOut timeout, String COL, String ROW, ArrayList<String> fpALExpected, BiFunction<String, String, ArrayList<String>> Method2Call) {
        Integer Count = 0;
        ArrayList<String> lvLsReturn = null;
        try {
            Count = 0;
            while (Count < timeout.getMaxCount() && !fpALExpected.equals(lvLsReturn = Method2Call.apply(COL, ROW))) {
                Thread.sleep(timeout.getPT().intValue());
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return lvLsReturn;
    }

    private ArrayList<String> verifyWCM(OKW_TimeOut timeout, String COL, String ROW, ArrayList<String> fpALExpectedWCM, BiFunction<String, String, ArrayList<String>> Method2Call) {
        Integer Count = 0;
        ArrayList<String> lvLsReturn = null;
        try {
            Count = 0;
            while (Count < timeout.getMaxCount() && !Matcher.WildcardMatch(lvLsReturn = Method2Call.apply(COL, ROW), fpALExpectedWCM)) {
                Thread.sleep(timeout.getPT().intValue());
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return lvLsReturn;
    }

    private ArrayList<String> verifyREGX(OKW_TimeOut timeout, String COL, String ROW, ArrayList<String> fpALExpectedREGXs, BiFunction<String, String, ArrayList<String>> Method2Call) {
        Integer Count = 0;
        ArrayList<String> lvLsReturn = null;
        try {
            Count = 0;
            while (Count < timeout.getMaxCount() && !Matcher.RegexMatch(lvLsReturn = Method2Call.apply(COL, ROW), fpALExpectedREGXs)) {
                Thread.sleep(timeout.getPT().intValue());
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return lvLsReturn;
    }

    private ArrayList<String> verify(OKW_TimeOut timeout, ArrayList<String> fpALExpected, Supplier<ArrayList<String>> Method2Call) {
        Integer Count = 0;
        ArrayList<String> lvLsReturn = null;
        try {
            Count = 0;
            while (Count < timeout.getMaxCount() && !fpALExpected.equals(lvLsReturn = Method2Call.get())) {
                Thread.sleep(timeout.getPT().intValue());
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return lvLsReturn;
    }

    private ArrayList<String> verifyWCM(OKW_TimeOut timeout, ArrayList<String> fpALExpectedWCMs, Supplier<ArrayList<String>> Method2Call) {
        Integer Count = 0;
        ArrayList<String> lvLsReturn = null;
        try {
            Count = 0;
            while (Count < timeout.getMaxCount() && !Matcher.WildcardMatch(lvLsReturn = Method2Call.get(), fpALExpectedWCMs)) {
                Thread.sleep(timeout.getPT().intValue());
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return lvLsReturn;
    }

    private ArrayList<String> verifyREGX(OKW_TimeOut timeout, ArrayList<String> fpALExpectedREGXs, Supplier<ArrayList<String>> Method2Call) {
        Integer Count = 0;
        ArrayList<String> lvLsReturn = null;
        try {
            Count = 0;
            while (Count < timeout.getMaxCount() && !Matcher.RegexMatch(lvLsReturn = Method2Call.get(), fpALExpectedREGXs)) {
                Thread.sleep(timeout.getPT().intValue());
                Integer n = Count;
                Integer n2 = Count = Integer.valueOf(Count + 1);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return lvLsReturn;
    }

    @Override
    public void VerifyLabel(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyLabel_TO(), myOKW.VerifyLabel_PT());
                Actual = this.verify(TimeOut, lvlsExpected, () -> MyObject.VerifyLabel());
                this.verification(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyLabelWCM(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyLabel_TO(), myOKW.VerifyLabel_PT());
                Actual = this.verifyWCM(TimeOut, lvlsExpected, () -> MyObject.VerifyLabel());
                this.verificationWCM(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyLabelREGX(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyLabel_TO(), myOKW.VerifyLabel_PT());
                Actual = this.verifyREGX(TimeOut, lvlsExpected, () -> MyObject.VerifyLabel());
                this.verificationREGX(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyPlaceholder(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyPlaceholder_TO(), myOKW.VerifyPlaceholder_PT());
                Actual = this.verify(TimeOut, lvlsExpected, () -> MyObject.VerifyPlaceholder());
                this.verification(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyPlaceholderWCM(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyPlaceholder_TO(), myOKW.VerifyPlaceholder_PT());
                Actual = this.verifyWCM(TimeOut, lvlsExpected, () -> MyObject.VerifyPlaceholder());
                this.verificationWCM(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyMaxLength(String FN, String ExpVal) throws Exception {
        block5: {
            Integer lviExpected = null;
            Integer Actual = null;
            try {
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                    String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                    Log.LogPrint(lvsLM);
                    break block5;
                }
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE", "SEP", "VSEP", "HSEP", "EMPTY");
                try {
                    String myExpVal = Parser.ParseMe(ExpVal);
                    lviExpected = Integer.parseInt(myExpVal);
                }
                catch (NumberFormatException e) {
                    String lvsLM = PROP.getProperty("OKWNotAllowedValueException.IntegerOnly.${LANGUAGE}", ExpVal);
                    throw new OKWNotAllowedValueException(lvsLM);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyMaxLength_TO(), myOKW.VerifyMaxLength_PT());
                Actual = this.verify(TimeOut, lviExpected, () -> MyObject.VerifyMaxLength());
                this.verification(Actual, lviExpected);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void VerifyPlaceholderREGX(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyPlaceholder_TO(), myOKW.VerifyPlaceholder_PT());
                Actual = this.verifyREGX(TimeOut, lvlsExpected, () -> MyObject.VerifyPlaceholder());
                this.verificationREGX(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifySelectedValue(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifySelectedValue_TO(), myOKW.VerifySelectedValue_PT());
                Actual = this.verify(TimeOut, lvlsExpected, () -> MyObject.VerifySelectedValue());
                this.verification(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifySelectedValueWCM(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifySelectedValue_TO(), myOKW.VerifySelectedValue_PT());
                Actual = this.verifyWCM(TimeOut, lvlsExpected, () -> MyObject.VerifySelectedValue());
                this.verificationWCM(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifySelectedValueREGX(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifySelectedValue_TO(), myOKW.VerifySelectedValue_PT());
                Actual = this.verifyREGX(TimeOut, lvlsExpected, () -> MyObject.VerifySelectedValue());
                this.verificationREGX(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyTablecellValue(String CAT, String COL, String ROW, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(CAT);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyTablecellValue_TO(), myOKW.VerifyTablecellValue_PT());
                Actual = this.verify(TimeOut, COL, ROW, lvlsExpected, (col, row) -> MyObject.VerifyTablecellValue((String)col, (String)row));
                this.verification(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyTablecellValueWCM(String CAT, String COL, String ROW, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(CAT);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyTablecellValue_TO(), myOKW.VerifyTablecellValue_PT());
                Actual = this.verifyWCM(TimeOut, COL, ROW, lvlsExpected, (col, row) -> MyObject.VerifyTablecellValue((String)col, (String)row));
                this.verificationWCM(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyTablecellValueREGX(String FN, String COL, String ROW, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyTablecellValue_TO(), myOKW.VerifyTablecellValue_PT());
                Actual = this.verifyREGX(TimeOut, COL, ROW, lvlsExpected, (col, row) -> MyObject.VerifyTablecellValue((String)col, (String)row));
                this.verificationREGX(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyTooltip(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyTooltip_TO(), myOKW.VerifyTooltip_PT());
                Actual = this.verify(TimeOut, lvlsExpected, () -> MyObject.VerifyTooltip());
                this.verification(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyTooltipWCM(String FN, String ExpVal) throws Exception {
        ArrayList<String> Actual = null;
        ArrayList<String> lvlsExpected = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyTooltip_TO(), myOKW.VerifyTooltip_PT());
                Actual = this.verifyWCM(TimeOut, lvlsExpected, () -> MyObject.VerifyTooltip());
                this.verificationWCM(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyTooltipREGX(String FN, String ExpVal) throws Exception {
        ArrayList<String> Actual = null;
        ArrayList<String> lvlsExpected = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyTooltip_TO(), myOKW.VerifyTooltip_PT());
                Actual = this.verifyREGX(TimeOut, lvlsExpected, () -> MyObject.VerifyTooltip());
                this.verificationREGX(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyValue(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyValue_TO(), myOKW.VerifyValue_PT());
                Actual = this.verify(TimeOut, lvlsExpected, () -> MyObject.VerifyValue());
                this.verification(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyValueWCM(String FN, String ExpVal) throws Exception {
        ArrayList<String> Actual = null;
        ArrayList<String> lvlsExpected = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyValue_TO(), myOKW.VerifyValue_PT());
                Actual = this.verifyWCM(TimeOut, lvlsExpected, () -> MyObject.VerifyValue());
                this.verificationWCM(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyValueREGX(String FN, String ExpVal) throws Exception {
        ArrayList<String> Actual = null;
        ArrayList<String> lvlsExpected = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyValue_TO(), myOKW.VerifyValue_PT());
                Actual = this.verifyREGX(TimeOut, lvlsExpected, () -> MyObject.VerifyValue());
                this.verificationREGX(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void FileCreate(String PATH) throws Exception {
        String lvsPATH = "";
        try {
            if (PATH.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || "".equals(PATH)) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                lvsPATH = Parser.ParseMe(PATH);
                lvsPATH = OKW_FileHelper.convertDirectorySeperator(lvsPATH);
                String lsvLog = PROP.getProperty("ok.FileCreate.ResolvedPath.${LANGUAGE}", lvsPATH);
                Log.LogPrint(lsvLog);
                OKW_FileHelper.createFile(lvsPATH);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void FileDelete(String fpsPathAndFileName) throws Exception {
        String lvsPathAndFileName = "";
        try {
            if (fpsPathAndFileName.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || "".equals(fpsPathAndFileName)) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                lvsPathAndFileName = Parser.ParseMe(fpsPathAndFileName);
                lvsPathAndFileName = OKW_FileHelper.convertDirectorySeperator(lvsPathAndFileName);
                String lsvLog = PROP.getProperty("ok.FileDelete.ResolvedPath.${LANGUAGE}", lvsPathAndFileName);
                Log.LogPrint(lsvLog);
                OKW_FileHelper.deleteFile(lvsPathAndFileName);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void FilesDelete(String fpsDirPath, String fpsFileMatch) throws Exception {
        String lvsDirPath = "";
        String lvsFileMatch = "";
        try {
            if (fpsDirPath.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || "".equals(fpsDirPath) || fpsFileMatch.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || "".equals(fpsFileMatch)) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                lvsDirPath = Parser.ParseMe(fpsDirPath);
                lvsFileMatch = Parser.ParseMe(fpsDirPath);
                lvsDirPath = OKW_FileHelper.convertDirectorySeperator(lvsDirPath);
                lvsFileMatch = OKW_FileHelper.convertDirectorySeperator(lvsFileMatch);
                String lsvLog = PROP.getProperty("ok.FileDelete.ResolvedPath.${LANGUAGE}", lvsFileMatch);
                Log.LogPrint(lsvLog);
                OKW_FileHelper.deleteFiles(lvsDirPath);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void DirectoryDelete(String PATH) throws Exception {
        String lvsPATH = "";
        try {
            if (PATH.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || "".equals(PATH)) {
                String lvsLM = PROP.getProperty("ok.Ignore");
                Log.LogPrint(lvsLM);
            } else {
                lvsPATH = Parser.ParseMe(PATH);
                lvsPATH = OKW_FileHelper.convertDirectorySeperator(lvsPATH);
                String lsvLog = PROP.getProperty("ok.DirectoryDelete.ResolvedPath.${LANGUAGE}", lvsPATH);
                Log.LogPrint(lsvLog);
                OKW_FileHelper.deleteDirectory(lvsPATH);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void DirectoryCreate(String PATH) throws Exception {
        String lvsPATH = "";
        try {
            if (PATH.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || "".equals(PATH)) {
                String lvsLM = PROP.getProperty("ok.Ignore");
                Log.LogPrint(lvsLM);
            } else {
                lvsPATH = Parser.ParseMe(PATH);
                lvsPATH = OKW_FileHelper.convertDirectorySeperator(lvsPATH);
                String lsvLog = PROP.getProperty("ok.DirectoryCreate.ResolvedPath.${LANGUAGE}", lvsPATH);
                Log.LogPrint(lsvLog);
                OKW_FileHelper.DirectoryCreate(lvsPATH);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyFileExists(String fpsPathAndFileName, String ExpVal) throws Exception {
        block4: {
            String lvsPathAndFileName = "";
            try {
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                    String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                    Log.LogPrint(lvsLM);
                    break block4;
                }
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("YES")) || ExpVal.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("NO"))) {
                    lvsPathAndFileName = Parser.ParseMe(fpsPathAndFileName);
                    lvsPathAndFileName = OKW_FileHelper.convertDirectorySeperator(lvsPathAndFileName);
                    String lsvLog = PROP.getProperty("ok.VerifyFileExists.ResolvedPath.${LANGUAGE}", lvsPathAndFileName);
                    Log.LogPrint(lsvLog);
                    Boolean lvbActual = OKW_FileHelper.fileExists(lvsPathAndFileName);
                    String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
                    this.verification(lvsActual, ExpVal);
                    break block4;
                }
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.YesNoIgnore.${LANGUAGE}", ExpVal);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void VerifyIsFile(String fpsPathAndFileName, String ExpVal) throws Exception {
        block4: {
            String lvsPathAndFileName = "";
            try {
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                    String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                    Log.LogPrint(lvsLM);
                    break block4;
                }
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("YES")) || ExpVal.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("NO"))) {
                    lvsPathAndFileName = Parser.ParseMe(fpsPathAndFileName);
                    lvsPathAndFileName = OKW_FileHelper.convertDirectorySeperator(lvsPathAndFileName);
                    String lsvLog = PROP.getProperty("ok.VerifyIsFile.ResolvedPath.${LANGUAGE}", lvsPathAndFileName);
                    Log.LogPrint(lsvLog);
                    Boolean lvbActual = OKW_FileHelper.isFile(lvsPathAndFileName);
                    String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
                    this.verification(lvsActual, ExpVal);
                    break block4;
                }
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.YesNoIgnore.${LANGUAGE}", ExpVal);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void VerifyIsDirectory(String fpsPathAndFileName, String ExpVal) throws Exception {
        block4: {
            String lvsPathAndFileName = "";
            try {
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                    String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                    Log.LogPrint(lvsLM);
                    break block4;
                }
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("YES")) || ExpVal.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("NO"))) {
                    lvsPathAndFileName = Parser.ParseMe(fpsPathAndFileName);
                    lvsPathAndFileName = OKW_FileHelper.convertDirectorySeperator(lvsPathAndFileName);
                    String lsvLog = PROP.getProperty("ok.VerifyIsDirectory.ResolvedPath.${LANGUAGE}", lvsPathAndFileName);
                    Log.LogPrint(lsvLog);
                    Boolean lvbActual = OKW_FileHelper.isFile(lvsPathAndFileName);
                    String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
                    this.verification(lvsActual, ExpVal);
                    break block4;
                }
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.YesNoIgnore.${LANGUAGE}", ExpVal);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void VerifyDirectoryExists(String fpsPath, String ExpVal) throws Exception {
        block6: {
            String lvsPath = "";
            try {
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                    String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                    Log.LogPrint(lvsLM);
                    break block6;
                }
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("YES")) || ExpVal.equals(OKW_Const_Sngltn.getInstance().GetConst4Internalname("NO"))) {
                    lvsPath = Parser.ParseMe(fpsPath);
                    lvsPath = OKW_FileHelper.convertDirectorySeperator(lvsPath);
                    String lsvLog = PROP.getProperty("ok.VerifyDirectoryExists.ResolvedPath.${LANGUAGE}", lvsPath);
                    Log.LogPrint(lsvLog);
                    Boolean lvbActual = OKW_FileHelper.directoryExists(lvsPath);
                    String lvsActual = OKW_Const_Sngltn.getInstance().Boolean2YesNo(lvbActual);
                    this.verification(lvsActual, ExpVal);
                    break block6;
                }
                String lvsLM = PROP.getProperty("OKWNotAllowedValueException.YesNoIgnore.${LANGUAGE}", ExpVal);
                throw new OKWNotAllowedValueException(lvsLM);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void CopyFile(String fpsSourcePathAndFileName, String fpsDestinationPathAndFileName) throws Exception {
    }

    @Override
    public void VerifyMinLength(String FN, String ExpVal) throws Exception {
        block5: {
            Integer lviExpected = null;
            Integer Actual = null;
            try {
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                    String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                    Log.LogPrint(lvsLM);
                    break block5;
                }
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE", "SEP", "VSEP", "HSEP", "EMPTY");
                try {
                    String myExpVal = Parser.ParseMe(ExpVal);
                    lviExpected = Integer.parseInt(myExpVal);
                }
                catch (NumberFormatException e) {
                    String lvsLM = PROP.getProperty("OKWNotAllowedValueException.IntegerOnly.${LANGUAGE}", ExpVal);
                    throw new OKWNotAllowedValueException(lvsLM);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyMinLength_TO(), myOKW.VerifyMinLength_PT());
                Actual = this.verify(TimeOut, lviExpected, () -> MyObject.VerifyMinLength());
                this.verification(Actual, lviExpected);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void VerifyErrorMSG(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyErrorMSG_TO(), myOKW.VerifyErrorMSG_PT());
                Actual = this.verify(TimeOut, lvlsExpected, () -> MyObject.VerifyErrorMSG());
                this.verification(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyErrorMSG_WCM(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyErrorMSG_TO(), myOKW.VerifyErrorMSG_PT());
                Actual = this.verifyWCM(TimeOut, lvlsExpected, () -> MyObject.VerifyErrorMSG());
                this.verificationWCM(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void VerifyErrorMSG_REGX(String FN, String ExpVal) throws Exception {
        ArrayList<String> lvlsExpected = null;
        ArrayList<String> Actual = null;
        try {
            if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("IGNORE")) || ExpVal.equals("")) {
                String lvsLM = PROP.getProperty("ok.Ignore.${LANGUAGE}");
                Log.LogPrint(lvsLM);
            } else {
                this.isValueAllowed(ExpVal, "IGNORE", "DELETE");
                if (ExpVal.equals(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("EMPTY"))) {
                    lvlsExpected = new ArrayList();
                    lvlsExpected.add("");
                } else {
                    lvlsExpected = OKW_Const_Sngltn.getInstance().SplitSEP(ExpVal);
                    lvlsExpected = Parser.ParseMe(lvlsExpected);
                }
                IGUIChildwindow MyObject = (IGUIChildwindow)CO.setChildName(FN);
                OKW myOKW = FrameObjectDictionary_Sngltn.myAnnotationDictionary.get(CO.getObjectFN());
                OKW_TimeOut TimeOut = new OKW_TimeOut(myOKW.VerifyErrorMSG_TO(), myOKW.VerifyErrorMSG_PT());
                Actual = this.verifyREGX(TimeOut, lvlsExpected, () -> MyObject.VerifyErrorMSG());
                this.verificationREGX(Actual, lvlsExpected);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void isValueAllowed(String ValueToAnalyse, String ... NotAllowedValues) {
        String NotAllowedValue = "";
        for (int i = 0; i < NotAllowedValues.length; ++i) {
            NotAllowedValue = NotAllowedValues[i];
            if (!ValueToAnalyse.contains(OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname(NotAllowedValue))) continue;
            String lvsLM = PROP.getProperty("OKWNotAllowedValueException.${LANGUAGE}", null, ValueToAnalyse);
            throw new OKWNotAllowedValueException(lvsLM);
        }
    }

    protected void LogVerifyError(String fpsExpected, String fpsActual) {
        Log.LogError(PROP.getProperty("ok.LogVerifyError.ExpectedActuel.${LANGUAGE}", null, fpsExpected, fpsActual));
        Log.ResOpenList(PROP.getProperty("ok.LogVerifyError.Details.${LANGUAGE}"));
        Log.LogPrint(PROP.getProperty("ok.LogVerifyError.Expected.${LANGUAGE}", null, fpsExpected));
        Log.LogPrint(PROP.getProperty("ok.LogVerifyError.Actuel.${LANGUAGE}", null, fpsActual));
        Log.ResCloseList();
    }
}

