/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import okw.log.Logger_Sngltn;

public class ResourceList {
    private static Logger_Sngltn Log = Logger_Sngltn.getInstance();

    public static Collection<String> getResources(Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path", ".");
        String[] classPathElements = classPath.split(System.getProperty("path.separator"));
        Log.ResOpenListDebug("Class Path...");
        for (String element : classPathElements) {
            Log.LogPrintDebug(element);
            retval.addAll(ResourceList.getResources(element, pattern));
        }
        Log.ResCloseListDebug();
        return retval;
    }

    private static Collection<String> getResources(String element, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File file = new File(element);
        if (file.isDirectory()) {
            retval.addAll(ResourceList.getResourcesFromDirectory(file, pattern));
        } else {
            retval.addAll(ResourceList.getResourcesFromJarFile(file, pattern));
        }
        return retval;
    }

    private static Collection<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ZipFile zf;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            retval.add(fileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return retval;
    }

    private static Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        File[] fileList;
        ArrayList<String> retval = new ArrayList<String>();
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                retval.addAll(ResourceList.getResourcesFromDirectory(file, pattern));
                continue;
            }
            try {
                String fileName = file.getCanonicalPath();
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept) continue;
                retval.add(fileName);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return retval;
    }

    public static void main(String[] args) {
        Pattern pattern = args.length < 1 ? Pattern.compile(".*") : Pattern.compile(args[0]);
        Collection<String> list = ResourceList.getResources(pattern);
        for (String name : list) {
            System.out.println(name);
        }
    }
}

