/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import okw.ResourceList;
import okw.exceptions.OKWFileDoesNotExistsException;
import okw.log.Logger_Sngltn;
import okw.parser.Parser;
import org.apache.commons.lang3.StringUtils;
import org.stringtemplate.v4.ST;

public class OKW_Properties
extends Properties {
    private static OKW_Properties Instance;
    String PropPath = "";
    String PropPathWin = "";
    private static Logger_Sngltn Log;
    protected ArrayList<String> CoreProperties = new ArrayList();
    protected ArrayList<String> ResoursesProperties = new ArrayList();
    protected ArrayList<String> FileProperties = new ArrayList();
    private static final long serialVersionUID = -6936118958227023483L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OKW_Properties getInstance() {
        if (Instance != null) return Instance;
        Class<OKW_Properties> clazz = OKW_Properties.class;
        synchronized (OKW_Properties.class) {
            if (Instance != null) return Instance;
            Instance = new OKW_Properties();
            // ** MonitorExit[var0] (shouldn't be in output)
            return Instance;
        }
    }

    private OKW_Properties() {
        this.init();
    }

    @Override
    public void clear() {
        super.clear();
        this.CoreProperties.clear();
        this.ResoursesProperties.clear();
        this.FileProperties.clear();
    }

    public void init() {
        String Sep = System.getProperty("file.separator");
        this.clear();
        Log.ResOpenList("Find Properties...");
        Log.ResOpenList("Find OKW Core Properties...");
        String PropPattern = ".*okw.default.properties.*\\.properties";
        String PropPath = "okw" + Sep + "default" + Sep + "properties" + Sep;
        String PropPathWin = "okw/default/properties/";
        ArrayList<String> someProperties = this.getPropertyFiles(PropPattern, PropPath, PropPathWin);
        this.CoreProperties.addAll(someProperties);
        Log.ResCloseList();
        Log.ResOpenList("Find Project Properties...");
        PropPattern = ".*okw.properties.*\\.properties";
        PropPath = "okw" + Sep + "properties" + Sep;
        PropPathWin = "okw/properties/";
        ArrayList<String> some3Properties = this.getPropertyFiles(PropPattern, PropPath, PropPathWin);
        this.ResoursesProperties.addAll(some3Properties);
        Log.ResCloseList();
        Log.ResCloseList();
        this.updateProperties();
    }

    protected ArrayList<String> getPropertyFiles(String Patternstring, String PropPath, String PropPathWin) {
        String loadResoure = "";
        ArrayList<String> myReturn = new ArrayList<String>();
        Pattern pattern = Pattern.compile(Patternstring);
        ArrayList myList = (ArrayList)ResourceList.getResources(pattern);
        for (String element : myList) {
            Log.ResOpenList(element);
            loadResoure = StringUtils.startsWith((CharSequence)element, (CharSequence)PropPath) ? element : (StringUtils.startsWith((CharSequence)element, (CharSequence)PropPathWin) ? element : PropPath + StringUtils.splitByWholeSeparator((String)element, (String)PropPath)[1]);
            Log.LogPrint("--> " + loadResoure);
            myReturn.add(loadResoure);
            Log.ResCloseList();
        }
        return myReturn;
    }

    public void updateProperties() {
        super.clear();
        Log.ResOpenList("Update Properties...");
        Log.ResOpenList("Load OKW Core Properties...");
        Collections.sort(this.CoreProperties, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        for (String s : this.CoreProperties) {
            this.loadFromResource(s);
        }
        Log.ResCloseList();
        Log.ResOpenList("Load Project Properties...");
        Collections.sort(this.ResoursesProperties, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        for (String s : this.ResoursesProperties) {
            this.loadFromResource(s);
        }
        Log.ResCloseList();
        Log.ResOpenList("Load File Properties...");
        for (String s : this.FileProperties) {
            this.loadFromFile(s);
        }
        Log.ResCloseList();
        Log.ResOpenList("Load System Enviroment Vars...");
        this.loadSystemEnviromentVars();
        Log.ResCloseList();
        Log.ResOpenList("Load System Propertie...");
        this.loadSystemProperties();
        Log.ResCloseList();
        Log.ResCloseList();
    }

    public Boolean addResource(String fpsResourceName) {
        Boolean lvbReturn = true;
        lvbReturn = this.ResoursesProperties.add(fpsResourceName);
        this.updateProperties();
        return lvbReturn;
    }

    public void addPropertiesFile(String fpsFileName) {
        this.FileProperties.add(fpsFileName);
        this.updateProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String> getPropertiesFilesFromResources(String folder) {
        ArrayList<String> Return = new ArrayList<String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(folder);
        String path = "";
        try {
            File[] FoldersAndFiles;
            Log.ResOpenList("Scan folder: " + folder);
            path = URLDecoder.decode(url.getPath(), Charset.defaultCharset().name());
            String urlResourceFolder = path.replaceAll(folder, "");
            for (File FolderOrFile : FoldersAndFiles = new File(path).listFiles()) {
                if (FolderOrFile.isDirectory()) {
                    String Folder = FolderOrFile.getPath().replaceAll(urlResourceFolder, "");
                    Return.addAll(this.getPropertiesFilesFromResources(Folder));
                    continue;
                }
                if (!FolderOrFile.isFile() || !FolderOrFile.getName().endsWith(".properties")) continue;
                Log.LogPrint(folder + "/" + FolderOrFile.getName().replaceAll(urlResourceFolder, ""));
                Return.add(folder + "/" + FolderOrFile.getName().replaceAll(urlResourceFolder, ""));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        finally {
            Log.ResCloseList();
        }
        return Return;
    }

    private Boolean loadFromResource(String fpsResource) {
        InputStream overwrites = Thread.currentThread().getContextClassLoader().getResourceAsStream(fpsResource);
        Boolean lvbReturn = false;
        String myLogPrint = "Load Resource: " + fpsResource;
        try {
            if (overwrites != null) {
                this.load(overwrites);
                overwrites.close();
                lvbReturn = true;
                myLogPrint = myLogPrint + " - OK";
            } else {
                myLogPrint = myLogPrint + " - not found!";
            }
        }
        catch (IOException e) {
            lvbReturn = false;
            myLogPrint = myLogPrint + " - failed!";
        }
        Log.LogPrint(myLogPrint);
        return lvbReturn;
    }

    private Boolean loadFromFile(String fpsPropertiesFile) {
        Boolean lvbReturn = false;
        try {
            File myFile = new File(fpsPropertiesFile);
            if (!myFile.exists()) {
                lvbReturn = false;
                throw new OKWFileDoesNotExistsException("File: " + fpsPropertiesFile + " does not exists.");
            }
            FileInputStream propFile = new FileInputStream(new File(fpsPropertiesFile));
            this.load(propFile);
            propFile.close();
            lvbReturn = true;
        }
        catch (Exception e) {
            throw new OKWFileDoesNotExistsException("File: " + fpsPropertiesFile + " does not exists.", e);
        }
        return lvbReturn;
    }

    private void loadSystemEnviromentVars() {
        Map<String, String> env = System.getenv();
        Log.ResOpenList("System Enviroment Vars...");
        for (String key : env.keySet()) {
            String value = env.get(key);
            if (this.containsKey(key)) {
                Log.LogPrint("Override: " + key + ": '" + this.get(key) + "'");
                Log.LogPrint("    with: " + key + ": '" + value + "'");
            } else {
                Log.LogPrint("   Write: " + key + ": '" + value + "'");
            }
            this.setProperty(key, value);
        }
        Log.ResCloseList();
    }

    private void loadSystemProperties() {
        Properties mySystemProperties = System.getProperties();
        Set<String> keys = mySystemProperties.stringPropertyNames();
        Log.ResOpenList("System Properties...");
        for (String key : keys) {
            String value = (String)mySystemProperties.get(key);
            if (this.containsKey(key)) {
                Log.LogPrint("Override: " + key + ": '" + this.get(key) + "'");
                Log.LogPrint("    with: " + key + ": '" + value + "'");
            } else {
                Log.LogPrint("   Write: " + key + ": '" + value + "'");
            }
            this.setProperty(key, value);
        }
        Log.ResCloseList();
    }

    public void PrintProperties() {
        Log.ResOpenList("List of Properties...");
        TreeMap<Object, Object> sortedSystemProperties = new TreeMap<Object, Object>(this);
        Set keySet = sortedSystemProperties.keySet();
        for (String propertyName : keySet) {
            String propertyValue = this.getProperty(propertyName);
            Log.LogPrint(propertyName + ": " + propertyValue);
        }
        Log.ResCloseList();
    }

    public void PrintPropertiesSources() {
        Iterator<String> iterator = null;
        Log.ResOpenList("Properties Sources...");
        Log.ResOpenList("Core sources...");
        for (String mySource : this.CoreProperties) {
            Log.LogPrint(mySource);
        }
        Log.ResCloseList();
        Log.ResOpenList("Project specific sources...");
        for (String mySource : this.ResoursesProperties) {
            Log.LogPrint(mySource);
        }
        Log.ResCloseList();
        Log.ResOpenList("File sources...");
        for (String mySource : this.FileProperties) {
            Log.LogPrint(mySource);
        }
        Log.ResCloseList();
        Log.ResCloseList();
    }

    public ArrayList<String> getKeysStartswith(String Startwitth) throws IOException {
        ArrayList<String> Return = new ArrayList<String>();
        Set<String> keys = this.stringPropertyNames();
        for (String key : keys) {
            if (!key.startsWith(Startwitth)) continue;
            Return.add(key);
        }
        return Return;
    }

    public ArrayList<String> getPropertiesForKeysStartswith(String Startwith) throws IOException {
        ArrayList<String> Return = new ArrayList<String>();
        Set<String> keys = this.stringPropertyNames();
        for (String key : keys) {
            if (!key.startsWith(Startwith)) continue;
            Return.add(this.getProperty(key));
        }
        return Return;
    }

    @Override
    public String getProperty(String fpsKey) {
        String lvsReturn = "";
        String lvsKey = "";
        lvsKey = Parser.ParseMe(fpsKey);
        lvsReturn = super.getProperty(lvsKey);
        if (lvsReturn == null) {
            Logger_Sngltn.getInstance().LogWarning("Propertykey (parsed) not found: '" + lvsKey + "'");
        } else {
            lvsReturn = Parser.ParseMe(lvsReturn);
        }
        return lvsReturn;
    }

    public String getProperty(String fpsKey, String fpsDefault, Object ... Parameters) {
        String lvsReturn = "";
        String lvsTemplate = "";
        lvsTemplate = fpsDefault == null ? this.getProperty(fpsKey) : this.getProperty(fpsKey, fpsDefault);
        if (lvsTemplate == null) {
            Logger_Sngltn.getInstance().LogWarning("Propertykey not found: '" + fpsKey + "'");
        } else {
            ST st = new ST(lvsTemplate, '%', '%');
            Integer i = 0;
            while (i < Parameters.length) {
                Integer J = i + 1;
                String PName = "P" + J.toString();
                Object Value = Parameters[i];
                st.add(PName, Value);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            lvsReturn = st.render();
        }
        return lvsReturn;
    }

    public Boolean getProperty2Boolean(String fpsKey, String fpsDefault) {
        Boolean lvbReturn = false;
        String lvsReturn = "";
        lvsReturn = this.getProperty(fpsKey, fpsDefault);
        lvbReturn = Boolean.parseBoolean(lvsReturn);
        return lvbReturn;
    }

    static {
        Log = Logger_Sngltn.getInstance();
    }
}

