/*
 * Decompiled with CFR 0.152.
 */
package okw.log;

import java.util.List;
import okw.OKW_Helper;
import okw.log.ILogger;

public class Log2Console
implements ILogger {
    private String BlanksBefore = "";
    private int LevelCounter = 0;
    private Boolean cvbDebugMode = false;

    @Override
    public void reset() {
        this.LevelCounter = 0;
        this.BlanksBefore = "";
        this.BlanksBefore();
    }

    @Override
    public void LogError(String fps_Message) {
        System.out.println(this.BlanksBefore + OKW_Helper.repeatString("-", (Integer)80));
        System.out.println(this.BlanksBefore + "ERROR: " + fps_Message);
        System.out.println(this.BlanksBefore + OKW_Helper.repeatString("-", (Integer)80));
    }

    @Override
    public void LogException(String fps_Message) {
        System.out.print(this.BlanksBefore + "Exception: ");
        System.out.println(fps_Message);
    }

    @Override
    public void LogFunctionEnd() {
        this.LogPrint("-------");
        this.ResCloseList();
    }

    @Override
    public void LogFunctionEnd(String fps_Return) {
        this.ResOpenList("Return...");
        this.LogPrint(fps_Return);
        this.ResCloseList();
        this.LogPrint("-------");
        this.ResCloseList();
    }

    @Override
    public void LogFunctionEnd(Boolean fpb_Return) {
        this.ResOpenList("Return...");
        this.LogPrint(fpb_Return.toString());
        this.ResCloseList();
        this.LogPrint("-------");
        this.ResCloseList();
    }

    @Override
    public void LogFunctionEnd(List<String> fpls_Return) {
        this.ResOpenList("Return...");
        for (String Value : fpls_Return) {
            this.LogPrint(Value);
        }
        this.ResCloseList();
        this.LogPrint("-------");
        this.ResCloseList();
    }

    @Override
    public void LogFunctionStart(String fps_FunctionName, String ... fpsParameter) {
        this.ResOpenList(fps_FunctionName);
        this.ResOpenList("Parameter...");
        for (int i = 0; i < fpsParameter.length; i += 2) {
            this.LogPrint(fpsParameter[i] + ": >>" + fpsParameter[i + 1] + "<<");
        }
        this.ResCloseList();
        this.LogPrint("-------");
    }

    @Override
    public void LogKeyWordEnd() {
        this.ResCloseList();
    }

    @Override
    public void LogKeyWordStart(String fps_KeyWordName, String ... fpsParameter) {
        String String2Print = fps_KeyWordName;
        if (fpsParameter.length == 0) {
            String2Print = String2Print + "()";
        } else if (fpsParameter.length == 1) {
            String2Print = String2Print + ": \"" + fpsParameter[0] + "\"";
        } else if (fpsParameter.length == 2) {
            String2Print = String2Print + ": \"" + fpsParameter[0] + "\" = \"" + fpsParameter[1] + "\"";
        } else {
            String2Print = String2Print + "(\"" + fpsParameter[0] + "\"";
            for (int i = 1; i < fpsParameter.length; ++i) {
                String2Print = String2Print + ", \"" + fpsParameter[i] + "\"";
            }
            String2Print = String2Print + ")";
        }
        this.ResOpenList(String2Print);
    }

    @Override
    public void LogLocalACCallStart(String sourceExcerpt, String Type2) {
        this.ResOpenList(sourceExcerpt);
        this.LogPrint("Type: " + Type2);
    }

    @Override
    public void LogLocalACCallEnd() {
        this.ResCloseList();
    }

    @Override
    public void LogRemoteACCallStart(String sourceExcerpt, String Type2) {
        this.ResOpenList(sourceExcerpt);
        this.LogPrint("Type: " + Type2);
    }

    @Override
    public void LogRemoteACCallEnd() {
        this.ResCloseList();
    }

    @Override
    public void LogStepStart(String categoryName, String categoryType, String choiceValue, String featureName, String localCategoryName, String sourceExcerpt, String type) {
        this.LogPrint("Step: " + sourceExcerpt);
        ++this.LevelCounter;
        this.LogPrint("       Feature Name:" + featureName);
        this.LogPrint("      Category Name:" + categoryName);
        this.LogPrint("      Category Type:" + categoryType);
        this.LogPrint("       Choice Value:" + choiceValue);
        this.LogPrint("Local Category Name:" + localCategoryName);
        this.LogPrint("               Type:" + type);
        this.BlanksBefore();
    }

    @Override
    public void LogStepEnd() {
        this.ResCloseList();
    }

    public void LogPreconditionStart(String Gherkin) {
        this.ResOpenList(Gherkin);
    }

    public void LogPreconditionEnd() {
        this.ResCloseList();
    }

    public void LogPostconditionStart(String Gherkin) {
        this.ResOpenList(Gherkin);
    }

    public void LogPostconditionEnd() {
        this.ResCloseList();
    }

    @Override
    public void LogPass(String fps_Message) {
        System.out.println(this.BlanksBefore + OKW_Helper.repeatString("-", (Integer)80));
        System.out.println(this.BlanksBefore + "Pass: " + fps_Message);
        System.out.println(this.BlanksBefore + OKW_Helper.repeatString("-", (Integer)80));
    }

    @Override
    public void LogPrint(String fps_Message) {
        System.out.println(this.BlanksBefore + fps_Message);
    }

    @Override
    public void LogSourceLocation(String Start, String End, String featureName, String sourceType) {
        System.out.println(this.BlanksBefore + featureName);
        System.out.println(this.BlanksBefore + Start);
        System.out.println(this.BlanksBefore + End);
        System.out.println(this.BlanksBefore + sourceType);
    }

    @Override
    public void LogWarning(String fps_Message) {
        System.out.println(this.BlanksBefore + OKW_Helper.repeatString("-", (Integer)80));
        System.out.println(this.BlanksBefore + "WARNING: " + fps_Message);
        System.out.println(this.BlanksBefore + OKW_Helper.repeatString("-", (Integer)80));
    }

    @Override
    public void ResCloseList() {
        this.LevelCounter = this.LevelCounter > 0 ? --this.LevelCounter : 0;
        this.BlanksBefore();
    }

    @Override
    public void ResOpenList(String fps_Name) {
        this.LogPrint(fps_Name);
        ++this.LevelCounter;
        this.BlanksBefore();
    }

    private void BlanksBefore() {
        this.BlanksBefore = OKW_Helper.repeatString("  ", (Integer)this.LevelCounter);
    }

    @Override
    public void LogTestcaseStart(String fps_TestcaseName) {
        this.reset();
        this.LogPrint("");
        this.LogPrint("-------------------------------------------------------------------------");
        this.LogKeyWordStart("Testcase", fps_TestcaseName);
    }

    @Override
    public void LogTestcaseEnd() {
        this.ResCloseList();
        this.LogPrint("-------------------------------------------------------------------------");
    }

    @Override
    public void LogSequenceStart(String fps_KeyWordName, String fpsWindowFN, String fps_SequenceName, String ... fpsParameter) {
        int i = fpsParameter.length;
        int n = i + 3;
        String[] newArray = new String[n];
        newArray[0] = fpsWindowFN;
        newArray[1] = fps_SequenceName;
        for (int cnt = 2; cnt < i; ++cnt) {
            newArray[cnt] = fpsParameter[cnt - 2];
        }
        this.LogKeyWordStart(fps_KeyWordName, newArray);
    }

    @Override
    public void LogSequenceEnd() {
        this.ResCloseList();
    }

    @Override
    public void LogFunctionStartDebug(String fps_FunctionName, String ... fpsParameter) {
        if (this.cvbDebugMode.booleanValue()) {
            this.LogFunctionStart(fps_FunctionName, fpsParameter);
        }
    }

    @Override
    public void LogFunctionEndDebug() {
        if (this.cvbDebugMode.booleanValue()) {
            this.LogFunctionEnd();
        }
    }

    @Override
    public void LogFunctionEndDebug(Boolean fpb_Return) {
        if (this.cvbDebugMode.booleanValue()) {
            this.LogFunctionEnd();
        }
    }

    @Override
    public void LogFunctionEndDebug(String fps_Return) {
        if (this.cvbDebugMode.booleanValue()) {
            this.LogFunctionEnd(fps_Return);
        }
    }

    @Override
    public void LogFunctionEndDebug(List<String> fpLs_Return) {
        if (this.cvbDebugMode.booleanValue()) {
            this.LogFunctionEnd(fpLs_Return);
        }
    }

    @Override
    public void LogPrintDebug(String fps_Message) {
        if (this.cvbDebugMode.booleanValue()) {
            this.LogPrint(fps_Message);
        }
    }

    @Override
    public void ResOpenListDebug(String fps_Name) {
        if (this.cvbDebugMode.booleanValue()) {
            this.ResOpenList(fps_Name);
        }
    }

    @Override
    public void ResCloseListDebug() {
        if (this.cvbDebugMode.booleanValue()) {
            this.ResCloseList();
        }
    }

    @Override
    public void setDebugMode(Boolean cvbDebugMode) {
        this.cvbDebugMode = cvbDebugMode;
    }
}

