/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import okw.OKW_HandleException;
import okw.exceptions.OKWMessageNotFoundException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OKW_XmlReader {
    private Document myXMLDocument;
    private DocumentBuilderFactory mydbFactory;
    private DocumentBuilder mydBuilder;
    private XPath myXPath;
    private String myXMLFile;

    public String getXMLFile() {
        return this.myXMLFile.toString();
    }

    public OKW_XmlReader(String fpsXMLFile) throws JAXBException, ParserConfigurationException, SAXException, IOException {
        this.myXMLFile = fpsXMLFile;
        this.Init();
    }

    private void Init() throws JAXBException, ParserConfigurationException, SAXException, IOException {
        InputStream is = OKW_XmlReader.class.getResourceAsStream(this.myXMLFile.toString());
        if (is == null) {
            System.out.println("============================================================================================================");
            System.out.println("OKW Exception: File not found! -> '" + this.myXMLFile.toString() + "'");
            System.out.println("============================================================================================================");
            throw new FileNotFoundException("File not found! The File was: '" + this.myXMLFile.toString() + "'");
        }
        this.mydbFactory = DocumentBuilderFactory.newInstance();
        this.mydBuilder = this.mydbFactory.newDocumentBuilder();
        this.myXMLDocument = this.mydBuilder.parse(is);
        this.myXPath = XPathFactory.newInstance().newXPath();
    }

    public String getTextContentSingleValue(String fpsXPathExpression) {
        String lvsReturn = "Message Not Found!";
        try {
            NodeList myNodeList = (NodeList)this.myXPath.compile(fpsXPathExpression).evaluate(this.myXMLDocument, XPathConstants.NODESET);
            if (myNodeList.getLength() != 1) {
                if (myNodeList.getLength() < 1) {
                    throw new OKWMessageNotFoundException("TextContent not Found!: " + fpsXPathExpression);
                }
                throw new OKWMessageNotFoundException("TextContent not Unique!: " + fpsXPathExpression);
            }
            Node myNode = myNodeList.item(0);
            lvsReturn = myNode.getTextContent();
        }
        catch (XPathExpressionException e) {
            OKW_HandleException.StopRunning(e, this.getClass());
        }
        return lvsReturn;
    }

    public ArrayList<String> getTextContentAsList(String fpsXPathExpression) {
        ArrayList<String> lvALReturn;
        block4: {
            lvALReturn = new ArrayList<String>();
            try {
                NodeList myNodeList = (NodeList)this.myXPath.compile(fpsXPathExpression).evaluate(this.myXMLDocument, XPathConstants.NODESET);
                int lviCount = myNodeList.getLength();
                if (lviCount >= 1) {
                    for (int i = 0; i < lviCount; ++i) {
                        Node myNode = myNodeList.item(i);
                        lvALReturn.add(myNode.getTextContent());
                    }
                    break block4;
                }
                throw new OKWMessageNotFoundException("TextContent not Found!");
            }
            catch (XPathExpressionException | OKWMessageNotFoundException e) {
                OKW_HandleException.StopRunning(e, this.getClass());
            }
        }
        return lvALReturn;
    }
}

