/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.xpath.XPathExpressionException;
import okw.LogMessenger;
import okw.OKW_Helper;
import okw.OKW_Properties;
import okw.exceptions.OKWFrameObjectParentNotFoundException;
import okw.log.Logger_Sngltn;

public class OKW_GetJavaClass {
    private static Logger_Sngltn Log = Logger_Sngltn.getInstance();
    private static LogMessenger LM = new LogMessenger("FrameObjectDictionary");

    public static String findClassGuiAdapter(String fpsClassName) {
        String OKW_GuiAdapteNameSpace = OKW_Properties.getInstance().getProperty("okw.gui.adapter", "okw.gui.adapter");
        return OKW_GetJavaClass.findClass(fpsClassName, OKW_GuiAdapteNameSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findClass(String fpsClassName, String fpsNameSpace) {
        String returnGUIAdapter = "";
        try {
            ArrayList<String> allAdapter = OKW_GetJavaClass.getClasses(fpsNameSpace);
            for (String Adapter : allAdapter) {
                if (!Adapter.matches(".*" + fpsClassName)) continue;
                returnGUIAdapter = Adapter;
            }
        }
        catch (IOException | XPathExpressionException e) {
            e.printStackTrace();
        }
        return returnGUIAdapter;
    }

    public static ArrayList<String> getClasses(String fpsPackage) throws IOException, XPathExpressionException {
        ArrayList<String> lvAsReturn = new ArrayList<String>();
        Log.ResOpenList("ClassPathes...");
        ArrayList<String> lvClassPathes = OKW_GetJavaClass.getClassPaths(fpsPackage);
        Log.ResCloseList();
        for (String lvClassPath : lvClassPathes) {
            File file;
            if ((lvClassPath = URLDecoder.decode(lvClassPath, Charset.defaultCharset().name())).startsWith("file:")) {
                lvClassPath = OKW_Helper.getRightFromDelimiterNumber(lvClassPath, "file:", 1);
                lvClassPath = OKW_Helper.getLeftFromDelimiterNumber(lvClassPath, "!", 1);
            }
            if (!(file = new File(lvClassPath)).exists()) continue;
            if (lvClassPath.endsWith("jar")) {
                lvAsReturn.addAll(OKW_GetJavaClass.getClassesFromJar(lvClassPath, fpsPackage));
                continue;
            }
            if (!Files.isDirectory(Paths.get(file.toURI()), LinkOption.NOFOLLOW_LINKS)) continue;
            lvAsReturn.addAll(OKW_GetJavaClass.getClassesFromDirectory(file.getAbsolutePath(), fpsPackage));
        }
        return lvAsReturn;
    }

    public static ArrayList<String> getClassPaths(String packageName) throws IOException {
        ArrayList<String> ReturnList = new ArrayList<String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String replacedURL = resource.getPath();
            Log.LogPrint("'" + replacedURL + "'");
            ReturnList.add(replacedURL);
        }
        return ReturnList;
    }

    private static ArrayList<String> getClassesFromDirectory(String fpsdirectory, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        File directory = new File(fpsdirectory);
        if (directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    classes.addAll(OKW_GetJavaClass.getClassesFromDirectory(file.getPath(), packageName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                classes.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getClassesFromJar(String jarPath, String packageName) throws IOException {
        ArrayList<String> lvAL_Return = new ArrayList<String>();
        try (JarFile jarFile = null;){
            jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String entryName = entry.getName();
                packageName = packageName.replace(".", "/");
                if (entryName == null || !entryName.endsWith(".class") || !entryName.startsWith(packageName)) continue;
                try {
                    Class<?> entryClass = Class.forName(entryName.substring(0, entryName.length() - 6).replace("/", "."));
                    if (entryClass == null) continue;
                    lvAL_Return.add(entryClass.getName());
                }
                catch (Throwable throwable) {}
            }
        }
        return lvAL_Return;
    }

    public static Class<?> loadClass(String fpsClass) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> aClass = null;
        try {
            aClass = classLoader.loadClass(fpsClass);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return aClass;
    }

    public static Object createInstanceByType(Class<?> fpParentType) throws InstantiationException, XPathExpressionException {
        Object lvo_Obj = null;
        Boolean bOK = false;
        Log.LogFunctionStartDebug("FrameObjectDictionary.CreateInstanceByObjectName", "fpParentClass", fpParentType.getName());
        try {
            lvo_Obj = fpParentType.newInstance();
            Log.LogPrintDebug(LM.GetMessage("CreateInstanceByObjectName", "InstanceWasCreated", lvo_Obj.getClass().getName()));
            bOK = true;
        }
        catch (IllegalAccessException e) {
            throw new OKWFrameObjectParentNotFoundException(LM.GetMessage("CreateInstanceByObjectName", "InstanceWasCreated", fpParentType.getName()));
        }
        finally {
            if (bOK.booleanValue()) {
                Log.LogFunctionEndDebug(lvo_Obj.getClass().getName());
            } else {
                Log.LogFunctionEndDebug();
            }
        }
        return lvo_Obj;
    }

    public static ArrayList<Class<?>> getListOfClasses(String fpsNamespace) throws ClassNotFoundException, IOException, XPathExpressionException {
        ArrayList lvALReturn = new ArrayList();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> lvALClassNames = OKW_GetJavaClass.getClasses(fpsNamespace);
        try {
            for (String lvsClass : lvALClassNames) {
                Class<?> aClass = classLoader.loadClass(lvsClass);
                lvALReturn.add(aClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return lvALReturn;
    }
}

