/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.xpath.XPathExpressionException;
import okw.OKW_Helper;

public class OKW_GetJavaClass {
    public static ArrayList<String> getClasses(String fpsPackage) throws IOException, XPathExpressionException {
        ArrayList<String> lvAsReturn = new ArrayList<String>();
        ArrayList<String> lvClassPathes = OKW_GetJavaClass.getClassPaths(fpsPackage);
        for (String lvClassPath : lvClassPathes) {
            File file;
            if (lvClassPath.startsWith("file:")) {
                lvClassPath = OKW_Helper.GetRightFromDelimiterNumber(lvClassPath, "file:", 1);
                lvClassPath = OKW_Helper.GetLeftFromDelimiterNumber(lvClassPath, "!", 1);
            }
            if (!(file = new File(lvClassPath)).exists()) continue;
            if (lvClassPath.endsWith("jar")) {
                lvAsReturn.addAll(OKW_GetJavaClass.getClassesFromJar(lvClassPath, fpsPackage));
                continue;
            }
            if (!Files.isDirectory(Paths.get(lvClassPath, new String[0]), LinkOption.NOFOLLOW_LINKS)) continue;
            lvAsReturn.addAll(OKW_GetJavaClass.getClassesFromDirectory(lvClassPath, fpsPackage));
        }
        return lvAsReturn;
    }

    public static ArrayList<String> getClassPaths(String packageName) throws IOException {
        ArrayList<String> ReturnList = new ArrayList<String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String replacedURL = resource.getPath();
            System.out.println(">>" + replacedURL + "<<");
            ReturnList.add(replacedURL);
        }
        return ReturnList;
    }

    private static ArrayList<String> getClassesFromDirectory(String fpsdirectory, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        File directory = new File(fpsdirectory);
        if (directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    classes.addAll(OKW_GetJavaClass.getClassesFromDirectory(file.getPath(), packageName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                classes.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getClassesFromJar(String jarPath, String packageName) throws IOException {
        ArrayList<String> lvAL_Return = new ArrayList<String>();
        try (JarFile jarFile = null;){
            jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String entryName = entry.getName();
                packageName = packageName.replace(".", "/");
                if (entryName == null || !entryName.endsWith(".class") || !entryName.startsWith(packageName)) continue;
                try {
                    Class<?> entryClass = Class.forName(entryName.substring(0, entryName.length() - 6).replace("/", "."));
                    if (entryClass == null) continue;
                    lvAL_Return.add(entryClass.getName());
                }
                catch (Throwable throwable) {}
            }
        }
        return lvAL_Return;
    }
}

