/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import okw.exceptions.OKWDirectoryDoesNotExistsException;
import okw.exceptions.OKWDirectorySeperatorNotImplementedException;
import okw.exceptions.OKWFileDoesNotExistsException;
import okw.log.Logger_Sngltn;

public class OKW_FileHelper {
    private static Logger_Sngltn Log = Logger_Sngltn.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean DirectoryCreateEmpty(String fpsPath) {
        String lvsPath = "";
        Boolean lvbReturn = false;
        try {
            Log.LogFunctionStart("DirectoryCreateEmpty", "String", fpsPath);
            File myDirectory = new File(fpsPath);
            if (myDirectory.exists() & myDirectory.isDirectory()) {
                OKW_FileHelper.DirectoryDelete(lvsPath);
            } else if (myDirectory.exists() & myDirectory.isFile()) {
                OKW_FileHelper.FileDelete(lvsPath);
            }
            myDirectory.mkdirs();
            lvbReturn = true;
        }
        catch (Exception e) {
            Log.LogPrint("The process failed:");
        }
        finally {
            Log.LogFunctionEnd(lvbReturn);
        }
        return lvbReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DirectoryDelete(String fpsPaFiNa) {
        String lvsPaFiNa = fpsPaFiNa;
        Boolean lvbReturn = false;
        Log.LogFunctionStartDebug("OKW_Helper.DirectoryDelete", "fpsPaFiNa", fpsPaFiNa);
        try {
            File myPath = new File(lvsPaFiNa);
            if (myPath.exists()) {
                for (File f : myPath.listFiles()) {
                    if (f.isDirectory()) {
                        OKW_FileHelper.DirectoryDelete(f.getPath());
                        f.delete();
                        continue;
                    }
                    f.delete();
                }
                myPath.delete();
            }
        }
        finally {
            Log.LogFunctionEndDebug(lvbReturn);
        }
    }

    public static Boolean DirectoryExists(String fpsPaFiNa) {
        Boolean lvbReturn = false;
        Log.LogFunctionStartDebug("OKW_FileHelper.DirectoryExists", "fpsPaFiNa", fpsPaFiNa);
        try {
            File myFile = new File(fpsPaFiNa);
            if (myFile.exists()) {
                if (myFile.isDirectory()) {
                    lvbReturn = true;
                } else {
                    if (myFile.isFile()) {
                        throw new OKWFileDoesNotExistsException("This is not a directory! Given path is a directory!");
                    }
                    lvbReturn = false;
                }
            }
        }
        finally {
            Log.LogFunctionEndDebug(lvbReturn);
        }
        return lvbReturn;
    }

    public static void DirectoryCopy(String fpsSourceFolder, String fpsDestinationFolder) {
        File sourceFolder = new File(fpsSourceFolder);
        File destinationFolder = new File(fpsDestinationFolder);
        OKW_FileHelper.DirectoryCopy(sourceFolder, destinationFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean DirectoryCopy(File fpSourceFolder, File fpDestinationFolder) {
        Boolean lvbReturn = false;
        try {
            Log.LogFunctionStartDebug("OKW_FileHelper.DirectoryMove", "fpSourceFolder", fpSourceFolder.getPath(), "fpDestinationFolder", fpDestinationFolder.getPath());
            if (fpSourceFolder.isDirectory()) {
                String[] files;
                if (!fpDestinationFolder.exists()) {
                    fpDestinationFolder.mkdir();
                    System.out.println("Directory created :: " + fpDestinationFolder);
                }
                for (String file : files = fpSourceFolder.list()) {
                    File srcFile = new File(fpSourceFolder, file);
                    File destFile = new File(fpDestinationFolder, file);
                    OKW_FileHelper.DirectoryCopy(srcFile, destFile);
                }
            } else {
                Files.copy(fpSourceFolder.toPath(), fpDestinationFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
                System.out.println("File copied :: " + fpDestinationFolder);
            }
        }
        catch (IOException e) {
            Log.LogPrintDebug(e.getMessage());
        }
        finally {
            Log.LogFunctionEndDebug(lvbReturn);
        }
        return lvbReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean DirectoryMove(String fpsPaNaSource, String fpsPaNaDestination) throws IOException, FileNotFoundException {
        Boolean lvbReturn = false;
        String lvsPaNaSource = fpsPaNaSource;
        String lvsPaNaDestination = fpsPaNaDestination;
        try {
            Log.LogFunctionStartDebug("OKW_FileHelper.DirectoryMove", "fpsPaNaSource", fpsPaNaSource, "fpsPaNaDestination", fpsPaNaDestination);
            if (OKW_FileHelper.DirectoryExists(lvsPaNaSource).booleanValue()) {
                OKW_FileHelper.DirectoryDelete(lvsPaNaDestination);
                OKW_FileHelper.Copy(lvsPaNaSource, lvsPaNaDestination, true);
                OKW_FileHelper.DirectoryDelete(lvsPaNaSource);
                lvbReturn = true;
            }
        }
        finally {
            Log.LogFunctionEndDebug(lvbReturn);
        }
        return lvbReturn;
    }

    public static void Copy(String fpsSource, String fpsDestination, Boolean copySubDirs) throws IOException, FileNotFoundException {
        Path lvSourcePath = Paths.get(fpsSource, new String[0]);
        Path lvDestinationPath = Paths.get(fpsDestination, new String[0]);
        if (Files.notExists(lvSourcePath, new LinkOption[0])) {
            throw new FileNotFoundException("Source directory does not exist or could not be found: " + fpsSource);
        }
        Files.copy(lvSourcePath, lvDestinationPath, new CopyOption[0]);
    }

    public static void FilesDelete(String fpsPaFiNa) {
        if (OKW_FileHelper.DirectoryExists(fpsPaFiNa).booleanValue()) {
            File[] listOfFiles;
            File myDir = new File(fpsPaFiNa);
            for (File myFielToDelete : listOfFiles = myDir.listFiles()) {
                if (myFielToDelete.isDirectory()) {
                    // empty if block
                }
                myFielToDelete.delete();
            }
        }
    }

    public static Boolean FileDelete(String fpsPaFiNa) {
        Boolean lvbReturn = false;
        Log.LogFunctionStartDebug("OKW_FileHelper.FileDelete", "fpsPaFiNa", fpsPaFiNa);
        if (OKW_FileHelper.FileExists(fpsPaFiNa).booleanValue()) {
            try {
                File myFile = new File(fpsPaFiNa);
                lvbReturn = myFile.delete();
            }
            finally {
                Log.LogFunctionEndDebug();
            }
        }
        return lvbReturn;
    }

    public static Boolean FileExists(String fpsPaFiNa) {
        Boolean lvbReturn = false;
        Log.LogFunctionStartDebug("OKW_FileHelper.FileExist", "fpsPaFiNa", fpsPaFiNa);
        try {
            File myFile = new File(fpsPaFiNa);
            if (myFile.exists()) {
                if (myFile.isFile()) {
                    lvbReturn = true;
                } else {
                    if (myFile.isDirectory()) {
                        throw new OKWFileDoesNotExistsException("This is not a file! Given path is a directory!");
                    }
                    lvbReturn = false;
                }
            }
        }
        finally {
            Log.LogFunctionEndDebug(lvbReturn.toString());
        }
        return lvbReturn;
    }

    public static void Move(String fpsPaFiNaSource, String fpsPaFiNaDestination) throws IOException, FileNotFoundException {
        block4: {
            Log.LogFunctionStartDebug("OKW_FileHelper.Move", "fpsPaFiNaSource", fpsPaFiNaSource, "fpsPaFiNaDestination", fpsPaFiNaDestination);
            try {
                if (OKW_FileHelper.FileExists(fpsPaFiNaSource).booleanValue()) {
                    OKW_FileHelper.FileDelete(fpsPaFiNaDestination);
                    OKW_FileHelper.Copy(fpsPaFiNaSource, fpsPaFiNaDestination, true);
                    OKW_FileHelper.FileDelete(fpsPaFiNaSource);
                    break block4;
                }
                Log.LogFunctionEnd();
                throw new OKWFileDoesNotExistsException("file doesnot exists...");
            }
            finally {
                Log.LogFunctionEnd();
            }
        }
    }

    public static boolean FileCreate(String fpsPaFiNa) throws IOException {
        Boolean lvbReturn = false;
        Path newFilePath = Paths.get(fpsPaFiNa, new String[0]);
        try {
            if (!Files.exists(newFilePath, new LinkOption[0])) {
                Files.createFile(newFilePath, new FileAttribute[0]);
            }
        }
        finally {
            Log.LogFunctionEnd(lvbReturn);
        }
        return lvbReturn;
    }

    public static Boolean IsDirectoryEmpty(String fpsPath) {
        block4: {
            Boolean lvbReturn = false;
            Log.LogFunctionStart("OKW_FileHelper.IsDirectoryEmpty", "fpaFolder", fpsPath);
            try {
                if (OKW_FileHelper.DirectoryExists(fpsPath).booleanValue()) {
                    lvbReturn = Paths.get(fpsPath, new String[0]).toFile().listFiles().length == 0;
                    break block4;
                }
                throw new OKWDirectoryDoesNotExistsException("Directory Doesnt Exists...");
            }
            finally {
                Log.LogFunctionEnd(lvbReturn);
            }
        }
        return false;
    }

    public static String ConvertDirectorySeperator(String fpsPath) {
        String lvsReturn;
        block5: {
            lvsReturn = fpsPath;
            Log.LogFunctionStartDebug("OKW_FileHelper.ConvertDirectorySeperator", "fpsPath", fpsPath);
            try {
                String myFileSeparator = System.getProperty("file.separator");
                if (myFileSeparator.equals("/")) {
                    lvsReturn = fpsPath.replace("\\", "/");
                    break block5;
                }
                if (myFileSeparator.equals("||")) {
                    lvsReturn = fpsPath.replace("/", "\\");
                    break block5;
                }
                throw new OKWDirectorySeperatorNotImplementedException("");
            }
            finally {
                Log.LogFunctionEndDebug(lvsReturn);
            }
        }
        return lvsReturn;
    }
}

