/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import okw.exceptions.OKWDirectoryDoesNotExistsException;
import okw.exceptions.OKWDirectorySeperatorNotImplementedException;
import okw.exceptions.OKWFileDoesNotExistsException;
import okw.log.Logger_Sngltn;

public class OKW_FileHelper {
    private static Logger_Sngltn Log = Logger_Sngltn.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean createEmptyDirectory(String fpsPath) {
        String lvsPath = "";
        Boolean lvbReturn = false;
        try {
            Log.LogFunctionStart("DirectoryCreateEmpty", "String", fpsPath);
            File myDirectory = new File(fpsPath);
            if (myDirectory.exists() & myDirectory.isDirectory()) {
                OKW_FileHelper.deleteDirectory(lvsPath);
            } else if (myDirectory.exists() & myDirectory.isFile()) {
                OKW_FileHelper.deleteFile(lvsPath);
            }
            myDirectory.mkdirs();
            lvbReturn = true;
        }
        catch (Exception e) {
            Log.LogPrint("The process failed:");
        }
        finally {
            Log.LogFunctionEnd(lvbReturn);
        }
        return lvbReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDirectory(String fpsPath) {
        String lvsPath = fpsPath;
        Boolean lvbReturn = false;
        Log.LogFunctionStartDebug("OKW_Helper.DirectoryDelete", "fpsPaFiNa", fpsPath);
        try {
            File myPath = new File(lvsPath);
            if (myPath.exists()) {
                for (File f : myPath.listFiles()) {
                    if (f.isDirectory()) {
                        OKW_FileHelper.deleteDirectory(f.getPath());
                        f.delete();
                        continue;
                    }
                    f.delete();
                }
                myPath.delete();
            }
        }
        finally {
            Log.LogFunctionEndDebug(lvbReturn);
        }
    }

    public static Boolean directoryExists(String fpsPaFiNa) {
        Boolean lvbReturn = false;
        Log.LogFunctionStartDebug("OKW_FileHelper.DirectoryExists", "fpsPaFiNa", fpsPaFiNa);
        try {
            File myFile = new File(fpsPaFiNa);
            if (myFile.exists()) {
                if (myFile.isDirectory()) {
                    lvbReturn = true;
                } else {
                    if (myFile.isFile()) {
                        throw new OKWFileDoesNotExistsException("This is not a directory! Given path is a directory!");
                    }
                    lvbReturn = false;
                }
            }
        }
        finally {
            Log.LogFunctionEndDebug(lvbReturn);
        }
        return lvbReturn;
    }

    public static void copyDirectory(String fpsSourceFolder, String fpsDestinationFolder) {
        File sourceFolder = new File(fpsSourceFolder);
        File destinationFolder = new File(fpsDestinationFolder);
        OKW_FileHelper.copyDirectory(sourceFolder, destinationFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyDirectory(File fpSourceFolder, File fpDestinationFolder) {
        Boolean lvbReturn = false;
        try {
            Log.LogFunctionStartDebug("OKW_FileHelper.DirectoryMove", "fpSourceFolder", fpSourceFolder.getPath(), "fpDestinationFolder", fpDestinationFolder.getPath());
            if (fpSourceFolder.isDirectory()) {
                String[] files;
                if (!fpDestinationFolder.exists()) {
                    fpDestinationFolder.mkdir();
                    System.out.println("Directory created :: " + fpDestinationFolder);
                }
                for (String file : files = fpSourceFolder.list()) {
                    File srcFile = new File(fpSourceFolder, file);
                    File destFile = new File(fpDestinationFolder, file);
                    OKW_FileHelper.copyDirectory(srcFile, destFile);
                }
            } else {
                Files.copy(fpSourceFolder.toPath(), fpDestinationFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
                System.out.println("File copied :: " + fpDestinationFolder);
            }
        }
        catch (IOException e) {
            Log.LogPrintDebug(e.getMessage());
        }
        finally {
            Log.LogFunctionEndDebug(lvbReturn);
        }
        return lvbReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveDirectory(String fpsPaNaSource, String fpsPaNaDestination) throws IOException, FileNotFoundException {
        Boolean lvbReturn = false;
        String lvsPaNaSource = fpsPaNaSource;
        String lvsPaNaDestination = fpsPaNaDestination;
        try {
            Log.LogFunctionStartDebug("OKW_FileHelper.DirectoryMove", "fpsPaNaSource", fpsPaNaSource, "fpsPaNaDestination", fpsPaNaDestination);
            if (OKW_FileHelper.directoryExists(lvsPaNaSource).booleanValue()) {
                OKW_FileHelper.deleteDirectory(lvsPaNaDestination);
                OKW_FileHelper.copy(lvsPaNaSource, lvsPaNaDestination, true);
                OKW_FileHelper.deleteDirectory(lvsPaNaSource);
                lvbReturn = true;
            }
        }
        finally {
            Log.LogFunctionEndDebug(lvbReturn);
        }
        return lvbReturn;
    }

    public static void copy(String fpsSource, String fpsDestination, Boolean copySubDirs) throws IOException, FileNotFoundException {
        Path lvSourcePath = Paths.get(fpsSource, new String[0]);
        Path lvDestinationPath = Paths.get(fpsDestination, new String[0]);
        if (Files.notExists(lvSourcePath, new LinkOption[0])) {
            throw new FileNotFoundException("Source directory does not exist or could not be found: " + fpsSource);
        }
        Files.copy(lvSourcePath, lvDestinationPath, new CopyOption[0]);
    }

    public static void deleteFiles(String fpsPaFiNa) {
        if (OKW_FileHelper.directoryExists(fpsPaFiNa).booleanValue()) {
            File[] listOfFiles;
            File myDir = new File(fpsPaFiNa);
            for (File myFileToDelete : listOfFiles = myDir.listFiles()) {
                if (myFileToDelete.isDirectory()) continue;
                myFileToDelete.delete();
            }
        }
    }

    public static Boolean deleteFile(String fpsPaFiNa) {
        Boolean lvbReturn = false;
        Log.LogFunctionStartDebug("OKW_FileHelper.FileDelete", "fpsPaFiNa", fpsPaFiNa);
        if (OKW_FileHelper.fileExists(fpsPaFiNa).booleanValue()) {
            try {
                File myFile = new File(fpsPaFiNa);
                lvbReturn = myFile.delete();
            }
            finally {
                Log.LogFunctionEndDebug();
            }
        }
        return lvbReturn;
    }

    public static Boolean fileExists(String fpsPaFiNa) {
        Boolean lvbReturn = false;
        Log.LogFunctionStartDebug("OKW_FileHelper.FileExist", "fpsPaFiNa", fpsPaFiNa);
        try {
            File myFile = new File(fpsPaFiNa);
            if (myFile.exists()) {
                if (myFile.isFile()) {
                    lvbReturn = true;
                } else {
                    if (myFile.isDirectory()) {
                        throw new OKWFileDoesNotExistsException("This is not a file! Given path is a directory!");
                    }
                    lvbReturn = false;
                }
            }
        }
        finally {
            Log.LogFunctionEndDebug(lvbReturn.toString());
        }
        return lvbReturn;
    }

    public static void move(String fpsPaFiNaSource, String fpsPaFiNaDestination) throws IOException, FileNotFoundException {
        block4: {
            Log.LogFunctionStartDebug("OKW_FileHelper.Move", "fpsPaFiNaSource", fpsPaFiNaSource, "fpsPaFiNaDestination", fpsPaFiNaDestination);
            try {
                if (OKW_FileHelper.fileExists(fpsPaFiNaSource).booleanValue()) {
                    OKW_FileHelper.deleteFile(fpsPaFiNaDestination);
                    OKW_FileHelper.copy(fpsPaFiNaSource, fpsPaFiNaDestination, true);
                    OKW_FileHelper.deleteFile(fpsPaFiNaSource);
                    break block4;
                }
                Log.LogFunctionEnd();
                throw new OKWFileDoesNotExistsException("file doesnot exists...");
            }
            finally {
                Log.LogFunctionEnd();
            }
        }
    }

    public static boolean createFile(String fpsPaFiNa) throws IOException {
        Boolean lvbReturn = false;
        Path newFilePath = Paths.get(fpsPaFiNa, new String[0]);
        try {
            if (!Files.exists(newFilePath, new LinkOption[0])) {
                Files.createFile(newFilePath, new FileAttribute[0]);
            }
        }
        finally {
            Log.LogFunctionEnd(lvbReturn);
        }
        return lvbReturn;
    }

    public static Boolean isDirectoryEmpty(String fpsPath) {
        block4: {
            Boolean lvbReturn = false;
            Log.LogFunctionStart("OKW_FileHelper.IsDirectoryEmpty", "fpaFolder", fpsPath);
            try {
                if (OKW_FileHelper.directoryExists(fpsPath).booleanValue()) {
                    lvbReturn = Paths.get(fpsPath, new String[0]).toFile().listFiles().length == 0;
                    break block4;
                }
                throw new OKWDirectoryDoesNotExistsException("Directory Doesnt Exists...");
            }
            finally {
                Log.LogFunctionEnd(lvbReturn);
            }
        }
        return false;
    }

    public static String convertDirectorySeperator(String fpsPath) {
        String lvsReturn = fpsPath;
        Log.LogFunctionStartDebug("OKW_FileHelper.ConvertDirectorySeperator", "fpsPath", fpsPath);
        try {
            String myFileSeparator = System.getProperty("file.separator");
            if ("/".equals(myFileSeparator)) {
                lvsReturn = fpsPath.replace("\\", "/");
            } else if ("\\".equals(myFileSeparator)) {
                lvsReturn = fpsPath.replace("/", "\\");
            } else {
                throw new OKWDirectorySeperatorNotImplementedException("Error: Unknown file.separator: -" + myFileSeparator + "-");
            }
            lvsReturn = lvsReturn.replace("\\C:", "C:");
        }
        finally {
            Log.LogFunctionEndDebug(lvsReturn);
        }
        return lvsReturn;
    }
}

