/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import okw.exceptions.OKWFileDoesNotExistsException;
import okw.log.Logger_Sngltn;

public class OKW_Properties
extends Properties {
    private static OKW_Properties Instance;
    private static Logger_Sngltn Log;
    protected ArrayList<String> CoreProperties = new ArrayList();
    protected ArrayList<String> ResoursesProperties = new ArrayList();
    protected ArrayList<String> FileProperties = new ArrayList();
    private static final long serialVersionUID = -6936118958227023483L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OKW_Properties getInstance() {
        if (Instance != null) return Instance;
        Class<OKW_Properties> clazz = OKW_Properties.class;
        synchronized (OKW_Properties.class) {
            if (Instance != null) return Instance;
            Instance = new OKW_Properties();
            // ** MonitorExit[var0] (shouldn't be in output)
            return Instance;
        }
    }

    private OKW_Properties() {
        this.init();
    }

    @Override
    public void clear() {
        super.clear();
        this.CoreProperties.clear();
        this.ResoursesProperties.clear();
        this.FileProperties.clear();
    }

    public void init() {
        this.clear();
        this.CoreProperties.add("core.properties");
        this.CoreProperties.add("frmSeChrome.properties");
        ArrayList<String> someProperties = this.getPropertiesFilesFromResources("");
        this.ResoursesProperties.addAll(someProperties);
        this.updateProperties();
        this.PrintPropertiesSources();
    }

    public void updateProperties() {
        super.clear();
        for (String s : this.CoreProperties) {
            this.loadFromResource(s);
        }
        for (String s : this.ResoursesProperties) {
            this.loadFromResource(s);
        }
        for (String s : this.FileProperties) {
            this.loadFromFile(s);
        }
        this.loadSystemEnviromentVars();
        this.loadSystemProperties();
    }

    public Boolean addResource(String fpsResourceName) {
        Boolean lvbReturn = true;
        lvbReturn = this.ResoursesProperties.add(fpsResourceName);
        this.updateProperties();
        return lvbReturn;
    }

    public void addPropertiesFile(String fpsFileName) {
        this.FileProperties.add(fpsFileName);
        this.updateProperties();
    }

    private ArrayList<String> getPropertiesFilesFromResources(String folder) {
        File[] FoldersAndFiles;
        ArrayList<String> Return = new ArrayList<String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(folder);
        String path = url.getPath();
        String urlResourceFolder = path.replaceAll(folder, "");
        for (File FolderOrFile : FoldersAndFiles = new File(path).listFiles()) {
            if (FolderOrFile.isDirectory()) {
                String Folder = FolderOrFile.getPath().replaceAll(urlResourceFolder, "");
                Return.addAll(this.getPropertiesFilesFromResources(Folder));
                continue;
            }
            if (!FolderOrFile.isFile() || !FolderOrFile.getName().endsWith(".properties")) continue;
            Log.LogPrint(FolderOrFile.getPath());
            Return.add(folder + "/" + FolderOrFile.getName().replaceAll(urlResourceFolder, ""));
        }
        return Return;
    }

    private Boolean loadFromResource(String fpsResource) {
        InputStream overwrites = Thread.currentThread().getContextClassLoader().getResourceAsStream(fpsResource);
        Boolean lvbReturn = false;
        try {
            if (overwrites != null) {
                Log.LogPrint(fpsResource);
                this.load(overwrites);
                overwrites.close();
                lvbReturn = true;
            }
        }
        catch (IOException e) {
            lvbReturn = false;
        }
        return lvbReturn;
    }

    private Boolean loadFromFile(String fpsPropertiesFile) {
        Boolean lvbReturn = false;
        try {
            File myFile = new File(fpsPropertiesFile);
            if (!myFile.exists()) {
                lvbReturn = false;
                throw new OKWFileDoesNotExistsException("File: " + fpsPropertiesFile + " does not exists.");
            }
            FileInputStream propFile = new FileInputStream(new File(fpsPropertiesFile));
            this.load(propFile);
            propFile.close();
            lvbReturn = true;
        }
        catch (Exception e) {
            throw new OKWFileDoesNotExistsException("File: " + fpsPropertiesFile + " does not exists.", e);
        }
        return lvbReturn;
    }

    private void loadSystemEnviromentVars() {
        Map<String, String> env = System.getenv();
        Log.ResOpenList("System Enviroment Vars...");
        for (String key : env.keySet()) {
            String value = env.get(key);
            if (this.containsKey(key)) {
                Log.LogPrint("\u00dcberschreibe: " + key + ": '" + this.get(key) + "'");
                Log.LogPrint("         mit: " + key + ": '" + value + "'");
            } else {
                Log.LogPrint("    Schreibe: " + key + ": '" + value + "'");
            }
            this.setProperty(key, value);
        }
        Log.ResCloseList();
    }

    private void loadSystemProperties() {
        Properties mySystemProperties = System.getProperties();
        Set<String> keys = mySystemProperties.stringPropertyNames();
        Log.ResOpenList("System Properties...");
        for (String key : keys) {
            String value = (String)mySystemProperties.get(key);
            if (this.containsKey(key)) {
                Log.LogPrint("\u00dcberschreibe: " + key + ": '" + this.get(key) + "'");
                Log.LogPrint("         mit: " + key + ": '" + value + "'");
            } else {
                Log.LogPrint("    Schreibe: " + key + ": '" + value + "'");
            }
            this.setProperty(key, value);
        }
        Log.ResCloseList();
    }

    public void PrintProperties() {
        Log.ResOpenList("List of Properties...");
        TreeMap<Object, Object> sortedSystemProperties = new TreeMap<Object, Object>(this);
        Set keySet = sortedSystemProperties.keySet();
        for (String propertyName : keySet) {
            String propertyValue = this.getProperty(propertyName);
            Log.LogPrint(propertyName + ": " + propertyValue);
        }
        Log.ResCloseList();
    }

    public void PrintPropertiesSources() {
        Iterator<String> iterator = null;
        Log.ResOpenList("Properties Sources...");
        Log.ResOpenList("Core sources...");
        for (String mySource : this.CoreProperties) {
            Log.LogPrint(mySource);
        }
        Log.ResCloseList();
        Log.ResOpenList("Project specific sources...");
        for (String mySource : this.ResoursesProperties) {
            Log.LogPrint(mySource);
        }
        Log.ResCloseList();
        Log.ResOpenList("File sources...");
        for (String mySource : this.FileProperties) {
            Log.LogPrint(mySource);
        }
        Log.ResCloseList();
        Log.ResCloseList();
    }

    public ArrayList<String> getKeysStartswith(String Startwitth) throws IOException {
        ArrayList<String> Return = new ArrayList<String>();
        Set<String> keys = this.stringPropertyNames();
        for (String key : keys) {
            if (!key.startsWith(Startwitth)) continue;
            Return.add(key);
        }
        return Return;
    }

    public ArrayList<String> getPropertiesForKeysStartswith(String Startwith) throws IOException {
        ArrayList<String> Return = new ArrayList<String>();
        Set<String> keys = this.stringPropertyNames();
        for (String key : keys) {
            if (!key.startsWith(Startwith)) continue;
            Return.add(this.getProperty(key));
        }
        return Return;
    }

    static {
        Log = Logger_Sngltn.getInstance();
    }
}

