/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class OKW_Properties
extends Properties {
    protected ArrayList<String> ResoursesProperties = new ArrayList();
    protected ArrayList<String> FileProperties = new ArrayList();
    private static final long serialVersionUID = -6936118958227023483L;

    public Boolean addResource(String fpsResourceName) {
        Boolean lvbReturn = true;
        lvbReturn = this.ResoursesProperties.add(fpsResourceName);
        this.updateProperties();
        return lvbReturn;
    }

    public Boolean addFile(String fpsFileName) {
        Boolean lvbReturn = true;
        if (this.FileProperties.add(fpsFileName)) {
            this.updateProperties();
        } else {
            lvbReturn = false;
        }
        return lvbReturn;
    }

    private Boolean loadFromResource(String fpsResource) {
        InputStream overwrites = Thread.currentThread().getContextClassLoader().getResourceAsStream(fpsResource);
        Boolean lvbReturn = false;
        try {
            if (overwrites != null) {
                this.load(overwrites);
                overwrites.close();
                lvbReturn = true;
            }
        }
        catch (IOException e) {
            lvbReturn = false;
        }
        return lvbReturn;
    }

    private Boolean loadFromFile(String fpsPropertiesFile) {
        Boolean lvbReturn = false;
        try {
            FileInputStream propFile = new FileInputStream(new File(fpsPropertiesFile));
            this.load(propFile);
            propFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lvbReturn;
    }

    @Override
    public void clear() {
        this.ResoursesProperties.clear();
        this.FileProperties.clear();
        this.updateProperties();
    }

    public void updateProperties() {
        super.clear();
        for (String s : this.ResoursesProperties) {
            this.loadFromResource(s);
        }
        for (String s : this.FileProperties) {
            this.loadFromFile(s);
        }
        this.putAll((Map<?, ?>)System.getProperties());
    }

    public void PrintProperties() {
        TreeMap<Object, Object> sortedSystemProperties = new TreeMap<Object, Object>(this);
        Set keySet = sortedSystemProperties.keySet();
        for (String propertyName : keySet) {
            String propertyValue = this.getProperty(propertyName);
            System.out.println(propertyName + ": " + propertyValue);
        }
    }
}

