/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class OKW_GetJavaClass {
    static ArrayList<String> getClasses(String fpsPackage) {
        ArrayList<String> lvAsReturn = new ArrayList<String>();
        try {
            ArrayList<String> lvClassPathes = OKW_GetJavaClass.getClassPaths(fpsPackage);
            for (String lvClassPath : lvClassPathes) {
                File file = new File(lvClassPath);
                if (!file.exists()) continue;
                if (lvClassPath.endsWith("jar")) {
                    lvAsReturn.addAll(OKW_GetJavaClass.getClassesFromDirectory(lvClassPath, fpsPackage));
                    continue;
                }
                if (!Files.isDirectory(Paths.get(lvClassPath, new String[0]), LinkOption.NOFOLLOW_LINKS)) continue;
                lvAsReturn.addAll(OKW_GetJavaClass.getClassesFromDirectory(lvClassPath, fpsPackage));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lvAsReturn;
    }

    public static ArrayList<String> getClassPaths(String packageName) throws IOException {
        ArrayList<String> ReturnList = new ArrayList<String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String replacedURL = resource.getPath();
            System.out.println(">>" + replacedURL + "<<");
            ReturnList.add(replacedURL);
        }
        return ReturnList;
    }

    private static ArrayList<String> getClassesFromDirectory(String fpsdirectory, String packageName) {
        File[] files;
        ArrayList<String> classes = new ArrayList<String>();
        File directory = new File(fpsdirectory);
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(OKW_GetJavaClass.getClassesFromDirectory(file.getPath(), packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            System.out.println(">>Class: " + file.getName());
            classes.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getClassesFromJar(String jarPath, String packageName) {
        JarFile jarFile = null;
        ArrayList<String> lvAL_Return = new ArrayList<String>();
        try {
            jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String entryName = entry.getName();
                packageName = packageName.replace(".", "/");
                if (entryName == null || !entryName.endsWith(".class") || !entryName.startsWith(packageName)) continue;
                try {
                    Class<?> entryClass = Class.forName(entryName.substring(0, entryName.length() - 6).replace("/", "."));
                    if (entryClass == null) continue;
                    lvAL_Return.add(entryClass.getName());
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return lvAL_Return;
    }
}

