/*
 * Decompiled with CFR 0.152.
 */
package okw;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.EnumSet;

public class Copy {
    static boolean okayToOverwrite(Path file) {
        String answer = System.console().readLine("overwrite %s (yes/no)? ", file);
        return answer.equalsIgnoreCase("y") || answer.equalsIgnoreCase("yes");
    }

    static void copyFile(Path source, Path target, boolean prompt, boolean preserve) {
        CopyOption[] copyOptionArray;
        if (preserve) {
            CopyOption[] copyOptionArray2 = new CopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
        }
        CopyOption[] options = copyOptionArray;
        if (!prompt || Files.notExists(target, new LinkOption[0]) || Copy.okayToOverwrite(target)) {
            try {
                Files.copy(source, target, options);
            }
            catch (IOException x) {
                System.err.format("Unable to copy: %s: %s%n", source, x);
            }
        }
    }

    static void usage() {
        System.err.println("java Copy [-ip] source... target");
        System.err.println("java Copy -r [-ip] source-dir... target");
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        String arg;
        int argi;
        boolean recursive = false;
        boolean prompt = false;
        boolean preserve = false;
        for (argi = 0; argi < args.length && (arg = args[argi]).startsWith("-"); ++argi) {
            if (arg.length() < 2) {
                Copy.usage();
            }
            block6: for (int i = 1; i < arg.length(); ++i) {
                char c = arg.charAt(i);
                switch (c) {
                    case 'r': {
                        recursive = true;
                        continue block6;
                    }
                    case 'i': {
                        prompt = true;
                        continue block6;
                    }
                    case 'p': {
                        preserve = true;
                        continue block6;
                    }
                    default: {
                        Copy.usage();
                    }
                }
            }
        }
        int remaining = args.length - argi;
        if (remaining < 2) {
            Copy.usage();
        }
        Path[] source = new Path[remaining - 1];
        int i = 0;
        while (remaining > 1) {
            source[i++] = Paths.get(args[argi++], new String[0]);
            --remaining;
        }
        Path target = Paths.get(args[argi], new String[0]);
        boolean isDir = Files.isDirectory(target, new LinkOption[0]);
        for (i = 0; i < source.length; ++i) {
            Path dest;
            Path path = dest = isDir ? target.resolve(source[i].getFileName()) : target;
            if (recursive) {
                EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
                TreeCopier tc = new TreeCopier(source[i], dest, prompt, preserve);
                Files.walkFileTree(source[i], opts, Integer.MAX_VALUE, tc);
                continue;
            }
            if (Files.isDirectory(source[i], new LinkOption[0])) {
                System.err.format("%s: is a directory%n", source[i]);
                continue;
            }
            Copy.copyFile(source[i], dest, prompt, preserve);
        }
    }

    static class TreeCopier
    implements FileVisitor<Path> {
        private final Path source;
        private final Path target;
        private final boolean prompt;
        private final boolean preserve;

        TreeCopier(Path source, Path target, boolean prompt, boolean preserve) {
            this.source = source;
            this.target = target;
            this.prompt = prompt;
            this.preserve = preserve;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            CopyOption[] copyOptionArray;
            if (this.preserve) {
                CopyOption[] copyOptionArray2 = new CopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            } else {
                copyOptionArray = new CopyOption[]{};
            }
            CopyOption[] options = copyOptionArray;
            Path newdir = this.target.resolve(this.source.relativize(dir));
            try {
                Files.copy(dir, newdir, options);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException x) {
                System.err.format("Unable to create: %s: %s%n", newdir, x);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Copy.copyFile(file, this.target.resolve(this.source.relativize(file)), this.prompt, this.preserve);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (exc == null && this.preserve) {
                Path newdir = this.target.resolve(this.source.relativize(dir));
                try {
                    FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                    Files.setLastModifiedTime(newdir, time);
                }
                catch (IOException x) {
                    System.err.format("Unable to copy all attributes to: %s: %s%n", newdir, x);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            if (exc instanceof FileSystemLoopException) {
                System.err.println("cycle detected: " + file);
            } else {
                System.err.format("Unable to copy: %s: %s%n", file, exc);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

