/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.support.tools;

import java.io.File;
import java.io.Serializable;
import org.opalj.br.ClassFile;
import org.opalj.br.ClassHierarchy;
import org.opalj.br.ClassHierarchy$;
import org.opalj.br.ObjectType;
import org.opalj.br.ObjectType$;
import org.opalj.br.reader.Java8Framework$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class ClassHierarchyExtractor$ {
    public static ClassHierarchyExtractor$ MODULE$;

    static {
        new ClassHierarchyExtractor$();
    }

    public String deriveSpecification(Traversable<ObjectType> types, ClassHierarchy classHierarchy) {
        Traversable specLines = (Traversable)types.map((Function1 & Serializable & scala.Serializable)aType -> {
            void var2_2;
            block1: {
                String specLine = new StringBuilder(0).append(classHierarchy.isInterface(aType).isYes() ? "interface " : "class ").append(aType.fqn()).toString();
                Option superclassType = classHierarchy.superclassType(aType);
                if (!superclassType.isDefined()) break block1;
                specLine = new StringBuilder(9).append(specLine).append(" extends ").append(((ObjectType)superclassType.get()).fqn()).toString();
                Option superinterfaceTypes = classHierarchy.superinterfaceTypes(aType);
                if (superinterfaceTypes.isDefined() && ((TraversableOnce)superinterfaceTypes.get()).nonEmpty()) {
                    specLine = new StringBuilder(0).append(specLine).append(((TraversableOnce)((SetLike)superinterfaceTypes.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.fqn(), Set$.MODULE$.canBuildFrom())).mkString(" implements ", ", ", "")).toString();
                }
            }
            return var2_2;
        }, Traversable$.MODULE$.canBuildFrom());
        return specLines.mkString("\n");
    }

    public void main(String[] args) {
        ClassHierarchy classHierarchy;
        if (args.length < 3 || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(2))).forall((Function1 & Serializable & scala.Serializable)arg -> BoxesRunTime.boxToBoolean((boolean)ClassHierarchyExtractor$.$anonfun$main$1(arg)))) {
            Predef$.MODULE$.println((Object)"Usage:     java \u2026ClassHierarchy supertype filterprefix <JAR|JMOD file>+");
            Predef$.MODULE$.println((Object)"Example:   \u2026 java.lang.Enum \"\" .../rt.jar");
            Predef$.MODULE$.println((Object)"           lists all subclasses of java.lang.Enum in rt.jar; \"\" effectively disables the filter.");
            throw package$.MODULE$.exit(-1);
        }
        String supertypeName = args[0].replace('.', '/');
        String filterPrefix = args[1].replace('.', '/');
        List classFiles2 = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(classFiles, filename) -> (List)classFiles.$plus$plus((GenTraversableOnce)Java8Framework$.MODULE$.ClassFiles(new File((String)filename), Java8Framework$.MODULE$.ClassFiles$default$2()).iterator().map((Function1 & Serializable & scala.Serializable)x$2 -> (ClassFile)x$2._1()), List$.MODULE$.canBuildFrom()));
        if (classFiles2.forall((Function1 & Serializable & scala.Serializable)cf -> BoxesRunTime.boxToBoolean((boolean)ClassHierarchyExtractor$.$anonfun$main$4(cf)))) {
            Predef$.MODULE$.println((Object)"the class files do not contain java.lang.Object; adding default type hierarchy");
            classHierarchy = ClassHierarchy$.MODULE$.apply((Traversable)classFiles2, ClassHierarchy$.MODULE$.apply$default$2(), (LogContext)GlobalLogContext$.MODULE$);
        } else {
            classHierarchy = ClassHierarchy$.MODULE$.apply((Traversable)classFiles2, (Seq)Nil$.MODULE$, (LogContext)GlobalLogContext$.MODULE$);
        }
        ClassHierarchy classHierarchy2 = classHierarchy;
        ObjectType supertype = ObjectType$.MODULE$.apply(supertypeName);
        if (classHierarchy2.isUnknown(supertype)) {
            Console$.MODULE$.err().println(new StringBuilder(50).append("The type: ").append(supertypeName).append(" is not defined in the specified jar(s).").toString());
            throw package$.MODULE$.exit(-2);
        }
        Predef$.MODULE$.println((Object)new StringBuilder(65).append("# Class hierarchy for: ").append(supertypeName).append(" limited to subclasses that start with: ").append("\"").append(filterPrefix).append("\"").toString());
        Set allRelevantSubtypes = (Set)classHierarchy2.allSubtypes(supertype, true).filter((Function1 & Serializable & scala.Serializable)candidateType -> BoxesRunTime.boxToBoolean((boolean)ClassHierarchyExtractor$.$anonfun$main$5(filterPrefix, candidateType)));
        String spec = this.deriveSpecification((Traversable<ObjectType>)allRelevantSubtypes, classHierarchy2);
        Predef$.MODULE$.println((Object)spec);
    }

    public static final /* synthetic */ boolean $anonfun$main$1(String arg) {
        return arg.endsWith(".jar") || arg.endsWith(".jmod");
    }

    public static final /* synthetic */ boolean $anonfun$main$4(ClassFile cf) {
        ObjectType objectType = cf.thisType();
        ObjectType objectType2 = ObjectType$.MODULE$.Object();
        return objectType == null ? objectType2 != null : !objectType.equals(objectType2);
    }

    public static final /* synthetic */ boolean $anonfun$main$5(String filterPrefix$1, ObjectType candidateType) {
        return candidateType.fqn().startsWith(filterPrefix$1);
    }

    private ClassHierarchyExtractor$() {
        MODULE$ = this;
    }
}

