/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.support.info;

import java.io.Serializable;
import java.net.URL;
import org.opalj.br.ObjectType;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectAnalysisApplication;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.br.fpcf.PropertyStoreKey$;
import org.opalj.br.fpcf.analyses.EagerClassImmutabilityAnalysis$;
import org.opalj.br.fpcf.analyses.EagerL0FieldMutabilityAnalysis$;
import org.opalj.br.fpcf.analyses.EagerTypeImmutabilityAnalysis$;
import org.opalj.br.fpcf.properties.ClassImmutability;
import org.opalj.br.fpcf.properties.ClassImmutability$;
import org.opalj.br.fpcf.properties.TypeImmutability;
import org.opalj.br.fpcf.properties.TypeImmutability$;
import org.opalj.fpcf.EPS;
import org.opalj.fpcf.PropertyStore;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import org.opalj.util.Seconds$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public final class ImmutabilityAnalysis$
extends ProjectAnalysisApplication {
    public static ImmutabilityAnalysis$ MODULE$;

    static {
        new ImmutabilityAnalysis$();
    }

    public String title() {
        return "Immutability Analysis";
    }

    public String description() {
        return "determines the immutability of classes and types";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        DoubleRef t = DoubleRef.create((double)Seconds$.MODULE$.None());
        PropertyStore ps = (PropertyStore)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            PropertyStore ps = (PropertyStore)project.get((ProjectInformationKey)PropertyStoreKey$.MODULE$);
            Set derivedPKs = (Set)Predef$.MODULE$.Set().empty().$plus$plus((GenTraversableOnce)EagerL0FieldMutabilityAnalysis$.MODULE$.derives().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.pk())).$plus$plus((GenTraversableOnce)EagerClassImmutabilityAnalysis$.MODULE$.derives().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.pk())).$plus$plus((GenTraversableOnce)EagerTypeImmutabilityAnalysis$.MODULE$.derives().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.pk()));
            ps.setupPhase(derivedPKs, ps.setupPhase$default$2(), ps.setupPhase$default$3(), ps.setupPhase$default$4());
            EagerL0FieldMutabilityAnalysis$.MODULE$.start(project, ps, null);
            EagerClassImmutabilityAnalysis$.MODULE$.start(project, ps, null);
            EagerTypeImmutabilityAnalysis$.MODULE$.start(project, ps, null);
            ps.waitOnPhaseCompletion();
            return var1_1;
        }, (Function1 & Serializable & scala.Serializable)r -> {
            t.elem = Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)r).timeSpan());
            return BoxedUnit.UNIT;
        });
        Map immutableClasses = (Map)((TraversableLike)ps.entities(ClassImmutability$.MODULE$.key()).toSeq().filter((Function1 & Serializable & scala.Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysis$.$anonfun$doAnalyze$6(project, ep)))).groupBy((Function1 & Serializable & scala.Serializable)x$4 -> (ClassImmutability)x$4.ub()).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), ((TraversableOnce)kv._2()).toList().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysis$.$anonfun$doAnalyze$9(a, b)))), Map$.MODULE$.canBuildFrom());
        String immutableClassesPerCategory = ((TraversableOnce)((TraversableOnce)immutableClasses.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(4).append("\t\t").append(kv._1()).append(": ").append(((SeqLike)kv._2()).size()).toString(), Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
        Map immutableTypes = (Map)((TraversableLike)ps.entities(TypeImmutability$.MODULE$.key()).toSeq().filter((Function1 & Serializable & scala.Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysis$.$anonfun$doAnalyze$11(project, ep)))).groupBy((Function1 & Serializable & scala.Serializable)x$5 -> (TypeImmutability)x$5.ub()).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), (Object)BoxesRunTime.boxToInteger((int)((SeqLike)kv._2()).size())), Map$.MODULE$.canBuildFrom());
        String immutableTypesPerCategory = ((TraversableOnce)((TraversableOnce)immutableTypes.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(4).append("\t\t").append(kv._1()).append(": ").append(kv._2$mcI$sp()).toString(), Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
        String immutableClassesInfo = ((TraversableOnce)((TraversableLike)((TraversableLike)immutableClasses.values().flatten((Function1)Predef$.MODULE$.$conforms())).filter((Function1 & Serializable & scala.Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysis$.$anonfun$doAnalyze$15(project, ep)))).map((Function1 & Serializable & scala.Serializable)ep -> new StringBuilder(8).append(((ObjectType)ep.e()).toJava()).append(" => ").append(ep.ub()).append(" => ").append(ps.apply(ep.e(), TypeImmutability$.MODULE$.key()).ub()).toString(), scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("\tImmutability:\n\t\t", "\n\t\t", "\n");
        return new BasicReport(new StringBuilder(126).append("\nImmutability Information:\n").append(immutableClassesInfo).append("\nSummary (w.r.t classes):\n").append("\tObject Immutability:\n").append(immutableClassesPerCategory).append("\n").append("\tType Immutability:\n").append(immutableTypesPerCategory).append("\n").append("\n").append(ps.toString(false)).append("\n").append("The overall analysis took: ").append(new Seconds(t.elem)).toString());
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$6(Project project$1, EPS ep) {
        return project$1.classHierarchy().isInterface((ObjectType)ep.e()).isNo();
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$9(EPS a, EPS b) {
        ObjectType cfA = (ObjectType)a.e();
        ObjectType cfB = (ObjectType)b.e();
        return new StringOps(Predef$.MODULE$.augmentString(cfA.toJava())).$less((Object)cfB.toJava());
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$11(Project project$1, EPS ep) {
        return project$1.classHierarchy().isInterface((ObjectType)ep.e()).isNo();
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$15(Project project$1, EPS ep) {
        return project$1.classHierarchy().isInterface((ObjectType)ep.e()).isNo();
    }

    private ImmutabilityAnalysis$() {
        MODULE$ = this;
    }
}

