/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.support.info;

import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opalj.br.analyses.AnalysisApplication;
import org.opalj.br.analyses.BasicReport$;
import org.opalj.br.analyses.MethodInfo;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectAnalysisApplication;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.br.analyses.ReportableAnalysisResult;
import org.opalj.log.GlobalLogContext$;
import org.opalj.tac.AITACode;
import org.opalj.tac.Call;
import org.opalj.tac.DUVar;
import org.opalj.tac.Expr;
import org.opalj.tac.LazyDetachedTACAIKey$;
import org.opalj.tac.Stmt;
import org.opalj.value.ValueInformation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClassUsageAnalysis$
extends ProjectAnalysisApplication {
    public static ClassUsageAnalysis$ MODULE$;
    private final GlobalLogContext$ logContext;

    static {
        new ClassUsageAnalysis$();
    }

    public GlobalLogContext$ logContext() {
        return this.logContext;
    }

    public String title() {
        return "Class Usage Analysis";
    }

    public String description() {
        return "Analyzes a project for how a particular class is used within it, i.e., which methods of instances of that class are called";
    }

    /*
     * WARNING - void declaration
     */
    private String assembleMethodDescriptor(Call<DUVar<ValueInformation>> call, boolean isFineGrainedAnalysis) {
        String string;
        String fqMethodName = new StringBuilder(1).append(call.declaringClass().toJava()).append("#").append(call.name()).toString();
        if (isFineGrainedAnalysis) {
            String methodDescriptor = call.descriptor().toString();
            string = new StringBuilder(2).append(fqMethodName).append(": ").append(methodDescriptor).toString();
        } else {
            void var3_3;
            string = var3_3;
        }
        return string;
    }

    private void processCall(Call<DUVar<ValueInformation>> call, ConcurrentHashMap<String, AtomicInteger> map, String className, boolean isFineGrainedAnalysis) {
        block0: {
            String methodDescriptor;
            String declaringClassName;
            String string = declaringClassName = call.declaringClass().toJava();
            String string2 = className;
            if ((string != null ? !string.equals(string2) : string2 != null) || map.putIfAbsent(methodDescriptor = this.assembleMethodDescriptor(call, isFineGrainedAnalysis), new AtomicInteger(1)) == null) break block0;
            map.get(methodDescriptor).addAndGet(1);
        }
    }

    public String analysisSpecificParametersDescription() {
        return "-class=<fully-qualified class name> \n[-granularity=<fine|coarse> (Default: coarse)]";
    }

    private final String parameterNameForClass() {
        return "-class=";
    }

    private final String parameterNameForGranularity() {
        return "-granularity=";
    }

    public Traversable<String> checkAnalysisSpecificParameters(Seq<String> parameters) {
        Seq remainingParameters = (Seq)parameters.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ClassUsageAnalysis$.$anonfun$checkAnalysisSpecificParameters$1(p)));
        return AnalysisApplication.checkAnalysisSpecificParameters$((AnalysisApplication)this, (Seq)remainingParameters);
    }

    private Tuple2<String, Object> getAnalysisParameters(Seq<String> parameters) {
        boolean bl;
        Option classParam = parameters.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-class=")));
        if (!classParam.isDefined()) {
            throw new IllegalArgumentException("missing argument: -class");
        }
        String className = ((String)classParam.get()).substring(((String)classParam.get()).indexOf("=") + 1);
        Option granularityParam = parameters.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith("-granularity=")));
        if (granularityParam.isDefined()) {
            boolean bl2;
            String string = ((String)granularityParam.get()).substring(((String)granularityParam.get()).indexOf("=") + 1);
            if ("fine".equals(string)) {
                bl2 = true;
            } else if ("coarse".equals(string)) {
                bl2 = false;
            } else {
                String msg = "incorrect argument: -granularity must be one of fine|coarse";
                throw new IllegalArgumentException(msg);
            }
            bl = bl2;
        } else {
            bl = false;
        }
        boolean isFineGrainedAnalysis = bl;
        return new Tuple2((Object)className, (Object)BoxesRunTime.boxToBoolean((boolean)isFineGrainedAnalysis));
    }

    public ReportableAnalysisResult doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        Tuple2<String, Object> tuple2 = this.getAnalysisParameters(parameters);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String className = (String)tuple2._1();
        boolean isFineGrainedAnalysis = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)className, (Object)BoxesRunTime.boxToBoolean((boolean)isFineGrainedAnalysis));
        Tuple2 tuple23 = tuple22;
        String className2 = (String)tuple23._1();
        boolean isFineGrainedAnalysis2 = tuple23._2$mcZ$sp();
        ConcurrentHashMap resultMap = new ConcurrentHashMap();
        Function1 tacProvider = (Function1)project.get((ProjectInformationKey)LazyDetachedTACAIKey$.MODULE$);
        project.parForeachMethodWithBody(project.parForeachMethodWithBody$default$1(), project.parForeachMethodWithBody$default$2(), (Function1 & Serializable & scala.Serializable)methodInfo -> {
            ClassUsageAnalysis$.$anonfun$doAnalyze$1(tacProvider, resultMap, className2, isFineGrainedAnalysis2, methodInfo);
            return BoxedUnit.UNIT;
        });
        ListBuffer report = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Result:"}));
        resultMap.entrySet().stream().sorted((value1, value2) -> Predef$.MODULE$.int2Integer(((AtomicInteger)value1.getValue()).get()).compareTo(Predef$.MODULE$.int2Integer(((AtomicInteger)value2.getValue()).get()))).forEach(next -> report.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(2).append(next.getKey()).append(": ").append(next.getValue()).toString()})));
        return BasicReport$.MODULE$.apply((Iterable)report);
    }

    public static final /* synthetic */ boolean $anonfun$checkAnalysisSpecificParameters$1(String p) {
        return !p.contains("-class=") && !p.contains("-granularity=");
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$2(ConcurrentHashMap resultMap$1, String className$1, boolean isFineGrainedAnalysis$1, Stmt stmt) {
        int n = stmt.astID();
        switch (n) {
            case 5: 
            case 19: {
                Expr expr = stmt.asAssignmentLike().expr();
                if (expr instanceof Call) {
                    Expr expr2 = expr;
                    MODULE$.processCall((Call<DUVar<ValueInformation>>)((Call)expr2), resultMap$1, className$1, isFineGrainedAnalysis$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                MODULE$.processCall((Call<DUVar<ValueInformation>>)stmt.asMethodCall(), resultMap$1, className$1, isFineGrainedAnalysis$1);
                break;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$1(Function1 tacProvider$1, ConcurrentHashMap resultMap$1, String className$1, boolean isFineGrainedAnalysis$1, MethodInfo methodInfo) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((AITACode)tacProvider$1.apply((Object)methodInfo.method())).stmts())).foreach((Function1 & Serializable & scala.Serializable)stmt -> {
            ClassUsageAnalysis$.$anonfun$doAnalyze$2(resultMap$1, className$1, isFineGrainedAnalysis$1, stmt);
            return BoxedUnit.UNIT;
        });
    }

    private ClassUsageAnalysis$() {
        MODULE$ = this;
        this.logContext = GlobalLogContext$.MODULE$;
    }
}

