/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.support.info;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Calendar;
import org.opalj.ai.fpcf.properties.AIDomainFactoryKey$;
import org.opalj.br.DeclaredMethod;
import org.opalj.br.DefinedMethod;
import org.opalj.br.Field;
import org.opalj.br.VirtualDeclaredMethod;
import org.opalj.br.analyses.AnalysisApplication;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DeclaredMethods;
import org.opalj.br.analyses.DeclaredMethodsKey$;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.Project$;
import org.opalj.br.analyses.ProjectAnalysisApplication;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.br.analyses.VirtualFormalParameter;
import org.opalj.br.fpcf.PropertyStoreKey$;
import org.opalj.br.fpcf.properties.cg.Callees;
import org.opalj.br.fpcf.properties.cg.Callees$;
import org.opalj.br.fpcf.properties.cg.Callers;
import org.opalj.br.fpcf.properties.cg.Callers$;
import org.opalj.br.fpcf.properties.pointsto.AllocationSitePointsToSet$;
import org.opalj.br.fpcf.properties.pointsto.PointsToSetLike;
import org.opalj.collection.LongSet;
import org.opalj.fpcf.EPS;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.par.PKECPropertyStore$;
import org.opalj.fpcf.seq.PKESequentialPropertyStore;
import org.opalj.fpcf.seq.PKESequentialPropertyStore$;
import org.opalj.log.LogContext;
import org.opalj.tac.cg.AllocationSiteBasedPointsToCallGraphKey$;
import org.opalj.tac.cg.CHACallGraphKey$;
import org.opalj.tac.cg.CTACallGraphKey$;
import org.opalj.tac.cg.CallGraph;
import org.opalj.tac.cg.CallGraphSerializer$;
import org.opalj.tac.cg.FTACallGraphKey$;
import org.opalj.tac.cg.MTACallGraphKey$;
import org.opalj.tac.cg.RTACallGraphKey$;
import org.opalj.tac.cg.TypeBasedPointsToCallGraphKey$;
import org.opalj.tac.cg.XTACallGraphKey$;
import org.opalj.tac.common.DefinitionSite;
import org.opalj.tac.fpcf.analyses.pointsto.ArrayEntity;
import org.opalj.tac.fpcf.analyses.pointsto.CallExceptions;
import org.opalj.tac.fpcf.analyses.pointsto.MethodExceptions;
import org.opalj.tac.fpcf.analyses.pointsto.TamiFlexKey$;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

public final class CallGraph$
extends ProjectAnalysisApplication {
    public static CallGraph$ MODULE$;
    private final Regex algorithmRegex;

    static {
        new CallGraph$();
    }

    public String title() {
        return "Call Graph Analysis";
    }

    public String description() {
        return "Provides the number of reachable methods and call edges in the give project.";
    }

    public String analysisSpecificParametersDescription() {
        return "[-algorithm=CHA|RTA|MTA|FTA|CTA|XTA|TypeBasedPointsTo|PointsTo][-domain=domain][-callers=method][-callees=method][-writeCG=file][-analysisName=name][-schedulingStrategy=name][-writeOutput=file][-j=<number of threads>][-main=package.MainClass][-tamiflex-log=logfile][-finalizerAnalysis=<yes|no|default>][-loadedClassesAnalysis=<yes|no|default>][-staticInitializerAnalysis=<yes|no|default>][-reflectionAnalysis=<yes|no|default>][-serializationAnalysis=<yes|no|default>][-threadRelatedCallsAnalysis=<yes|no|default>][-configuredNativeMethodsAnalysis=<yes|no|default>]";
    }

    private Regex algorithmRegex() {
        return this.algorithmRegex;
    }

    public Traversable<String> checkAnalysisSpecificParameters(Seq<String> parameters) {
        Seq remainingParameters = (Seq)parameters.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)CallGraph$.$anonfun$checkAnalysisSpecificParameters$1(p)));
        return AnalysisApplication.checkAnalysisSpecificParameters$((AnalysisApplication)this, (Seq)remainingParameters);
    }

    private BasicReport performAnalysis(Project<URL> project, List<String> calleesSigs, List<String> callersSigs, Option<String> analysisName, String cgAlgorithm, Option<String> cgFile, Option<String> outputFile, Option<Object> numThreads, double projectTime) {
        project.getOrCreateProjectInformationKeyInitializationData((ProjectInformationKey)PropertyStoreKey$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> (Function1 & Serializable & scala.Serializable)context -> {
            PKESequentialPropertyStore pKESequentialPropertyStore;
            LogContext lg = project.logContext();
            int threads = BoxesRunTime.unboxToInt((Object)numThreads.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            if (threads == 0) {
                pKESequentialPropertyStore = PKESequentialPropertyStore$.MODULE$.apply((Seq)context, lg);
            } else {
                PKECPropertyStore$.MODULE$.MaxThreads_$eq(threads);
                pKESequentialPropertyStore = PKECPropertyStore$.MODULE$.apply((Seq)context, lg);
            }
            return pKESequentialPropertyStore;
        });
        DeclaredMethods declaredMethods = (DeclaredMethods)project.get((ProjectInformationKey)DeclaredMethodsKey$.MODULE$);
        Traversable allMethods = declaredMethods.declaredMethods().filter((Function1 & Serializable & scala.Serializable)dm -> BoxesRunTime.boxToBoolean((boolean)CallGraph$.$anonfun$performAnalysis$4(dm))).toTraversable();
        DoubleRef propertyStoreTime = DoubleRef.create((double)Seconds$.MODULE$.None());
        DoubleRef callGraphTime = DoubleRef.create((double)Seconds$.MODULE$.None());
        PropertyStore ps = (PropertyStore)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> (PropertyStore)project.get((ProjectInformationKey)PropertyStoreKey$.MODULE$), (Function1 & Serializable & scala.Serializable)t -> {
            propertyStoreTime.elem = Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)t).timeSpan());
            return BoxedUnit.UNIT;
        });
        CallGraph cg = (CallGraph)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> {
            CallGraph callGraph;
            String string = cgAlgorithm;
            if ("CHA".equals(string)) {
                callGraph = (CallGraph)project.get((ProjectInformationKey)CHACallGraphKey$.MODULE$);
            } else if ("RTA".equals(string)) {
                callGraph = (CallGraph)project.get((ProjectInformationKey)RTACallGraphKey$.MODULE$);
            } else if ("MTA".equals(string)) {
                callGraph = (CallGraph)project.get((ProjectInformationKey)MTACallGraphKey$.MODULE$);
            } else if ("FTA".equals(string)) {
                callGraph = (CallGraph)project.get((ProjectInformationKey)FTACallGraphKey$.MODULE$);
            } else if ("CTA".equals(string)) {
                callGraph = (CallGraph)project.get((ProjectInformationKey)CTACallGraphKey$.MODULE$);
            } else if ("XTA".equals(string)) {
                callGraph = (CallGraph)project.get((ProjectInformationKey)XTACallGraphKey$.MODULE$);
            } else if ("TypeBasedPointsTo".equals(string)) {
                callGraph = (CallGraph)project.get((ProjectInformationKey)TypeBasedPointsToCallGraphKey$.MODULE$);
            } else if ("PointsTo".equals(string)) {
                callGraph = (CallGraph)project.get((ProjectInformationKey)AllocationSiteBasedPointsToCallGraphKey$.MODULE$);
            } else {
                throw new MatchError((Object)string);
            }
            return callGraph;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            callGraphTime.elem = Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)t).timeSpan());
            return BoxedUnit.UNIT;
        });
        try {
            ps.shutdown();
        }
        catch (Throwable t2) {
            Console$.MODULE$.err().println("PropertyStore shutdown failed: ");
            t2.printStackTrace();
        }
        String string = cgAlgorithm;
        String string2 = "PointsTo";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            List ptss = ps.entities(AllocationSitePointsToSet$.MODULE$.key()).toList();
            Predef$.MODULE$.println((Object)new StringBuilder(5).append("PTSs ").append(ptss.size()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(12).append("PTS entries ").append(((TraversableOnce)ptss.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)CallGraph$.$anonfun$performAnalysis$9(p)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)).toString());
            scala.collection.immutable.Map byType = ptss.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.e().getClass());
            Predef$.MODULE$.println((Object)new StringBuilder(14).append("DefSite PTSs: ").append(CallGraph$.getNum$1(DefinitionSite.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(16).append("Parameter PTSs: ").append(CallGraph$.getNum$1(VirtualFormalParameter.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Instance Field PTSs: ").append(CallGraph$.getNum$1(Tuple2.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(19).append("Static Field PTSs: ").append(CallGraph$.getNum$1(Field.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(12).append("Array PTSs: ").append(CallGraph$.getNum$1(ArrayEntity.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(13).append("Return PTSs: ").append(CallGraph$.getNum$1(DefinedMethod.class, byType) + CallGraph$.getNum$1(VirtualDeclaredMethod.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(22).append("MethodException PTSs: ").append(CallGraph$.getNum$1(MethodExceptions.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("CallException PTSs: ").append(CallGraph$.getNum$1(CallExceptions.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("DefSite PTS entries: ").append(CallGraph$.getEntries$1(DefinitionSite.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(23).append("Parameter PTS entries: ").append(CallGraph$.getEntries$1(VirtualFormalParameter.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(28).append("Instance Field PTS entries: ").append(CallGraph$.getEntries$1(Tuple2.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(26).append("Static Field PTS entries: ").append(CallGraph$.getEntries$1(Field.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(19).append("Array PTS entries: ").append(CallGraph$.getEntries$1(ArrayEntity.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("Return PTS entries: ").append(CallGraph$.getEntries$1(DefinedMethod.class, byType) + CallGraph$.getEntries$1(VirtualDeclaredMethod.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(29).append("MethodException PTS entries: ").append(CallGraph$.getEntries$1(MethodExceptions.class, byType)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(27).append("CallException PTS entries: ").append(CallGraph$.getEntries$1(CallExceptions.class, byType)).toString());
        }
        Traversable reachableMethods = cg.reachableMethods().toTraversable();
        int numEdges = cg.numEdges();
        Predef$.MODULE$.println((Object)ps.statistics().mkString("\n"));
        Predef$.MODULE$.println((Object)calleesSigs.mkString("\n"));
        Predef$.MODULE$.println((Object)callersSigs.mkString("\n"));
        allMethods.foreach((Function1 & Serializable & scala.Serializable)m -> {
            CallGraph$.$anonfun$performAnalysis$16(calleesSigs, ps, declaredMethods, callersSigs, m);
            return BoxedUnit.UNIT;
        });
        if (cgFile.nonEmpty()) {
            CallGraphSerializer$.MODULE$.writeCG(cg, new File((String)cgFile.get()), declaredMethods);
        }
        if (outputFile.isDefined()) {
            File output = new File((String)outputFile.get());
            boolean newOutputFile = !output.exists();
            try (PrintWriter outputWriter = new PrintWriter(new FileOutputStream(output, true));){
                if (newOutputFile) {
                    output.createNewFile();
                    outputWriter.println("analysisName;project time;propertyStore time;callGraph time;total time;methods;reachable;edges");
                }
                double totalTime = Seconds$.MODULE$.$plus$extension(Seconds$.MODULE$.$plus$extension(projectTime, propertyStoreTime.elem), callGraphTime.elem);
                outputWriter.println(new StringBuilder(7).append(analysisName.get()).append(";").append(Seconds$.MODULE$.toString$extension0(projectTime, false)).append(";").append(Seconds$.MODULE$.toString$extension0(propertyStoreTime.elem, false)).append(";").append(Seconds$.MODULE$.toString$extension0(callGraphTime.elem, false)).append(";").append(Seconds$.MODULE$.toString$extension0(totalTime, false)).append(";").append(allMethods.size()).append(";").append(reachableMethods.size()).append(";").append(numEdges).toString());
            }
        }
        String message = new StringBuilder(110).append("|# of methods: ").append(allMethods.size()).append("\n                |# of reachable methods: ").append(reachableMethods.size()).append("\n                |# of call edges: ").append(numEdges).append("\n                |").toString();
        return new BasicReport(new StringOps(Predef$.MODULE$.augmentString(message)).stripMargin('|'));
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        Project newProject;
        DoubleRef projectTime;
        ObjectRef numThreads;
        ObjectRef outputFile;
        ObjectRef cgFile;
        ObjectRef analysisName;
        ObjectRef cgAlgorithm;
        ObjectRef callersSigs;
        ObjectRef calleesSigs;
        block3: {
            ObjectRef tacDomain = ObjectRef.create((Object)None$.MODULE$);
            calleesSigs = ObjectRef.create((Object)Nil$.MODULE$);
            callersSigs = ObjectRef.create((Object)Nil$.MODULE$);
            cgAlgorithm = ObjectRef.create((Object)"RTA");
            analysisName = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef schedulingStrategy = ObjectRef.create((Object)None$.MODULE$);
            cgFile = ObjectRef.create((Object)None$.MODULE$);
            outputFile = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef mainClass = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef tamiflexLog = ObjectRef.create((Object)None$.MODULE$);
            numThreads = ObjectRef.create((Object)None$.MODULE$);
            Regex domainRegex = new StringOps(Predef$.MODULE$.augmentString("-domain=(.*)")).r();
            Regex callersRegex = new StringOps(Predef$.MODULE$.augmentString("-callers=(.*)")).r();
            Regex calleesRegex = new StringOps(Predef$.MODULE$.augmentString("-callees=(.*)")).r();
            Regex analysisNameRegex = new StringOps(Predef$.MODULE$.augmentString("-analysisName=(.*)")).r();
            Regex schedulingStrategyRegex = new StringOps(Predef$.MODULE$.augmentString("-schedulingStrategy=(.*)")).r();
            Regex writeCGRegex = new StringOps(Predef$.MODULE$.augmentString("-writeCG=(.*)")).r();
            Regex writeOutputRegex = new StringOps(Predef$.MODULE$.augmentString("-writeOutput=(.*)")).r();
            Regex numThreadsRegex = new StringOps(Predef$.MODULE$.augmentString("-j=(.*)")).r();
            Regex mainClassRegex = new StringOps(Predef$.MODULE$.augmentString("-main=(.*)")).r();
            Regex tamiflexLogRegex = new StringOps(Predef$.MODULE$.augmentString("-tamiflex-log=(.*)")).r();
            Regex finalizerAnalysisRegex = new StringOps(Predef$.MODULE$.augmentString("-finalizerAnalysis=(.*)")).r();
            Regex loadedClassesAnalysisRegex = new StringOps(Predef$.MODULE$.augmentString("-loadedClassesAnalysis=(.*)")).r();
            Regex staticInitializerAnalysisRegex = new StringOps(Predef$.MODULE$.augmentString("-staticInitializerAnalysis=(.*)")).r();
            Regex reflectionAnalysisRegex = new StringOps(Predef$.MODULE$.augmentString("-reflectionAnalysis=(.*)")).r();
            Regex serializationAnalysisRegex = new StringOps(Predef$.MODULE$.augmentString("-serializationAnalysis=(.*)")).r();
            Regex threadRelatedCallsAnalysisRegex = new StringOps(Predef$.MODULE$.augmentString("-threadRelatedCallsAnalysis=(.*)")).r();
            Regex configuredNativeMethodsAnalysisRegex = new StringOps(Predef$.MODULE$.augmentString("-configuredNativeMethodsAnalysis=(.*)")).r();
            ObjectRef newConfig = ObjectRef.create((Object)project.config());
            ObjectRef modules = ObjectRef.create((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((Config)newConfig.elem).getStringList("org.opalj.tac.cg.CallGraphKey.modules")).asScala()).toSet());
            parameters.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                CallGraph$.$anonfun$doAnalyze$1(domainRegex, tacDomain, callersRegex, callersSigs, calleesRegex, calleesSigs, cgAlgorithm, analysisNameRegex, analysisName, schedulingStrategyRegex, schedulingStrategy, numThreadsRegex, numThreads, writeCGRegex, cgFile, writeOutputRegex, outputFile, mainClassRegex, mainClass, tamiflexLogRegex, tamiflexLog, finalizerAnalysisRegex, loadedClassesAnalysisRegex, staticInitializerAnalysisRegex, reflectionAnalysisRegex, serializationAnalysisRegex, threadRelatedCallsAnalysisRegex, configuredNativeMethodsAnalysisRegex, modules, x0$1);
                return BoxedUnit.UNIT;
            });
            if (((Option)tamiflexLog.elem).isDefined()) {
                newConfig.elem = ((Config)newConfig.elem).withValue(TamiFlexKey$.MODULE$.configKey(), ConfigValueFactory.fromAnyRef((Object)((Option)tamiflexLog.elem).get()));
                modules.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)modules.elem).$plus((Object)"org.opalj.tac.fpcf.analyses.cg.reflection.TamiFlexCallGraphAnalysisScheduler");
            }
            if (((Option)schedulingStrategy.elem).isDefined()) {
                newConfig.elem = ((Config)newConfig.elem).withValue("org.opalj.fpcf.seq.PKESequentialPropertyStore.TasksManager", ConfigValueFactory.fromAnyRef((Object)((Option)schedulingStrategy.elem).get()));
            }
            if (((Option)mainClass.elem).isDefined()) {
                String key = new StringBuilder(58).append("org.opalj.br.analyses.cg.InitialEntryPointsKey.").append("entryPoints").toString();
                java.util.List currentValues = ((Config)newConfig.elem).getList(key).unwrapped();
                java.util.Map configValue = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"declaringClass"), (Object)((String)((Option)mainClass.elem).get()).replace('.', '/')), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"main")}))).asJava();
                currentValues.add(ConfigValueFactory.fromMap((java.util.Map)configValue));
                newConfig.elem = ((Config)newConfig.elem).withValue(key, (ConfigValue)ConfigValueFactory.fromIterable((Iterable)currentValues));
                newConfig.elem = ((Config)newConfig.elem).withValue(new StringBuilder(55).append("org.opalj.br.analyses.cg.InitialEntryPointsKey.").append("analysis").toString(), ConfigValueFactory.fromAnyRef((Object)"org.opalj.br.analyses.cg.ConfigurationEntryPointsFinder"));
            }
            newConfig.elem = ((Config)newConfig.elem).withValue("org.opalj.tac.cg.CallGraphKey.modules", (ConfigValue)ConfigValueFactory.fromIterable((Iterable)((Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)modules.elem)).asJava())));
            projectTime = DoubleRef.create((double)Seconds$.MODULE$.None());
            newProject = (Project)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> Project$.MODULE$.recreate(project, (Config)newConfig$1.elem, Project$.MODULE$.recreate$default$3()), (Function1 & Serializable & scala.Serializable)t -> {
                projectTime.elem = Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)t).timeSpan());
                return BoxedUnit.UNIT;
            });
            String domainFQN = (String)((Option)tacDomain.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.opalj.ai.domain.l0.PrimitiveTACAIDomain");
            Class<?> domain = Class.forName(domainFQN);
            newProject.updateProjectInformationKeyInitializationData((ProjectInformationKey)AIDomainFactoryKey$.MODULE$, (Function1 & Serializable & scala.Serializable)x0$2 -> {
                scala.collection.immutable.Set set;
                Option option = x0$2;
                if (None$.MODULE$.equals(option)) {
                    set = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{domain}));
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    scala.collection.immutable.Set requirements = (scala.collection.immutable.Set)some.value();
                    set = (scala.collection.immutable.Set)requirements.$plus((Object)domain);
                } else {
                    throw new MatchError((Object)option);
                }
                return set;
            });
            if (!((Option)analysisName.elem).isEmpty()) break block3;
            analysisName.elem = new Some((Object)new StringBuilder(4).append("RUN-").append(Calendar.getInstance().getTime().toString()).toString());
        }
        return this.performAnalysis((Project<URL>)newProject, (List<String>)((List)calleesSigs.elem), (List<String>)((List)callersSigs.elem), (Option<String>)((Option)analysisName.elem), (String)cgAlgorithm.elem, (Option<String>)((Option)cgFile.elem), (Option<String>)((Option)outputFile.elem), (Option<Object>)((Option)numThreads.elem), projectTime.elem);
    }

    public static final /* synthetic */ boolean $anonfun$checkAnalysisSpecificParameters$1(String p) {
        return !p.matches(MODULE$.algorithmRegex().regex()) && !p.startsWith("-domain=") && !p.startsWith("-callers=") && !p.startsWith("-callees=") && !p.startsWith("-analysisName=") && !p.startsWith("-schedulingStrategy=") && !p.startsWith("-writeCG=") && !p.startsWith("-writeOutput=") && !p.startsWith("-main=") && !p.startsWith("-j=") && !p.startsWith("-tamiflex-log=") && !p.startsWith("-finalizerAnalysis=") && !p.startsWith("-loadedClassesAnalysis=") && !p.startsWith("-staticInitializerAnalysis=") && !p.startsWith("-reflectionAnalysis=") && !p.startsWith("-serializationAnalysis=") && !p.startsWith("-threadRelatedCallsAnalysis=") && !p.startsWith("-configuredNativeMethodsAnalysis=");
    }

    public static final /* synthetic */ boolean $anonfun$performAnalysis$4(DeclaredMethod dm) {
        return dm.hasSingleDefinedMethod() && dm.definedMethod().classFile().thisType() == dm.declaringClassType();
    }

    public static final /* synthetic */ int $anonfun$performAnalysis$9(EPS p) {
        return ((LongSet)((PointsToSetLike)p.ub()).elements()).size();
    }

    private static final int getNum$1(Class tpe, scala.collection.immutable.Map byType$1) {
        return BoxesRunTime.unboxToInt((Object)byType$1.get((Object)tpe).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ int $anonfun$performAnalysis$14(EPS x$4) {
        return ((PointsToSetLike)x$4.ub()).numElements();
    }

    public static final /* synthetic */ int $anonfun$performAnalysis$13(List x$3) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$3.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)CallGraph$.$anonfun$performAnalysis$14(x$4)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private static final int getEntries$1(Class tpe, scala.collection.immutable.Map byType$1) {
        return BoxesRunTime.unboxToInt((Object)byType$1.get((Object)tpe).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)CallGraph$.$anonfun$performAnalysis$13(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ void $anonfun$performAnalysis$17(String mSig$1, DeclaredMethod m$1, PropertyStore ps$1, DeclaredMethods declaredMethods$1, String methodSignature) {
        block0: {
            if (!mSig$1.contains(methodSignature)) break block0;
            Predef$.MODULE$.println((Object)new StringBuilder(12).append("Callees of ").append(m$1.toJava()).append(":").toString());
            Predef$.MODULE$.println((Object)((TraversableOnce)((Callees)ps$1.apply((Object)m$1, Callees$.MODULE$.key()).ub()).callSites(ps$1, declaredMethods$1).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int pc = tuple2._1$mcI$sp();
                Iterator callees = (Iterator)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pc)), (Object)callees.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toJava()).mkString(", "));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).mkString("\t", "\n\t", "\n"));
        }
    }

    public static final /* synthetic */ void $anonfun$performAnalysis$20(String mSig$1, DeclaredMethod m$1, PropertyStore ps$1, DeclaredMethods declaredMethods$1, String methodSignature) {
        block0: {
            if (!mSig$1.contains(methodSignature)) break block0;
            Predef$.MODULE$.println((Object)new StringBuilder(12).append("Callers of ").append(m$1.toJava()).append(":").toString());
            Predef$.MODULE$.println((Object)TraversableOnce$.MODULE$.MonadOps(((Callers)ps$1.apply((Object)m$1, Callers$.MODULE$.key()).ub()).callers(declaredMethods$1)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                DeclaredMethod caller = (DeclaredMethod)tuple3._1();
                int pc = BoxesRunTime.unboxToInt((Object)tuple3._2());
                boolean isDirect = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                String string = new StringBuilder(2).append(caller.toJava()).append(", ").append(pc).append((Object)(!isDirect ? ", indirect" : "")).toString();
                return string;
            }).mkString("\t", "\n\t", "\n"));
        }
    }

    public static final /* synthetic */ void $anonfun$performAnalysis$16(List calleesSigs$1, PropertyStore ps$1, DeclaredMethods declaredMethods$1, List callersSigs$1, DeclaredMethod m) {
        String mSig = m.descriptor().toJava(m.name());
        calleesSigs$1.foreach((Function1 & Serializable & scala.Serializable)methodSignature -> {
            CallGraph$.$anonfun$performAnalysis$17(mSig, m, ps$1, declaredMethods$1, methodSignature);
            return BoxedUnit.UNIT;
        });
        callersSigs$1.foreach((Function1 & Serializable & scala.Serializable)methodSignature -> {
            CallGraph$.$anonfun$performAnalysis$20(mSig, m, ps$1, declaredMethods$1, methodSignature);
            return BoxedUnit.UNIT;
        });
    }

    private static final void analyisOption$1(String option, String analysis, ObjectRef modules$1) {
        String string = option;
        if ("yes".equals(string)) {
            modules$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)modules$1.elem).$plus((Object)new StringBuilder(40).append("org.opalj.tac.fpcf.analyses.cg.").append(analysis).append("Scheduler").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("no".equals(string)) {
            modules$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)modules$1.elem).$minus((Object)new StringBuilder(40).append("org.opalj.tac.fpcf.analyses.cg.").append(analysis).append("Scheduler").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("default".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(18).append("illegal value for ").append(analysis).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$1(Regex domainRegex$1, ObjectRef tacDomain$1, Regex callersRegex$1, ObjectRef callersSigs$2, Regex calleesRegex$1, ObjectRef calleesSigs$2, ObjectRef cgAlgorithm$2, Regex analysisNameRegex$1, ObjectRef analysisName$1, Regex schedulingStrategyRegex$1, ObjectRef schedulingStrategy$1, Regex numThreadsRegex$1, ObjectRef numThreads$2, Regex writeCGRegex$1, ObjectRef cgFile$1, Regex writeOutputRegex$1, ObjectRef outputFile$1, Regex mainClassRegex$1, ObjectRef mainClass$1, Regex tamiflexLogRegex$1, ObjectRef tamiflexLog$1, Regex finalizerAnalysisRegex$1, Regex loadedClassesAnalysisRegex$1, Regex staticInitializerAnalysisRegex$1, Regex reflectionAnalysisRegex$1, Regex serializationAnalysisRegex$1, Regex threadRelatedCallsAnalysisRegex$1, Regex configuredNativeMethodsAnalysisRegex$1, ObjectRef modules$1, String x0$1) {
        String string = x0$1;
        Option option = domainRegex$1.unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String domainClass = (String)((LinearSeqOptimized)option.get()).apply(0);
            if (!((Option)tacDomain$1.elem).isEmpty()) {
                throw new IllegalArgumentException("-domain was set twice");
            }
            tacDomain$1.elem = new Some((Object)domainClass);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Option option2 = callersRegex$1.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String methodSig = (String)((LinearSeqOptimized)option2.get()).apply(0);
                callersSigs$2.elem = ((List)callersSigs$2.elem).$colon$colon((Object)methodSig);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Option option3 = calleesRegex$1.unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
                    String methodSig = (String)((LinearSeqOptimized)option3.get()).apply(0);
                    calleesSigs$2.elem = ((List)calleesSigs$2.elem).$colon$colon((Object)methodSig);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Option option4 = MODULE$.algorithmRegex().unapplySeq((CharSequence)string);
                    if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0) {
                        String algo = (String)((LinearSeqOptimized)option4.get()).apply(0);
                        cgAlgorithm$2.elem = algo;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Option option5 = analysisNameRegex$1.unapplySeq((CharSequence)string);
                        if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(1) == 0) {
                            String name = (String)((LinearSeqOptimized)option5.get()).apply(0);
                            if (!((Option)analysisName$1.elem).isEmpty()) {
                                throw new IllegalArgumentException("-analysisName was set twice");
                            }
                            analysisName$1.elem = new Some((Object)name);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Option option6 = schedulingStrategyRegex$1.unapplySeq((CharSequence)string);
                            if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(1) == 0) {
                                String name = (String)((LinearSeqOptimized)option6.get()).apply(0);
                                if (!((Option)schedulingStrategy$1.elem).isEmpty()) {
                                    throw new IllegalArgumentException("-schedulingStrategy was set twice");
                                }
                                schedulingStrategy$1.elem = new Some((Object)name);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                Option option7 = numThreadsRegex$1.unapplySeq((CharSequence)string);
                                if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(1) == 0) {
                                    String threads = (String)((LinearSeqOptimized)option7.get()).apply(0);
                                    if (!((Option)numThreads$2.elem).isEmpty()) {
                                        throw new IllegalArgumentException("-j was set twice");
                                    }
                                    numThreads$2.elem = new Some((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(threads)));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    Option option8 = writeCGRegex$1.unapplySeq((CharSequence)string);
                                    if (!option8.isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(1) == 0) {
                                        String fileName = (String)((LinearSeqOptimized)option8.get()).apply(0);
                                        if (!((Option)cgFile$1.elem).isEmpty()) {
                                            throw new IllegalArgumentException("-writeCG was set twice");
                                        }
                                        cgFile$1.elem = new Some((Object)fileName);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        Option option9 = writeOutputRegex$1.unapplySeq((CharSequence)string);
                                        if (!option9.isEmpty() && option9.get() != null && ((LinearSeqOptimized)option9.get()).lengthCompare(1) == 0) {
                                            String fileName = (String)((LinearSeqOptimized)option9.get()).apply(0);
                                            if (!((Option)outputFile$1.elem).isEmpty()) {
                                                throw new IllegalArgumentException("-writeOutput was set twice");
                                            }
                                            outputFile$1.elem = new Some((Object)fileName);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            Option option10 = mainClassRegex$1.unapplySeq((CharSequence)string);
                                            if (!option10.isEmpty() && option10.get() != null && ((LinearSeqOptimized)option10.get()).lengthCompare(1) == 0) {
                                                String fileName = (String)((LinearSeqOptimized)option10.get()).apply(0);
                                                if (!((Option)mainClass$1.elem).isEmpty()) {
                                                    throw new IllegalArgumentException("-main was set twice");
                                                }
                                                mainClass$1.elem = new Some((Object)fileName);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                Option option11 = tamiflexLogRegex$1.unapplySeq((CharSequence)string);
                                                if (!option11.isEmpty() && option11.get() != null && ((LinearSeqOptimized)option11.get()).lengthCompare(1) == 0) {
                                                    String fileName = (String)((LinearSeqOptimized)option11.get()).apply(0);
                                                    if (!((Option)tamiflexLog$1.elem).isEmpty()) {
                                                        throw new IllegalArgumentException("-tamiflex-log was set twice");
                                                    }
                                                    tamiflexLog$1.elem = new Some((Object)fileName);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    Option option12 = finalizerAnalysisRegex$1.unapplySeq((CharSequence)string);
                                                    if (!option12.isEmpty() && option12.get() != null && ((LinearSeqOptimized)option12.get()).lengthCompare(1) == 0) {
                                                        String option13 = (String)((LinearSeqOptimized)option12.get()).apply(0);
                                                        CallGraph$.analyisOption$1(option13, "FinalizerAnalysis", modules$1);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        Option option14 = loadedClassesAnalysisRegex$1.unapplySeq((CharSequence)string);
                                                        if (!option14.isEmpty() && option14.get() != null && ((LinearSeqOptimized)option14.get()).lengthCompare(1) == 0) {
                                                            String option15 = (String)((LinearSeqOptimized)option14.get()).apply(0);
                                                            CallGraph$.analyisOption$1(option15, "LoadedClassesAnalysis", modules$1);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        } else {
                                                            Option option16 = staticInitializerAnalysisRegex$1.unapplySeq((CharSequence)string);
                                                            if (!option16.isEmpty() && option16.get() != null && ((LinearSeqOptimized)option16.get()).lengthCompare(1) == 0) {
                                                                String option17 = (String)((LinearSeqOptimized)option16.get()).apply(0);
                                                                CallGraph$.analyisOption$1(option17, "StaticInitializerAnalysis", modules$1);
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            } else {
                                                                Option option18 = reflectionAnalysisRegex$1.unapplySeq((CharSequence)string);
                                                                if (!option18.isEmpty() && option18.get() != null && ((LinearSeqOptimized)option18.get()).lengthCompare(1) == 0) {
                                                                    String option19 = (String)((LinearSeqOptimized)option18.get()).apply(0);
                                                                    CallGraph$.analyisOption$1(option19, "reflection.ReflectionRelatedCallsAnalysis", modules$1);
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                } else {
                                                                    Option option20 = serializationAnalysisRegex$1.unapplySeq((CharSequence)string);
                                                                    if (!option20.isEmpty() && option20.get() != null && ((LinearSeqOptimized)option20.get()).lengthCompare(1) == 0) {
                                                                        String option21 = (String)((LinearSeqOptimized)option20.get()).apply(0);
                                                                        CallGraph$.analyisOption$1(option21, "SerializationRelatedCallsAnalysis", modules$1);
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    } else {
                                                                        Option option22 = threadRelatedCallsAnalysisRegex$1.unapplySeq((CharSequence)string);
                                                                        if (!option22.isEmpty() && option22.get() != null && ((LinearSeqOptimized)option22.get()).lengthCompare(1) == 0) {
                                                                            String option23 = (String)((LinearSeqOptimized)option22.get()).apply(0);
                                                                            CallGraph$.analyisOption$1(option23, "ThreadRelatedCallsAnalysis", modules$1);
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        } else {
                                                                            Option option24 = configuredNativeMethodsAnalysisRegex$1.unapplySeq((CharSequence)string);
                                                                            if (!option24.isEmpty() && option24.get() != null && ((LinearSeqOptimized)option24.get()).lengthCompare(1) == 0) {
                                                                                String option25 = (String)((LinearSeqOptimized)option24.get()).apply(0);
                                                                                CallGraph$.analyisOption$1(option25, "ConfiguredNativeMethodsCallGraphAnalysis", modules$1);
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            } else {
                                                                                throw new MatchError((Object)string);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private CallGraph$() {
        MODULE$ = this;
        this.algorithmRegex = new StringOps(Predef$.MODULE$.augmentString("-algorithm=(CHA|RTA|MTA|FTA|CTA|XTA|TypeBasedPointsTo|PointsTo)")).r();
    }
}

