/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.opalj.fpcf.EOptionP;
import org.opalj.fpcf.FallbackReason;
import org.opalj.fpcf.Property;
import org.opalj.fpcf.PropertyKey;
import org.opalj.fpcf.PropertyKind;
import org.opalj.fpcf.PropertyStore;
import scala.Function3;

public final class PropertyKey$ {
    public static final PropertyKey$ MODULE$ = new PropertyKey$();
    private static final int[] propertyKeys = (int[])new PropertyKey[72];
    private static final String[] propertyKeyNames = new String[72];
    private static final Function3<PropertyStore, FallbackReason, Object, Property>[] fallbackPropertyComputations = new Function3[72];
    private static final AtomicInteger lastKeyId = new AtomicInteger(-1);

    private int nextKeyId() {
        int nextKeyId = lastKeyId.incrementAndGet();
        if (nextKeyId >= 72) {
            throw new IllegalStateException(new StringBuilder(101).append("maximum number of property keys (").append(72).append(") ").append("exceeded; increase PropertyKind.SupportedPropertyKinds").toString());
        }
        return nextKeyId;
    }

    private void setKeyName(int keyId, String name) {
        PropertyKey$.propertyKeyNames[keyId] = name;
        for (int i = 0; i < keyId; ++i) {
            String string = propertyKeyNames[i];
            String string2 = name;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            throw new IllegalArgumentException(new StringBuilder(34).append("the property name ").append(name).append(" is already used").toString());
        }
    }

    public <E, P extends Property> int create(String name, Function3<PropertyStore, FallbackReason, E, P> fallbackPropertyComputation) {
        int thisKeyId = this.nextKeyId();
        this.setKeyName(thisKeyId, name);
        PropertyKey$.fallbackPropertyComputations[thisKeyId] = fallbackPropertyComputation;
        int pk = thisKeyId;
        PropertyKey$.propertyKeys[thisKeyId] = (int)new PropertyKey(pk);
        return pk;
    }

    public <E, P extends Property> int create(String name) {
        return this.create(name, (P)null);
    }

    public <E, P extends Property> int create(String name, P fallbackProperty) {
        Function3 & Serializable fpc = (Function3 & Serializable)(x$1, x$2, x$3) -> fallbackProperty;
        return this.create(name, (P)fpc);
    }

    public int key(int id) {
        return propertyKeys[id].id();
    }

    public String name(int id) {
        return propertyKeyNames[id];
    }

    public final String name(PropertyKind pKind) {
        return this.name(pKind.id());
    }

    public final String name(EOptionP<?, ? extends Property> eOptionP) {
        return this.name(eOptionP.pk());
    }

    public final boolean hasFallback(PropertyKind propertyKind) {
        return this.hasFallbackBasedOnPKId(propertyKind.id());
    }

    public final boolean hasFallbackBasedOnPKId(int pkId) {
        return fallbackPropertyComputations[pkId] != null;
    }

    public <P extends Property> P fallbackProperty(PropertyStore ps, FallbackReason fr, Object e, int pk) {
        return (P)this.fallbackPropertyBasedOnPKId(ps, fr, e, pk);
    }

    public Property fallbackPropertyBasedOnPKId(PropertyStore ps, FallbackReason fr, Object e, int pkId) {
        Function3<PropertyStore, FallbackReason, Object, Property> fallbackComputation = fallbackPropertyComputations[pkId];
        if (fallbackComputation == null) {
            throw new IllegalArgumentException(new StringBuilder(32).append("no fallback computation exists: ").append(this.name(pkId)).toString());
        }
        return (Property)fallbackComputation.apply((Object)ps, (Object)fr, e);
    }

    public int maxId() {
        return lastKeyId.get();
    }

    public final <P> String toString$extension(int $this) {
        return new StringBuilder(8).append("PK(").append(this.name($this)).append(",id=").append($this).append(")").toString();
    }

    public final <P> int hashCode$extension(int $this) {
        return Integer.hashCode($this);
    }

    public final <P> boolean equals$extension(int $this, Object x$1) {
        int n;
        Object object = x$1;
        return object instanceof PropertyKey && $this == (n = ((PropertyKey)x$1).id());
    }

    private PropertyKey$() {
    }
}

