/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf;

import java.io.Serializable;
import org.opalj.collection.immutable.IntTrieSet;
import org.opalj.fpcf.AnalysisScenario$;
import org.opalj.fpcf.ComputationSpecification;
import org.opalj.fpcf.ComputationType;
import org.opalj.fpcf.EagerComputation$;
import org.opalj.fpcf.LazyComputation$;
import org.opalj.fpcf.PhaseConfiguration;
import org.opalj.fpcf.PropertyBounds;
import org.opalj.fpcf.PropertyKey$;
import org.opalj.fpcf.PropertyKind;
import org.opalj.fpcf.PropertyKindsConfiguration;
import org.opalj.fpcf.PropertyKindsConfiguration$;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.Schedule;
import org.opalj.fpcf.SpecificationViolation;
import org.opalj.fpcf.Transformer$;
import org.opalj.fpcf.TriggeredComputation$;
import org.opalj.graphs.Graph;
import org.opalj.graphs.Graph$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001\u0002\u000f\u001e\u0001\u0011B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\te\u0001\u0011\t\u0011)A\u0005]!)1\u0007\u0001C\u0001i!1!\t\u0001Q!\n\rCaA\u0012\u0001!B\u00139\u0005BB+\u0001A\u0003&a\u000b\u0003\u0004[\u0001\u0001\u0006KA\u0016\u0005\u00077\u0002\u0001\u000b\u0015\u0002,\t\rq\u0003\u0001\u0015)\u0003W\u0011\u0019i\u0006\u0001)Q\u0005=\"1\u0011\r\u0001Q!\nYCaA\u0019\u0001!B\u00139\u0005BB2\u0001A\u0003&q\t\u0003\u0004e\u0001\u0001\u0006Ka\u0012\u0005\u0007K\u0002\u0001\u000b\u0015B$\t\r\u0019\u0004\u0001\u0015)\u0003h\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015)\b\u0001\"\u0001w\u0011\u0015i\b\u0001\"\u0001\u007f\u0011!\t\t\u0001\u0001Q\u0005\n\u0005\r\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003[\u0001A\u0011BA\u0018\u000f\u001d\tI$\bE\u0001\u0003w1a\u0001H\u000f\t\u0002\u0005u\u0002BB\u001a\u001a\t\u0003\ty\u0004C\u0004\u0002Be!\t!a\u0011\u0003!\u0005s\u0017\r\\=tSN\u001c6-\u001a8be&|'B\u0001\u0010 \u0003\u00111\u0007o\u00194\u000b\u0005\u0001\n\u0013!B8qC2T'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005\u0015B4C\u0001\u0001'!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fM\u0006\u0011\u0001o]\u000b\u0002]A\u0011q\u0006M\u0007\u0002;%\u0011\u0011'\b\u0002\u000e!J|\u0007/\u001a:usN#xN]3\u0002\u0007A\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003k\u0005\u00032a\f\u00017!\t9\u0004\b\u0004\u0001\u0005\u000be\u0002!\u0019\u0001\u001e\u0003\u0003\u0005\u000b\"a\u000f \u0011\u0005\u001db\u0014BA\u001f)\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aJ \n\u0005\u0001C#aA!os\")Af\u0001a\u0001]\u0005\u00012o\u00195fIVdWmQ8naV$X\r\u001a\t\u0003O\u0011K!!\u0012\u0015\u0003\u000f\t{w\u000e\\3b]\u0006)\u0011\r\u001c7D'B\u0019\u0001j\u0014*\u000f\u0005%k\u0005C\u0001&)\u001b\u0005Y%B\u0001'$\u0003\u0019a$o\\8u}%\u0011a\nK\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&aA*fi*\u0011a\n\u000b\t\u0004_M3\u0014B\u0001+\u001e\u0005a\u0019u.\u001c9vi\u0006$\u0018n\u001c8Ta\u0016\u001c\u0017NZ5dCRLwN\\\u0001\u0012I\u0016\u0014\u0018N^3e!J|\u0007/\u001a:uS\u0016\u001c\bc\u0001%P/B\u0011q\u0006W\u0005\u00033v\u0011a\u0002\u0015:pa\u0016\u0014H/\u001f\"pk:$7/\u0001\rfC\u001e,'\u000f\\=EKJLg/\u001a3Qe>\u0004XM\u001d;jKN\f\u0001eY8mY\u0006\u0014wN]1uSZ,G.\u001f#fe&4X\r\u001a)s_B,'\u000f^5fg\u00069B.\u0019>jYf$UM]5wK\u0012\u0004&o\u001c9feRLWm]\u0001\u0013S:LG/[1mSj\fG/[8o\t\u0006$\u0018\r\u0005\u0003I?Js\u0014B\u00011R\u0005\ri\u0015\r]\u0001\u000fkN,G\r\u0015:pa\u0016\u0014H/[3t\u0003\u001d)\u0017mZ3s\u0007N\u000ba\u0001\\1{s\u000e\u001b\u0016a\u0003;sS\u001e<WM]3e\u0007N\u000ba\u0002\u001e:b]N4wN]7feN\u001c5+A\u0005eKJLg/\u001a3CsB!\u0001j\u00185l!\ty\u0013.\u0003\u0002k;\ta\u0001K]8qKJ$\u0018pS5oIB!q\u0005\\,H\u0013\ti\u0007F\u0001\u0004UkBdWMM\u0001\u000eC2d\u0007K]8qKJ$\u0018.Z:\u0016\u0003Y\u000b\u0001\u0002\n9mkN$S-\u001d\u000b\u0003eNl\u0011\u0001\u0001\u0005\u0006iJ\u0001\rAU\u0001\u0003GN\f\u0001\u0005\u001d:pa\u0016\u0014H/_\"p[B,H/\u0019;j_:\u001cH)\u001a9f]\u0012,gnY5fgV\tq\u000fE\u0002yw^k\u0011!\u001f\u0006\u0003u~\taa\u001a:ba\"\u001c\u0018B\u0001?z\u0005\u00159%/\u00199i\u0003]\u0019w.\u001c9vi\u0006$\u0018n\u001c8EKB,g\u000eZ3oG&,7/F\u0001\u0000!\rA8PU\u0001\naJ|7-Z:t\u0007N#B!!\u0002\u0002\fA\u0019q%a\u0002\n\u0007\u0005%\u0001F\u0001\u0003V]&$\b\"\u0002;\u0016\u0001\u0004\u0011\u0016aD2p[B,H/Z*dQ\u0016$W\u000f\\3\u0015\t\u0005E\u0011\u0011\u0006\u000b\u0005\u0003'\tI\u0002\u0005\u00030\u0003+1\u0014bAA\f;\tA1k\u00195fIVdW\rC\u0004\u0002\u001cY\u0001\u001d!!\b\u0002\u00151|wmQ8oi\u0016DH\u000f\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019cH\u0001\u0004Y><\u0017\u0002BA\u0014\u0003C\u0011!\u0002T8h\u0007>tG/\u001a=u\u0011\u0019\tYC\u0006a\u0001]\u0005i\u0001O]8qKJ$\u0018p\u0015;pe\u0016\fAbY8naV$X\r\u00155bg\u0016$B!!\r\u00028A!q&a\r7\u0013\r\t)$\b\u0002\u0013!\"\f7/Z\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0004\u0002,]\u0001\rAL\u0001\u0011\u0003:\fG._:jgN\u001bWM\\1sS>\u0004\"aL\r\u0014\u0005e1CCAA\u001e\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\t)%a\u0013\u0015\r\u0005\u001d\u0013QJA3!\u0011y\u0003!!\u0013\u0011\u0007]\nY\u0005B\u0003:7\t\u0007!\bC\u0004\u0002Pm\u0001\r!!\u0015\u0002\u0011\u0005t\u0017\r\\=tKN\u0004b!a\u0015\u0002^\u0005\rd\u0002BA+\u00033r1ASA,\u0013\u0005I\u0013bAA.Q\u00059\u0001/Y2lC\u001e,\u0017\u0002BA0\u0003C\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u00037B\u0003\u0003B\u0018T\u0003\u0013Ba!a\u000b\u001c\u0001\u0004q\u0003")
public class AnalysisScenario<A> {
    private final PropertyStore ps;
    private boolean scheduleComputed;
    private Set<ComputationSpecification<A>> allCS;
    private Set<PropertyBounds> derivedProperties;
    private Set<PropertyBounds> eagerlyDerivedProperties;
    private Set<PropertyBounds> collaborativelyDerivedProperties;
    private Set<PropertyBounds> lazilyDerivedProperties;
    private Map<ComputationSpecification<A>, Object> initializationData;
    private Set<PropertyBounds> usedProperties;
    private Set<ComputationSpecification<A>> eagerCS;
    private Set<ComputationSpecification<A>> lazyCS;
    private Set<ComputationSpecification<A>> triggeredCS;
    private Set<ComputationSpecification<A>> transformersCS;
    private Map<PropertyKind, Tuple2<PropertyBounds, Set<ComputationSpecification<A>>>> derivedBy;

    public static <A> AnalysisScenario<A> apply(Iterable<ComputationSpecification<A>> analyses, PropertyStore propertyStore) {
        return AnalysisScenario$.MODULE$.apply(analyses, propertyStore);
    }

    public PropertyStore ps() {
        return this.ps;
    }

    public Set<PropertyBounds> allProperties() {
        return (Set)this.derivedProperties.$plus$plus(this.usedProperties);
    }

    public AnalysisScenario<A> $plus$eq(ComputationSpecification<A> cs) {
        if (this.scheduleComputed) {
            throw new IllegalStateException("process was already computed");
        }
        ComputationType computationType = cs.computationType();
        if (EagerComputation$.MODULE$.equals(computationType)) {
            this.eagerCS = (Set)this.eagerCS.$plus(cs);
        } else if (TriggeredComputation$.MODULE$.equals(computationType)) {
            this.triggeredCS = (Set)this.triggeredCS.$plus(cs);
        } else if (LazyComputation$.MODULE$.equals(computationType)) {
            this.lazyCS = (Set)this.lazyCS.$plus(cs);
        } else if (Transformer$.MODULE$.equals(computationType)) {
            this.transformersCS = (Set)this.transformersCS.$plus(cs);
        } else {
            throw new MatchError((Object)computationType);
        }
        this.allCS = (Set)this.allCS.$plus(cs);
        this.initializationData = (Map)this.initializationData.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(cs), cs.init(this.ps())));
        return this;
    }

    public Graph<PropertyBounds> propertyComputationsDependencies() {
        if (!this.scheduleComputed) {
            throw new IllegalStateException("initialization incomplete; schedule not computed");
        }
        Graph psDeps = Graph$.MODULE$.empty(ClassTag$.MODULE$.apply(PropertyBounds.class));
        this.allCS.foreach((Function1 & Serializable)cs -> {
            AnalysisScenario.$anonfun$propertyComputationsDependencies$1(this, psDeps, cs);
            return BoxedUnit.UNIT;
        });
        return psDeps;
    }

    public Graph<ComputationSpecification<A>> computationDependencies() {
        if (!this.scheduleComputed) {
            throw new IllegalStateException("initialization incomplete; schedule not computed");
        }
        Graph compDeps = Graph$.MODULE$.empty(ClassTag$.MODULE$.apply(ComputationSpecification.class));
        ObjectRef derivedBy = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        this.allCS.foreach((Function1 & Serializable)cs -> {
            AnalysisScenario.$anonfun$computationDependencies$1(derivedBy, cs);
            return BoxedUnit.UNIT;
        });
        Map derivedBy2 = (Map)derivedBy.elem;
        this.allCS.foreach((Function1 & Serializable)cs -> {
            AnalysisScenario.$anonfun$computationDependencies$4(this, compDeps, derivedBy2, cs);
            return BoxedUnit.UNIT;
        });
        derivedBy2.valuesIterator().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AnalysisScenario.$anonfun$computationDependencies$7(x$1))).foreach((Function1 & Serializable)css -> {
            ComputationSpecification headCS;
            Iterator cssIt = css.iterator();
            ComputationSpecification lastCS = headCS = (ComputationSpecification)cssIt.next();
            do {
                ComputationSpecification nextCS = (ComputationSpecification)cssIt.next();
                compDeps.addEdge(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)lastCS), (Object)nextCS));
                lastCS = nextCS;
            } while (cssIt.hasNext());
            return compDeps.addEdge(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)lastCS), (Object)headCS));
        });
        return compDeps;
    }

    private void processCS(ComputationSpecification<A> cs) {
        cs.derivesLazily().foreach((Function1 & Serializable)lazilyDerivedProperty -> {
            AnalysisScenario.$anonfun$processCS$1(this, cs, lazilyDerivedProperty);
            return BoxedUnit.UNIT;
        });
        cs.derivesCollaboratively().foreach((Function1 & Serializable)collaborativelyDerivedProperty -> {
            AnalysisScenario.$anonfun$processCS$2(this, cs, collaborativelyDerivedProperty);
            return BoxedUnit.UNIT;
        });
        cs.derivesEagerly().foreach((Function1 & Serializable)eagerlyDerivedProperty -> {
            AnalysisScenario.$anonfun$processCS$3(this, cs, eagerlyDerivedProperty);
            return BoxedUnit.UNIT;
        });
        this.usedProperties = (Set)this.usedProperties.$plus$plus(cs.uses(this.ps()));
        this.eagerlyDerivedProperties = (Set)this.eagerlyDerivedProperties.$plus$plus(cs.derivesEagerly());
        this.handleDerivedProperties$1(cs.derivesEagerly(), cs);
        this.collaborativelyDerivedProperties = (Set)this.collaborativelyDerivedProperties.$plus$plus(cs.derivesCollaboratively());
        this.handleDerivedProperties$1(cs.derivesCollaboratively(), cs);
        this.lazilyDerivedProperties = (Set)this.lazilyDerivedProperties.$plus$plus((IterableOnce)cs.derivesLazily().toList());
        this.handleDerivedProperties$1(Option$.MODULE$.option2Iterable(cs.derivesLazily()).toSet(), cs);
    }

    public Schedule<A> computeSchedule(PropertyStore propertyStore, LogContext logContext) {
        if (this.scheduleComputed) {
            throw new IllegalStateException("schedule already computed");
        }
        this.scheduleComputed = true;
        this.allCS.foreach((Function1 & Serializable)cs -> {
            this.processCS(cs);
            return BoxedUnit.UNIT;
        });
        IntTrieSet alreadyComputedPropertyKinds = propertyStore.alreadyComputedPropertyKindIds().toSet();
        this.allCS.foreach((Function1 & Serializable)cs -> {
            AnalysisScenario.$anonfun$computeSchedule$2(alreadyComputedPropertyKinds, cs);
            return BoxedUnit.UNIT;
        });
        Set underivedProperties = (Set)this.usedProperties.$minus$minus(this.derivedProperties);
        ((IterableOnceOps)underivedProperties.filterNot((Function1 & Serializable)underivedProperty -> BoxesRunTime.boxToBoolean((boolean)alreadyComputedPropertyKinds.contains(underivedProperty.pk().id())))).foreach((Function1 & Serializable)underivedProperty -> {
            AnalysisScenario.$anonfun$computeSchedule$5(logContext, underivedProperty);
            return BoxedUnit.UNIT;
        });
        return new Schedule<A>(this.allCS.isEmpty() ? package$.MODULE$.List().empty() : new .colon.colon(this.computePhase(propertyStore), (List)Nil$.MODULE$), this.initializationData);
    }

    private PhaseConfiguration<A> computePhase(PropertyStore propertyStore) {
        ObjectRef suppressInterimUpdates = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        this.transformersCS.foreach((Function1 & Serializable)cs -> {
            suppressInterimUpdates.elem = (Map)((Map)suppressInterimUpdates.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((PropertyBounds)cs.derivesLazily().get()).pk()), cs.uses(this.ps()).map((Function1 & Serializable)x$2 -> x$2.pk())));
            return BoxedUnit.UNIT;
        });
        Builder batchBuilder = package$.MODULE$.List().newBuilder();
        batchBuilder.$plus$plus$eq(this.lazyCS);
        batchBuilder.$plus$plus$eq(this.transformersCS);
        batchBuilder.$plus$plus$eq(this.triggeredCS);
        batchBuilder.$plus$plus$eq(this.eagerCS);
        Set x$1 = (Set)this.derivedProperties.map((Function1 & Serializable)x$3 -> x$3.pk());
        Map x$2 = (Map)suppressInterimUpdates.elem;
        Set<PropertyKind> x$32 = PropertyKindsConfiguration$.MODULE$.apply$default$2();
        List<List<PropertyKind>> x$4 = PropertyKindsConfiguration$.MODULE$.apply$default$4();
        PropertyKindsConfiguration phase1Configuration = new PropertyKindsConfiguration((Set<PropertyKind>)x$1, x$32, (Map<PropertyKind, Set<PropertyKind>>)x$2, x$4);
        return new PhaseConfiguration(phase1Configuration, (List)batchBuilder.result());
    }

    public static final /* synthetic */ void $anonfun$propertyComputationsDependencies$2(AnalysisScenario $this, Graph psDeps$1, ComputationSpecification cs$1, PropertyBounds derived) {
        psDeps$1.addVertice((Object)derived);
        cs$1.uses($this.ps()).foreach((Function1 & Serializable)use -> psDeps$1.addEdge((Object)derived, use));
    }

    public static final /* synthetic */ void $anonfun$propertyComputationsDependencies$1(AnalysisScenario $this, Graph psDeps$1, ComputationSpecification cs) {
        cs.derives().foreach((Function1 & Serializable)derived -> {
            AnalysisScenario.$anonfun$propertyComputationsDependencies$2($this, psDeps$1, cs, derived);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$computationDependencies$1(ObjectRef derivedBy$1, ComputationSpecification cs) {
        cs.derives().foreach((Function1 & Serializable)derives -> {
            derivedBy$1.elem = (Map)((Map)derivedBy$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)derives), (Object)((SetOps)((Map)derivedBy$1.elem).getOrElse((Object)derives, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).$plus((Object)cs)));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$computationDependencies$5(Map derivedBy$2, ComputationSpecification cs$3, Graph compDeps$1, PropertyBounds usedPK) {
        derivedBy$2.get((Object)usedPK).iterator().flatten(Predef$.MODULE$.$conforms()).foreach((Function1 & Serializable)providerCS -> {
            if (providerCS != cs$3) {
                return compDeps$1.addEdge((Object)cs$3, providerCS);
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$computationDependencies$4(AnalysisScenario $this, Graph compDeps$1, Map derivedBy$2, ComputationSpecification cs) {
        compDeps$1.addVertice((Object)cs);
        cs.uses($this.ps()).foreach((Function1 & Serializable)usedPK -> {
            AnalysisScenario.$anonfun$computationDependencies$5(derivedBy$2, cs, compDeps$1, usedPK);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$computationDependencies$7(Set x$1) {
        return x$1.size() > 1;
    }

    public static final /* synthetic */ void $anonfun$processCS$1(AnalysisScenario $this, ComputationSpecification cs$4, PropertyBounds lazilyDerivedProperty) {
        if ($this.derivedProperties.contains((Object)lazilyDerivedProperty)) {
            String pkName = PropertyKey$.MODULE$.name(lazilyDerivedProperty.pk().id());
            String m = new StringBuilder(59).append("can not register ").append(cs$4).append(": ").append(pkName).append(" is already computed by another analysis").toString();
            throw new SpecificationViolation(m);
        }
    }

    public static final /* synthetic */ void $anonfun$processCS$2(AnalysisScenario $this, ComputationSpecification cs$4, PropertyBounds collaborativelyDerivedProperty) {
        if ($this.eagerlyDerivedProperties.contains((Object)collaborativelyDerivedProperty) || $this.lazilyDerivedProperties.contains((Object)collaborativelyDerivedProperty)) {
            String pkName = PropertyKey$.MODULE$.name(collaborativelyDerivedProperty.pk().id());
            String m = new StringBuilder(67).append("can not register ").append(cs$4).append(": ").append(pkName).append(" is not computed collaboratively by all analyses").toString();
            throw new SpecificationViolation(m);
        }
    }

    public static final /* synthetic */ void $anonfun$processCS$3(AnalysisScenario $this, ComputationSpecification cs$4, PropertyBounds eagerlyDerivedProperty) {
        if ($this.derivedProperties.contains((Object)eagerlyDerivedProperty)) {
            String pkName = PropertyKey$.MODULE$.name(eagerlyDerivedProperty.pk().id());
            String m = new StringBuilder(59).append("can not register ").append(cs$4).append(": ").append(pkName).append(" is already computed by another analysis").toString();
            throw new SpecificationViolation(m);
        }
    }

    public static final /* synthetic */ void $anonfun$processCS$4(AnalysisScenario $this, ComputationSpecification cs$4, PropertyBounds derivedProperty) {
        Tuple2 tuple2;
        PropertyKind pk = derivedProperty.pk();
        boolean bl = false;
        Some some = null;
        Option option = $this.derivedBy.get((Object)pk);
        if (None$.MODULE$.equals(option)) {
            $this.derivedBy = (Map)$this.derivedBy.$plus(new Tuple2((Object)pk, (Object)new Tuple2((Object)derivedProperty, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ComputationSpecification[]{cs$4})))));
            return;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Tuple2 tuple22 = (Tuple2)some.value();
            if (tuple22 != null) {
                PropertyBounds propertyBounds = (PropertyBounds)tuple22._1();
                Set css = (Set)tuple22._2();
                PropertyBounds propertyBounds2 = derivedProperty;
                PropertyBounds propertyBounds3 = propertyBounds;
                if (!(propertyBounds2 != null ? !((Object)propertyBounds2).equals(propertyBounds3) : propertyBounds3 != null)) {
                    $this.derivedBy = (Map)$this.derivedBy.$plus(new Tuple2((Object)pk, (Object)new Tuple2((Object)derivedProperty, (Object)css.$plus((Object)cs$4))));
                    return;
                }
            }
        }
        if (bl && (tuple2 = (Tuple2)some.value()) != null) {
            PropertyBounds deviatingPropertyBounds = (PropertyBounds)tuple2._1();
            Set css = (Set)tuple2._2();
            String propertyName = PropertyKey$.MODULE$.name(pk);
            throw new IllegalArgumentException(new StringBuilder(89).append("different bounds (").append(deviatingPropertyBounds).append(" vs. ").append(derivedProperty).append(") ").append("are computed by ").append(css).append(" vs. ").append(cs$4).append(" ").append("for the collaboratively computed property ").append(propertyName).toString());
        }
        throw new MatchError((Object)option);
    }

    private final void handleDerivedProperties$1(Set derivedProperties, ComputationSpecification cs$4) {
        this.derivedProperties = (Set)this.derivedProperties.$plus$plus((IterableOnce)derivedProperties);
        derivedProperties.foreach((Function1 & Serializable)derivedProperty -> {
            AnalysisScenario.$anonfun$processCS$4(this, cs$4, derivedProperty);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$computeSchedule$3(IntTrieSet alreadyComputedPropertyKinds$1, ComputationSpecification cs$5, PropertyBounds derivedProperty) {
        if (alreadyComputedPropertyKinds$1.contains(derivedProperty.pk().id())) {
            String pkName = PropertyKey$.MODULE$.name(derivedProperty.pk().id());
            String m = new StringBuilder(52).append("can not register ").append(cs$5).append(": ").append(pkName).append(" was computed in a previous phase").toString();
            throw new SpecificationViolation(m);
        }
    }

    public static final /* synthetic */ void $anonfun$computeSchedule$2(IntTrieSet alreadyComputedPropertyKinds$1, ComputationSpecification cs) {
        cs.derives().foreach((Function1 & Serializable)derivedProperty -> {
            AnalysisScenario.$anonfun$computeSchedule$3(alreadyComputedPropertyKinds$1, cs, derivedProperty);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$computeSchedule$5(LogContext logContext$1, PropertyBounds underivedProperty) {
        String propertyName = PropertyKey$.MODULE$.name(underivedProperty.pk().id());
        if (PropertyKey$.MODULE$.hasFallback(underivedProperty.pk())) {
            String message = new StringBuilder(43).append("no analyses scheduled for: ").append(propertyName).append("; using fallback").toString();
            OPALLogger$.MODULE$.warn("analysis configuration", message, logContext$1);
            return;
        }
        throw new IllegalStateException(new StringBuilder(26).append("no analysis scheduled for ").append(propertyName).toString());
    }

    public AnalysisScenario(PropertyStore ps) {
        this.ps = ps;
        this.scheduleComputed = false;
        this.allCS = Predef$.MODULE$.Set().empty();
        this.derivedProperties = Predef$.MODULE$.Set().empty();
        this.eagerlyDerivedProperties = Predef$.MODULE$.Set().empty();
        this.collaborativelyDerivedProperties = Predef$.MODULE$.Set().empty();
        this.lazilyDerivedProperties = Predef$.MODULE$.Set().empty();
        this.initializationData = Predef$.MODULE$.Map().empty();
        this.usedProperties = Predef$.MODULE$.Set().empty();
        this.eagerCS = Predef$.MODULE$.Set().empty();
        this.lazyCS = Predef$.MODULE$.Set().empty();
        this.triggeredCS = Predef$.MODULE$.Set().empty();
        this.transformersCS = Predef$.MODULE$.Set().empty();
        this.derivedBy = Predef$.MODULE$.Map().empty();
    }
}

