/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.support.tools;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.opalj.ba.ToDAConfig;
import org.opalj.bc.Assembler$;
import org.opalj.br.ClassFile;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.Project$;
import org.opalj.io.package$;
import scala.Console$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class ProjectSerializer$ {
    public static ProjectSerializer$ MODULE$;

    static {
        new ProjectSerializer$();
    }

    private void showUsage(Option<String> error) {
        Predef$.MODULE$.println((Object)"OPAL - Project Serializer");
        Predef$.MODULE$.println((Object)"Writes out the project's rewritten and transformed class files.");
        Predef$.MODULE$.println((Object)"(No INVOKEDYNAMICS and optimized bytecode.)");
        error.foreach((Function1 & Serializable & scala.Serializable)e -> {
            ProjectSerializer$.$anonfun$showUsage$1(e);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"Parameters:");
        Predef$.MODULE$.println((Object)"   -in <JAR File or Folder> a jar or a folder containing a project's class files");
        Predef$.MODULE$.println((Object)"   -out <FileName> the folder where the class files are stored.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Example:");
        Predef$.MODULE$.println((Object)"   java org.opalj.br.ProjectSerializer -jar <JAR File> -o <output folder>");
    }

    public void main(String[] args) {
        File inFile;
        String in = null;
        ObjectRef out = ObjectRef.create(null);
        for (int i = 0; i < args.length; ++i) {
            BoxedUnit boxedUnit;
            String string = args[i];
            if ("-in".equals(string)) {
                in = args[++i];
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ("-out".equals(string)) {
                out.elem = args[++i];
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl = "-h".equals(string) ? true : "--help".equals(string);
            if (bl) {
                this.showUsage((Option<String>)None$.MODULE$);
                System.exit(0);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            this.showUsage((Option<String>)new Some((Object)new StringBuilder(13).append("Unsupported: ").append(string).toString()));
            System.exit(2);
            boxedUnit = BoxedUnit.UNIT;
        }
        if (in == null || (String)out.elem == null) {
            this.showUsage((Option<String>)new Some((Object)"Parameters missing."));
            System.exit(1);
        }
        if (!(inFile = new File(in)).exists()) {
            Console$.MODULE$.err().println(new StringBuilder(16).append(in).append(" does not exist.").toString());
            System.exit(1);
        }
        File outFolder = new File((String)out.elem);
        ProjectSerializer$.checkOrCreateOutputFolder$1(outFolder, out);
        File classesFolder = new File(new StringBuilder(7).append(outFolder.getPath()).append(File.separator).append("classes").toString());
        ProjectSerializer$.checkOrCreateOutputFolder$1(classesFolder, out);
        Project p = Project$.MODULE$.apply(inFile);
        this.serialize(p, classesFolder);
        Predef$.MODULE$.println((Object)new StringBuilder(25).append("Wrote all classfiles to ").append(outFolder).append(".").toString());
    }

    public void serialize(Project<?> p, File targetFolder) {
        File zipFile = new File(new StringBuilder(11).append(targetFolder.getAbsolutePath()).append(File.separator).append("project.zip").toString());
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
        p.parForeachProjectClassFile(p.parForeachProjectClassFile$default$1(), (Function1 & Serializable & scala.Serializable)cf -> {
            ProjectSerializer$.$anonfun$serialize$1(targetFolder, zipOut, cf);
            return BoxedUnit.UNIT;
        });
        zipOut.close();
    }

    public static final /* synthetic */ void $anonfun$showUsage$1(String e) {
        Predef$.MODULE$.println();
        Console$.MODULE$.err().println(e);
        Predef$.MODULE$.println();
    }

    private static final void checkOrCreateOutputFolder$1(File outFolder, ObjectRef out$1) {
        block0: {
            if ((outFolder.exists() || outFolder.mkdirs()) && (!outFolder.exists() || outFolder.isDirectory())) break block0;
            Console$.MODULE$.err().println(new StringBuilder(41).append((String)out$1.elem).append(" could not be created or is not a folder.").toString());
            System.exit(1);
        }
    }

    public static final /* synthetic */ void $anonfun$serialize$1(File targetFolder$1, ZipOutputStream zipOut$1, ClassFile cf) {
        String classFileFolderName = new StringBuilder(1).append(targetFolder$1.getAbsolutePath()).append("/").append(cf.thisType().packageName()).toString();
        File classFileFolder = new File(classFileFolderName);
        classFileFolder.mkdirs();
        String classFileName = new StringBuilder(6).append(cf.fqn()).append(".class").toString();
        File targetFile = new File(new StringBuilder(1).append(targetFolder$1.getAbsolutePath()).append("/").append(classFileName).toString());
        ClassFile x$1 = cf;
        ToDAConfig x$2 = org.opalj.ba.package$.MODULE$.toDA$default$2(x$1);
        byte[] b = Assembler$.MODULE$.apply(org.opalj.ba.package$.MODULE$.toDA(x$1, x$2), Assembler$.MODULE$.apply$default$2());
        package$.MODULE$.process((Closeable)new BufferedOutputStream(new FileOutputStream(targetFile)), (Function1 & Serializable & scala.Serializable)bos -> {
            bos.write(b);
            return BoxedUnit.UNIT;
        });
        ZipOutputStream zipOutputStream = zipOut$1;
        synchronized (zipOutputStream) {
            ZipEntry e = new ZipEntry(classFileName);
            zipOut$1.putNextEntry(e);
            zipOut$1.write(b, 0, b.length);
            zipOut$1.closeEntry();
        }
    }

    private ProjectSerializer$() {
        MODULE$ = this;
    }
}

