/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.support.info;

import java.io.Serializable;
import java.net.URL;
import org.opalj.br.ClassFile;
import org.opalj.br.Method;
import org.opalj.br.analyses.AnalysisExecutor;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.br.collection.TypesSet;
import org.opalj.br.collection.TypesSet$;
import org.opalj.fpcf.ComputationSpecification;
import org.opalj.fpcf.EPS;
import org.opalj.fpcf.FPCFAnalysesManager;
import org.opalj.fpcf.FPCFAnalysesManagerKey$;
import org.opalj.fpcf.Property;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.PropertyStoreKey$;
import org.opalj.fpcf.analyses.EagerL1ThrownExceptionsAnalysis$;
import org.opalj.fpcf.analyses.LazyVirtualMethodThrownExceptionsAnalysis$;
import org.opalj.fpcf.properties.ThrownExceptions;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class ThrownExceptions$
extends DefaultOneStepAnalysis {
    public static ThrownExceptions$ MODULE$;

    static {
        new ThrownExceptions$();
    }

    public String title() {
        return "Thrown Exceptions";
    }

    public String description() {
        return "Computes the set of the exceptions (in)directly thrown by methods";
    }

    public final String AnalysisLevelL0() {
        return "-analysisLevel=L0";
    }

    public final String AnalysisLevelL1() {
        return "-analysisLevel=L1";
    }

    public final String SuppressPerMethodReports() {
        return "-suppressPerMethodReports";
    }

    public String analysisSpecificParametersDescription() {
        return "[-analysisLevel=<L0|L1>  (Default: L1)]\n[-suppressPerMethodReports]";
    }

    public Traversable<String> checkAnalysisSpecificParameters(Seq<String> parameters) {
        Seq remainingParameters = (Seq)parameters.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ThrownExceptions$.$anonfun$checkAnalysisSpecificParameters$1(p)));
        return AnalysisExecutor.checkAnalysisSpecificParameters$((AnalysisExecutor)this, (Seq)remainingParameters);
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        String string;
        LongRef executionTime = LongRef.create((long)Nanoseconds$.MODULE$.None());
        PropertyStore ps = (PropertyStore)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> {
            PropertyStore propertyStore;
            if (parameters.contains((Object)"-analysisLevel=L0")) {
                void var2_2;
                PropertyStore ps = (PropertyStore)project.get((ProjectInformationKey)PropertyStoreKey$.MODULE$);
                ps.setupPhase(Predef$.MODULE$.Set().empty(), ps.setupPhase$default$2());
                project.allMethods().foreach((Function1 & Serializable & scala.Serializable)m -> {
                    ps.force((Object)m, org.opalj.fpcf.properties.ThrownExceptions$.MODULE$.key());
                    return BoxedUnit.UNIT;
                });
                ps.waitOnPhaseCompletion();
                propertyStore = var2_2;
            } else {
                propertyStore = ((FPCFAnalysesManager)project.get((ProjectInformationKey)FPCFAnalysesManagerKey$.MODULE$)).runAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComputationSpecification[]{LazyVirtualMethodThrownExceptionsAnalysis$.MODULE$, EagerL1ThrownExceptionsAnalysis$.MODULE$}));
            }
            return propertyStore;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            executionTime.elem = ((Nanoseconds)t).timeSpan();
            return BoxedUnit.UNIT;
        });
        Iterable allMethods = ps.entities(org.opalj.fpcf.properties.ThrownExceptions$.MODULE$.key()).toIterable();
        Tuple2 tuple2 = allMethods.partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ThrownExceptions$.$anonfun$doAnalyze$4(x$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable epsNotThrowingExceptions = (Iterable)tuple2._1();
        Iterable otherEPS = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)epsNotThrowingExceptions, (Object)otherEPS);
        Tuple2 tuple23 = tuple22;
        Iterable epsNotThrowingExceptions2 = (Iterable)tuple23._1();
        Iterable otherEPS2 = (Iterable)tuple23._2();
        Iterable epsThrowingExceptions = (Iterable)otherEPS2.filter((Function1 & Serializable & scala.Serializable)eps -> BoxesRunTime.boxToBoolean((boolean)ThrownExceptions$.$anonfun$doAnalyze$5(eps)));
        Iterable methodsThrowingExceptions = (Iterable)epsThrowingExceptions.map((Function1 & Serializable & scala.Serializable)x$3 -> (Method)x$3.e(), scala.collection.Iterable$.MODULE$.canBuildFrom());
        int privateMethodsThrowingExceptionsCount = methodsThrowingExceptions.count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isPrivate()));
        Iterable privateMethodsNotThrowingExceptions = (Iterable)((TraversableLike)epsNotThrowingExceptions2.map((Function1 & Serializable & scala.Serializable)x$5 -> (Method)x$5.e(), scala.collection.Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isPrivate()));
        if (parameters.contains((Object)"-suppressPerMethodReports")) {
            string = "";
        } else {
            Map epsThrowingExceptionsByClassFile = epsThrowingExceptions.groupBy((Function1 & Serializable & scala.Serializable)x$7 -> ((Method)x$7.e()).classFile());
            string = ((TraversableOnce)epsThrowingExceptionsByClassFile.map((Function1 & Serializable & scala.Serializable)e -> {
                Tuple2 tuple2 = e;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ClassFile cf = (ClassFile)tuple2._1();
                Iterable epsThrowingExceptionsPerMethod = (Iterable)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)cf, (Object)epsThrowingExceptionsPerMethod);
                Tuple2 tuple23 = tuple22;
                ClassFile cf2 = (ClassFile)tuple23._1();
                Iterable epsThrowingExceptionsPerMethod2 = (Iterable)tuple23._2();
                return new StringBuilder(2).append(cf2.thisType().toJava()).append("{").append(((TraversableOnce)((TraversableOnce)epsThrowingExceptionsPerMethod2.map((Function1 & Serializable & scala.Serializable)eps -> {
                    TypesSet types;
                    Method m = (Method)eps.e();
                    Property property = eps.ub();
                    if (!(property instanceof ThrownExceptions)) {
                        throw new MatchError((Object)property);
                    }
                    ThrownExceptions thrownExceptions = (ThrownExceptions)property;
                    TypesSet typesSet = types = thrownExceptions.types();
                    TypesSet types2 = typesSet;
                    return new StringBuilder(8).append(m.descriptor().toJava(m.name())).append(" throws ").append(types2.toString()).toString();
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n\t\t", "\n\t\t", "\n")).append("}").toString();
            }, Iterable$.MODULE$.canBuildFrom())).mkString("\n", "\n", "\n");
        }
        String perMethodsReport = string;
        String psStatistics = ((TraversableOnce)ps.statistics().map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(2).append((String)e._1()).append(": ").append(e._2$mcI$sp()).toString(), scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("Property Store Statistics:\n\t", "\n\t", "\n");
        String analysisStatistics = new StringBuilder(128).append("\nStatistics:\n#methods with a thrown exceptions property: ").append(new StringBuilder(4).append(allMethods.size()).append(" (").append(project.methodsCount()).append(")\n").toString()).append("#methods with exceptions information more precise than _ <: Throwable: ").append(new StringBuilder(1).append(methodsThrowingExceptions.size() + epsNotThrowingExceptions2.size()).append("\n").toString()).append(new StringBuilder(24).append(" ... #exceptions == 0: ").append(epsNotThrowingExceptions2.size()).append("\n").toString()).append(new StringBuilder(36).append(" ... #exceptions == 0 and private: ").append(privateMethodsNotThrowingExceptions.size()).append("\n").toString()).append(new StringBuilder(36).append(" ... #exceptions >  0 and private: ").append(privateMethodsThrowingExceptionsCount).append("\n").toString()).append(new StringBuilder(17).append("execution time: ").append(new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(executionTime.elem))).append("\n").toString()).toString();
        return new BasicReport(new StringBuilder(33).append(psStatistics).append("\nThrown Exceptions Information:\n").append(perMethodsReport).append("\n").append(ps.toString(false)).append(analysisStatistics).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkAnalysisSpecificParameters$1(String p) {
        String string = p;
        String string2 = "-analysisLevel=L0";
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = p;
        String string4 = "-analysisLevel=L1";
        if (string3 == null) {
            if (string4 == null) return false;
        } else if (string3.equals(string4)) return false;
        String string5 = p;
        String string6 = "-suppressPerMethodReports";
        if (string5 == null) {
            if (string6 == null) return false;
            return true;
        } else if (string5.equals(string6)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$4(EPS x$1) {
        return ((ThrownExceptions)x$1.ub()).throwsNoExceptions();
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$5(EPS eps) {
        TypesSet typesSet = ((ThrownExceptions)eps.lb()).types();
        TypesSet typesSet2 = TypesSet$.MODULE$.SomeException();
        return typesSet == null ? typesSet2 != null : !typesSet.equals(typesSet2);
    }

    private ThrownExceptions$() {
        MODULE$ = this;
    }
}

