/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.support.info;

import java.net.URL;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.fpcf.ComputationSpecification;
import org.opalj.fpcf.FPCFAnalysesManager;
import org.opalj.fpcf.FPCFAnalysesManagerKey$;
import org.opalj.fpcf.Property;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.analyses.LazyFieldLocalityAnalysis$;
import org.opalj.fpcf.analyses.LazyVirtualCallAggregatingEscapeAnalysis$;
import org.opalj.fpcf.analyses.LazyVirtualReturnValueFreshnessAnalysis$;
import org.opalj.fpcf.analyses.escape.EagerReturnValueFreshnessAnalysis$;
import org.opalj.fpcf.analyses.escape.LazyInterProceduralEscapeAnalysis$;
import org.opalj.fpcf.properties.ExtensibleGetter$;
import org.opalj.fpcf.properties.FreshReturnValue$;
import org.opalj.fpcf.properties.Getter$;
import org.opalj.fpcf.properties.NoFreshReturnValue$;
import org.opalj.fpcf.properties.PrimitiveReturnValue$;
import org.opalj.fpcf.properties.VExtensibleGetter$;
import org.opalj.fpcf.properties.VFreshReturnValue$;
import org.opalj.fpcf.properties.VGetter$;
import org.opalj.fpcf.properties.VNoFreshReturnValue$;
import org.opalj.fpcf.properties.VPrimitiveReturnValue$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public final class ReturnValueFreshness$
extends DefaultOneStepAnalysis {
    public static ReturnValueFreshness$ MODULE$;

    static {
        new ReturnValueFreshness$();
    }

    public String title() {
        return "\"Freshness\" of Return Values";
    }

    public String description() {
        return "Describes whether a method returns a value that is allocated in that method or its callees and only has escape state \"Escape Via Return\"";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        PropertyStore ps = ((FPCFAnalysesManager)project.get((ProjectInformationKey)FPCFAnalysesManagerKey$.MODULE$)).runAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComputationSpecification[]{LazyInterProceduralEscapeAnalysis$.MODULE$, LazyFieldLocalityAnalysis$.MODULE$, LazyVirtualCallAggregatingEscapeAnalysis$.MODULE$, LazyVirtualReturnValueFreshnessAnalysis$.MODULE$, EagerReturnValueFreshnessAnalysis$.MODULE$}));
        Seq fresh = ps.finalEntities((Property)FreshReturnValue$.MODULE$).toSeq();
        Seq notFresh = ps.finalEntities((Property)NoFreshReturnValue$.MODULE$).toSeq();
        Seq prim = ps.finalEntities((Property)PrimitiveReturnValue$.MODULE$).toSeq();
        Seq getter = ps.finalEntities((Property)Getter$.MODULE$).toSeq();
        Seq extGetter = ps.finalEntities((Property)ExtensibleGetter$.MODULE$).toSeq();
        Seq vfresh = ps.finalEntities((Property)VFreshReturnValue$.MODULE$).toSeq();
        Seq vnotFresh = ps.finalEntities((Property)VNoFreshReturnValue$.MODULE$).toSeq();
        Seq vprim = ps.finalEntities((Property)VPrimitiveReturnValue$.MODULE$).toSeq();
        Seq vgetter = ps.finalEntities((Property)VGetter$.MODULE$).toSeq();
        Seq vextGetter = ps.finalEntities((Property)VExtensibleGetter$.MODULE$).toSeq();
        String message = new StringBuilder(574).append("|# of methods with fresh return value: ").append(fresh.size()).append("\n                |# of methods without fresh return value: ").append(notFresh.size()).append("\n                |# of methods with primitive return value: ").append(prim.size()).append("\n                |# of methods that are getters: ").append(getter.size()).append("\n                |# of methods that are extensible getters: ").append(extGetter.size()).append("\n                |# of vmethods with fresh return value: ").append(vfresh.size()).append("\n                |# of vmethods without fresh return value: ").append(vnotFresh.size()).append("\n                |# of vmethods with primitive return value: ").append(vprim.size()).append("\n                |# of vmethods that are getters: ").append(vgetter.size()).append("\n                |# of vmethods that are extensible getters: ").append(vextGetter.size()).append("\n                |").toString();
        return new BasicReport(new StringOps(Predef$.MODULE$.augmentString(message)).stripMargin('|'));
    }

    private ReturnValueFreshness$() {
        MODULE$ = this;
    }
}

