/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.support.info;

import java.io.Serializable;
import java.net.URL;
import org.opalj.br.ClassFile;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.fpcf.EPS;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.PropertyStoreKey$;
import org.opalj.fpcf.analyses.EagerClassImmutabilityAnalysis$;
import org.opalj.fpcf.analyses.EagerL0FieldMutabilityAnalysis$;
import org.opalj.fpcf.analyses.EagerTypeImmutabilityAnalysis$;
import org.opalj.fpcf.properties.ClassImmutability;
import org.opalj.fpcf.properties.ClassImmutability$;
import org.opalj.fpcf.properties.TypeImmutability;
import org.opalj.fpcf.properties.TypeImmutability$;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import org.opalj.util.Seconds$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction0;

public final class ImmutabilityAnalysisRunner$
extends DefaultOneStepAnalysis {
    public static ImmutabilityAnalysisRunner$ MODULE$;

    static {
        new ImmutabilityAnalysisRunner$();
    }

    public String title() {
        return "Immutability Analysis";
    }

    public String description() {
        return "determines the immutability of classes and types";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        DoubleRef t = DoubleRef.create((double)Seconds$.MODULE$.None());
        PropertyStore ps = (PropertyStore)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> (PropertyStore)project.get((ProjectInformationKey)PropertyStoreKey$.MODULE$), (Function1 & Serializable & scala.Serializable)r -> {
            t.elem = Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)r).timeSpan());
            return BoxedUnit.UNIT;
        });
        PerformanceEvaluation$.MODULE$.time((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            EagerL0FieldMutabilityAnalysis$.MODULE$.start(project, ps, null);
            EagerClassImmutabilityAnalysis$.MODULE$.start(project, ps, null);
            EagerTypeImmutabilityAnalysis$.MODULE$.start(project, ps, null);
            ps.waitOnPhaseCompletion();
        }, (Function1 & Serializable & scala.Serializable)r -> {
            t.elem = Seconds$.MODULE$.$plus$extension(t.elem, Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)r).timeSpan()));
            return BoxedUnit.UNIT;
        });
        Map immutableClasses = (Map)((TraversableLike)ps.entities(ClassImmutability$.MODULE$.key()).toSeq().filter((Function1 & Serializable & scala.Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysisRunner$.$anonfun$doAnalyze$5(ep)))).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (ClassImmutability)x$1.ub()).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), ((TraversableOnce)kv._2()).toList().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysisRunner$.$anonfun$doAnalyze$8(a, b)))), Map$.MODULE$.canBuildFrom());
        String immutableClassesPerCategory = ((TraversableOnce)((TraversableOnce)immutableClasses.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(4).append("\t\t").append(kv._1()).append(": ").append(((SeqLike)kv._2()).size()).toString(), Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
        Map immutableTypes = (Map)((TraversableLike)ps.entities(TypeImmutability$.MODULE$.key()).toSeq().filter((Function1 & Serializable & scala.Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysisRunner$.$anonfun$doAnalyze$10(ep)))).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (TypeImmutability)x$2.ub()).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), (Object)BoxesRunTime.boxToInteger((int)((SeqLike)kv._2()).size())), Map$.MODULE$.canBuildFrom());
        String immutableTypesPerCategory = ((TraversableOnce)((TraversableOnce)immutableTypes.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(4).append("\t\t").append(kv._1()).append(": ").append(kv._2$mcI$sp()).toString(), Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
        String immutableClassesInfo = ((TraversableOnce)((TraversableLike)((TraversableLike)immutableClasses.values().flatten((Function1)Predef$.MODULE$.$conforms())).filter((Function1 & Serializable & scala.Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysisRunner$.$anonfun$doAnalyze$14(ep)))).map((Function1 & Serializable & scala.Serializable)ep -> new StringBuilder(8).append(((ClassFile)ep.e()).thisType().toJava()).append(" => ").append(ep.ub()).append(" => ").append(ps.apply(ep.e(), TypeImmutability$.MODULE$.key()).ub()).toString(), scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("\tImmutability:\n\t\t", "\n\t\t", "\n");
        return new BasicReport(new StringBuilder(126).append("\nImmutability Information:\n").append(immutableClassesInfo).append("\nSummary (w.r.t classes):\n").append("\tObject Immutability:\n").append(immutableClassesPerCategory).append("\n").append("\tType Immutability:\n").append(immutableTypesPerCategory).append("\n").append("\n").append(ps.toString(false)).append("\n").append("The overall analysis took: ").append(new Seconds(t.elem)).toString());
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$5(EPS ep) {
        return !((ClassFile)ep.e()).isInterfaceDeclaration();
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$8(EPS a, EPS b) {
        ClassFile cfA = (ClassFile)a.e();
        ClassFile cfB = (ClassFile)b.e();
        return new StringOps(Predef$.MODULE$.augmentString(cfA.thisType().toJava())).$less((Object)cfB.thisType().toJava());
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$10(EPS ep) {
        return !((ClassFile)ep.e()).isInterfaceDeclaration();
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$14(EPS ep) {
        return !((ClassFile)ep.e()).isInterfaceDeclaration();
    }

    private ImmutabilityAnalysisRunner$() {
        MODULE$ = this;
    }
}

