/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.hermes.queries;

import com.typesafe.config.Config;
import org.opalj.hermes.Globals$;
import org.opalj.hermes.queries.FanInFanOut$;
import org.opalj.hermes.queries.FeatureConfiguration;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class FeatureConfiguration$
implements Serializable {
    public static FeatureConfiguration$ MODULE$;

    static {
        new FeatureConfiguration$();
    }

    public LogContext logContext() {
        return GlobalLogContext$.MODULE$;
    }

    public final String logCategory() {
        return "Hermes - fan-in/fan-out query";
    }

    public FeatureConfiguration apply(String featureName, String categoriesKey, String categorySizeKey, int categoriesDefault, double categorySizeDefault, int offset) {
        Config config = Globals$.MODULE$.Config().getConfig(FanInFanOut$.MODULE$.configPrefix());
        int numCategories = BoxesRunTime.unboxToInt((Object)this.parseNumCategories(categoriesKey, config).getOrElse((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> categoriesDefault));
        double categorySize = BoxesRunTime.unboxToDouble((Object)this.parseCategorySize(categorySizeKey, config).getOrElse((Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> categorySizeDefault));
        return new FeatureConfiguration(featureName, numCategories, categorySize, offset);
    }

    private Option<Object> parseNumCategories(String categoriesKey, Config config) {
        Some some;
        int numCategories = config.getInt(categoriesKey);
        if (numCategories > 0) {
            some = new Some((Object)BoxesRunTime.boxToInteger((int)numCategories));
        } else {
            String message = FanInFanOut$.MODULE$.configPrefix() + categoriesKey + " setting invalid - value <= 0; category size has been set to default";
            OPALLogger$.MODULE$.warn("Hermes - fan-in/fan-out query", message, this.logContext());
            some = None$.MODULE$;
        }
        return some;
    }

    private Option<Object> parseCategorySize(String categorySizeKey, Config config) {
        Some some;
        double categorySize = config.getDouble(categorySizeKey);
        if (categorySize > 0.0) {
            some = new Some((Object)BoxesRunTime.boxToDouble((double)categorySize));
        } else {
            String message = FanInFanOut$.MODULE$.configPrefix() + categorySizeKey + " setting invalid - value <= 0; category size has been set to default";
            OPALLogger$.MODULE$.warn("Hermes - fan-in/fan-out query", message, this.logContext());
            some = None$.MODULE$;
        }
        return some;
    }

    public FeatureConfiguration apply(String featureName, int numCategories, double categorySize, int offset) {
        return new FeatureConfiguration(featureName, numCategories, categorySize, offset);
    }

    public Option<Tuple4<String, Object, Object, Object>> unapply(FeatureConfiguration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.featureName(), (Object)BoxesRunTime.boxToInteger((int)x$0.numCategories()), (Object)BoxesRunTime.boxToDouble((double)x$0.categorySize()), (Object)BoxesRunTime.boxToInteger((int)x$0.offset())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FeatureConfiguration$() {
        MODULE$ = this;
    }
}

