/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.hermes;

import java.io.File;
import org.opalj.hermes.HermesCLI$Hermes$;
import scala.Console$;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scalafx.beans.value.ObservableValue;

public final class HermesCLI$ {
    public static HermesCLI$ MODULE$;

    static {
        new HermesCLI$();
    }

    private void showUsage() {
        Predef$.MODULE$.println((Object)"OPAL - Hermes");
        Predef$.MODULE$.println((Object)"Parameters:");
        Predef$.MODULE$.println((Object)"   -config <FileName> the configuration which lists a corpus' projects");
        Predef$.MODULE$.println((Object)"   -statistics <FileName> the csv file to which the results should be exported");
        Predef$.MODULE$.println((Object)"   -mapping <FileName> the properties file with the mapping between the feature");
        Predef$.MODULE$.println((Object)"                       queries and the extracted features; format:");
        Predef$.MODULE$.println((Object)"                       <FeatureQueryClass>=<FeatureID>(,<FeatureID>)*");
        Predef$.MODULE$.println((Object)"                       where in FeatureIDs every \\ is replaced by \\\\");
        Predef$.MODULE$.println((Object)"                                             ... new line ('\\n') is replaced by \\n");
        Predef$.MODULE$.println((Object)"                                             ... , is replaced by \\,");
        Predef$.MODULE$.println((Object)"   [-noProjectStatistics project statistics are not exported]");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"java org.opalj.hermes.HermesCLI -config <ConfigFile.json> -statistics <FileName>");
    }

    public void main(String[] args) {
        String configFile = null;
        ObjectRef statisticsFile = ObjectRef.create(null);
        ObjectRef mappingFile = ObjectRef.create((Object)None$.MODULE$);
        BooleanRef noProjectStatistics = BooleanRef.create((boolean)false);
        for (int i = 0; i < args.length; ++i) {
            BoxedUnit boxedUnit;
            String string = args[i];
            if ("-config".equals(string)) {
                configFile = args[++i];
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ("-statistics".equals(string)) {
                statisticsFile.elem = args[++i];
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ("-mapping".equals(string)) {
                mappingFile.elem = new Some((Object)args[++i]);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ("-noProjectStatistics".equals(string)) {
                noProjectStatistics.elem = true;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Console$.MODULE$.err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown parameter ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
            this.showUsage();
            System.exit(2);
            boxedUnit = BoxedUnit.UNIT;
        }
        if (configFile == null || (String)statisticsFile.elem == null) {
            Console$.MODULE$.err().println("Missing config file and/or statistics file.");
            this.showUsage();
            System.exit(1);
        }
        HermesCLI$Hermes$.MODULE$.analysesFinished().onChange((Function3 & java.io.Serializable & Serializable)(x$1, x$2, isFinished) -> {
            HermesCLI$.$anonfun$main$1(statisticsFile, mappingFile, noProjectStatistics, x$1, x$2, isFinished);
            return BoxedUnit.UNIT;
        });
        HermesCLI$Hermes$.MODULE$.initialize(new File(configFile));
        HermesCLI$Hermes$.MODULE$.analyzeCorpus(false);
    }

    public static final /* synthetic */ void $anonfun$main$2(String mappingFile) {
        File theMappingFile = new File(mappingFile).getAbsoluteFile();
        HermesCLI$Hermes$.MODULE$.exportMapping(theMappingFile);
        Predef$.MODULE$.println((Object)("Wrote mapping: " + theMappingFile));
    }

    public static final /* synthetic */ void $anonfun$main$1(ObjectRef statisticsFile$1, ObjectRef mappingFile$1, BooleanRef noProjectStatistics$1, ObservableValue x$1, Boolean x$2, Boolean isFinished) {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(isFinished)) break block0;
            File theStatisticsFile = new File((String)statisticsFile$1.elem).getAbsoluteFile();
            HermesCLI$Hermes$.MODULE$.exportStatistics(theStatisticsFile, !noProjectStatistics$1.elem);
            Predef$.MODULE$.println((Object)("Wrote statistics: " + theStatisticsFile));
            ((Option)mappingFile$1.elem).foreach((Function1 & java.io.Serializable & Serializable)mappingFile -> {
                HermesCLI$.$anonfun$main$2(mappingFile);
                return BoxedUnit.UNIT;
            });
            System.exit(0);
        }
    }

    private HermesCLI$() {
        MODULE$ = this;
    }
}

