/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.analyses;

import java.io.File;
import java.io.Serializable;
import org.opalj.br.ClassFile;
import org.opalj.br.ClassHierarchy;
import org.opalj.br.ClassHierarchy$;
import org.opalj.br.ObjectType;
import org.opalj.br.ObjectType$;
import org.opalj.br.reader.Java8Framework$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqView$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class ClassHierarchyExtractor$ {
    public static ClassHierarchyExtractor$ MODULE$;

    static {
        new ClassHierarchyExtractor$();
    }

    public String deriveSpecification(Traversable<ObjectType> types, ClassHierarchy classHierarchy) {
        Traversable specLines = (Traversable)types.map((Function1 & Serializable & scala.Serializable)aType -> {
            void var2_2;
            block1: {
                String specLine = (classHierarchy.isInterface(aType).isYes() ? "interface " : "class ") + aType.fqn();
                Option superclassType = classHierarchy.superclassType(aType);
                if (!superclassType.isDefined()) break block1;
                specLine = specLine + (" extends " + ((ObjectType)superclassType.get()).fqn());
                Option superinterfaceTypes = classHierarchy.superinterfaceTypes(aType);
                if (superinterfaceTypes.isDefined() && ((TraversableOnce)superinterfaceTypes.get()).nonEmpty()) {
                    specLine = specLine + ((TraversableOnce)((SetLike)superinterfaceTypes.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.fqn(), Set$.MODULE$.canBuildFrom())).mkString(" implements ", ", ", "");
                }
            }
            return var2_2;
        }, Traversable$.MODULE$.canBuildFrom());
        return specLines.mkString("\n");
    }

    public void main(String[] args) {
        ObjectType supertype;
        if (args.length < 3 || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(2))).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.endsWith(".jar")))) {
            Predef$.MODULE$.println((Object)"Usage:     java \u2026ClassHierarchy supertype filterprefix <JAR file>+");
            Predef$.MODULE$.println((Object)"Example:   \u2026 java.lang.Enum \"\" .../rt.jar");
            Predef$.MODULE$.println((Object)"           lists all subclasses of java.lang.Enum in rt.jar; \"\" effectively disables the filter.");
            Predef$.MODULE$.println((Object)"Copyright: 2015 Michael Eichberg (eichberg@informatik.tu-darmstadt.de)");
            throw package$.MODULE$.exit(-1);
        }
        String supertypeName = args[0].replace('.', '/');
        String filterPrefix = args[1].replace('.', '/');
        List list = List$.MODULE$.empty();
        List classFiles = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$div$colon((Object)list, (Function2 & Serializable & scala.Serializable)(cfs, filename) -> (List)cfs.$plus$plus((GenTraversableOnce)Java8Framework$.MODULE$.ClassFiles(new File((String)filename), Java8Framework$.MODULE$.ClassFiles$default$2()), List$.MODULE$.canBuildFrom()));
        ClassHierarchy classHierarchy = ClassHierarchy$.MODULE$.apply((Traversable)classFiles.view().map((Function1 & Serializable & scala.Serializable)x$4 -> (ClassFile)x$4._1(), SeqView$.MODULE$.canBuildFrom()), ClassHierarchy$.MODULE$.apply$default$2(), (LogContext)GlobalLogContext$.MODULE$);
        if (classHierarchy.isUnknown(supertype = ObjectType$.MODULE$.apply(supertypeName))) {
            Console$.MODULE$.err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The type: ", " is not defined in the specified jar(s)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{supertypeName})));
            throw package$.MODULE$.exit(-2);
        }
        Predef$.MODULE$.println((Object)("# Class hierarchy for: " + supertypeName + " limited to subclasses that start with: " + "\"" + filterPrefix + "\""));
        Set allRelevantSubtypes = (Set)classHierarchy.allSubtypes(supertype, true).filter((Function1 & Serializable & scala.Serializable)candidateType -> BoxesRunTime.boxToBoolean((boolean)ClassHierarchyExtractor$.$anonfun$main$4(filterPrefix, candidateType)));
        String spec = this.deriveSpecification((Traversable<ObjectType>)allRelevantSubtypes, classHierarchy);
        Predef$.MODULE$.println((Object)spec);
    }

    public static final /* synthetic */ boolean $anonfun$main$4(String filterPrefix$1, ObjectType candidateType) {
        return candidateType.fqn().startsWith(filterPrefix$1);
    }

    private ClassHierarchyExtractor$() {
        MODULE$ = this;
    }
}

