/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai.debug;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.opalj.ai.AIResult;
import org.opalj.ai.Domain;
import org.opalj.ai.InstructionCountBoundedAI;
import org.opalj.ai.util.XHTML$;
import org.opalj.br.ClassFile;
import org.opalj.br.Code;
import org.opalj.br.Method;
import org.opalj.br.analyses.ProgressManagement;
import org.opalj.br.analyses.Project;
import org.opalj.io.package$;
import org.opalj.log.LogContext;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation;
import org.opalj.util.Seconds;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

public final class InterpretMethodsAnalysis$ {
    public static InterpretMethodsAnalysis$ MODULE$;

    static {
        new InterpretMethodsAnalysis$();
    }

    public void println(String s) {
        Console$.MODULE$.out().println(s);
        Console$.MODULE$.flush();
    }

    public <Source> Tuple2<String, Option<File>> interpret(Project<Source> project, Class<? extends Domain> domainClass, boolean beVerbose, Function1<Object, ProgressManagement> initProgressManagement, double maxEvaluationFactor, LogContext logContext) {
        Tuple2 tuple2;
        PerformanceEvaluation performanceEvaluationContext = new PerformanceEvaluation();
        AtomicInteger methodsCount = new AtomicInteger(0);
        AtomicLong instructionEvaluationsCount = new AtomicLong(0L);
        Constructor<? extends Domain> domainConstructor = domainClass.getConstructor(Project.class, Method.class);
        Iterable collectedExceptions = (Iterable)performanceEvaluationContext.time((Symbol)SymbolLiteral.bootstrap("apply", "OVERALL"), (Function0 & Serializable & scala.Serializable)() -> {
            ConcurrentLinkedQueue results = new ConcurrentLinkedQueue();
            project.parForeachMethodWithBody(project.parForeachMethodWithBody$default$1(), project.parForeachMethodWithBody$default$2(), (Function1 & Serializable & scala.Serializable)m -> this.analyzeMethod$1(m.source().toString(), m.method(), project, beVerbose, maxEvaluationFactor, logContext, performanceEvaluationContext, methodsCount, instructionEvaluationsCount, domainConstructor).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)results.add(x$1))));
            return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results).asScala();
        });
        if (collectedExceptions.nonEmpty()) {
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("Generated "));
            $buf.$amp$plus((Object)new Date());
            Elem header = new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            Seq body2 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Elem[]{header}))).$plus$plus((GenTraversableOnce)collectedExceptions.groupBy((Function1 & Serializable & scala.Serializable)e -> (String)e._1()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)InterpretMethodsAnalysis$.$anonfun$interpret$7(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                Tuple2 tuple2 = x$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String exResource = (String)tuple2._1();
                Iterable exInstances = (Iterable)tuple2._2();
                Iterable exDetails = (Iterable)exInstances.map((Function1 & Serializable & scala.Serializable)ex -> {
                    Tuple4 tuple4 = ex;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    ClassFile classFile = (ClassFile)tuple4._2();
                    Method method = (Method)tuple4._3();
                    Throwable throwable = (Throwable)tuple4._4();
                    Tuple3 tuple3 = new Tuple3((Object)classFile, (Object)method, (Object)throwable);
                    Tuple3 tuple32 = tuple3;
                    ClassFile classFile2 = (ClassFile)tuple32._1();
                    Method method2 = (Method)tuple32._2();
                    Throwable throwable2 = (Throwable)tuple32._3();
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n                                "));
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)classFile2.thisType().fqn());
                    $buf.$amp$plus((Object)new Elem(null, "b", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                    $buf.$amp$plus((Object)new Text("\n                                "));
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)new Text("\""));
                    $buf3.$amp$plus((Object)method2.signatureToJava(true));
                    $buf3.$amp$plus((Object)new Text("\""));
                    $buf.$amp$plus((Object)new Elem(null, "i", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                    $buf.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                    $buf.$amp$plus((Object)new Text("\n                                "));
                    $buf.$amp$plus((Object)("Length: " + ((Code)method2.body().get()).instructions().length));
                    $buf.$amp$plus((Object)new Text("\n                                "));
                    NodeBuffer $buf4 = new NodeBuffer();
                    $buf4.$amp$plus((Object)XHTML$.MODULE$.throwableToXHTML(throwable2));
                    $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                    $buf.$amp$plus((Object)new Text("\n                            "));
                    return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                }, scala.collection.Iterable$.MODULE$.canBuildFrom());
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n                        "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)exResource);
                $buf.$amp$plus((Object)new Elem(null, "h1", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n                        "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("Number of thrown exceptions: "));
                $buf3.$amp$plus((Object)BoxesRunTime.boxToInteger((int)exInstances.size()));
                $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf.$amp$plus((Object)new Text("\n                        "));
                $buf.$amp$plus((Object)exDetails);
                $buf.$amp$plus((Object)new Text("\n                    "));
                Elem elem = new Elem(null, "section", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                return elem;
            }, Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            Node node = XHTML$.MODULE$.createXHTML((Option)new Some((Object)"Exceptions Thrown During Interpretation"), NodeSeq$.MODULE$.fromSeq(body2));
            File file = package$.MODULE$.writeAndOpen(node, "ExceptionsOfCrashedAbstractInterpretations", ".html");
            tuple2 = new Tuple2((Object)("During the interpretation of " + methodsCount.get() + " methods (of " + project.methodsCount() + ") in " + project.classFilesCount() + " classes (real time: " + new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(performanceEvaluationContext.getTime((Symbol)SymbolLiteral.bootstrap("apply", "OVERALL")))) + ", ai (\u2211CPU Times): " + new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(performanceEvaluationContext.getTime((Symbol)SymbolLiteral.bootstrap("apply", "AI")))) + ")" + collectedExceptions.size() + " exceptions occured."), (Object)new Some((Object)file));
        } else {
            tuple2 = new Tuple2((Object)("No exceptions occured during the interpretation of " + methodsCount.get() + " methods (of " + project.methodsCount() + ") in " + project.classFilesCount() + " classes\nreal time: " + new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(performanceEvaluationContext.getTime((Symbol)SymbolLiteral.bootstrap("apply", "OVERALL")))) + "\n" + "ai (\u2211CPU Times): " + new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(performanceEvaluationContext.getTime((Symbol)SymbolLiteral.bootstrap("apply", "AI")))) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"; evaluated ", " instructions\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)instructionEvaluationsCount.get())})) + "naive ai (\u2211CPU Times): " + new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(performanceEvaluationContext.getTime((Symbol)SymbolLiteral.bootstrap("apply", "NAIVE_AI")))) + "\n"), (Object)None$.MODULE$);
        }
        return tuple2;
    }

    public <Source> double interpret$default$5() {
        return 3.0;
    }

    private final Option analyzeMethod$1(String source, Method method, Project project$1, boolean beVerbose$1, double maxEvaluationFactor$1, LogContext logContext$1, PerformanceEvaluation performanceEvaluationContext$1, AtomicInteger methodsCount$1, AtomicLong instructionEvaluationsCount$1, Constructor domainConstructor$1) {
        Some some;
        Code body2 = (Code)method.body().get();
        try {
            if (beVerbose$1) {
                this.println(method.toJava("\u001b[33m[started]\u001b[0m"));
            }
            long evaluatedCount = BoxesRunTime.unboxToLong((Object)performanceEvaluationContext$1.time((Symbol)SymbolLiteral.bootstrap("apply", "AI"), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
                InstructionCountBoundedAI ai = new InstructionCountBoundedAI(body2, maxEvaluationFactor$1, true, logContext$1);
                Domain domain = (Domain)domainConstructor$1.newInstance(project$1, method);
                AIResult result = ai.apply(method, domain);
                if (result.wasAborted()) {
                    if (beVerbose$1) {
                        MODULE$.println(method.toJava("\u001b[31m[aborted after evaluating " + ai.currentEvaluationCount() + " instructions (size of instructions array=" + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])body2.instructions())).size() + "; max=" + ai.maxEvaluationCount() + ")]" + "\u001b[0m"));
                    }
                    String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"evaluation bound (max=", ") exceeded"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ai.maxEvaluationCount())}));
                    throw new InterruptedException(message);
                }
                long evaluatedCount = ai.currentEvaluationCount();
                instructionEvaluationsCount$1.addAndGet(evaluatedCount);
                return evaluatedCount;
            }));
            int naiveEvaluatedCount = BoxesRunTime.unboxToInt((Object)performanceEvaluationContext$1.time((Symbol)SymbolLiteral.bootstrap("apply", "NAIVE_AI"), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                InstructionCountBoundedAI ai = new InstructionCountBoundedAI(body2, maxEvaluationFactor$1, false, logContext$1);
                Domain domain = (Domain)domainConstructor$1.newInstance(project$1, method);
                ai.apply(method, domain);
                return ai.currentEvaluationCount();
            }));
            if (beVerbose$1 && (long)naiveEvaluatedCount > evaluatedCount) {
                int codeLength = body2.instructions().length;
                String message = method.toJava(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"evaluation steps (code size:", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)codeLength)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (w/o dead variables analysis) vs. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)naiveEvaluatedCount), BoxesRunTime.boxToLong((long)evaluatedCount)})));
                this.println(message);
            }
            if (beVerbose$1) {
                this.println(method.toJava("\u001b[32m[finished]\u001b[0m"));
            }
            methodsCount$1.incrementAndGet();
            some = None$.MODULE$;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 == null) {
                throw throwable;
            }
            Throwable throwable3 = throwable2;
            ClassFile classFile = method.classFile();
            String source2 = project$1.source(classFile.thisType()).get().toString();
            Some some2 = new Some((Object)new Tuple4((Object)source2, (Object)classFile, (Object)method, (Object)throwable3));
            some = some2;
        }
        return some;
    }

    public static final /* synthetic */ boolean $anonfun$interpret$7(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private InterpretMethodsAnalysis$() {
        MODULE$ = this;
    }
}

