/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai.debug;

import java.io.File;
import java.io.Serializable;
import org.opalj.ai.analyses.cg.BasicVTACallGraphAlgorithmConfiguration;
import org.opalj.ai.analyses.cg.BasicVTAWithPreAnalysisCallGraphAlgorithmConfiguration;
import org.opalj.ai.analyses.cg.CFACallGraphAlgorithmConfiguration;
import org.opalj.ai.analyses.cg.CHACallGraphAlgorithmConfiguration;
import org.opalj.ai.analyses.cg.CHACallGraphAlgorithmConfiguration$;
import org.opalj.ai.analyses.cg.CallGraph;
import org.opalj.ai.analyses.cg.CallGraphAlgorithmConfiguration;
import org.opalj.ai.analyses.cg.CallGraphFactory$;
import org.opalj.ai.analyses.cg.ComputedCallGraph;
import org.opalj.ai.analyses.cg.ComputedCallGraph$;
import org.opalj.ai.analyses.cg.DefaultVTACallGraphAlgorithmConfiguration;
import org.opalj.ai.analyses.cg.ExtVTACallGraphAlgorithmConfiguration;
import org.opalj.br.Method;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.Project$;
import org.opalj.br.reader.BytecodeInstructionsCache;
import org.opalj.br.reader.Java8FrameworkWithCaching;
import org.opalj.graphs.DefaultMutableNode;
import org.opalj.graphs.Node;
import org.opalj.graphs.package$;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class CallGraphVisualization$ {
    public static CallGraphVisualization$ MODULE$;

    static {
        new CallGraphVisualization$();
    }

    public void main(String[] args) {
        Object object = new Object();
        try {
            Object object2;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() < 3 || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() > 4) {
                Predef$.MODULE$.println((Object)"You have to specify:");
                Predef$.MODULE$.println((Object)"\t1) The algorithm to use (CHA, BasicVTA, DefaultVTA, ExtVTA, kCFA with k in {1,2,3,4,6}).");
                Predef$.MODULE$.println((Object)"\t2) A jar/class file or a directory containing jar/class files.");
                Predef$.MODULE$.println((Object)"\t3) A pattern that specifies which class/interface types should be included in the output.");
                Predef$.MODULE$.println((Object)"\t4 - Optional) The number of seconds (max. 30) before the analysis starts (e.g., to attach a profiler).");
                throw scala.sys.package$.MODULE$.exit(-1);
            }
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() == 4) {
                try {
                    int secs = Integer.parseInt(args[3], 10);
                    if (secs > 30) {
                        Console$.MODULE$.err().println("\t4) The number of seconds before the analysis starts (max. 30).");
                        throw scala.sys.package$.MODULE$.exit(-30);
                    }
                    Thread.sleep((long)secs * 1000L);
                }
                catch (NumberFormatException numberFormatException) {
                    Console$.MODULE$.err().println("\t4) The number of seconds before the analysis starts (max 30).");
                    throw scala.sys.package$.MODULE$.exit(-31);
                }
            }
            Function0 & Serializable & scala.Serializable x$6 = (Function0 & Serializable & scala.Serializable)() -> (Project)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> {
                List list;
                BytecodeInstructionsCache cache = new BytecodeInstructionsCache();
                Java8FrameworkWithCaching ClassFileReader = new Java8FrameworkWithCaching(cache);
                String fileName = args[1];
                File file = new File(fileName);
                if (!file.exists()) {
                    Predef$.MODULE$.println((Object)("\u001b[31mfile does not exist: " + fileName + "\u001b[0m"));
                    throw scala.sys.package$.MODULE$.exit(-2);
                }
                try {
                    Java8FrameworkWithCaching qual$1 = ClassFileReader;
                    File x$4 = file;
                    Function2 x$5 = qual$1.ClassFiles$default$2();
                    list = qual$1.ClassFiles(x$4, x$5);
                }
                catch (Exception e2) {
                    Predef$.MODULE$.println((Object)("\u001b[31mcannot read file: " + e2.getMessage() + "\u001b[0m"));
                    throw scala.sys.package$.MODULE$.exit(-3);
                }
                List classFiles = list;
                cache = null;
                ClassFileReader = null;
                Project project = Project$.MODULE$.apply((Traversable)classFiles, (Traversable)scala.package$.MODULE$.Traversable().empty(), true);
                Predef$.MODULE$.println((Object)((TraversableOnce)((TraversableOnce)project.statistics().map((Function1 & Serializable & scala.Serializable)e -> "\t" + e._1() + ": " + e._2$mcI$sp(), Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("Project statistics:\n\t", "\n\t", ""));
                return project;
            }, (Function1 & Serializable & scala.Serializable)t -> {
                Predef$.MODULE$.println((Object)("Setting up the project took " + new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)t).timeSpan()))));
                return BoxedUnit.UNIT;
            });
            JFunction1.mcVJ.sp & Serializable & scala.Serializable x$7 = (JFunction1.mcVJ.sp & Serializable & scala.Serializable)m -> {
                Predef$.MODULE$.println((Object)("Required memory for base representation: " + org.opalj.util.package$.MODULE$.asMB(m)));
                Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)BoxedUnit.UNIT), "\n");
            };
            Option x$8 = PerformanceEvaluation$.MODULE$.memory$default$3((Function0)x$6, (Function1)x$7);
            Project project = (Project)PerformanceEvaluation$.MODULE$.memory((Function0)x$6, (Function1)x$7, x$8);
            String fqnFilter = args[2];
            String callGraphAlgorithm = args[0];
            Function0 & Serializable & scala.Serializable x$9 = (Function0 & Serializable & scala.Serializable)() -> {
                void var3_3;
                ComputedCallGraph computedCallGraph = (ComputedCallGraph)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> {
                    CHACallGraphAlgorithmConfiguration cHACallGraphAlgorithmConfiguration;
                    String string = callGraphAlgorithm;
                    if ("CHA".equals(string)) {
                        cHACallGraphAlgorithmConfiguration = new CHACallGraphAlgorithmConfiguration(project, CHACallGraphAlgorithmConfiguration$.MODULE$.$lessinit$greater$default$2());
                    } else if ("BasicVTA".equals(string)) {
                        cHACallGraphAlgorithmConfiguration = new BasicVTACallGraphAlgorithmConfiguration(project);
                    } else if ("BasicVTAWithPreAnalysis".equals(string)) {
                        cHACallGraphAlgorithmConfiguration = new BasicVTAWithPreAnalysisCallGraphAlgorithmConfiguration(project);
                    } else {
                        boolean bl = "VTA".equals(string) ? true : "DefaultVTA".equals(string);
                        if (bl) {
                            cHACallGraphAlgorithmConfiguration = new DefaultVTACallGraphAlgorithmConfiguration(project);
                        } else if ("ExtVTA".equals(string)) {
                            cHACallGraphAlgorithmConfiguration = new ExtVTACallGraphAlgorithmConfiguration(project);
                        } else if ("1CFA".equals(string)) {
                            cHACallGraphAlgorithmConfiguration = new CFACallGraphAlgorithmConfiguration(project, 1);
                        } else if ("2CFA".equals(string)) {
                            cHACallGraphAlgorithmConfiguration = new CFACallGraphAlgorithmConfiguration(project, 2);
                        } else {
                            boolean bl2 = "CFA".equals(string) ? true : "3CFA".equals(string);
                            if (bl2) {
                                cHACallGraphAlgorithmConfiguration = new CFACallGraphAlgorithmConfiguration(project, 3);
                            } else if ("4CFA".equals(string)) {
                                cHACallGraphAlgorithmConfiguration = new CFACallGraphAlgorithmConfiguration(project, 4);
                            } else if ("6CFA".equals(string)) {
                                cHACallGraphAlgorithmConfiguration = new CFACallGraphAlgorithmConfiguration(project, 6);
                            } else {
                                Predef$.MODULE$.println((Object)("Unknown call graph algorithm: " + string + "; available: CHA, BasicVTA, DefaultVTA, ExtVTA"));
                                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                            }
                        }
                    }
                    CHACallGraphAlgorithmConfiguration callGraphAlgorithmConfig = cHACallGraphAlgorithmConfiguration;
                    Function0 & Serializable & scala.Serializable entryPoints = (Function0 & Serializable & scala.Serializable)() -> CallGraphFactory$.MODULE$.defaultEntryPointsForLibraries(project);
                    return CallGraphFactory$.MODULE$.create(project, (Function0)entryPoints, (CallGraphAlgorithmConfiguration)callGraphAlgorithmConfig);
                }, (Function1 & Serializable & scala.Serializable)t -> {
                    Predef$.MODULE$.println((Object)("Creating the call graph took: " + new Nanoseconds(((Nanoseconds)t).timeSpan())));
                    return BoxedUnit.UNIT;
                });
                CallGraph callGraph = computedCallGraph.callGraph();
                Predef$.MODULE$.println((Object)("Methods with at least one resolved call: " + callGraph.callsCount()));
                Predef$.MODULE$.println((Object)("Methods which are called by at least one method: " + callGraph.calledByCount()));
                IntRef maxCallSitesPerMethod = IntRef.create((int)0);
                ObjectRef methodWithMaxCallSites = ObjectRef.create(null);
                IntRef maxCallTargets = IntRef.create((int)0);
                ObjectRef methodWithMethodCallWithMaxTargets = ObjectRef.create(null);
                IntRef methodCallWithMaxTargetsPC = IntRef.create((int)0);
                callGraph.foreachCallingMethod((Function2 & Serializable & scala.Serializable)(method, callees) -> {
                    CallGraphVisualization$.$anonfun$main$10(maxCallSitesPerMethod, methodWithMaxCallSites, maxCallTargets, methodWithMethodCallWithMaxTargets, methodCallWithMaxTargetsPC, method, callees);
                    return BoxedUnit.UNIT;
                });
                int arg$macro$1 = callGraph.callSites();
                Predef$.MODULE$.println((Object)new StringOps("Number of call sites: %,d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)})));
                int arg$macro$2 = callGraph.callEdgesCount();
                int arg$macro$3 = callGraph.calledByEdgesCount();
                Predef$.MODULE$.println((Object)(new StringOps("Number of call edges: %,d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$2)})) + new StringOps(" / called-by edges: %,d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$3)}))));
                Predef$.MODULE$.println((Object)("Maximum number of targets for one call: " + maxCallTargets.elem + "; method: " + ((Method)methodWithMethodCallWithMaxTargets.elem).fullyQualifiedSignature() + "; pc: " + methodCallWithMaxTargetsPC.elem));
                Predef$.MODULE$.println((Object)("Method with the maximum number of call sites: " + maxCallSitesPerMethod.elem + "; method: " + ((Method)methodWithMaxCallSites.elem).fullyQualifiedSignature()));
                return var3_3;
            };
            JFunction1.mcVJ.sp & Serializable & scala.Serializable x$10 = (JFunction1.mcVJ.sp & Serializable & scala.Serializable)m -> {
                Predef$.MODULE$.println((Object)("Required memory for call graph: " + org.opalj.util.package$.MODULE$.asMB(m)));
                Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)BoxedUnit.UNIT), "\n");
            };
            Option x$11 = PerformanceEvaluation$.MODULE$.memory$default$3((Function0)x$9, (Function1)x$10);
            ComputedCallGraph computedCallGraph = (ComputedCallGraph)PerformanceEvaluation$.MODULE$.memory((Function0)x$9, (Function1)x$10, x$11);
            Some some = ComputedCallGraph$.MODULE$.unapply(computedCallGraph);
            if (some.isEmpty()) {
                throw new MatchError((Object)computedCallGraph);
            }
            CallGraph callGraph = (CallGraph)((Tuple3)some.get())._1();
            List unresolvedMethodCalls = (List)((Tuple3)some.get())._2();
            List exceptions = (List)((Tuple3)some.get())._3();
            Tuple3 tuple3 = new Tuple3((Object)callGraph, (Object)unresolvedMethodCalls, (Object)exceptions);
            Tuple3 tuple32 = tuple3;
            CallGraph callGraph2 = (CallGraph)tuple32._1();
            List unresolvedMethodCalls2 = (List)tuple32._2();
            List exceptions2 = (List)tuple32._3();
            AnyRefMap nodesForMethods = AnyRefMap$.MODULE$.empty();
            callGraph2.foreachCallingMethod((Function2 & Serializable & scala.Serializable)(method, callees) -> method.classFile().thisType().fqn().startsWith(fqnFilter) ? CallGraphVisualization$.createNode$1(method, fqnFilter, callGraph2, nodesForMethods) : BoxedUnit.UNIT);
            Set nodes = nodesForMethods.values().toSet();
            if (unresolvedMethodCalls2.size() > 0) {
                Predef$.MODULE$.println((Object)("Unresolved method calls: " + unresolvedMethodCalls2.size()));
            }
            if (exceptions2.size() > 0) {
                Predef$.MODULE$.println((Object)("Exceptions: " + exceptions2.size()));
                object2 = org.opalj.io.package$.MODULE$.writeAndOpen(((TraversableOnce)exceptions2.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toFullString(), List$.MODULE$.canBuildFrom())).mkString("Exceptions that occured while creating the call graph...:\n", "\n\n", ""), "ExceptionsThrownDuringCallGraphConstruction", ".txt");
            } else {
                object2 = BoxedUnit.UNIT;
            }
            org.opalj.io.package$.MODULE$.writeAndOpen(package$.MODULE$.toDot((Traversable)nodes, package$.MODULE$.toDot$default$2(), package$.MODULE$.toDot$default$3(), package$.MODULE$.toDot$default$4(), package$.MODULE$.toDot$default$5()), callGraphAlgorithm + "CallGraph", ".dot");
            Predef$.MODULE$.println((Object)"Callgraph:");
            Predef$.MODULE$.println((Object)("Number of nodes: " + nodes.size()));
            int edges = BoxesRunTime.unboxToInt((Object)nodes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(l, r) -> BoxesRunTime.boxToInteger((int)CallGraphVisualization$.$anonfun$main$20(BoxesRunTime.unboxToInt((Object)l), r))));
            Predef$.MODULE$.println((Object)("Number of edges: " + edges));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ boolean $anonfun$main$12(IntRef maxCallTargets$1, Tuple2 e) {
        return ((TraversableOnce)e._2()).size() == maxCallTargets$1.elem;
    }

    public static final /* synthetic */ void $anonfun$main$10(IntRef maxCallSitesPerMethod$1, ObjectRef methodWithMaxCallSites$1, IntRef maxCallTargets$1, ObjectRef methodWithMethodCallWithMaxTargets$1, IntRef methodCallWithMaxTargetsPC$1, Method method, Map callees) {
        block1: {
            int maxTargetsPerCallSite;
            int callSitesCount = callees.size();
            if (callSitesCount > maxCallSitesPerMethod$1.elem) {
                maxCallSitesPerMethod$1.elem = callSitesCount;
                methodWithMaxCallSites$1.elem = method;
            }
            if ((maxTargetsPerCallSite = BoxesRunTime.unboxToInt((Object)((TraversableOnce)callees.values().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$))) <= maxCallTargets$1.elem) break block1;
            maxCallTargets$1.elem = maxTargetsPerCallSite;
            methodWithMethodCallWithMaxTargets$1.elem = method;
            methodCallWithMaxTargetsPC$1.elem = ((Tuple2)callees.find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)CallGraphVisualization$.$anonfun$main$12(maxCallTargets$1, e))).get())._1$mcI$sp();
        }
    }

    public static final /* synthetic */ boolean $anonfun$main$16(String fqnFilter$1, Method callee) {
        return callee.classFile().fqn().startsWith(fqnFilter$1);
    }

    public static final /* synthetic */ void $anonfun$main$15(String fqnFilter$1, CallGraph callGraph$1, AnyRefMap nodesForMethods$1, DefaultMutableNode node$1, Iterable perCallsiteCallees) {
        perCallsiteCallees.withFilter((Function1 & Serializable & scala.Serializable)callee -> BoxesRunTime.boxToBoolean((boolean)CallGraphVisualization$.$anonfun$main$16(fqnFilter$1, callee))).foreach((Function1 & Serializable & scala.Serializable)callee -> {
            node$1.addChild((Node)CallGraphVisualization$.createNode$1(callee, fqnFilter$1, callGraph$1, nodesForMethods$1));
            return BoxedUnit.UNIT;
        });
    }

    private static final DefaultMutableNode createNode$1(Method caller, String fqnFilter$1, CallGraph callGraph$1, AnyRefMap nodesForMethods$1) {
        Object object;
        if (nodesForMethods$1.contains((Object)caller)) {
            return (DefaultMutableNode)nodesForMethods$1.apply((Object)caller);
        }
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)m -> m.toJava();
        String string = caller.name();
        String string2 = "<init>";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            object = new Some((Object)"darkseagreen1");
        } else {
            String string3 = caller.name();
            String string4 = "<clinit>";
            object = !(string3 != null ? !string3.equals(string4) : string4 != null) ? new Some((Object)"darkseagreen") : (caller.isStatic() ? new Some((Object)"gold") : None$.MODULE$);
        }
        DefaultMutableNode node = new DefaultMutableNode((Object)caller, (Function1)intersect, (Option)object);
        nodesForMethods$1.$plus$eq(new Tuple2((Object)caller, (Object)node));
        callGraph$1.calls(caller).values().foreach((Function1 & Serializable & scala.Serializable)perCallsiteCallees -> {
            CallGraphVisualization$.$anonfun$main$15(fqnFilter$1, callGraph$1, nodesForMethods$1, node, perCallsiteCallees);
            return BoxedUnit.UNIT;
        });
        return node;
    }

    public static final /* synthetic */ void $anonfun$main$21(IntRef c$1, Node n) {
        ++c$1.elem;
    }

    public static final /* synthetic */ int $anonfun$main$20(int l, DefaultMutableNode r) {
        IntRef c = IntRef.create((int)0);
        r.foreachSuccessor((Function1 & Serializable & scala.Serializable)n -> {
            CallGraphVisualization$.$anonfun$main$21(c, n);
            return BoxedUnit.UNIT;
        });
        return l + c.elem;
    }

    private CallGraphVisualization$() {
        MODULE$ = this;
    }
}

