/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai;

import java.io.Serializable;
import java.net.URL;
import org.opalj.ai.analyses.cg.CHACallGraphAlgorithmConfiguration;
import org.opalj.ai.analyses.cg.CHACallGraphAlgorithmConfiguration$;
import org.opalj.ai.analyses.cg.CallGraph;
import org.opalj.ai.analyses.cg.CallGraphAlgorithmConfiguration;
import org.opalj.ai.analyses.cg.CallGraphComparison$;
import org.opalj.ai.analyses.cg.CallGraphDifferenceReport;
import org.opalj.ai.analyses.cg.CallGraphFactory$;
import org.opalj.ai.analyses.cg.ComputedCallGraph;
import org.opalj.ai.analyses.cg.ComputedCallGraph$;
import org.opalj.ai.analyses.cg.DefaultVTACallGraphDomain;
import org.opalj.ai.analyses.cg.VTAWithPreAnalysisCallGraphAlgorithmConfiguration;
import org.opalj.br.Method;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;

public final class CallGraphDiff$
extends DefaultOneStepAnalysis {
    public static CallGraphDiff$ MODULE$;

    static {
        new CallGraphDiff$();
    }

    public String title() {
        return "identifies differences between two call graphs";
    }

    public String description() {
        return "identifies methods that do not have the same call graph information";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        BasicReport basicReport;
        Tuple2<List<CallGraphDifferenceReport>, List<CallGraphDifferenceReport>> tuple2 = this.callGraphDiff(project, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x -> {
            Console$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        }, isInterrupted);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List unexpected = (List)tuple2._1();
        List additional = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)unexpected, (Object)additional);
        Tuple2 tuple23 = tuple22;
        List unexpected2 = (List)tuple23._1();
        List additional2 = (List)tuple23._2();
        if (unexpected2.nonEmpty() || additional2.nonEmpty()) {
            String r = "Found the following difference(s):\n";
            if (additional2.nonEmpty()) {
                r = additional2.mkString(r + "Additional:\n", "\n\n", "\n\n");
            }
            if (unexpected2.nonEmpty()) {
                r = unexpected2.mkString(r + "Unexpected:\n", "\n\n", "\n\n");
            }
            basicReport = new BasicReport(r);
        } else {
            basicReport = new BasicReport("No differences found.");
        }
        return basicReport;
    }

    public Tuple2<List<CallGraphDifferenceReport>, List<CallGraphDifferenceReport>> callGraphDiff(Project<?> project, Function1<String, BoxedUnit> println, Function0<Object> isInterrupted) {
        CallGraph morePreciseCG;
        CallGraph lessPreciseCG;
        Function0 & Serializable & scala.Serializable entryPoints = (Function0 & Serializable & scala.Serializable)() -> CallGraphFactory$.MODULE$.defaultEntryPointsForLibraries(project);
        ComputedCallGraph computedCallGraph = (ComputedCallGraph)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> CallGraphFactory$.MODULE$.create(project, entryPoints, (CallGraphAlgorithmConfiguration)new CHACallGraphAlgorithmConfiguration(project, CHACallGraphAlgorithmConfiguration$.MODULE$.$lessinit$greater$default$2())), (Function1 & Serializable & scala.Serializable)t -> {
            println.apply((Object)("creating the less precise call graph took " + new Nanoseconds(((Nanoseconds)t).timeSpan())));
            return BoxedUnit.UNIT;
        });
        Some some = ComputedCallGraph$.MODULE$.unapply(computedCallGraph);
        if (some.isEmpty()) {
            throw new MatchError((Object)computedCallGraph);
        }
        CallGraph callGraph = lessPreciseCG = (CallGraph)((Tuple3)some.get())._1();
        CallGraph lessPreciseCG2 = callGraph;
        if (isInterrupted.apply$mcZ$sp()) {
            return null;
        }
        ComputedCallGraph computedCallGraph2 = (ComputedCallGraph)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> CallGraphFactory$.MODULE$.create(project, entryPoints, (CallGraphAlgorithmConfiguration)new VTAWithPreAnalysisCallGraphAlgorithmConfiguration(project){

            public DefaultVTACallGraphDomain<?> Domain(Method method) {
                return new DefaultVTACallGraphDomain(this.project(), this.fieldValueInformation(), this.methodReturnValueInformation(), this.cache(), method);
            }
        }), (Function1 & Serializable & scala.Serializable)ns -> {
            println.apply((Object)("creating the more precise call graph took " + new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)ns).timeSpan()))));
            return BoxedUnit.UNIT;
        });
        Some some2 = ComputedCallGraph$.MODULE$.unapply(computedCallGraph2);
        if (some2.isEmpty()) {
            throw new MatchError((Object)computedCallGraph2);
        }
        CallGraph callGraph2 = morePreciseCG = (CallGraph)((Tuple3)some2.get())._1();
        CallGraph morePreciseCG2 = callGraph2;
        if (isInterrupted.apply$mcZ$sp()) {
            return null;
        }
        return CallGraphComparison$.MODULE$.apply(project, lessPreciseCG2, morePreciseCG2);
    }

    private CallGraphDiff$() {
        MODULE$ = this;
    }
}

