/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.analyses;

import java.io.File;
import java.net.URL;
import org.opalj.br.ClassFile;
import org.opalj.br.ClassHierarchy;
import org.opalj.br.ClassHierarchy$;
import org.opalj.br.ObjectType;
import org.opalj.br.ObjectType$;
import org.opalj.br.reader.Java8Framework$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqView$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.sys.package$;

public final class ClassHierarchyExtractor$ {
    public static final ClassHierarchyExtractor$ MODULE$;

    static {
        new ClassHierarchyExtractor$();
    }

    public String deriveSpecification(Traversable<ObjectType> types, ClassHierarchy classHierarchy) {
        Traversable specLines = (Traversable)types.map((Function1)new Serializable(classHierarchy){
            public static final long serialVersionUID = 0L;
            private final ClassHierarchy classHierarchy$1;

            /*
             * WARNING - void declaration
             */
            public final String apply(ObjectType aType) {
                void var2_2;
                String specLine = new StringBuilder().append((Object)(this.classHierarchy$1.isInterface(aType).isYes() ? "interface " : "class ")).append((Object)aType.fqn()).toString();
                Option superclassType = this.classHierarchy$1.superclassType(aType);
                if (superclassType.isDefined()) {
                    specLine = new StringBuilder().append((Object)specLine).append((Object)new StringBuilder().append((Object)" extends ").append((Object)((ObjectType)superclassType.get()).fqn()).toString()).toString();
                    Option superinterfaceTypes = this.classHierarchy$1.superinterfaceTypes(aType);
                    if (superinterfaceTypes.isDefined() && ((TraversableOnce)superinterfaceTypes.get()).nonEmpty()) {
                        specLine = new StringBuilder().append((Object)specLine).append((Object)((TraversableOnce)((SetLike)superinterfaceTypes.get()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(ObjectType x$1) {
                                return x$1.fqn();
                            }
                        }, Set$.MODULE$.canBuildFrom())).mkString(" implements ", ", ", "")).toString();
                    }
                }
                return var2_2;
            }
            {
                this.classHierarchy$1 = classHierarchy$1;
            }
        }, Traversable$.MODULE$.canBuildFrom());
        return specLines.mkString("\n");
    }

    public void main(String[] args) {
        if (args.length >= 3 && Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])args).drop(2)).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.endsWith(".jar");
            }
        })) {
            ObjectType supertype;
            String supertypeName = args[0].replace('.', '/');
            String filterPrefix = args[1].replace('.', '/');
            List list = List$.MODULE$.empty();
            List classFiles = (List)Predef$.MODULE$.refArrayOps((Object[])args).$div$colon((Object)list, (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<Tuple2<ClassFile, URL>> apply(List<Tuple2<ClassFile, URL>> cfs, String filename) {
                    return (List)cfs.$plus$plus((GenTraversableOnce)Java8Framework$.MODULE$.ClassFiles(new File(filename), Java8Framework$.MODULE$.ClassFiles$default$2()), List$.MODULE$.canBuildFrom());
                }
            });
            ClassHierarchy classHierarchy = ClassHierarchy$.MODULE$.apply((Traversable)classFiles.view().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ClassFile apply(Tuple2<ClassFile, URL> x$4) {
                    return (ClassFile)x$4._1();
                }
            }, SeqView$.MODULE$.canBuildFrom()), ClassHierarchy$.MODULE$.apply$default$2(), (LogContext)GlobalLogContext$.MODULE$);
            if (classHierarchy.isUnknown(supertype = ObjectType$.MODULE$.apply(supertypeName))) {
                Console$.MODULE$.err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The type: ", " is not defined in the specified jar(s)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{supertypeName})));
                throw package$.MODULE$.exit(-2);
            }
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"# Class hierarchy for: ").append((Object)supertypeName).append((Object)" limited to subclasses that start with: ").append((Object)"\"").append((Object)filterPrefix).append((Object)"\"").toString());
            Set allRelevantSubtypes = (Set)classHierarchy.allSubtypes(supertype, true).filter((Function1)new Serializable(filterPrefix){
                public static final long serialVersionUID = 0L;
                private final String filterPrefix$1;

                public final boolean apply(ObjectType candidateType) {
                    return candidateType.fqn().startsWith(this.filterPrefix$1);
                }
                {
                    this.filterPrefix$1 = filterPrefix$1;
                }
            });
            String spec = this.deriveSpecification((Traversable<ObjectType>)allRelevantSubtypes, classHierarchy);
            Predef$.MODULE$.println((Object)spec);
            return;
        }
        Predef$.MODULE$.println((Object)"Usage:     java \u2026ClassHierarchy supertype filterprefix <JAR file>+");
        Predef$.MODULE$.println((Object)"Example:   \u2026 java.lang.Enum \"\" .../rt.jar");
        Predef$.MODULE$.println((Object)"           lists all subclasses of java.lang.Enum in rt.jar; \"\" effectively disables the filter.");
        Predef$.MODULE$.println((Object)"Copyright: 2015 Michael Eichberg (eichberg@informatik.tu-darmstadt.de)");
        throw package$.MODULE$.exit(-1);
    }

    private ClassHierarchyExtractor$() {
        MODULE$ = this;
    }
}

