/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai.debug;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.opalj.ai.AIResult;
import org.opalj.ai.Domain;
import org.opalj.ai.InstructionCountBoundedAI;
import org.opalj.ai.debug.InterpretMethodsAnalysis$;
import org.opalj.ai.debug.InterpretMethodsAnalysis$$anonfun$3$;
import org.opalj.ai.util.XHTML$;
import org.opalj.br.ClassFile;
import org.opalj.br.Code;
import org.opalj.br.Method;
import org.opalj.br.analyses.MethodInfo;
import org.opalj.br.analyses.ProgressManagement;
import org.opalj.br.analyses.Project;
import org.opalj.io.package$;
import org.opalj.log.LogContext;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation;
import org.opalj.util.Seconds;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.control.ControlThrowable;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

public final class InterpretMethodsAnalysis$ {
    public static final InterpretMethodsAnalysis$ MODULE$;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;

    static {
        symbol$1 = Symbol$.MODULE$.apply("OVERALL");
        symbol$2 = Symbol$.MODULE$.apply("AI");
        symbol$3 = Symbol$.MODULE$.apply("NAIVE_AI");
        new InterpretMethodsAnalysis$();
    }

    public void println(String s) {
        Console$.MODULE$.out().println(s);
        Console$.MODULE$.flush();
    }

    public <Source> Tuple2<String, Option<File>> interpret(Project<Source> project, Class<? extends Domain> domainClass, boolean beVerbose, Function1<Object, ProgressManagement> initProgressManagement, double maxEvaluationFactor, LogContext logContext) {
        Tuple2 tuple2;
        PerformanceEvaluation performanceEvaluationContext = new PerformanceEvaluation();
        AtomicInteger methodsCount = new AtomicInteger(0);
        AtomicLong instructionEvaluationsCount = new AtomicLong(0L);
        Constructor<? extends Domain> domainConstructor = domainClass.getConstructor(Project.class, ClassFile.class, Method.class);
        Iterable collectedExceptions = (Iterable)performanceEvaluationContext.time(symbol$1, (Function0)new Serializable(project, beVerbose, maxEvaluationFactor, logContext, performanceEvaluationContext, methodsCount, instructionEvaluationsCount, domainConstructor){
            public static final long serialVersionUID = 0L;
            public final Project project$1;
            public final boolean beVerbose$1;
            public final double maxEvaluationFactor$1;
            public final LogContext logContext$1;
            public final PerformanceEvaluation performanceEvaluationContext$1;
            public final AtomicInteger methodsCount$1;
            public final AtomicLong instructionEvaluationsCount$1;
            public final Constructor domainConstructor$1;

            public final Iterable<Tuple4<String, ClassFile, Method, Throwable>> apply() {
                ConcurrentLinkedQueue<E> results = new ConcurrentLinkedQueue<E>();
                this.project$1.parForeachMethodWithBody(this.project$1.parForeachMethodWithBody$default$1(), this.project$1.parForeachMethodWithBody$default$2(), (Function1)new Serializable(this, results){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;
                    public final ConcurrentLinkedQueue results$1;

                    public final Option<Object> apply(MethodInfo<Source> m) {
                        MethodInfo<Source> methodInfo = m;
                        if (methodInfo != null) {
                            Tuple3 tuple3;
                            Object source = methodInfo.source();
                            ClassFile classFile = methodInfo.classFile();
                            Method method = methodInfo.method();
                            Tuple3 tuple32 = tuple3 = new Tuple3(source, (Object)classFile, (Object)method);
                            Object source2 = tuple32._1();
                            ClassFile classFile2 = (ClassFile)tuple32._2();
                            Method method2 = (Method)tuple32._3();
                            return InterpretMethodsAnalysis$.MODULE$.org$opalj$ai$debug$InterpretMethodsAnalysis$$analyzeMethod$1(source2.toString(), classFile2, method2, this.$outer.project$1, this.$outer.beVerbose$1, this.$outer.maxEvaluationFactor$1, this.$outer.logContext$1, this.$outer.performanceEvaluationContext$1, this.$outer.methodsCount$1, this.$outer.instructionEvaluationsCount$1, this.$outer.domainConstructor$1).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$3$$anonfun$apply$1 $outer;

                                public final boolean apply(Tuple4<String, ClassFile, Method, Throwable> x$4) {
                                    return this.$outer.results$1.add(x$4);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        throw new MatchError(methodInfo);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.results$1 = results$1;
                    }
                });
                return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results).asScala();
            }
            {
                this.project$1 = project$1;
                this.beVerbose$1 = beVerbose$1;
                this.maxEvaluationFactor$1 = maxEvaluationFactor$1;
                this.logContext$1 = logContext$1;
                this.performanceEvaluationContext$1 = performanceEvaluationContext$1;
                this.methodsCount$1 = methodsCount$1;
                this.instructionEvaluationsCount$1 = instructionEvaluationsCount$1;
                this.domainConstructor$1 = domainConstructor$1;
            }
        });
        if (collectedExceptions.nonEmpty()) {
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("Generated "));
            $buf.$amp$plus((Object)new Date());
            Elem header = new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            Seq body2 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Elem[]{header}))).$plus$plus((GenTraversableOnce)collectedExceptions.groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple4<String, ClassFile, Method, Throwable> e) {
                    return (String)e._1();
                }
            }).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Iterable<Tuple4<String, ClassFile, Method, Throwable>>> check$ifrefutable$1) {
                    Tuple2<String, Iterable<Tuple4<String, ClassFile, Method, Throwable>>> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Elem apply(Tuple2<String, Iterable<Tuple4<String, ClassFile, Method, Throwable>>> x$6) {
                    Tuple2<String, Iterable<Tuple4<String, ClassFile, Method, Throwable>>> tuple2 = x$6;
                    if (tuple2 != null) {
                        String exResource = (String)tuple2._1();
                        Iterable exInstances = (Iterable)tuple2._2();
                        Iterable exDetails = (Iterable)exInstances.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Elem apply(Tuple4<String, ClassFile, Method, Throwable> ex) {
                                Tuple4<String, ClassFile, Method, Throwable> tuple4 = ex;
                                if (tuple4 != null) {
                                    Tuple3 tuple3;
                                    ClassFile classFile = (ClassFile)tuple4._2();
                                    Method method = (Method)tuple4._3();
                                    Throwable throwable = (Throwable)tuple4._4();
                                    Tuple3 tuple32 = tuple3 = new Tuple3((Object)classFile, (Object)method, (Object)throwable);
                                    ClassFile classFile2 = (ClassFile)tuple32._1();
                                    Method method2 = (Method)tuple32._2();
                                    Throwable throwable2 = (Throwable)tuple32._3();
                                    NodeBuffer $buf = new NodeBuffer();
                                    $buf.$amp$plus((Object)new Text("\n                                "));
                                    NodeBuffer $buf2 = new NodeBuffer();
                                    $buf2.$amp$plus((Object)classFile2.thisType().fqn());
                                    $buf.$amp$plus((Object)new Elem(null, "b", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                                    $buf.$amp$plus((Object)new Text("\n                                "));
                                    NodeBuffer $buf3 = new NodeBuffer();
                                    $buf3.$amp$plus((Object)new Text("\""));
                                    $buf3.$amp$plus((Object)method2.toJava(true));
                                    $buf3.$amp$plus((Object)new Text("\""));
                                    $buf.$amp$plus((Object)new Elem(null, "i", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                                    $buf.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                                    $buf.$amp$plus((Object)new Text("\n                                "));
                                    $buf.$amp$plus((Object)new StringBuilder().append((Object)"Length: ").append((Object)BoxesRunTime.boxToInteger((int)((Code)method2.body().get()).instructions().length)).toString());
                                    $buf.$amp$plus((Object)new Text("\n                                "));
                                    NodeBuffer $buf4 = new NodeBuffer();
                                    $buf4.$amp$plus((Object)XHTML$.MODULE$.throwableToXHTML(throwable2));
                                    $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                                    $buf.$amp$plus((Object)new Text("\n                            "));
                                    return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                                }
                                throw new MatchError(tuple4);
                            }
                        }, scala.collection.Iterable$.MODULE$.canBuildFrom());
                        NodeBuffer $buf = new NodeBuffer();
                        $buf.$amp$plus((Object)new Text("\n                        "));
                        NodeBuffer $buf2 = new NodeBuffer();
                        $buf2.$amp$plus((Object)exResource);
                        $buf.$amp$plus((Object)new Elem(null, "h1", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                        $buf.$amp$plus((Object)new Text("\n                        "));
                        NodeBuffer $buf3 = new NodeBuffer();
                        $buf3.$amp$plus((Object)new Text("Number of thrown exceptions: "));
                        $buf3.$amp$plus((Object)BoxesRunTime.boxToInteger((int)exInstances.size()));
                        $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                        $buf.$amp$plus((Object)new Text("\n                        "));
                        $buf.$amp$plus((Object)exDetails);
                        $buf.$amp$plus((Object)new Text("\n                    "));
                        Elem elem = new Elem(null, "section", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                        return elem;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            Node node = XHTML$.MODULE$.createXHTML((Option)new Some((Object)"Exceptions Thrown During Interpretation"), NodeSeq$.MODULE$.fromSeq(body2));
            File file = package$.MODULE$.writeAndOpen(node, "ExceptionsOfCrashedAbstractInterpretations", ".html");
            tuple2 = new Tuple2((Object)new StringBuilder().append((Object)"During the interpretation of ").append((Object)BoxesRunTime.boxToInteger((int)methodsCount.get())).append((Object)" methods (of ").append((Object)BoxesRunTime.boxToInteger((int)project.methodsCount())).append((Object)") in ").append((Object)BoxesRunTime.boxToInteger((int)project.classFilesCount())).append((Object)" classes (real time: ").append((Object)new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(performanceEvaluationContext.getTime(symbol$1)))).append((Object)", ai (\u2211CPU Times): ").append((Object)new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(performanceEvaluationContext.getTime(symbol$2)))).append((Object)")").append((Object)BoxesRunTime.boxToInteger((int)collectedExceptions.size())).append((Object)" exceptions occured.").toString(), (Object)new Some((Object)file));
        } else {
            tuple2 = new Tuple2((Object)new StringBuilder().append((Object)"No exceptions occured during the interpretation of ").append((Object)BoxesRunTime.boxToInteger((int)methodsCount.get())).append((Object)" methods (of ").append((Object)BoxesRunTime.boxToInteger((int)project.methodsCount())).append((Object)") in ").append((Object)BoxesRunTime.boxToInteger((int)project.classFilesCount())).append((Object)" classes\nreal time: ").append((Object)new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(performanceEvaluationContext.getTime(symbol$1)))).append((Object)"\n").append((Object)"ai (\u2211CPU Times): ").append((Object)new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(performanceEvaluationContext.getTime(symbol$2)))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"; evaluated ", " instructions\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)instructionEvaluationsCount.get())}))).append((Object)"naive ai (\u2211CPU Times): ").append((Object)new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(performanceEvaluationContext.getTime(symbol$3)))).append((Object)"\n").toString(), (Object)None$.MODULE$);
        }
        return tuple2;
    }

    public <Source> double interpret$default$5() {
        return 3.0;
    }

    public final Option org$opalj$ai$debug$InterpretMethodsAnalysis$$analyzeMethod$1(String source, ClassFile classFile, Method method, Project project$1, boolean beVerbose$1, double maxEvaluationFactor$1, LogContext logContext$1, PerformanceEvaluation performanceEvaluationContext$1, AtomicInteger methodsCount$1, AtomicLong instructionEvaluationsCount$1, Constructor domainConstructor$1) {
        Throwable throwable2;
        block6: {
            Some some;
            Code body2 = (Code)method.body().get();
            try {
                if (beVerbose$1) {
                    this.println(method.toJava(classFile, "\u001b[33m[started]\u001b[0m"));
                }
                long evaluatedCount = BoxesRunTime.unboxToLong((Object)performanceEvaluationContext$1.time(symbol$2, (Function0)new Serializable(project$1, beVerbose$1, maxEvaluationFactor$1, logContext$1, instructionEvaluationsCount$1, domainConstructor$1, classFile, method, body2){
                    public static final long serialVersionUID = 0L;
                    private final Project project$1;
                    private final boolean beVerbose$1;
                    private final double maxEvaluationFactor$1;
                    private final LogContext logContext$1;
                    private final AtomicLong instructionEvaluationsCount$1;
                    private final Constructor domainConstructor$1;
                    private final ClassFile classFile$1;
                    private final Method method$1;
                    private final Code body$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        InstructionCountBoundedAI ai = new InstructionCountBoundedAI(this.body$1, this.maxEvaluationFactor$1, true, this.logContext$1);
                        Domain domain = (Domain)this.domainConstructor$1.newInstance(this.project$1, this.classFile$1, this.method$1);
                        AIResult result = ai.apply(this.classFile$1, this.method$1, domain);
                        if (result.wasAborted()) {
                            if (this.beVerbose$1) {
                                InterpretMethodsAnalysis$.MODULE$.println(this.method$1.toJava(this.classFile$1, new StringBuilder().append((Object)"\u001b[31m[aborted after evaluating ").append((Object)BoxesRunTime.boxToInteger((int)ai.currentEvaluationCount())).append((Object)" instructions (size of instructions array=").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.body$1.instructions()).size())).append((Object)"; max=").append((Object)BoxesRunTime.boxToInteger((int)ai.maxEvaluationCount())).append((Object)")]").append((Object)"\u001b[0m").toString()));
                            }
                            String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"evaluation bound (max=", ") exceeded"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ai.maxEvaluationCount())}));
                            throw new InterruptedException(message);
                        }
                        long evaluatedCount = ai.currentEvaluationCount();
                        this.instructionEvaluationsCount$1.addAndGet(evaluatedCount);
                        return evaluatedCount;
                    }
                    {
                        this.project$1 = project$1;
                        this.beVerbose$1 = beVerbose$1;
                        this.maxEvaluationFactor$1 = maxEvaluationFactor$1;
                        this.logContext$1 = logContext$1;
                        this.instructionEvaluationsCount$1 = instructionEvaluationsCount$1;
                        this.domainConstructor$1 = domainConstructor$1;
                        this.classFile$1 = classFile$1;
                        this.method$1 = method$1;
                        this.body$1 = body$1;
                    }
                }));
                int naiveEvaluatedCount = BoxesRunTime.unboxToInt((Object)performanceEvaluationContext$1.time(symbol$3, (Function0)new Serializable(project$1, maxEvaluationFactor$1, logContext$1, domainConstructor$1, classFile, method, body2){
                    public static final long serialVersionUID = 0L;
                    private final Project project$1;
                    private final double maxEvaluationFactor$1;
                    private final LogContext logContext$1;
                    private final Constructor domainConstructor$1;
                    private final ClassFile classFile$1;
                    private final Method method$1;
                    private final Code body$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        InstructionCountBoundedAI ai = new InstructionCountBoundedAI(this.body$1, this.maxEvaluationFactor$1, false, this.logContext$1);
                        Domain domain = (Domain)this.domainConstructor$1.newInstance(this.project$1, this.classFile$1, this.method$1);
                        ai.apply(this.classFile$1, this.method$1, domain);
                        return ai.currentEvaluationCount();
                    }
                    {
                        this.project$1 = project$1;
                        this.maxEvaluationFactor$1 = maxEvaluationFactor$1;
                        this.logContext$1 = logContext$1;
                        this.domainConstructor$1 = domainConstructor$1;
                        this.classFile$1 = classFile$1;
                        this.method$1 = method$1;
                        this.body$1 = body$1;
                    }
                }));
                if ((long)naiveEvaluatedCount > evaluatedCount) {
                    int codeLength = body2.instructions().length;
                    String message = method.toJava(classFile, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Evaluation steps (code length:", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)codeLength)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (w/o dead variables analysis) vs. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)naiveEvaluatedCount), BoxesRunTime.boxToLong((long)evaluatedCount)}))).toString());
                    this.println(message);
                }
                if (beVerbose$1) {
                    this.println(method.toJava(classFile, "\u001b[32m[finished]\u001b[0m"));
                }
                methodsCount$1.incrementAndGet();
                some = None$.MODULE$;
            }
            catch (Throwable throwable2) {
                Some some2;
                Throwable throwable3 = throwable2;
                if (throwable3 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable3;
                    throw (Throwable)controlThrowable;
                }
                if (throwable3 == null) break block6;
                Throwable throwable4 = throwable3;
                String source2 = project$1.source(classFile.thisType()).get().toString();
                some = some2 = new Some((Object)new Tuple4((Object)source2, (Object)classFile, (Object)method, (Object)throwable4));
            }
            return some;
        }
        throw throwable2;
    }

    private InterpretMethodsAnalysis$() {
        MODULE$ = this;
    }
}

