/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.hermes.queries;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import org.opalj.hermes.Globals$;
import org.opalj.hermes.queries.FanInFanOut$;
import org.opalj.hermes.queries.FeatureConfiguration;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class FeatureConfiguration$
implements Serializable {
    public static final FeatureConfiguration$ MODULE$;

    static {
        new FeatureConfiguration$();
    }

    public FeatureConfiguration apply(String featureName, String categoriesKey, String categorySizeKey, int categoriesDefault, double categorySizeDefault, int offset) {
        Config config = Globals$.MODULE$.Config().getConfig(FanInFanOut$.MODULE$.configPrefix());
        int numCategories = BoxesRunTime.unboxToInt((Object)this.parseNumCategories(categoriesKey, config).getOrElse((Function0)new Serializable(categoriesDefault){
            public static final long serialVersionUID = 0L;
            private final int categoriesDefault$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.categoriesDefault$1;
            }
            {
                this.categoriesDefault$1 = categoriesDefault$1;
            }
        }));
        double categorySize = BoxesRunTime.unboxToDouble((Object)this.parseCategorySize(categorySizeKey, config).getOrElse((Function0)new Serializable(categorySizeDefault){
            public static final long serialVersionUID = 0L;
            private final double categorySizeDefault$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.categorySizeDefault$1;
            }
            {
                this.categorySizeDefault$1 = categorySizeDefault$1;
            }
        }));
        return new FeatureConfiguration(featureName, numCategories, categorySize, offset);
    }

    private Option<Object> parseNumCategories(String categoriesKey, Config config) {
        None$ none$;
        try {
            int numCategories = config.getInt(categoriesKey);
            if (numCategories <= 0) {
                throw new ConfigException.BadValue(new StringBuilder().append((Object)FanInFanOut$.MODULE$.configPrefix()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{categoriesKey}))).toString(), "value <= 0");
            }
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)numCategories));
        }
        catch (Error error) {
            error.printStackTrace();
            none$ = None$.MODULE$;
        }
        catch (ConfigException configException) {
            OPALLogger$.MODULE$.warn("queries", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Category size has been set to 3."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configException.getMessage()})), (LogContext)GlobalLogContext$.MODULE$);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<Object> parseCategorySize(String categorySizeKey, Config config) {
        None$ none$;
        try {
            double categorySize = config.getDouble(categorySizeKey);
            if (categorySize <= 0.0) {
                throw new ConfigException.BadValue(new StringBuilder().append((Object)FanInFanOut$.MODULE$.configPrefix()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{categorySizeKey}))).toString(), "value <= 0");
            }
            none$ = new Some((Object)BoxesRunTime.boxToDouble((double)categorySize));
        }
        catch (Error error) {
            error.printStackTrace();
            none$ = None$.MODULE$;
        }
        catch (ConfigException configException) {
            OPALLogger$.MODULE$.warn("queries", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Category size has been set to 3."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configException.getMessage()})), (LogContext)GlobalLogContext$.MODULE$);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public FeatureConfiguration apply(String featureName, int numCategories, double categorySize, int offset) {
        return new FeatureConfiguration(featureName, numCategories, categorySize, offset);
    }

    public Option<Tuple4<String, Object, Object, Object>> unapply(FeatureConfiguration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.featureName(), (Object)BoxesRunTime.boxToInteger((int)x$0.numCategories()), (Object)BoxesRunTime.boxToDouble((double)x$0.categorySize()), (Object)BoxesRunTime.boxToInteger((int)x$0.offset())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FeatureConfiguration$() {
        MODULE$ = this;
    }
}

