/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf;

import java.net.URL;
import org.opalj.br.ClassFile;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.br.analyses.SourceElementsPropertyStoreKey$;
import org.opalj.fpcf.EP;
import org.opalj.fpcf.FPCFAnalysesManager;
import org.opalj.fpcf.FPCFAnalysesManagerKey$;
import org.opalj.fpcf.FPCFAnalysisRunner;
import org.opalj.fpcf.Property;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.analysis.FieldMutabilityAnalysis$;
import org.opalj.fpcf.analysis.ObjectImmutabilityAnalysis$;
import org.opalj.fpcf.analysis.TypeExtensibilityAnalysis$;
import org.opalj.fpcf.analysis.TypeImmutabilityAnalysis$;
import org.opalj.fpcf.properties.ExtensibleType$;
import org.opalj.fpcf.properties.ObjectImmutability;
import org.opalj.fpcf.properties.ObjectImmutability$;
import org.opalj.fpcf.properties.TypeImmutability;
import org.opalj.fpcf.properties.TypeImmutability$;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import org.opalj.util.Seconds$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public final class ImmutabilityAnalysis$
extends DefaultOneStepAnalysis {
    public static final ImmutabilityAnalysis$ MODULE$;

    static {
        new ImmutabilityAnalysis$();
    }

    public String title() {
        return "determines the immutability of objects and types";
    }

    public String description() {
        return "determines the immutability of objects and types";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        DoubleRef t = DoubleRef.create((double)Seconds$.MODULE$.None());
        PropertyStore projectStore = (PropertyStore)PerformanceEvaluation$.MODULE$.time((Function0)new Serializable(project){
            public static final long serialVersionUID = 0L;
            private final Project project$1;

            public final PropertyStore apply() {
                return (PropertyStore)this.project$1.get((ProjectInformationKey)SourceElementsPropertyStoreKey$.MODULE$);
            }
            {
                this.project$1 = project$1;
            }
        }, (Function1)new Serializable(t){
            public static final long serialVersionUID = 0L;
            private final DoubleRef t$1;

            public final void apply(long r) {
                this.t$1.elem = Nanoseconds$.MODULE$.toSeconds$extension(r);
            }
            {
                this.t$1 = t$1;
            }
        });
        FPCFAnalysesManager manager = (FPCFAnalysesManager)project.get((ProjectInformationKey)FPCFAnalysesManagerKey$.MODULE$);
        manager.run((FPCFAnalysisRunner)TypeExtensibilityAnalysis$.MODULE$, manager.run$default$2());
        manager.run((FPCFAnalysisRunner)FieldMutabilityAnalysis$.MODULE$, manager.run$default$2());
        PerformanceEvaluation$.MODULE$.time((Function0)new Serializable(manager){
            public static final long serialVersionUID = 0L;
            private final FPCFAnalysesManager manager$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.manager$1.runAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FPCFAnalysisRunner[]{ObjectImmutabilityAnalysis$.MODULE$, TypeImmutabilityAnalysis$.MODULE$}));
            }
            {
                this.manager$1 = manager$1;
            }
        }, (Function1)new Serializable(t){
            public static final long serialVersionUID = 0L;
            private final DoubleRef t$1;

            public final void apply(long r) {
                this.t$1.elem = Seconds$.MODULE$.$plus$extension(this.t$1.elem, Nanoseconds$.MODULE$.toSeconds$extension(r));
            }
            {
                this.t$1 = t$1;
            }
        });
        projectStore.validate((Option)None$.MODULE$);
        String extensibleClasses = ((TraversableOnce)((TraversableOnce)projectStore.entities((Property)ExtensibleType$.MODULE$).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Object x$1) {
                return ((ClassFile)x$1).thisType().toJava();
            }
        }, Traversable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n\t\t\t", "\n\t\t\t", "\n");
        Map immutableClasses = (Map)((TraversableLike)projectStore.entities(ObjectImmutability$.MODULE$.key()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(EP<Object, ObjectImmutability> ep) {
                return !((ClassFile)ep.e()).isInterfaceDeclaration();
            }
        })).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ObjectImmutability apply(EP<Object, ObjectImmutability> x$2) {
                return (ObjectImmutability)x$2.p();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ObjectImmutability, List<EP<Object, ObjectImmutability>>> apply(Tuple2<ObjectImmutability, Traversable<EP<Object, ObjectImmutability>>> kv) {
                return new Tuple2(kv._1(), ((TraversableOnce)kv._2()).toList().sortWith((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(EP<Object, ObjectImmutability> a, EP<Object, ObjectImmutability> b) {
                        ClassFile cfA = (ClassFile)a.e();
                        ClassFile cfB = (ClassFile)b.e();
                        return new StringOps(Predef$.MODULE$.augmentString(cfA.thisType().toJava())).$less((Object)cfB.thisType().toJava());
                    }
                }));
            }
        }, Map$.MODULE$.canBuildFrom());
        String immutableClassesPerCategory = ((TraversableOnce)((TraversableOnce)immutableClasses.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<ObjectImmutability, List<EP<Object, ObjectImmutability>>> kv) {
                return new StringBuilder().append((Object)"\t\t").append(kv._1()).append((Object)": ").append((Object)BoxesRunTime.boxToInteger((int)((SeqLike)kv._2()).size())).toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
        Map immutableTypes = (Map)((TraversableLike)projectStore.entities(TypeImmutability$.MODULE$.key()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(EP<Object, TypeImmutability> ep) {
                return !((ClassFile)ep.e()).isInterfaceDeclaration();
            }
        })).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TypeImmutability apply(EP<Object, TypeImmutability> x$3) {
                return (TypeImmutability)x$3.p();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TypeImmutability, Object> apply(Tuple2<TypeImmutability, Traversable<EP<Object, TypeImmutability>>> kv) {
                return new Tuple2(kv._1(), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)kv._2()).size()));
            }
        }, Map$.MODULE$.canBuildFrom());
        String immutableTypesPerCategory = ((TraversableOnce)((TraversableOnce)immutableTypes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TypeImmutability, Object> kv) {
                return new StringBuilder().append((Object)"\t\t").append(kv._1()).append((Object)": ").append((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
        String immutableClassesInfo = ((TraversableOnce)((TraversableLike)((TraversableLike)immutableClasses.values().flatten((Function1)Predef$.MODULE$.$conforms())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(EP<Object, ObjectImmutability> ep) {
                return !((ClassFile)ep.e()).isInterfaceDeclaration();
            }
        })).map((Function1)new Serializable(projectStore){
            public static final long serialVersionUID = 0L;
            private final PropertyStore projectStore$1;

            public final String apply(EP<Object, ObjectImmutability> ep) {
                return new StringBuilder().append((Object)((ClassFile)ep.e()).thisType().toJava()).append((Object)" => ").append((Object)ep.p()).append((Object)" => ").append((Object)this.projectStore$1.apply(ep.e(), TypeImmutability$.MODULE$.key()).p()).toString();
            }
            {
                this.projectStore$1 = projectStore$1;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("\tImmutability:\n\t\t", "\n\t\t", "\n");
        return new BasicReport(new StringBuilder().append((Object)"Details:\n").append((Object)new StringOps(Predef$.MODULE$.augmentString(extensibleClasses)).mkString("\tExtensible Classes:\n\t\t", "\n\t\t", "\n")).append((Object)immutableClassesInfo).append((Object)"\nSummary (w.r.t classes):\n").append((Object)"\tObject Immutability:\n").append((Object)immutableClassesPerCategory).append((Object)"\n").append((Object)"\tType Immutability:\n").append((Object)immutableTypesPerCategory).append((Object)"\n").append((Object)"\n").append((Object)projectStore.toString(false)).append((Object)"\n").append((Object)"The overall analysis took: ").append((Object)new Seconds(t.elem)).toString());
    }

    private ImmutabilityAnalysis$() {
        MODULE$ = this;
    }
}

