/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai;

import java.net.URL;
import org.opalj.ai.analyses.cg.CHACallGraphAlgorithmConfiguration;
import org.opalj.ai.analyses.cg.CHACallGraphAlgorithmConfiguration$;
import org.opalj.ai.analyses.cg.CallGraph;
import org.opalj.ai.analyses.cg.CallGraphAlgorithmConfiguration;
import org.opalj.ai.analyses.cg.CallGraphComparison$;
import org.opalj.ai.analyses.cg.CallGraphDifferenceReport;
import org.opalj.ai.analyses.cg.CallGraphFactory$;
import org.opalj.ai.analyses.cg.ComputedCallGraph;
import org.opalj.ai.analyses.cg.ComputedCallGraph$;
import org.opalj.ai.analyses.cg.DefaultVTACallGraphDomain;
import org.opalj.ai.analyses.cg.VTAWithPreAnalysisCallGraphAlgorithmConfiguration;
import org.opalj.br.ClassFile;
import org.opalj.br.Method;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class CallGraphDiff$
extends DefaultOneStepAnalysis {
    public static final CallGraphDiff$ MODULE$;

    static {
        new CallGraphDiff$();
    }

    public String title() {
        return "identifies differences between two call graphs";
    }

    public String description() {
        return "identifies methods that do not have the same call graph information";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        Tuple2<List<CallGraphDifferenceReport>, List<CallGraphDifferenceReport>> tuple2 = this.callGraphDiff(project, (Function1<String, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Console$.MODULE$.println(x);
            }
        }, isInterrupted);
        if (tuple2 != null) {
            BasicReport basicReport;
            Tuple2 tuple22;
            List unexpected = (List)tuple2._1();
            List additional = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)unexpected, (Object)additional);
            List unexpected2 = (List)tuple23._1();
            List additional2 = (List)tuple23._2();
            if (unexpected2.nonEmpty() || additional2.nonEmpty()) {
                String r = "Found the following difference(s):\n";
                if (additional2.nonEmpty()) {
                    r = additional2.mkString(new StringBuilder().append((Object)r).append((Object)"Additional:\n").toString(), "\n\n", "\n\n");
                }
                if (unexpected2.nonEmpty()) {
                    r = unexpected2.mkString(new StringBuilder().append((Object)r).append((Object)"Unexpected:\n").toString(), "\n\n", "\n\n");
                }
                basicReport = new BasicReport(r);
            } else {
                basicReport = new BasicReport("No differences found.");
            }
            return basicReport;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<List<CallGraphDifferenceReport>, List<CallGraphDifferenceReport>> callGraphDiff(Project<?> project, Function1<String, BoxedUnit> println, Function0<Object> isInterrupted) {
        CallGraph morePreciseCG;
        CallGraph callGraph;
        CallGraph lessPreciseCG;
        CallGraph callGraph2;
        Serializable entryPoints = new Serializable(project){
            public static final long serialVersionUID = 0L;
            private final Project project$1;

            public final Iterable<Method> apply() {
                return CallGraphFactory$.MODULE$.defaultEntryPointsForLibraries(this.project$1);
            }
            {
                this.project$1 = project$1;
            }
        };
        ComputedCallGraph computedCallGraph = (ComputedCallGraph)PerformanceEvaluation$.MODULE$.time((Function0)new Serializable(project, (Function0)entryPoints){
            public static final long serialVersionUID = 0L;
            private final Project project$1;
            private final Function0 entryPoints$1;

            public final ComputedCallGraph apply() {
                return CallGraphFactory$.MODULE$.create(this.project$1, this.entryPoints$1, (CallGraphAlgorithmConfiguration)new CHACallGraphAlgorithmConfiguration(this.project$1, CHACallGraphAlgorithmConfiguration$.MODULE$.$lessinit$greater$default$2()));
            }
            {
                this.project$1 = project$1;
                this.entryPoints$1 = entryPoints$1;
            }
        }, (Function1)new Serializable(println){
            public static final long serialVersionUID = 0L;
            private final Function1 println$1;

            public final void apply(long t) {
                this.println$1.apply((Object)new StringBuilder().append((Object)"creating the less precise call graph took ").append((Object)new Nanoseconds(t)).toString());
            }
            {
                this.println$1 = println$1;
            }
        });
        Some some = ComputedCallGraph$.MODULE$.unapply(computedCallGraph);
        if (some.isEmpty()) {
            throw new MatchError((Object)computedCallGraph);
        }
        CallGraph lessPreciseCG2 = callGraph2 = (lessPreciseCG = (CallGraph)((Tuple3)some.get())._1());
        if (isInterrupted.apply$mcZ$sp()) {
            return null;
        }
        ComputedCallGraph computedCallGraph2 = (ComputedCallGraph)PerformanceEvaluation$.MODULE$.time((Function0)new Serializable(project, (Function0)entryPoints){
            public static final long serialVersionUID = 0L;
            public final Project project$1;
            private final Function0 entryPoints$1;

            public final ComputedCallGraph apply() {
                return CallGraphFactory$.MODULE$.create(this.project$1, this.entryPoints$1, (CallGraphAlgorithmConfiguration)new VTAWithPreAnalysisCallGraphAlgorithmConfiguration(this){

                    public DefaultVTACallGraphDomain<?> Domain(ClassFile classFile, Method method) {
                        return new DefaultVTACallGraphDomain(this.project(), this.fieldValueInformation(), this.methodReturnValueInformation(), this.cache(), classFile, method);
                    }
                });
            }
            {
                this.project$1 = project$1;
                this.entryPoints$1 = entryPoints$1;
            }
        }, (Function1)new Serializable(println){
            public static final long serialVersionUID = 0L;
            private final Function1 println$1;

            public final void apply(long ns) {
                this.println$1.apply((Object)new StringBuilder().append((Object)"creating the more precise call graph took ").append((Object)new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(ns))).toString());
            }
            {
                this.println$1 = println$1;
            }
        });
        Some some2 = ComputedCallGraph$.MODULE$.unapply(computedCallGraph2);
        if (some2.isEmpty()) {
            throw new MatchError((Object)computedCallGraph2);
        }
        CallGraph morePreciseCG2 = callGraph = (morePreciseCG = (CallGraph)((Tuple3)some2.get())._1());
        if (isInterrupted.apply$mcZ$sp()) {
            return null;
        }
        return CallGraphComparison$.MODULE$.apply(project, lessPreciseCG2, morePreciseCG2);
    }

    private CallGraphDiff$() {
        MODULE$ = this;
    }
}

