/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf.analysis.demo;

import java.net.URL;
import org.opalj.br.ClassFile;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.br.analyses.SourceElementsPropertyStoreKey$;
import org.opalj.fpcf.EP;
import org.opalj.fpcf.Property;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.analysis.FPCFAnalysesManager;
import org.opalj.fpcf.analysis.FPCFAnalysesManagerKey$;
import org.opalj.fpcf.analysis.Instantiability;
import org.opalj.fpcf.analysis.Instantiability$;
import org.opalj.fpcf.analysis.Instantiable$;
import org.opalj.fpcf.analysis.SimpleInstantiabilityAnalysis$;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import org.opalj.util.Seconds$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public final class SimpleInstantiabilityAnalysisDemo$
extends DefaultOneStepAnalysis {
    public static final SimpleInstantiabilityAnalysisDemo$ MODULE$;

    static {
        new SimpleInstantiabilityAnalysisDemo$();
    }

    public String title() {
        return "class instantiablility computation";
    }

    public String description() {
        return "determines the instantiable classes of a library/application";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        PropertyStore propertyStore = (PropertyStore)project.get((ProjectInformationKey)SourceElementsPropertyStoreKey$.MODULE$);
        FPCFAnalysesManager executer = (FPCFAnalysesManager)project.get((ProjectInformationKey)FPCFAnalysesManagerKey$.MODULE$);
        DoubleRef analysisTime = DoubleRef.create((double)Seconds$.MODULE$.None());
        PerformanceEvaluation$.MODULE$.time((Function0)new Serializable(executer){
            public static final long serialVersionUID = 0L;
            private final FPCFAnalysesManager executer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.executer$1.run(SimpleInstantiabilityAnalysis$.MODULE$, this.executer$1.run$default$2());
            }
            {
                this.executer$1 = executer$1;
            }
        }, (Function1)new Serializable(analysisTime){
            public static final long serialVersionUID = 0L;
            private final DoubleRef analysisTime$1;

            public final void apply(long t) {
                this.analysisTime$1.elem = Nanoseconds$.MODULE$.toSeconds$extension(t);
            }
            {
                this.analysisTime$1 = analysisTime$1;
            }
        });
        Traversable instantiableClasses = (Traversable)propertyStore.entities(Instantiability$.MODULE$.key()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(EP<Instantiability> ep) {
                Property property = ep.p();
                Instantiable$ instantiable$ = Instantiable$.MODULE$;
                return !(property != null ? !property.equals(instantiable$) : instantiable$ != null);
            }
        });
        Traversable classInfo = (Traversable)instantiableClasses.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(EP<Instantiability> e) {
                ClassFile classFile = (ClassFile)e._1();
                return classFile.thisType().toJava();
            }
        }, Traversable$.MODULE$.canBuildFrom());
        return new BasicReport(new StringBuilder().append((Object)classInfo.mkString("\ninstantiable classes:\n\n\t", "\n\t", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n# instantiable classes: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)instantiableClasses.size())})))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n #classes: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)project.classFilesCount())}))).append((Object)"\nanalysis time: ").append((Object)new Seconds(analysisTime.elem)).toString());
    }

    private SimpleInstantiabilityAnalysisDemo$() {
        MODULE$ = this;
    }
}

