/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf.analysis.demo;

import java.net.URL;
import org.opalj.AnalysisModes$;
import org.opalj.br.analyses.AnalysisModeConfigFactory$;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.br.analyses.SourceElementsPropertyStoreKey$;
import org.opalj.fpcf.EP;
import org.opalj.fpcf.Property;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.analysis.FPCFAnalysesManager;
import org.opalj.fpcf.analysis.FPCFAnalysesManagerKey$;
import org.opalj.fpcf.analysis.FPCFAnalysisRunner;
import org.opalj.fpcf.analysis.IsEntryPoint$;
import org.opalj.fpcf.analysis.LibraryEntryPointsAnalysis$;
import org.opalj.fpcf.analysis.MethodAccessibilityAnalysis$;
import org.opalj.fpcf.analysis.SimpleInstantiabilityAnalysis$;
import org.opalj.fpcf.analysis.cg.CallGraphFactory$;
import org.opalj.fpcf.analysis.demo.AnalysisDemo$class;
import org.opalj.fpcf.analysis.demo.MethodAnalysisDemo;
import org.opalj.fpcf.analysis.demo.MethodAnalysisDemo$class;
import org.opalj.fpcf.analysis.methods.CallableFromClassesInOtherPackagesAnalysis$;
import org.opalj.log.ConsoleOPALLogger;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.Level;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger;
import org.opalj.log.OPALLogger$;
import org.opalj.log.Warn$;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import org.opalj.util.Seconds$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class EntryPointAnalysisDemo$
extends DefaultOneStepAnalysis
implements MethodAnalysisDemo {
    public static final EntryPointAnalysisDemo$ MODULE$;

    static {
        new EntryPointAnalysisDemo$();
    }

    @Override
    public Traversable<String> buildMethodInfo(Traversable<EP<? extends Property>> entities, boolean withJarInfo, Project<URL> project) {
        return MethodAnalysisDemo$class.buildMethodInfo(this, entities, withJarInfo, project);
    }

    @Override
    public boolean buildMethodInfo$default$2() {
        return MethodAnalysisDemo$class.buildMethodInfo$default$2(this);
    }

    @Override
    public <P extends Property> Traversable<EP<Property>> entitiesByProperty(P property, PropertyStore propertyStore) {
        return AnalysisDemo$class.entitiesByProperty(this, property, propertyStore);
    }

    @Override
    public String finalReport(Traversable<String> infoStrings, String caption) {
        return AnalysisDemo$class.finalReport(this, infoStrings, caption);
    }

    public String title() {
        return "Determines the entry points for the given project.";
    }

    public String description() {
        return "Determines all methods that are initial entry points when construction a call graph.";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        IntRef oldEntryPoints = IntRef.create((int)0);
        DoubleRef oldTime = DoubleRef.create((double)Seconds$.MODULE$.None());
        PerformanceEvaluation$.MODULE$.time((Function0)new Serializable(project, oldEntryPoints){
            public static final long serialVersionUID = 0L;
            private final Project project$1;
            private final IntRef oldEntryPoints$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.oldEntryPoints$1.elem = CallGraphFactory$.MODULE$.defaultEntryPointsForLibraries(this.project$1).size();
            }
            {
                this.project$1 = project$1;
                this.oldEntryPoints$1 = oldEntryPoints$1;
            }
        }, (Function1)new Serializable(oldTime){
            public static final long serialVersionUID = 0L;
            private final DoubleRef oldTime$1;

            public final void apply(long t) {
                this.oldTime$1.elem = Nanoseconds$.MODULE$.toSeconds$extension(t);
            }
            {
                this.oldTime$1 = oldTime$1;
            }
        });
        Project cpaProject = AnalysisModeConfigFactory$.MODULE$.resetAnalysisMode(project, AnalysisModes$.MODULE$.CPA());
        FPCFAnalysesManager cpaExecuter = (FPCFAnalysesManager)cpaProject.get((ProjectInformationKey)FPCFAnalysesManagerKey$.MODULE$);
        DoubleRef analysisTimeCPA = DoubleRef.create((double)Seconds$.MODULE$.None());
        PerformanceEvaluation$.MODULE$.time((Function0)new Serializable(cpaExecuter){
            public static final long serialVersionUID = 0L;
            private final FPCFAnalysesManager cpaExecuter$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cpaExecuter$1.runAll((Seq<FPCFAnalysisRunner>)Predef$.MODULE$.wrapRefArray((Object[])new FPCFAnalysisRunner[]{SimpleInstantiabilityAnalysis$.MODULE$, CallableFromClassesInOtherPackagesAnalysis$.MODULE$, MethodAccessibilityAnalysis$.MODULE$}));
                this.cpaExecuter$1.run(LibraryEntryPointsAnalysis$.MODULE$, true);
            }
            {
                this.cpaExecuter$1 = cpaExecuter$1;
            }
        }, (Function1)new Serializable(analysisTimeCPA){
            public static final long serialVersionUID = 0L;
            private final DoubleRef analysisTimeCPA$1;

            public final void apply(long t) {
                this.analysisTimeCPA$1.elem = Nanoseconds$.MODULE$.toSeconds$extension(t);
            }
            {
                this.analysisTimeCPA$1 = analysisTimeCPA$1;
            }
        });
        Project opaProject = AnalysisModeConfigFactory$.MODULE$.resetAnalysisMode(project, AnalysisModes$.MODULE$.OPA());
        FPCFAnalysesManager opaExecuter = (FPCFAnalysesManager)opaProject.get((ProjectInformationKey)FPCFAnalysesManagerKey$.MODULE$);
        DoubleRef analysisTimeOPA = DoubleRef.create((double)Seconds$.MODULE$.None());
        PerformanceEvaluation$.MODULE$.time((Function0)new Serializable(opaExecuter){
            public static final long serialVersionUID = 0L;
            private final FPCFAnalysesManager opaExecuter$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.opaExecuter$1.runAll((Seq<FPCFAnalysisRunner>)Predef$.MODULE$.wrapRefArray((Object[])new FPCFAnalysisRunner[]{SimpleInstantiabilityAnalysis$.MODULE$, CallableFromClassesInOtherPackagesAnalysis$.MODULE$, MethodAccessibilityAnalysis$.MODULE$}));
                this.opaExecuter$1.run(LibraryEntryPointsAnalysis$.MODULE$, this.opaExecuter$1.run$default$2());
            }
            {
                this.opaExecuter$1 = opaExecuter$1;
            }
        }, (Function1)new Serializable(analysisTimeOPA){
            public static final long serialVersionUID = 0L;
            private final DoubleRef analysisTimeOPA$1;

            public final void apply(long t) {
                this.analysisTimeOPA$1.elem = Nanoseconds$.MODULE$.toSeconds$extension(t);
            }
            {
                this.analysisTimeOPA$1 = analysisTimeOPA$1;
            }
        });
        PropertyStore cpaStore = (PropertyStore)cpaProject.get((ProjectInformationKey)SourceElementsPropertyStoreKey$.MODULE$);
        PropertyStore opaStore = (PropertyStore)opaProject.get((ProjectInformationKey)SourceElementsPropertyStoreKey$.MODULE$);
        Traversable<EP<Property>> cpaEps = this.entitiesByProperty(IsEntryPoint$.MODULE$, cpaStore);
        Traversable<EP<Property>> opaEps = this.entitiesByProperty(IsEntryPoint$.MODULE$, opaStore);
        double methodsCount = project.methodsCount();
        String outputTable = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\n#methods: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)project.methodsCount())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"#entry points: | ", " (old)     | ", " (opa)     | ", " (cpa)\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)oldEntryPoints.elem), BoxesRunTime.boxToInteger((int)opaEps.size()), BoxesRunTime.boxToInteger((int)cpaEps.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentage:    | ", "% (old)     | ", "% (opa)     | ", "% (cpa)\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getPercentage$1(oldEntryPoints.elem, methodsCount), this.getPercentage$1(opaEps.size(), methodsCount), this.getPercentage$1(cpaEps.size(), methodsCount)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"analysisTime:  | ", " (old) | ", " (opa) | ", " (cpa)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Seconds(oldTime.elem), new Seconds(analysisTimeOPA.elem), new Seconds(analysisTimeCPA.elem)}))).toString();
        return new BasicReport(outputTable);
    }

    private final String getPercentage$1(int value, double methodsCount$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%1.2f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)value / methodsCount$1 * 100.0))}));
    }

    private EntryPointAnalysisDemo$() {
        MODULE$ = this;
        AnalysisDemo$class.$init$(this);
        MethodAnalysisDemo$class.$init$(this);
        OPALLogger$.MODULE$.updateLogger((LogContext)GlobalLogContext$.MODULE$, (OPALLogger)new ConsoleOPALLogger(true, (Level)Warn$.MODULE$));
    }
}

